/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.AppInfo;
import com.stripe.android.PaymentController;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.SetupIntentResult;
import com.stripe.android.SourceCallback;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.TokenCallback;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.AccountParams;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentIntentParams;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.SetupIntentParams;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Token;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class Stripe {
    @Nullable
    private static AppInfo sAppInfo;
    public static boolean advancedFraudSignalsEnabled;
    @NonNull
    private final StripeApiHandler mApiHandler;
    @NonNull
    private final StripeNetworkUtils mStripeNetworkUtils;
    @NonNull
    private final PaymentController mPaymentController;
    @NonNull
    private final TokenCreator mTokenCreator;
    @NonNull
    private final ApiKeyValidator mApiKeyValidator = new ApiKeyValidator();
    private String mDefaultPublishableKey;
    @Nullable
    private String mStripeAccount;

    public Stripe(@NonNull Context context) {
        this(context, new StripeApiHandler(context, sAppInfo), new StripeNetworkUtils(context), null);
    }

    public Stripe(@NonNull Context context, @NonNull String publishableKey) {
        this(context, new StripeApiHandler(context, sAppInfo), new StripeNetworkUtils(context), ApiKeyValidator.get().requireValid(publishableKey));
    }

    Stripe(@NonNull Context context, @NonNull StripeApiHandler apiHandler, @NonNull StripeNetworkUtils stripeNetworkUtils, @Nullable String publishableKey) {
        this(apiHandler, stripeNetworkUtils, new PaymentController(context, apiHandler), publishableKey);
    }

    Stripe(final @NonNull StripeApiHandler apiHandler, @NonNull StripeNetworkUtils stripeNetworkUtils, @NonNull PaymentController paymentController, @Nullable String publishableKey) {
        this(apiHandler, stripeNetworkUtils, paymentController, publishableKey, new TokenCreator(){

            @Override
            public void create(@NonNull Map<String, Object> tokenParams, @NonNull ApiRequest.Options options, @NonNull String tokenType, @Nullable Executor executor, @NonNull TokenCallback callback) {
                Stripe.executeTask(executor, new CreateTokenTask(apiHandler, tokenParams, options, tokenType, callback));
            }
        });
    }

    @VisibleForTesting
    Stripe(@NonNull StripeApiHandler apiHandler, @NonNull StripeNetworkUtils stripeNetworkUtils, @NonNull PaymentController paymentController, @Nullable String publishableKey, @NonNull TokenCreator tokenCreator) {
        this.mApiHandler = apiHandler;
        this.mStripeNetworkUtils = stripeNetworkUtils;
        this.mPaymentController = paymentController;
        this.mTokenCreator = tokenCreator;
        this.mDefaultPublishableKey = publishableKey != null ? this.mApiKeyValidator.requireValid(publishableKey) : null;
    }

    public static void setAppInfo(@Nullable AppInfo appInfo) {
        sAppInfo = appInfo;
    }

    @Nullable
    static AppInfo getAppInfo() {
        return sAppInfo;
    }

    public void confirmSetupIntent(@NonNull Activity activity, @NonNull SetupIntentParams setupIntentParams, @NonNull String publishableKey) {
        this.mPaymentController.startConfirmAndAuth(this, activity, setupIntentParams, publishableKey);
    }

    public void confirmSetupIntent(@NonNull Activity activity, @NonNull SetupIntentParams setupIntentParams) {
        this.confirmSetupIntent(activity, setupIntentParams, this.mDefaultPublishableKey);
    }

    public void confirmPayment(@NonNull Activity activity, @NonNull PaymentIntentParams confirmPaymentIntentParams, @NonNull String publishableKey) {
        this.mPaymentController.startConfirmAndAuth(this, activity, confirmPaymentIntentParams, publishableKey);
    }

    public void confirmPayment(@NonNull Activity activity, @NonNull PaymentIntentParams confirmPaymentIntentParams) {
        this.confirmPayment(activity, confirmPaymentIntentParams, this.mDefaultPublishableKey);
    }

    public void authenticatePayment(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent, @NonNull String publishableKey) {
        this.mPaymentController.startAuth(activity, paymentIntent, publishableKey);
    }

    public void authenticatePayment(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent) {
        this.authenticatePayment(activity, paymentIntent, this.mDefaultPublishableKey);
    }

    public boolean onPaymentResult(int requestCode, int resultCode, @Nullable Intent data, @NonNull String publishableKey, @NonNull ApiResultCallback<PaymentIntentResult> callback) {
        if (data != null && this.mPaymentController.shouldHandlePaymentResult(requestCode, resultCode, data)) {
            this.mPaymentController.handlePaymentResult(this, data, publishableKey, callback);
            return true;
        }
        return false;
    }

    public boolean onPaymentResult(int requestCode, int resultCode, @Nullable Intent data, @NonNull ApiResultCallback<PaymentIntentResult> callback) {
        return this.onPaymentResult(requestCode, resultCode, data, this.mDefaultPublishableKey, callback);
    }

    public boolean onSetupResult(int requestCode, int resultCode, @Nullable Intent data, @NonNull String publishableKey, @NonNull ApiResultCallback<SetupIntentResult> callback) {
        if (data != null && this.mPaymentController.shouldHandleSetupResult(requestCode, resultCode, data)) {
            this.mPaymentController.handleSetupResult(this, data, publishableKey, callback);
            return true;
        }
        return false;
    }

    public boolean onSetupResult(int requestCode, int resultCode, @Nullable Intent data, @NonNull ApiResultCallback<SetupIntentResult> callback) {
        return this.onSetupResult(requestCode, resultCode, data, this.mDefaultPublishableKey, callback);
    }

    public void createBankAccountToken(@NonNull BankAccount bankAccount, @NonNull TokenCallback callback) {
        this.createBankAccountToken(bankAccount, this.mDefaultPublishableKey, null, callback);
    }

    public void createBankAccountToken(@NonNull BankAccount bankAccount, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        Objects.requireNonNull(bankAccount, "Required parameter: 'bankAccount' is requred to create a token");
        this.createTokenFromParams(this.mStripeNetworkUtils.createBankAccountTokenParams(bankAccount), publishableKey, "bank_account", executor, callback);
    }

    public void createPiiToken(@NonNull String personalId, @NonNull TokenCallback callback) {
        this.createPiiToken(personalId, this.mDefaultPublishableKey, null, callback);
    }

    public void createPiiToken(@NonNull String personalId, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        this.createTokenFromParams(StripeNetworkUtils.createPersonalIdTokenParams(personalId), publishableKey, "pii", executor, callback);
    }

    @Nullable
    public Token createBankAccountTokenSynchronous(@NonNull BankAccount bankAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createBankAccountTokenSynchronous(bankAccount, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createBankAccountTokenSynchronous(@NonNull BankAccount bankAccount, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.mApiHandler.createToken(this.mStripeNetworkUtils.createBankAccountTokenParams(bankAccount), ApiRequest.Options.create(publishableKey, this.mStripeAccount), "bank_account");
    }

    public void createCvcUpdateToken(@NonNull @Size(min=3L, max=4L) String cvc, @NonNull TokenCallback callback) {
        this.createCvcUpdateToken(cvc, this.mDefaultPublishableKey, null, callback);
    }

    public void createCvcUpdateToken(@NonNull @Size(min=3L, max=4L) String cvc, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        this.createTokenFromParams(StripeNetworkUtils.createUpdateCvcTokenParams(cvc), publishableKey, "cvc_update", executor, callback);
    }

    public void createSource(@NonNull SourceParams sourceParams, @NonNull SourceCallback callback) {
        this.createSource(sourceParams, callback, this.mDefaultPublishableKey, null);
    }

    public void createSource(@NonNull SourceParams sourceParams, @NonNull SourceCallback callback, @NonNull String publishableKey, @Nullable Executor executor) {
        Stripe.executeTask(executor, new CreateSourceTask(this.mApiHandler, sourceParams, publishableKey, this.mStripeAccount, callback));
    }

    public void createPaymentMethod(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull ApiResultCallback<PaymentMethod> callback) {
        this.createPaymentMethod(paymentMethodCreateParams, callback, this.mDefaultPublishableKey, null);
    }

    public void createPaymentMethod(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull ApiResultCallback<PaymentMethod> callback, @NonNull String publishableKey, @Nullable Executor executor) {
        Stripe.executeTask(executor, new CreatePaymentMethodTask(this.mApiHandler, paymentMethodCreateParams, publishableKey, this.mStripeAccount, callback));
    }

    public void createToken(@NonNull Card card, @NonNull TokenCallback callback) {
        this.createToken(card, this.mDefaultPublishableKey, callback);
    }

    public void createToken(@NonNull Card card, @NonNull String publishableKey, @NonNull TokenCallback callback) {
        this.createToken(card, publishableKey, null, callback);
    }

    public void createToken(@NonNull Card card, @NonNull Executor executor, @NonNull TokenCallback callback) {
        this.createToken(card, this.mDefaultPublishableKey, executor, callback);
    }

    public void createToken(@NonNull Card card, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        Objects.requireNonNull(card, "Required Parameter: 'card' is required to create a token");
        this.createTokenFromParams(this.mStripeNetworkUtils.createCardTokenParams(card), publishableKey, "card", executor, callback);
    }

    @Nullable
    public Source createSourceSynchronous(@NonNull SourceParams params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.createSourceSynchronous(params, this.mDefaultPublishableKey);
    }

    @Nullable
    public Source createSourceSynchronous(@NonNull SourceParams params, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.createSource(params, ApiRequest.Options.create(publishableKey, this.mStripeAccount));
    }

    @Nullable
    public PaymentIntent retrievePaymentIntentSynchronous(@NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.retrievePaymentIntent(paymentIntentParams, ApiRequest.Options.create(publishableKey, this.mStripeAccount));
    }

    @Nullable
    public PaymentIntent retrievePaymentIntentSynchronous(@NonNull PaymentIntentParams paymentIntentParams) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        return this.retrievePaymentIntentSynchronous(paymentIntentParams, this.mDefaultPublishableKey);
    }

    @Nullable
    public PaymentIntent confirmPaymentIntentSynchronous(@NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.confirmPaymentIntent(paymentIntentParams, ApiRequest.Options.create(publishableKey, this.mStripeAccount));
    }

    @Nullable
    public SetupIntent retrieveSetupIntentSynchronous(@NonNull SetupIntentParams setupIntentParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.retrieveSetupIntent(setupIntentParams, ApiRequest.Options.create(publishableKey, this.mStripeAccount));
    }

    @Nullable
    public SetupIntent retrieveSetupIntentSynchronous(@NonNull SetupIntentParams setupIntentParams) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        return this.retrieveSetupIntentSynchronous(setupIntentParams, this.mDefaultPublishableKey);
    }

    @Nullable
    public SetupIntent confirmSetupIntentSynchronous(@NonNull SetupIntentParams setupIntentParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.confirmSetupIntent(setupIntentParams, ApiRequest.Options.create(publishableKey, this.mStripeAccount));
    }

    @Nullable
    public PaymentMethod createPaymentMethodSynchronous(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.createPaymentMethod(paymentMethodCreateParams, ApiRequest.Options.create(publishableKey, this.mStripeAccount));
    }

    @Nullable
    public PaymentMethod createPaymentMethodSynchronous(@NonNull PaymentMethodCreateParams paymentMethodCreateParams) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        return this.createPaymentMethodSynchronous(paymentMethodCreateParams, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createTokenSynchronous(@NonNull Card card) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createTokenSynchronous(card, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createTokenSynchronous(@NonNull Card card, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.mApiHandler.createToken(this.mStripeNetworkUtils.createCardTokenParams(card), ApiRequest.Options.create(publishableKey, this.mStripeAccount), "card");
    }

    @Nullable
    public Token createPiiTokenSynchronous(@NonNull String personalId) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createPiiTokenSynchronous(personalId, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createPiiTokenSynchronous(@NonNull String personalId, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.mApiHandler.createToken(StripeNetworkUtils.createPersonalIdTokenParams(personalId), ApiRequest.Options.create(publishableKey, this.mStripeAccount), "pii");
    }

    @Nullable
    public Token createCvcUpdateTokenSynchronous(@NonNull String cvc) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCvcUpdateTokenSynchronous(cvc, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createCvcUpdateTokenSynchronous(@NonNull String cvc, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.mApiHandler.createToken(StripeNetworkUtils.createUpdateCvcTokenParams(cvc), ApiRequest.Options.create(publishableKey, this.mStripeAccount), "cvc_update");
    }

    @Nullable
    public Token createAccountTokenSynchronous(@NonNull AccountParams accountParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.createAccountTokenSynchronous(accountParams, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createAccountTokenSynchronous(@NonNull AccountParams accountParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        try {
            return this.mApiHandler.createToken(accountParams.toParamMap(), ApiRequest.Options.create(publishableKey, this.mStripeAccount), "account");
        }
        catch (CardException cardException) {
            return null;
        }
    }

    @Nullable
    public Source retrieveSourceSynchronous(@NonNull @Size(min=1L) String sourceId, @NonNull @Size(min=1L) String clientSecret) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.retrieveSourceSynchronous(sourceId, clientSecret, this.mDefaultPublishableKey);
    }

    @Nullable
    public Source retrieveSourceSynchronous(@NonNull @Size(min=1L) String sourceId, @NonNull @Size(min=1L) String clientSecret, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.retrieveSource(sourceId, clientSecret, ApiRequest.Options.create(publishableKey, this.mStripeAccount));
    }

    @Deprecated
    public void setDefaultPublishableKey(@NonNull @Size(min=1L) String publishableKey) {
        this.mDefaultPublishableKey = this.mApiKeyValidator.requireValid(publishableKey);
    }

    public void setStripeAccount(@NonNull @Size(min=1L) String stripeAccount) {
        this.mStripeAccount = stripeAccount;
    }

    private void createTokenFromParams(@NonNull Map<String, Object> tokenParams, @NonNull @Size(min=1L) String publishableKey, @NonNull String tokenType, @Nullable Executor executor, @NonNull TokenCallback callback) {
        Objects.requireNonNull(callback, "Required Parameter: 'callback' is required to use the created token and handle errors");
        this.mTokenCreator.create(tokenParams, ApiRequest.Options.create(publishableKey, this.mStripeAccount), tokenType, executor, callback);
    }

    private static void executeTask(@Nullable Executor executor, @NonNull AsyncTask<Void, Void, ?> task) {
        if (executor != null) {
            task.executeOnExecutor(executor, (Object[])new Void[0]);
        } else {
            task.execute((Object[])new Void[0]);
        }
    }

    static {
        advancedFraudSignalsEnabled = true;
    }

    private static class CreateTokenTask
    extends ApiOperation<Token> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final Map<String, Object> mTokenParams;
        @NonNull
        private final ApiRequest.Options mOptions;
        @NonNull
        private final String mTokenType;

        CreateTokenTask(@NonNull StripeApiHandler apiHandler, @NonNull Map<String, Object> tokenParams, @NonNull ApiRequest.Options options, @NonNull String tokenType, @NonNull TokenCallback callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mTokenParams = tokenParams;
            this.mTokenType = tokenType;
            this.mOptions = options;
        }

        @Override
        @Nullable
        Token getResult() throws StripeException {
            return this.mApiHandler.createToken(this.mTokenParams, this.mOptions, this.mTokenType);
        }
    }

    private static class CreatePaymentMethodTask
    extends ApiOperation<PaymentMethod> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final PaymentMethodCreateParams mPaymentMethodCreateParams;
        @NonNull
        private final ApiRequest.Options mOptions;

        CreatePaymentMethodTask(@NonNull StripeApiHandler apiHandler, @NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String publishableKey, @Nullable String stripeAccount, @NonNull ApiResultCallback<PaymentMethod> callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mPaymentMethodCreateParams = paymentMethodCreateParams;
            this.mOptions = ApiRequest.Options.create(publishableKey, stripeAccount);
        }

        @Override
        @Nullable
        PaymentMethod getResult() throws StripeException {
            return this.mApiHandler.createPaymentMethod(this.mPaymentMethodCreateParams, this.mOptions);
        }
    }

    private static class CreateSourceTask
    extends ApiOperation<Source> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final SourceParams mSourceParams;
        @NonNull
        private final ApiRequest.Options mOptions;

        CreateSourceTask(@NonNull StripeApiHandler apiHandler, @NonNull SourceParams sourceParams, @NonNull String publishableKey, @Nullable String stripeAccount, @NonNull SourceCallback callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mSourceParams = sourceParams;
            this.mOptions = ApiRequest.Options.create(publishableKey, stripeAccount);
        }

        @Override
        @Nullable
        Source getResult() throws StripeException {
            return this.mApiHandler.createSource(this.mSourceParams, this.mOptions);
        }
    }

    @VisibleForTesting
    static interface TokenCreator {
        public void create(@NonNull Map<String, Object> var1, @NonNull ApiRequest.Options var2, @NonNull String var3, @Nullable Executor var4, @NonNull TokenCallback var5);
    }
}

