/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.stripe.android.R;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.MaskedCardView;
import java.util.ArrayList;
import java.util.List;

class MaskedCardAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final int NO_SELECTION = -1;
    @NonNull
    private final List<PaymentMethod> mPaymentMethods = new ArrayList<PaymentMethod>();
    private int mSelectedIndex = -1;

    MaskedCardAdapter(@NonNull List<PaymentMethod> paymentMethods) {
        this.setPaymentMethods(paymentMethods);
    }

    void setPaymentMethods(@NonNull List<PaymentMethod> paymentMethods) {
        PaymentMethod selectedPaymentMethod = this.getSelectedPaymentMethod();
        String selectedPaymentMethodId = selectedPaymentMethod != null ? selectedPaymentMethod.id : null;
        this.mPaymentMethods.clear();
        this.mPaymentMethods.addAll(paymentMethods);
        if (selectedPaymentMethodId == null || !this.setSelectedPaymentMethod(selectedPaymentMethodId)) {
            this.setSelectedIndex(this.getNewestPaymentMethodIndex());
        }
        this.notifyDataSetChanged();
    }

    private int getNewestPaymentMethodIndex() {
        int index = -1;
        Long created = 0L;
        for (int i = 0; i < this.mPaymentMethods.size(); ++i) {
            PaymentMethod paymentMethod = this.mPaymentMethods.get(i);
            if (paymentMethod.created == null || paymentMethod.created <= created) continue;
            created = paymentMethod.created;
            index = i;
        }
        return index;
    }

    public int getItemCount() {
        return this.mPaymentMethods.size();
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.setMaskedCardData(this.mPaymentMethods.get(position));
        holder.setIndex(position);
        holder.setSelected(position == this.mSelectedIndex);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        FrameLayout itemView = (FrameLayout)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.masked_card_row, parent, false);
        return new ViewHolder(itemView);
    }

    boolean setSelectedPaymentMethod(@NonNull String paymentMethodId) {
        for (int i = 0; i < this.mPaymentMethods.size(); ++i) {
            if (!paymentMethodId.equals(this.mPaymentMethods.get((int)i).id)) continue;
            this.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    @Nullable
    String getSelectedPaymentMethodId() {
        if (this.mSelectedIndex == -1) {
            return null;
        }
        return this.mPaymentMethods.get((int)this.mSelectedIndex).id;
    }

    @Nullable
    PaymentMethod getSelectedPaymentMethod() {
        if (this.mSelectedIndex == -1) {
            return null;
        }
        return this.mPaymentMethods.get(this.mSelectedIndex);
    }

    void setSelectedIndex(int selectedIndex) {
        this.mSelectedIndex = selectedIndex;
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        @NonNull
        private final MaskedCardView maskedCardView;
        private int index;

        ViewHolder(FrameLayout itemLayout) {
            super((View)itemLayout);
            this.maskedCardView = (MaskedCardView)itemLayout.findViewById(R.id.masked_card_item);
            itemLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (!ViewHolder.this.maskedCardView.isSelected()) {
                        ViewHolder.this.maskedCardView.toggleSelected();
                        MaskedCardAdapter.this.setSelectedIndex(ViewHolder.this.index);
                        MaskedCardAdapter.this.notifyDataSetChanged();
                    }
                }
            });
        }

        void setMaskedCardData(@NonNull PaymentMethod paymentMethod) {
            this.maskedCardView.setPaymentMethod(paymentMethod);
        }

        void setIndex(int index) {
            this.index = index;
        }

        void setSelected(boolean selected) {
            this.maskedCardView.setSelected(selected);
        }
    }
}

