/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.StripeUid;
import com.stripe.android.Supplier;
import com.stripe.android.UidSupplier;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

class TelemetryClientUtil {
    @NonNull
    private final Context mContext;
    @NonNull
    private final Supplier<StripeUid> mUidSupplier;

    TelemetryClientUtil(@NonNull Context context) {
        this(context, new UidSupplier(context));
    }

    TelemetryClientUtil(@NonNull Context context, @NonNull Supplier<StripeUid> uidSupplier) {
        this.mContext = context.getApplicationContext();
        this.mUidSupplier = uidSupplier;
    }

    @NonNull
    Map<String, Object> createTelemetryMap() {
        HashMap<String, Object> telemetryMap = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> firstMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> secondMap = new HashMap<String, Object>();
        telemetryMap.put("v2", 1);
        telemetryMap.put("tag", "9.3.6");
        telemetryMap.put("src", "android-sdk");
        firstMap.put("c", TelemetryClientUtil.createSingleValuePair(Locale.getDefault().toString()));
        firstMap.put("d", TelemetryClientUtil.createSingleValuePair(TelemetryClientUtil.getAndroidVersionString()));
        firstMap.put("f", TelemetryClientUtil.createSingleValuePair(this.getScreen()));
        firstMap.put("g", TelemetryClientUtil.createSingleValuePair(TelemetryClientUtil.getTimeZoneString()));
        telemetryMap.put("a", firstMap);
        secondMap.put("d", this.getHashedMuid());
        String packageName = this.getPackageName();
        secondMap.put("k", packageName);
        secondMap.put("o", Build.VERSION.RELEASE);
        secondMap.put("p", Build.VERSION.SDK_INT);
        secondMap.put("q", Build.MANUFACTURER);
        secondMap.put("r", Build.BRAND);
        secondMap.put("s", Build.MODEL);
        secondMap.put("t", Build.TAGS);
        if (this.mContext.getPackageName() != null) {
            try {
                PackageInfo pInfo = this.mContext.getPackageManager().getPackageInfo(packageName, 0);
                secondMap.put("l", pInfo.versionName);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        telemetryMap.put("b", secondMap);
        return telemetryMap;
    }

    @NonNull
    private static Map<String, Object> createSingleValuePair(Object value) {
        HashMap<String, Object> singleItemMap = new HashMap<String, Object>();
        singleItemMap.put("v", value);
        return singleItemMap;
    }

    @NonNull
    private static String getTimeZoneString() {
        int minutes = (int)TimeUnit.MINUTES.convert(TimeZone.getDefault().getRawOffset(), TimeUnit.MILLISECONDS);
        if (minutes % 60 == 0) {
            int hours = minutes / 60;
            return String.valueOf(hours);
        }
        BigDecimal decimalValue = new BigDecimal(minutes);
        decimalValue = decimalValue.setScale(2, 6);
        BigDecimal decHours = decimalValue.divide(new BigDecimal(60), new MathContext(2)).setScale(2, 6);
        return decHours.toString();
    }

    @NonNull
    private String getScreen() {
        if (this.mContext.getResources() == null) {
            return "";
        }
        int width = this.mContext.getResources().getDisplayMetrics().widthPixels;
        int height = this.mContext.getResources().getDisplayMetrics().heightPixels;
        int density = this.mContext.getResources().getDisplayMetrics().densityDpi;
        return String.format(Locale.ENGLISH, "%dw_%dh_%ddpi", width, height, density);
    }

    @NonNull
    private static String getAndroidVersionString() {
        String delimiter = " ";
        return "Android " + Build.VERSION.RELEASE + " " + Build.VERSION.CODENAME + " " + Build.VERSION.SDK_INT;
    }

    @NonNull
    String getHashedId() {
        String id = this.mUidSupplier.get().value;
        if (StripeTextUtils.isBlank(id)) {
            return "";
        }
        String hashId = StripeTextUtils.shaHashInput(id);
        return hashId == null ? "" : hashId;
    }

    @NonNull
    private String getHashedMuid() {
        String hashed = StripeTextUtils.shaHashInput(this.getPackageName() + this.getHashedId());
        return hashed == null ? "" : hashed;
    }

    @NonNull
    private String getPackageName() {
        if (this.mContext.getPackageName() == null) {
            return "";
        }
        return this.mContext.getPackageName();
    }
}

