/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import com.stripe.android.model.PaymentIntent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class PaymentIntentResult {
    @NonNull
    public final PaymentIntent paymentIntent;
    public final int status;

    private PaymentIntentResult(@NonNull Builder builder) {
        this.paymentIntent = builder.mPaymentIntent;
        this.status = builder.mStatus;
    }

    static final class Builder {
        private PaymentIntent mPaymentIntent;
        private int mStatus;

        Builder() {
        }

        @NonNull
        public Builder setPaymentIntent(@NonNull PaymentIntent paymentIntent) {
            this.mPaymentIntent = paymentIntent;
            return this;
        }

        @NonNull
        public Builder setStatus(int status) {
            this.mStatus = status;
            return this;
        }

        @NonNull
        public PaymentIntentResult build() {
            return new PaymentIntentResult(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
        public static final int UNKNOWN = 0;
        public static final int SUCCEEDED = 1;
        public static final int FAILED = 2;
        public static final int CANCELED = 3;
    }
}

