/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.utils.ObjectUtils;
import com.stripe.android.view.ActivityStarter;
import com.stripe.android.view.PaymentAuthRelayActivity;
import java.lang.ref.WeakReference;

class Stripe3ds2CompletionStarter
implements ActivityStarter<StartData> {
    @NonNull
    private final WeakReference<Activity> mActivityRef;
    private final int mRequestCode;

    Stripe3ds2CompletionStarter(@NonNull Activity activity, int requestCode) {
        this.mActivityRef = new WeakReference<Activity>(activity);
        this.mRequestCode = requestCode;
    }

    @Override
    public void start(@NonNull StartData data) {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, PaymentAuthRelayActivity.class).putExtra("client_secret", data.mPaymentIntent.getClientSecret());
        activity.startActivityForResult(intent, this.mRequestCode);
    }

    static class StartData {
        @NonNull
        private final PaymentIntent mPaymentIntent;
        private final int mStatus;
        @Nullable
        private final String mCompletionTransactionStatus;

        @NonNull
        static StartData createForComplete(@NonNull PaymentIntent paymentIntent, @NonNull String completionTransactionStatus) {
            return new StartData(paymentIntent, 0, completionTransactionStatus);
        }

        StartData(@NonNull PaymentIntent paymentIntent, int status) {
            this(paymentIntent, status, null);
        }

        private StartData(@NonNull PaymentIntent paymentIntent, int status, @Nullable String completionTransactionStatus) {
            this.mPaymentIntent = paymentIntent;
            this.mStatus = status;
            this.mCompletionTransactionStatus = completionTransactionStatus;
        }

        public int hashCode() {
            return ObjectUtils.hash(this.mPaymentIntent, this.mStatus, this.mCompletionTransactionStatus);
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof StartData && this.typedEquals((StartData)obj);
        }

        private boolean typedEquals(@NonNull StartData startData) {
            return ObjectUtils.equals(this.mPaymentIntent, startData.mPaymentIntent) && ObjectUtils.equals(this.mStatus, startData.mStatus) && ObjectUtils.equals(this.mCompletionTransactionStatus, startData.mCompletionTransactionStatus);
        }
    }
}

