/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ProgressBar;
import com.stripe.android.CustomerSession;
import com.stripe.android.R;
import com.stripe.android.StripeError;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.AddPaymentMethodActivity;
import com.stripe.android.view.MaskedCardAdapter;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import com.stripe.android.view.ViewUtils;
import com.stripe.android.view.i18n.TranslatorManager;
import java.util.List;

public class PaymentMethodsActivity
extends AppCompatActivity {
    private static final String STATE_SELECTED_PAYMENT_METHOD = "state_selected_payment_method";
    public static final String EXTRA_SELECTED_PAYMENT = "selected_payment";
    public static final String EXTRA_INITIAL_SELECTED_PAYMENT_METHOD_ID = "initial_selected_payment_method_id";
    public static final String TOKEN_PAYMENT_METHODS_ACTIVITY = "PaymentMethodsActivity";
    static final int REQUEST_CODE_ADD_CARD = 700;
    private boolean mCommunicating;
    private MaskedCardAdapter mMaskedCardAdapter;
    private ProgressBar mProgressBar;
    private RecyclerView mRecyclerView;
    private boolean mRecyclerViewUpdated;
    private boolean mStartedFromPaymentSession;
    private CustomerSession mCustomerSession;

    @Deprecated
    @NonNull
    public static Intent newIntent(@NonNull Activity activity) {
        return new PaymentMethodsActivityStarter(activity).newIntent();
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_payment_methods);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.payment_methods_progress_bar);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.payment_methods_recycler);
        View addCardView = this.findViewById(R.id.payment_methods_add_payment_container);
        this.mCustomerSession = CustomerSession.getInstance();
        this.mStartedFromPaymentSession = this.getIntent().hasExtra("payment_session_active");
        final boolean shouldShowPostalField = this.getIntent().getBooleanExtra("require_postal", false);
        addCardView.setOnClickListener(new View.OnClickListener(){

            public void onClick(@NonNull View view) {
                Intent addPaymentMethodIntent = AddPaymentMethodActivity.newIntent((Context)PaymentMethodsActivity.this, shouldShowPostalField, true);
                if (PaymentMethodsActivity.this.mStartedFromPaymentSession) {
                    addPaymentMethodIntent.putExtra("payment_session_active", true);
                }
                PaymentMethodsActivity.this.startActivityForResult(addPaymentMethodIntent, 700);
            }
        });
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.payment_methods_toolbar);
        this.setSupportActionBar(toolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        String selectedPaymentMethodId = savedInstanceState != null && savedInstanceState.containsKey(STATE_SELECTED_PAYMENT_METHOD) ? savedInstanceState.getString(STATE_SELECTED_PAYMENT_METHOD) : (this.getIntent().hasExtra(EXTRA_INITIAL_SELECTED_PAYMENT_METHOD_ID) ? this.getIntent().getStringExtra(EXTRA_INITIAL_SELECTED_PAYMENT_METHOD_ID) : null);
        this.getCustomerPaymentMethods(selectedPaymentMethodId);
        addCardView.requestFocusFromTouch();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 700 && resultCode == -1) {
            this.initLoggingTokens();
            if (data.hasExtra("new_payment_method")) {
                PaymentMethod paymentMethod = PaymentMethod.fromString(data.getStringExtra("new_payment_method"));
                this.getCustomerPaymentMethods(paymentMethod != null ? paymentMethod.id : null);
            } else {
                this.getCustomerPaymentMethods(null);
            }
        }
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        MenuItem saveItem = menu2.findItem(R.id.action_save);
        Drawable compatIcon = ViewUtils.getTintedIconWithAttribute((Context)this, this.getTheme(), R.attr.titleTextColor, R.drawable.ic_checkmark);
        saveItem.setIcon(compatIcon);
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.add_source_menu, menu2);
        menu2.findItem(R.id.action_save).setEnabled(!this.mCommunicating);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_save) {
            this.setSelectionAndFinish();
            return true;
        }
        boolean handled = super.onOptionsItemSelected(item);
        if (!handled) {
            this.onBackPressed();
        }
        return handled;
    }

    private void getCustomerPaymentMethods(@Nullable String selectPaymentMethodId) {
        this.setCommunicatingProgress(true);
        this.mCustomerSession.getPaymentMethods(PaymentMethod.Type.Card, new GetPaymentMethodsRetrievalListener(this, selectPaymentMethodId));
    }

    private void updatePaymentMethods(@NonNull List<PaymentMethod> paymentMethods) {
        if (!this.mRecyclerViewUpdated) {
            this.mMaskedCardAdapter = new MaskedCardAdapter(paymentMethods);
            this.mRecyclerView.setHasFixedSize(false);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mMaskedCardAdapter);
            this.mRecyclerViewUpdated = true;
        } else {
            this.mMaskedCardAdapter.setPaymentMethods(paymentMethods);
        }
    }

    private void selectPaymentMethod(@NonNull String paymentMethodId) {
        this.mMaskedCardAdapter.setSelectedPaymentMethod(paymentMethodId);
    }

    private void initLoggingTokens() {
        if (this.mStartedFromPaymentSession) {
            this.mCustomerSession.addProductUsageTokenIfValid("PaymentSession");
        }
        this.mCustomerSession.addProductUsageTokenIfValid(TOKEN_PAYMENT_METHODS_ACTIVITY);
    }

    private void cancelAndFinish() {
        this.setResult(0);
        this.finish();
    }

    private void setCommunicatingProgress(boolean communicating) {
        this.mCommunicating = communicating;
        if (communicating) {
            this.mProgressBar.setVisibility(0);
        } else {
            this.mProgressBar.setVisibility(8);
        }
        this.supportInvalidateOptionsMenu();
    }

    private void setSelectionAndFinish() {
        if (this.mMaskedCardAdapter == null || this.mMaskedCardAdapter.getSelectedPaymentMethod() == null) {
            this.cancelAndFinish();
            return;
        }
        PaymentMethod paymentMethod = this.mMaskedCardAdapter.getSelectedPaymentMethod();
        if (paymentMethod == null || paymentMethod.id == null) {
            this.cancelAndFinish();
            return;
        }
        Intent intent = new Intent().putExtra(EXTRA_SELECTED_PAYMENT, paymentMethod.toJson().toString());
        this.setResult(-1, intent);
        this.finish();
    }

    private void showError(@NonNull String error) {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)error).setCancelable(true).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        }).create().show();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(STATE_SELECTED_PAYMENT_METHOD, this.mMaskedCardAdapter.getSelectedPaymentMethodId());
    }

    private static final class GetPaymentMethodsRetrievalListener
    extends CustomerSession.ActivityPaymentMethodsRetrievalListener<PaymentMethodsActivity> {
        @Nullable
        final String mSelectPaymentMethodId;

        GetPaymentMethodsRetrievalListener(@NonNull PaymentMethodsActivity activity, @Nullable String selectPaymentMethodId) {
            super(activity);
            this.mSelectPaymentMethodId = selectPaymentMethodId;
        }

        @Override
        public void onPaymentMethodsRetrieved(@NonNull List<PaymentMethod> paymentMethods) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.updatePaymentMethods(paymentMethods);
            if (this.mSelectPaymentMethodId != null) {
                activity.selectPaymentMethod(this.mSelectPaymentMethodId);
            }
            activity.setCommunicatingProgress(false);
        }

        @Override
        public void onError(int errorCode, @Nullable String errorMessage, @Nullable StripeError stripeError) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            String displayedError = TranslatorManager.getErrorMessageTranslator().translate(errorCode, errorMessage, stripeError);
            activity.showError(displayedError);
            activity.setCommunicatingProgress(false);
        }
    }
}

