/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.LoggingUtils;
import com.stripe.android.PaymentAuthResult;
import com.stripe.android.PaymentAuthenticationController;
import com.stripe.android.RequestOptions;
import com.stripe.android.SourceCallback;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.TokenCallback;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.AccountParams;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentIntentParams;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.model.Token;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class Stripe {
    @VisibleForTesting
    TokenCreator mTokenCreator = new TokenCreator(){

        @Override
        public void create(@NonNull Map<String, Object> tokenParams, @NonNull String publishableKey, @Nullable String stripeAccount, @NonNull String tokenType, @Nullable Executor executor, @NonNull TokenCallback callback) {
            Stripe.this.executeTask(executor, new CreateTokenTask(Stripe.this.mApiHandler, tokenParams, publishableKey, stripeAccount, tokenType, callback));
        }
    };
    private String mDefaultPublishableKey;
    private String mStripeAccount;
    @NonNull
    private final StripeApiHandler mApiHandler;
    @NonNull
    private final LoggingUtils mLoggingUtils;
    @NonNull
    private final StripeNetworkUtils mStripeNetworkUtils;
    @NonNull
    private final PaymentAuthenticationController mPaymentAuthenticationController;

    public Stripe(@NonNull Context context) {
        this(context, new StripeApiHandler(context), new LoggingUtils(context), new StripeNetworkUtils(context));
    }

    public Stripe(@NonNull Context context, @NonNull String publishableKey) {
        this(context, new StripeApiHandler(context), new LoggingUtils(context), new StripeNetworkUtils(context));
        this.setDefaultPublishableKey(publishableKey);
    }

    @VisibleForTesting
    Stripe(@NonNull Context context, @NonNull StripeApiHandler apiHandler, @NonNull LoggingUtils loggingUtils, @NonNull StripeNetworkUtils stripeNetworkUtils) {
        this(apiHandler, loggingUtils, stripeNetworkUtils, new PaymentAuthenticationController(context, apiHandler));
    }

    @VisibleForTesting
    Stripe(@NonNull StripeApiHandler apiHandler, @NonNull LoggingUtils loggingUtils, @NonNull StripeNetworkUtils stripeNetworkUtils, @NonNull PaymentAuthenticationController paymentAuthenticationController) {
        this.mApiHandler = apiHandler;
        this.mLoggingUtils = loggingUtils;
        this.mStripeNetworkUtils = stripeNetworkUtils;
        this.mPaymentAuthenticationController = paymentAuthenticationController;
    }

    private void startPaymentAuth(@NonNull Activity activity, @NonNull PaymentIntentParams confirmPaymentIntentParams, @NonNull String publishableKey) {
        this.mPaymentAuthenticationController.confirmAndAuth(this, activity, confirmPaymentIntentParams, publishableKey);
    }

    public void startPaymentAuth(@NonNull Activity activity, @NonNull PaymentIntentParams paymentIntentParams) {
        this.startPaymentAuth(activity, paymentIntentParams, this.mDefaultPublishableKey);
    }

    private boolean onPaymentAuthResult(int requestCode, int resultCode, @Nullable Intent data, @NonNull String publishableKey, @NonNull ApiResultCallback<PaymentAuthResult> callback) {
        if (data != null && this.mPaymentAuthenticationController.shouldHandleResult(requestCode, resultCode, data)) {
            this.mPaymentAuthenticationController.handleResult(this, data, publishableKey, callback);
            return true;
        }
        return false;
    }

    public boolean onPaymentAuthResult(int requestCode, int resultCode, @Nullable Intent data, @NonNull ApiResultCallback<PaymentAuthResult> callback) {
        return this.onPaymentAuthResult(requestCode, resultCode, data, this.mDefaultPublishableKey, callback);
    }

    public void createBankAccountToken(@NonNull BankAccount bankAccount, @NonNull TokenCallback callback) {
        this.createBankAccountToken(bankAccount, this.mDefaultPublishableKey, null, callback);
    }

    public void createBankAccountToken(@NonNull BankAccount bankAccount, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        if (bankAccount == null) {
            throw new RuntimeException("Required parameter: 'bankAccount' is requred to create a token");
        }
        this.createTokenFromParams(this.mStripeNetworkUtils.hashMapFromBankAccount(bankAccount), publishableKey, "bank_account", executor, callback);
    }

    public void createPiiToken(@NonNull String personalId, @NonNull TokenCallback callback) {
        this.createPiiToken(personalId, this.mDefaultPublishableKey, null, callback);
    }

    public void createPiiToken(@NonNull String personalId, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        this.createTokenFromParams(StripeNetworkUtils.hashMapFromPersonalId(personalId), publishableKey, "pii", executor, callback);
    }

    public Token createBankAccountTokenSynchronous(BankAccount bankAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createBankAccountTokenSynchronous(bankAccount, this.mDefaultPublishableKey);
    }

    public Token createBankAccountTokenSynchronous(BankAccount bankAccount, String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.validateKey(publishableKey);
        return this.mApiHandler.createToken(this.mStripeNetworkUtils.hashMapFromBankAccount(bankAccount), RequestOptions.createForApi(publishableKey, this.mStripeAccount), "bank_account");
    }

    public void createCvcUpdateToken(@NonNull @Size(min=3L, max=4L) String cvc, @NonNull TokenCallback callback) {
        this.createCvcUpdateToken(cvc, this.mDefaultPublishableKey, null, callback);
    }

    public void createCvcUpdateToken(@NonNull @Size(min=3L, max=4L) String cvc, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        this.createTokenFromParams(StripeNetworkUtils.mapFromCvc(cvc), publishableKey, "cvc_update", executor, callback);
    }

    public void createSource(@NonNull SourceParams sourceParams, @NonNull SourceCallback callback) {
        this.createSource(sourceParams, callback, null, null);
    }

    public void createSource(@NonNull SourceParams sourceParams, @NonNull SourceCallback callback, @Nullable String publishableKey, @Nullable Executor executor) {
        String apiKey;
        String string = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return;
        }
        this.executeTask(executor, new CreateSourceTask(this.mApiHandler, sourceParams, publishableKey, this.mStripeAccount, callback));
    }

    public void createPaymentMethod(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull ApiResultCallback<PaymentMethod> callback) {
        this.createPaymentMethod(paymentMethodCreateParams, callback, null, null);
    }

    public void createPaymentMethod(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull ApiResultCallback<PaymentMethod> callback, @Nullable String publishableKey, @Nullable Executor executor) {
        String apiKey;
        String string = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return;
        }
        this.executeTask(executor, new CreatePaymentMethodTask(this.mApiHandler, paymentMethodCreateParams, apiKey, this.mStripeAccount, callback));
    }

    public void createToken(@NonNull Card card, @NonNull TokenCallback callback) {
        this.createToken(card, this.mDefaultPublishableKey, callback);
    }

    public void createToken(@NonNull Card card, @NonNull String publishableKey, @NonNull TokenCallback callback) {
        this.createToken(card, publishableKey, null, callback);
    }

    public void createToken(@NonNull Card card, @NonNull Executor executor, @NonNull TokenCallback callback) {
        this.createToken(card, this.mDefaultPublishableKey, executor, callback);
    }

    public void createToken(@NonNull Card card, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        if (card == null) {
            throw new RuntimeException("Required Parameter: 'card' is required to create a token");
        }
        this.createTokenFromParams(this.mStripeNetworkUtils.hashMapFromCard(card), publishableKey, "card", executor, callback);
    }

    @Nullable
    public Source createSourceSynchronous(@NonNull SourceParams params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.createSourceSynchronous(params, null);
    }

    @Nullable
    public Source createSourceSynchronous(@NonNull SourceParams params, @Nullable String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String apiKey;
        String string = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return null;
        }
        return this.mApiHandler.createSource(params, apiKey, this.mStripeAccount);
    }

    public PaymentIntent retrievePaymentIntentSynchronous(@NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.retrievePaymentIntent(paymentIntentParams, publishableKey, this.mStripeAccount);
    }

    @Nullable
    public PaymentIntent confirmPaymentIntentSynchronous(@NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.confirmPaymentIntent(paymentIntentParams, publishableKey, this.mStripeAccount);
    }

    @Nullable
    public PaymentMethod createPaymentMethodSynchronous(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.createPaymentMethod(paymentMethodCreateParams, publishableKey, this.mStripeAccount);
    }

    public Token createTokenSynchronous(Card card) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createTokenSynchronous(card, this.mDefaultPublishableKey);
    }

    public Token createTokenSynchronous(Card card, String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.validateKey(publishableKey);
        return this.mApiHandler.createToken(this.mStripeNetworkUtils.hashMapFromCard(card), RequestOptions.createForApi(publishableKey, this.mStripeAccount), "card");
    }

    public Token createPiiTokenSynchronous(@NonNull String personalId) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createPiiTokenSynchronous(personalId, this.mDefaultPublishableKey);
    }

    public Token createPiiTokenSynchronous(@NonNull String personalId, String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.validateKey(publishableKey);
        return this.mApiHandler.createToken(StripeNetworkUtils.hashMapFromPersonalId(personalId), RequestOptions.createForApi(publishableKey, this.mStripeAccount), "pii");
    }

    @Nullable
    public Token createCvcUpdateTokenSynchronous(@NonNull String cvc) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCvcUpdateTokenSynchronous(cvc, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createCvcUpdateTokenSynchronous(@NonNull String cvc, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.validateKey(publishableKey);
        return this.mApiHandler.createToken(StripeNetworkUtils.mapFromCvc(cvc), RequestOptions.createForApi(publishableKey, this.mStripeAccount), "cvc_update");
    }

    @Nullable
    public Token createAccountTokenSynchronous(@NonNull AccountParams accountParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.createAccountTokenSynchronous(accountParams, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createAccountTokenSynchronous(@NonNull AccountParams accountParams, @Nullable String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String apiKey;
        String string = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return null;
        }
        this.validateKey(publishableKey);
        try {
            return this.mApiHandler.createToken(accountParams.toParamMap(), RequestOptions.createForApi(publishableKey, this.mStripeAccount), "account");
        }
        catch (CardException cardException) {
            return null;
        }
    }

    public void logEventSynchronous(@NonNull List<String> productUsageTokens, @NonNull StripePaymentSource paymentSource) {
        Map<String, Object> loggingMap;
        if (paymentSource instanceof Token) {
            Token token = (Token)paymentSource;
            loggingMap = this.mLoggingUtils.getTokenCreationParams(productUsageTokens, this.mDefaultPublishableKey, token.getType());
        } else {
            Source source = (Source)paymentSource;
            loggingMap = this.mLoggingUtils.getSourceCreationParams(productUsageTokens, this.mDefaultPublishableKey, source.getType());
        }
        this.mApiHandler.logApiCall(loggingMap, RequestOptions.createForApi(this.mDefaultPublishableKey, this.mStripeAccount));
    }

    public Source retrieveSourceSynchronous(@NonNull @Size(min=1L) String sourceId, @NonNull @Size(min=1L) String clientSecret) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.retrieveSourceSynchronous(sourceId, clientSecret, null);
    }

    public Source retrieveSourceSynchronous(@NonNull @Size(min=1L) String sourceId, @NonNull @Size(min=1L) String clientSecret, @Nullable String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String apiKey;
        String string = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return null;
        }
        return this.mApiHandler.retrieveSource(sourceId, clientSecret, apiKey, this.mStripeAccount);
    }

    public void setDefaultPublishableKey(@NonNull @Size(min=1L) String publishableKey) {
        this.validateKey(publishableKey);
        this.mDefaultPublishableKey = publishableKey;
    }

    public void setStripeAccount(@NonNull @Size(min=1L) String stripeAccount) {
        this.mStripeAccount = stripeAccount;
    }

    private void createTokenFromParams(@NonNull Map<String, Object> tokenParams, @NonNull @Size(min=1L) String publishableKey, @NonNull String tokenType, @Nullable Executor executor, @NonNull TokenCallback callback) {
        if (callback == null) {
            throw new RuntimeException("Required Parameter: 'callback' is required to use the created token and handle errors");
        }
        this.validateKey(publishableKey);
        this.mTokenCreator.create(tokenParams, publishableKey, this.mStripeAccount, tokenType, executor, callback);
    }

    private void validateKey(@NonNull @Size(min=1L) String publishableKey) {
        if (publishableKey == null || publishableKey.length() == 0) {
            throw new IllegalArgumentException("Invalid Publishable Key: You must use a valid publishable key to create a token.  For more info, see https://stripe.com/docs/stripe.js.");
        }
        if (publishableKey.startsWith("sk_")) {
            throw new IllegalArgumentException("Invalid Publishable Key: You are using a secret key to create a token, instead of the publishable one. For more info, see https://stripe.com/docs/stripe.js");
        }
    }

    private void executeTask(@Nullable Executor executor, @NonNull AsyncTask<Void, Void, ?> task) {
        if (executor != null) {
            task.executeOnExecutor(executor, (Object[])new Void[0]);
        } else {
            task.execute((Object[])new Void[0]);
        }
    }

    private static class CreateTokenTask
    extends ApiOperation<Token> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final Map<String, Object> mTokenParams;
        @NonNull
        private final String mPublishableKey;
        @Nullable
        private final String mStripeAccount;
        @NonNull
        private final String mTokenType;

        CreateTokenTask(@NonNull StripeApiHandler apiHandler, @NonNull Map<String, Object> tokenParams, @NonNull String publishableKey, @Nullable String stripeAccount, @NonNull String tokenType, @NonNull TokenCallback callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mTokenParams = tokenParams;
            this.mPublishableKey = publishableKey;
            this.mStripeAccount = stripeAccount;
            this.mTokenType = tokenType;
        }

        @Override
        @Nullable
        Token getResult() throws StripeException {
            RequestOptions requestOptions = RequestOptions.createForApi(this.mPublishableKey, this.mStripeAccount);
            return this.mApiHandler.createToken(this.mTokenParams, requestOptions, this.mTokenType);
        }
    }

    private static class CreatePaymentMethodTask
    extends ApiOperation<PaymentMethod> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final PaymentMethodCreateParams mPaymentMethodCreateParams;
        @NonNull
        private final String mPublishableKey;
        @Nullable
        private final String mStripeAccount;

        CreatePaymentMethodTask(@NonNull StripeApiHandler apiHandler, @NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String publishableKey, @Nullable String stripeAccount, @NonNull ApiResultCallback<PaymentMethod> callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mPaymentMethodCreateParams = paymentMethodCreateParams;
            this.mPublishableKey = publishableKey;
            this.mStripeAccount = stripeAccount;
        }

        @Override
        @Nullable
        PaymentMethod getResult() throws StripeException {
            return this.mApiHandler.createPaymentMethod(this.mPaymentMethodCreateParams, this.mPublishableKey, this.mStripeAccount);
        }
    }

    private static class CreateSourceTask
    extends ApiOperation<Source> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final SourceParams mSourceParams;
        @NonNull
        private final String mPublishableKey;
        @Nullable
        private final String mStripeAccount;

        CreateSourceTask(@NonNull StripeApiHandler apiHandler, @NonNull SourceParams sourceParams, @NonNull String publishableKey, @Nullable String stripeAccount, @NonNull SourceCallback callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mSourceParams = sourceParams;
            this.mPublishableKey = publishableKey;
            this.mStripeAccount = stripeAccount;
        }

        @Override
        @Nullable
        Source getResult() throws StripeException {
            return this.mApiHandler.createSource(this.mSourceParams, this.mPublishableKey, this.mStripeAccount);
        }
    }

    @VisibleForTesting
    static interface TokenCreator {
        public void create(@NonNull Map<String, Object> var1, @NonNull String var2, @Nullable String var3, @NonNull String var4, @Nullable Executor var5, @NonNull TokenCallback var6);
    }
}

