/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.stripe.android.ApiVersion;
import com.stripe.android.RequestOptions;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.StripeRequest;
import com.stripe.android.StripeResponse;
import com.stripe.android.StripeSSLSocketFactory;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.InvalidRequestException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class RequestExecutor {
    static final String API_HOST = "https://api.stripe.com";
    static final String ANALYTICS_HOST = "https://q.stripe.com";
    static final String FINGERPRINTING_ENDPOINT = "https://m.stripe.com/4";
    private static final String CHARSET = "UTF-8";
    @NonNull
    private final ConnectionFactory mConnectionFactory = new ConnectionFactory();

    RequestExecutor() {
    }

    @NonNull
    StripeResponse execute(@NonNull StripeRequest request) throws APIConnectionException, InvalidRequestException {
        HttpURLConnection conn = null;
        try {
            conn = this.mConnectionFactory.create(request);
            int rCode = conn.getResponseCode();
            String rBody = rCode >= 200 && rCode < 300 ? this.getResponseBody(conn.getInputStream()) : this.getResponseBody(conn.getErrorStream());
            StripeResponse stripeResponse = new StripeResponse(rCode, rBody, conn.getHeaderFields());
            return stripeResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format(Locale.ENGLISH, "IOException during API request to Stripe (%s): %s Please check your internet connection and try again. If this problem persists, you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", StripeApiHandler.getTokensUrl(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Nullable
    private String getResponseBody(@NonNull InputStream responseStream) throws IOException {
        Scanner scanner = new Scanner(responseStream, CHARSET).useDelimiter("\\A");
        String rBody = scanner.hasNext() ? scanner.next() : null;
        responseStream.close();
        return rBody;
    }

    static class ConnectionFactory {
        private static final SSLSocketFactory SSL_SOCKET_FACTORY = new StripeSSLSocketFactory();
        @NonNull
        private final ApiVersion mApiVersion;

        @VisibleForTesting
        ConnectionFactory() {
            this(ApiVersion.getDefault());
        }

        private ConnectionFactory(@NonNull ApiVersion apiVersion) {
            this.mApiVersion = apiVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        private HttpURLConnection create(@NonNull StripeRequest request) throws IOException, InvalidRequestException {
            URL stripeURL = new URL(request.getUrl());
            HttpURLConnection conn = (HttpURLConnection)stripeURL.openConnection();
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(80000);
            conn.setUseCaches(false);
            if (request.urlStartsWith(RequestExecutor.API_HOST, RequestExecutor.ANALYTICS_HOST)) {
                for (Map.Entry<String, String> header : request.getHeaders(this.mApiVersion).entrySet()) {
                    conn.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            if (request.urlStartsWith(RequestExecutor.FINGERPRINTING_ENDPOINT)) {
                this.attachPseudoCookie(conn, request.options);
            }
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(SSL_SOCKET_FACTORY);
            }
            conn.setRequestMethod(request.method.code);
            if (StripeRequest.Method.POST == request.method) {
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", request.getContentType());
                try (OutputStream output = null;){
                    output = conn.getOutputStream();
                    output.write(this.getOutputBytes(request));
                }
            }
            return conn;
        }

        private void attachPseudoCookie(@NonNull HttpURLConnection connection, @NonNull RequestOptions options) {
            if (options.getGuid() != null && !TextUtils.isEmpty((CharSequence)options.getGuid())) {
                connection.setRequestProperty("Cookie", "m=" + options.getGuid());
            }
        }

        @NonNull
        private byte[] getOutputBytes(@NonNull StripeRequest request) throws InvalidRequestException {
            try {
                if (1 == request.options.getRequestType()) {
                    JSONObject jsonData = this.mapToJsonObject(request.params);
                    if (jsonData == null) {
                        throw new InvalidRequestException("Unable to create JSON data from parameters. Please contact support@stripe.com for assistance.", null, null, 0, null, null, null, null);
                    }
                    return jsonData.toString().getBytes(RequestExecutor.CHARSET);
                }
                return request.createQuery().getBytes(RequestExecutor.CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@stripe.com for assistance.", null, null, 0, null, null, null, e);
            }
        }

        @Nullable
        private JSONObject mapToJsonObject(@Nullable Map<String, ?> mapObject) {
            if (mapObject == null) {
                return null;
            }
            JSONObject jsonObject = new JSONObject();
            for (String key : mapObject.keySet()) {
                Object value = mapObject.get(key);
                if (value == null) continue;
                try {
                    if (value instanceof Map) {
                        try {
                            Map mapValue = (Map)value;
                            jsonObject.put(key, (Object)this.mapToJsonObject(mapValue));
                        }
                        catch (ClassCastException classCastException) {}
                        continue;
                    }
                    if (value instanceof List) {
                        jsonObject.put(key, (Object)this.listToJsonArray((List)value));
                        continue;
                    }
                    if (value instanceof Number || value instanceof Boolean) {
                        jsonObject.put(key, value);
                        continue;
                    }
                    jsonObject.put(key, (Object)value.toString());
                }
                catch (JSONException jSONException) {}
            }
            return jsonObject;
        }

        @Nullable
        private JSONArray listToJsonArray(@Nullable List<?> values) {
            if (values == null) {
                return null;
            }
            JSONArray jsonArray = new JSONArray();
            for (Object object : values) {
                if (object instanceof Map) {
                    Map mapObject = (Map)object;
                    jsonArray.put((Object)this.mapToJsonObject(mapObject));
                    continue;
                }
                if (object instanceof List) {
                    jsonArray.put((Object)this.listToJsonArray((List)object));
                    continue;
                }
                if (object instanceof Number || object instanceof Boolean) {
                    jsonArray.put(object);
                    continue;
                }
                jsonArray.put((Object)object.toString());
            }
            return jsonArray;
        }
    }
}

