/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.stripe.android.ApiVersion;
import com.stripe.android.RequestOptions;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.StripeRequest;
import com.stripe.android.StripeResponse;
import com.stripe.android.StripeSSLSocketFactory;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.InvalidRequestException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class RequestExecutor {
    static final String LIVE_API_BASE = "https://api.stripe.com";
    static final String LIVE_LOGGING_BASE = "https://q.stripe.com";
    static final String LOGGING_ENDPOINT = "https://m.stripe.com/4";
    private static final String CHARSET = "UTF-8";
    @NonNull
    private final ConnectionFactory mConnectionFactory = new ConnectionFactory();

    RequestExecutor() {
    }

    @NonNull
    StripeResponse execute(@NonNull StripeRequest request) throws APIConnectionException, InvalidRequestException {
        HttpURLConnection conn = null;
        try {
            conn = this.mConnectionFactory.create(request);
            int rCode = conn.getResponseCode();
            String rBody = rCode >= 200 && rCode < 300 ? this.getResponseBody(conn.getInputStream()) : this.getResponseBody(conn.getErrorStream());
            StripeResponse stripeResponse = new StripeResponse(rCode, rBody, conn.getHeaderFields());
            return stripeResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format(Locale.ENGLISH, "IOException during API request to Stripe (%s): %s Please check your internet connection and try again. If this problem persists, you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", StripeApiHandler.getTokensUrl(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Nullable
    private String getResponseBody(@NonNull InputStream responseStream) throws IOException {
        Scanner scanner = new Scanner(responseStream, CHARSET).useDelimiter("\\A");
        String rBody = scanner.hasNext() ? scanner.next() : null;
        responseStream.close();
        return rBody;
    }

    private static final class Parameter {
        @NonNull
        private final String key;
        @NonNull
        private final String value;

        Parameter(@NonNull String key, @NonNull String value) {
            this.key = key;
            this.value = value;
        }
    }

    static class ConnectionFactory {
        private static final SSLSocketFactory SSL_SOCKET_FACTORY = new StripeSSLSocketFactory();
        @NonNull
        private final ApiVersion mApiVersion;

        @VisibleForTesting
        ConnectionFactory() {
            this(ApiVersion.getDefault());
        }

        private ConnectionFactory(@NonNull ApiVersion apiVersion) {
            this.mApiVersion = apiVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        private HttpURLConnection create(@NonNull StripeRequest request) throws IOException, InvalidRequestException {
            URL stripeURL = new URL(this.getUrl(request));
            HttpURLConnection conn = (HttpURLConnection)stripeURL.openConnection();
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(80000);
            conn.setUseCaches(false);
            if (this.urlNeedsHeaderData(request.url)) {
                for (Map.Entry<String, String> header : this.getHeaders(request.options).entrySet()) {
                    conn.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            if (this.urlNeedsPseudoCookie(request.url)) {
                this.attachPseudoCookie(conn, request.options);
            }
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(SSL_SOCKET_FACTORY);
            }
            conn.setRequestMethod(request.method.code);
            if (StripeRequest.Method.POST == request.method) {
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", this.getContentType(request.options));
                try (OutputStream output = null;){
                    output = conn.getOutputStream();
                    output.write(this.getOutputBytes(request.params, request.options));
                }
            }
            return conn;
        }

        @NonNull
        private String getUrl(@NonNull StripeRequest request) throws UnsupportedEncodingException, InvalidRequestException {
            if (StripeRequest.Method.GET == request.method) {
                return this.formatUrl(request.url, this.createQuery(request.params));
            }
            return request.url;
        }

        @NonNull
        private String formatUrl(@NonNull String url, @Nullable String query) {
            if (query == null || query.isEmpty()) {
                return url;
            }
            String separator = url.contains("?") ? "&" : "?";
            return String.format(Locale.ROOT, "%s%s%s", url, separator, query);
        }

        private boolean urlNeedsHeaderData(@NonNull String url) {
            return url.startsWith(RequestExecutor.LIVE_API_BASE) || url.startsWith(RequestExecutor.LIVE_LOGGING_BASE);
        }

        private boolean urlNeedsPseudoCookie(@NonNull String url) {
            return url.startsWith(RequestExecutor.LOGGING_ENDPOINT);
        }

        private void attachPseudoCookie(@NonNull HttpURLConnection connection, @NonNull RequestOptions options) {
            if (options.getGuid() != null && !TextUtils.isEmpty((CharSequence)options.getGuid())) {
                connection.setRequestProperty("Cookie", "m=" + options.getGuid());
            }
        }

        @NonNull
        private String getContentType(@NonNull RequestOptions options) {
            if ("json_data".equals(options.getRequestType())) {
                return String.format(Locale.ROOT, "application/json; charset=%s", RequestExecutor.CHARSET);
            }
            return String.format(Locale.ROOT, "application/x-www-form-urlencoded;charset=%s", RequestExecutor.CHARSET);
        }

        @NonNull
        private byte[] getOutputBytes(@Nullable Map<String, ?> params, @NonNull RequestOptions options) throws InvalidRequestException {
            try {
                if ("json_data".equals(options.getRequestType())) {
                    JSONObject jsonData = this.mapToJsonObject(params);
                    if (jsonData == null) {
                        throw new InvalidRequestException("Unable to create JSON data from parameters. Please contact support@stripe.com for assistance.", null, null, 0, null, null, null, null);
                    }
                    return jsonData.toString().getBytes(RequestExecutor.CHARSET);
                }
                return this.createQuery(params).getBytes(RequestExecutor.CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@stripe.com for assistance.", null, null, 0, null, null, null, e);
            }
        }

        @Nullable
        private JSONObject mapToJsonObject(@Nullable Map<String, ?> mapObject) {
            if (mapObject == null) {
                return null;
            }
            JSONObject jsonObject = new JSONObject();
            for (String key : mapObject.keySet()) {
                Object value = mapObject.get(key);
                if (value == null) continue;
                try {
                    if (value instanceof Map) {
                        try {
                            Map mapValue = (Map)value;
                            jsonObject.put(key, (Object)this.mapToJsonObject(mapValue));
                        }
                        catch (ClassCastException classCastException) {}
                        continue;
                    }
                    if (value instanceof List) {
                        jsonObject.put(key, (Object)this.listToJsonArray((List)value));
                        continue;
                    }
                    if (value instanceof Number || value instanceof Boolean) {
                        jsonObject.put(key, value);
                        continue;
                    }
                    jsonObject.put(key, (Object)value.toString());
                }
                catch (JSONException jSONException) {}
            }
            return jsonObject;
        }

        @Nullable
        private JSONArray listToJsonArray(@Nullable List<?> values) {
            if (values == null) {
                return null;
            }
            JSONArray jsonArray = new JSONArray();
            for (Object object : values) {
                if (object instanceof Map) {
                    Map mapObject = (Map)object;
                    jsonArray.put((Object)this.mapToJsonObject(mapObject));
                    continue;
                }
                if (object instanceof List) {
                    jsonArray.put((Object)this.listToJsonArray((List)object));
                    continue;
                }
                if (object instanceof Number || object instanceof Boolean) {
                    jsonArray.put(object);
                    continue;
                }
                jsonArray.put((Object)object.toString());
            }
            return jsonArray;
        }

        @NonNull
        String createQuery(@Nullable Map<String, ?> params) throws UnsupportedEncodingException, InvalidRequestException {
            StringBuilder queryStringBuffer = new StringBuilder();
            List<Parameter> flatParams = this.flattenParams(params);
            for (Parameter flatParam : flatParams) {
                if (queryStringBuffer.length() > 0) {
                    queryStringBuffer.append("&");
                }
                queryStringBuffer.append(this.urlEncodePair(flatParam.key, flatParam.value));
            }
            return queryStringBuffer.toString();
        }

        @NonNull
        private List<Parameter> flattenParams(@Nullable Map<String, ?> params) throws InvalidRequestException {
            return this.flattenParamsMap(params, null);
        }

        @NonNull
        private List<Parameter> flattenParamsList(@NonNull List<?> params, @NonNull String keyPrefix) throws InvalidRequestException {
            LinkedList<Parameter> flatParams = new LinkedList<Parameter>();
            if (params.isEmpty()) {
                flatParams.add(new Parameter(keyPrefix, ""));
            } else {
                String newPrefix = String.format(Locale.ROOT, "%s[]", keyPrefix);
                for (Object param : params) {
                    flatParams.addAll(this.flattenParamsValue(param, newPrefix));
                }
            }
            return flatParams;
        }

        @NonNull
        private List<Parameter> flattenParamsMap(@Nullable Map<String, ?> params, @Nullable String keyPrefix) throws InvalidRequestException {
            LinkedList<Parameter> flatParams = new LinkedList<Parameter>();
            if (params == null) {
                return flatParams;
            }
            for (Map.Entry<String, ?> entry : params.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                String newPrefix = keyPrefix != null ? String.format(Locale.ROOT, "%s[%s]", keyPrefix, key) : key;
                flatParams.addAll(this.flattenParamsValue(value, newPrefix));
            }
            return flatParams;
        }

        @NonNull
        private List<Parameter> flattenParamsValue(@Nullable Object value, @NonNull String keyPrefix) throws InvalidRequestException {
            List<Parameter> flatParams;
            if (value instanceof Map) {
                flatParams = this.flattenParamsMap((Map)value, keyPrefix);
            } else if (value instanceof List) {
                flatParams = this.flattenParamsList((List)value, keyPrefix);
            } else {
                if ("".equals(value)) {
                    throw new InvalidRequestException("You cannot set '" + keyPrefix + "' to an empty string. We interpret empty strings as null in requests. You may set '" + keyPrefix + "' to null to delete the property.", keyPrefix, null, 0, null, null, null, null);
                }
                if (value == null) {
                    flatParams = new LinkedList<Parameter>();
                    flatParams.add(new Parameter(keyPrefix, ""));
                } else {
                    flatParams = new LinkedList<Parameter>();
                    flatParams.add(new Parameter(keyPrefix, value.toString()));
                }
            }
            return flatParams;
        }

        @NonNull
        private String urlEncodePair(@NonNull String k, @NonNull String v) throws UnsupportedEncodingException {
            return String.format(Locale.ROOT, "%s=%s", this.urlEncode(k), this.urlEncode(v));
        }

        @Nullable
        private String urlEncode(@Nullable String str) throws UnsupportedEncodingException {
            if (str == null) {
                return null;
            }
            return URLEncoder.encode(str, RequestExecutor.CHARSET);
        }

        @NonNull
        @VisibleForTesting
        Map<String, String> getHeaders(@NonNull RequestOptions options) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept-Charset", RequestExecutor.CHARSET);
            headers.put("Accept", "application/json");
            headers.put("User-Agent", String.format(Locale.ROOT, "Stripe/v1 AndroidBindings/%s", "9.0.1"));
            headers.put("Authorization", String.format(Locale.ENGLISH, "Bearer %s", options.getPublishableApiKey()));
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            ((AbstractMap)propertyMap).put("java.version", System.getProperty("java.version"));
            ((AbstractMap)propertyMap).put("os.name", "android");
            ((AbstractMap)propertyMap).put("os.version", String.valueOf(Build.VERSION.SDK_INT));
            ((AbstractMap)propertyMap).put("bindings.version", "9.0.1");
            ((AbstractMap)propertyMap).put("lang", "Java");
            ((AbstractMap)propertyMap).put("publisher", "Stripe");
            JSONObject headerMappingObject = new JSONObject(propertyMap);
            headers.put("X-Stripe-Client-User-Agent", headerMappingObject.toString());
            headers.put("Stripe-Version", this.mApiVersion.getCode());
            if (options.getStripeAccount() != null) {
                headers.put("Stripe-Account", options.getStripeAccount());
            }
            if (options.getIdempotencyKey() != null) {
                headers.put("Idempotency-Key", options.getIdempotencyKey());
            }
            return headers;
        }
    }
}

