/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.UidProvider;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StripeNetworkUtils {
    private static final String MUID = "muid";
    private static final String GUID = "guid";
    @NonNull
    private final String mPackageName;
    @NonNull
    private final UidProvider mUidProvider;

    StripeNetworkUtils(@NonNull Context context) {
        this(context.getPackageName(), new UidProvider(context));
    }

    @VisibleForTesting
    StripeNetworkUtils(@NonNull String packageName, @NonNull UidProvider uidProvider) {
        this.mPackageName = packageName;
        this.mUidProvider = uidProvider;
    }

    @NonNull
    Map<String, Object> hashMapFromCard(@NonNull Card card) {
        HashMap<String, Object> tokenParams = new HashMap<String, Object>();
        HashMap<String, Object> cardParams = new HashMap<String, Object>();
        ((AbstractMap)cardParams).put("number", StripeTextUtils.nullIfBlank(card.getNumber()));
        ((AbstractMap)cardParams).put("cvc", StripeTextUtils.nullIfBlank(card.getCVC()));
        ((AbstractMap)cardParams).put("exp_month", card.getExpMonth());
        ((AbstractMap)cardParams).put("exp_year", card.getExpYear());
        ((AbstractMap)cardParams).put("name", StripeTextUtils.nullIfBlank(card.getName()));
        ((AbstractMap)cardParams).put("currency", StripeTextUtils.nullIfBlank(card.getCurrency()));
        ((AbstractMap)cardParams).put("address_line1", StripeTextUtils.nullIfBlank(card.getAddressLine1()));
        ((AbstractMap)cardParams).put("address_line2", StripeTextUtils.nullIfBlank(card.getAddressLine2()));
        ((AbstractMap)cardParams).put("address_city", StripeTextUtils.nullIfBlank(card.getAddressCity()));
        ((AbstractMap)cardParams).put("address_zip", StripeTextUtils.nullIfBlank(card.getAddressZip()));
        ((AbstractMap)cardParams).put("address_state", StripeTextUtils.nullIfBlank(card.getAddressState()));
        ((AbstractMap)cardParams).put("address_country", StripeTextUtils.nullIfBlank(card.getAddressCountry()));
        StripeNetworkUtils.removeNullAndEmptyParams(cardParams);
        tokenParams.put("product_usage", card.getLoggingTokens());
        tokenParams.put("card", cardParams);
        this.addUidParams(tokenParams);
        return tokenParams;
    }

    @NonNull
    static Map<String, Object> hashMapFromPersonalId(@NonNull String personalId) {
        HashMap<String, String> tokenParams = new HashMap<String, String>();
        tokenParams.put("personal_id_number", personalId);
        HashMap<String, Object> piiParams = new HashMap<String, Object>();
        piiParams.put("pii", tokenParams);
        return piiParams;
    }

    @NonNull
    static Map<String, Object> mapFromCvc(@NonNull String cvc) {
        HashMap<String, String> tokenParams = new HashMap<String, String>();
        tokenParams.put("cvc", cvc);
        HashMap<String, Object> cvcParams = new HashMap<String, Object>();
        cvcParams.put("cvc_update", tokenParams);
        return cvcParams;
    }

    @NonNull
    Map<String, Object> hashMapFromBankAccount(@NonNull BankAccount bankAccount) {
        HashMap<String, Object> tokenParams = new HashMap<String, Object>();
        HashMap<String, Object> accountParams = new HashMap<String, Object>();
        ((AbstractMap)accountParams).put("country", bankAccount.getCountryCode());
        ((AbstractMap)accountParams).put("currency", bankAccount.getCurrency());
        ((AbstractMap)accountParams).put("account_number", bankAccount.getAccountNumber());
        ((AbstractMap)accountParams).put("routing_number", StripeTextUtils.nullIfBlank(bankAccount.getRoutingNumber()));
        ((AbstractMap)accountParams).put("account_holder_name", StripeTextUtils.nullIfBlank(bankAccount.getAccountHolderName()));
        ((AbstractMap)accountParams).put("account_holder_type", StripeTextUtils.nullIfBlank(bankAccount.getAccountHolderType()));
        StripeNetworkUtils.removeNullAndEmptyParams(accountParams);
        tokenParams.put("bank_account", accountParams);
        this.addUidParams(tokenParams);
        return tokenParams;
    }

    public static void removeNullAndEmptyParams(@NonNull Map<String, Object> mapToEdit) {
        for (String key : new HashSet<String>(mapToEdit.keySet())) {
            CharSequence sequence;
            if (mapToEdit.get(key) == null) {
                mapToEdit.remove(key);
            }
            if (mapToEdit.get(key) instanceof CharSequence && TextUtils.isEmpty((CharSequence)(sequence = (CharSequence)mapToEdit.get(key)))) {
                mapToEdit.remove(key);
            }
            if (!(mapToEdit.get(key) instanceof Map)) continue;
            Map stringObjectMap = (Map)mapToEdit.get(key);
            StripeNetworkUtils.removeNullAndEmptyParams(stringObjectMap);
        }
    }

    void addUidParamsToPaymentIntent(@NonNull Map<String, Object> params) {
        if (params.containsKey("source_data") && params.get("source_data") instanceof Map) {
            this.addUidParams((Map)params.get("source_data"));
        }
    }

    void addUidParams(@NonNull Map<String, Object> params) {
        String guid = this.mUidProvider.get();
        if (StripeTextUtils.isBlank(guid)) {
            return;
        }
        String hashGuid = StripeTextUtils.shaHashInput(guid);
        String muid = this.mPackageName + guid;
        String hashMuid = StripeTextUtils.shaHashInput(muid);
        if (!StripeTextUtils.isBlank(hashGuid)) {
            params.put(GUID, hashGuid);
        }
        if (!StripeTextUtils.isBlank(hashMuid)) {
            params.put(MUID, hashMuid);
        }
    }
}

