/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.wallets;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.wallets.Wallet;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class VisaCheckoutWallet
extends Wallet {
    private static final String FIELD_BILLING_ADDRESS = "billing_address";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SHIPPING_ADDRESS = "shipping_address";
    @Nullable
    public final Wallet.Address billingAddress;
    @Nullable
    public final String email;
    @Nullable
    public final String name;
    @Nullable
    public final Wallet.Address shippingAddress;

    private VisaCheckoutWallet(@NonNull Builder builder) {
        super(Wallet.Type.VisaCheckout, builder);
        this.billingAddress = builder.mBillingAddress;
        this.email = builder.mEmail;
        this.name = builder.mName;
        this.shippingAddress = builder.mShippingAddress;
    }

    @Override
    @NonNull
    Map<String, Object> getWalletTypeMap() {
        HashMap<String, Object> wallet = new HashMap<String, Object>();
        ((AbstractMap)wallet).put(FIELD_BILLING_ADDRESS, this.billingAddress != null ? this.billingAddress.toMap() : null);
        ((AbstractMap)wallet).put(FIELD_EMAIL, this.email);
        ((AbstractMap)wallet).put(FIELD_NAME, this.name);
        ((AbstractMap)wallet).put(FIELD_SHIPPING_ADDRESS, this.shippingAddress != null ? this.shippingAddress.toMap() : null);
        return wallet;
    }

    @Override
    @NonNull
    JSONObject getWalletTypeJson() {
        JSONObject wallet = new JSONObject();
        try {
            wallet.put(FIELD_BILLING_ADDRESS, this.billingAddress != null ? this.billingAddress.toJson() : null);
            wallet.put(FIELD_EMAIL, (Object)this.email);
            wallet.put(FIELD_NAME, (Object)this.name);
            wallet.put(FIELD_SHIPPING_ADDRESS, this.shippingAddress != null ? this.shippingAddress.toJson() : null);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return wallet;
    }

    @NonNull
    static Builder fromJson(@NonNull JSONObject wallet) {
        return new Builder().setBillingAddress(Wallet.Address.fromJson(wallet.optJSONObject(FIELD_BILLING_ADDRESS))).setEmail(StripeJsonUtils.optString(wallet, FIELD_EMAIL)).setName(StripeJsonUtils.optString(wallet, FIELD_NAME)).setShippingAddress(Wallet.Address.fromJson(wallet.optJSONObject(FIELD_SHIPPING_ADDRESS)));
    }

    public int hashCode() {
        return ObjectUtils.hash(this.billingAddress, this.email, this.name, this.shippingAddress);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof VisaCheckoutWallet && this.typedEquals((VisaCheckoutWallet)obj);
    }

    private boolean typedEquals(@NonNull VisaCheckoutWallet wallet) {
        return ObjectUtils.equals(this.billingAddress, wallet.billingAddress) && ObjectUtils.equals(this.email, wallet.email) && ObjectUtils.equals(this.name, wallet.name) && ObjectUtils.equals(this.shippingAddress, wallet.shippingAddress);
    }

    public static final class Builder
    extends Wallet.Builder<VisaCheckoutWallet> {
        @Nullable
        private Wallet.Address mBillingAddress;
        @Nullable
        private String mEmail;
        @Nullable
        private String mName;
        @Nullable
        private Wallet.Address mShippingAddress;

        @NonNull
        public Builder setBillingAddress(@Nullable Wallet.Address billingAddress) {
            this.mBillingAddress = billingAddress;
            return this;
        }

        @NonNull
        public Builder setEmail(@Nullable String email) {
            this.mEmail = email;
            return this;
        }

        @NonNull
        public Builder setName(@Nullable String name) {
            this.mName = name;
            return this;
        }

        @NonNull
        public Builder setShippingAddress(@Nullable Wallet.Address shippingAddress) {
            this.mShippingAddress = shippingAddress;
            return this;
        }

        @Override
        @NonNull
        public VisaCheckoutWallet build() {
            return new VisaCheckoutWallet(this);
        }
    }
}

