/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.CustomerSource;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Customer
extends StripeJsonModel {
    private static final String FIELD_ID = "id";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_DEFAULT_SOURCE = "default_source";
    private static final String FIELD_SHIPPING = "shipping";
    private static final String FIELD_SOURCES = "sources";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_HAS_MORE = "has_more";
    private static final String FIELD_TOTAL_COUNT = "total_count";
    private static final String FIELD_URL = "url";
    private static final String VALUE_LIST = "list";
    private static final String VALUE_CUSTOMER = "customer";
    private static final String VALUE_APPLE_PAY = "apple_pay";
    @Nullable
    private String mId;
    @Nullable
    private String mDefaultSource;
    @Nullable
    private ShippingInformation mShippingInformation;
    @NonNull
    private List<CustomerSource> mSources = new ArrayList<CustomerSource>();
    @Nullable
    private Boolean mHasMore;
    @Nullable
    private Integer mTotalCount;
    @Nullable
    private String mUrl;

    private Customer() {
    }

    public String getId() {
        return this.mId;
    }

    public String getDefaultSource() {
        return this.mDefaultSource;
    }

    public ShippingInformation getShippingInformation() {
        return this.mShippingInformation;
    }

    @NonNull
    public List<CustomerSource> getSources() {
        return this.mSources;
    }

    public Boolean getHasMore() {
        return this.mHasMore;
    }

    public Integer getTotalCount() {
        return this.mTotalCount;
    }

    public String getUrl() {
        return this.mUrl;
    }

    @Nullable
    public CustomerSource getSourceById(@NonNull String sourceId) {
        for (CustomerSource source : this.mSources) {
            if (!sourceId.equals(source.getId())) continue;
            return source;
        }
        return null;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_ID, this.mId);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_OBJECT, VALUE_CUSTOMER);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_DEFAULT_SOURCE, this.mDefaultSource);
        StripeJsonModel.putStripeJsonModelIfNotNull(jsonObject, FIELD_SHIPPING, this.mShippingInformation);
        JSONObject sourcesObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(sourcesObject, FIELD_OBJECT, VALUE_LIST);
        StripeJsonUtils.putBooleanIfNotNull(sourcesObject, FIELD_HAS_MORE, this.mHasMore);
        StripeJsonUtils.putIntegerIfNotNull(sourcesObject, FIELD_TOTAL_COUNT, this.mTotalCount);
        Customer.putStripeJsonModelListIfNotNull(sourcesObject, FIELD_DATA, this.mSources);
        StripeJsonUtils.putStringIfNotNull(sourcesObject, FIELD_URL, this.mUrl);
        StripeJsonUtils.putObjectIfNotNull(jsonObject, FIELD_SOURCES, sourcesObject);
        return jsonObject;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> mapObject = new HashMap<String, Object>();
        mapObject.put(FIELD_ID, this.mId);
        mapObject.put(FIELD_OBJECT, VALUE_CUSTOMER);
        mapObject.put(FIELD_DEFAULT_SOURCE, this.mDefaultSource);
        StripeJsonModel.putStripeJsonModelMapIfNotNull(mapObject, FIELD_SHIPPING, this.mShippingInformation);
        HashMap<String, Object> sourcesObject = new HashMap<String, Object>();
        sourcesObject.put(FIELD_HAS_MORE, this.mHasMore);
        sourcesObject.put(FIELD_TOTAL_COUNT, this.mTotalCount);
        sourcesObject.put(FIELD_OBJECT, VALUE_LIST);
        sourcesObject.put(FIELD_URL, this.mUrl);
        StripeJsonModel.putStripeJsonModelListIfNotNull(sourcesObject, FIELD_DATA, this.mSources);
        StripeNetworkUtils.removeNullAndEmptyParams(sourcesObject);
        mapObject.put(FIELD_SOURCES, sourcesObject);
        StripeNetworkUtils.removeNullAndEmptyParams(mapObject);
        return mapObject;
    }

    @Nullable
    public static Customer fromString(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            return Customer.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static Customer fromJson(JSONObject jsonObject) {
        String objectType = StripeJsonUtils.optString(jsonObject, FIELD_OBJECT);
        if (!VALUE_CUSTOMER.equals(objectType)) {
            return null;
        }
        Customer customer = new Customer();
        customer.mId = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        customer.mDefaultSource = StripeJsonUtils.optString(jsonObject, FIELD_DEFAULT_SOURCE);
        customer.mShippingInformation = ShippingInformation.fromJson(jsonObject.optJSONObject(FIELD_SHIPPING));
        JSONObject sources = jsonObject.optJSONObject(FIELD_SOURCES);
        if (sources != null && VALUE_LIST.equals(StripeJsonUtils.optString(sources, FIELD_OBJECT))) {
            customer.mHasMore = StripeJsonUtils.optBoolean(sources, FIELD_HAS_MORE);
            customer.mTotalCount = StripeJsonUtils.optInteger(sources, FIELD_TOTAL_COUNT);
            customer.mUrl = StripeJsonUtils.optString(sources, FIELD_URL);
            ArrayList<CustomerSource> sourceDataList = new ArrayList<CustomerSource>();
            JSONArray dataArray = sources.optJSONArray(FIELD_DATA);
            for (int i = 0; i < dataArray.length(); ++i) {
                try {
                    JSONObject customerSourceObject = dataArray.getJSONObject(i);
                    CustomerSource sourceData = CustomerSource.fromJson(customerSourceObject);
                    if (sourceData == null || VALUE_APPLE_PAY.equals(sourceData.getTokenizationMethod())) continue;
                    sourceDataList.add(sourceData);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            customer.mSources = sourceDataList;
        }
        return customer;
    }
}

