/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.Currency;

public class PaymentConfiguration {
    private static PaymentConfiguration mInstance;
    @Nullable
    private ClassLoader mEphemeralKeyProviderClassLoader;
    @NonNull
    private String mPublishableKey;
    private int mRequiredBillingAddressFields;
    private boolean mShouldUseSourcesForCards;
    private Currency mCurrency;

    private PaymentConfiguration(@NonNull String publishableKey) {
        this.mPublishableKey = publishableKey;
    }

    @NonNull
    public static PaymentConfiguration getInstance() {
        if (mInstance == null) {
            throw new IllegalStateException("Attempted to get instance of PaymentConfiguration without initialization.");
        }
        return mInstance;
    }

    public static void init(@NonNull String publishableKey) {
        mInstance = new PaymentConfiguration(publishableKey);
        PaymentConfiguration.mInstance.mRequiredBillingAddressFields = 0;
        PaymentConfiguration.mInstance.mShouldUseSourcesForCards = true;
    }

    @NonNull
    public String getPublishableKey() {
        return this.mPublishableKey;
    }

    public int getRequiredBillingAddressFields() {
        return this.mRequiredBillingAddressFields;
    }

    @NonNull
    public PaymentConfiguration setRequiredBillingAddressFields(int requiredBillingAddressFields) {
        this.mRequiredBillingAddressFields = requiredBillingAddressFields;
        return this;
    }

    @Deprecated
    public boolean getShouldUseSourcesForCards() {
        return this.mShouldUseSourcesForCards;
    }

    @Deprecated
    @NonNull
    public PaymentConfiguration setShouldUseSourcesForCards(boolean shouldUseSourcesForCards) {
        this.mShouldUseSourcesForCards = shouldUseSourcesForCards;
        return this;
    }

    @VisibleForTesting
    static void setInstance(@Nullable PaymentConfiguration paymentConfiguration) {
        mInstance = paymentConfiguration;
    }
}

