/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.stripe.android.StripeTextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class StripeJsonUtils {
    private static final String EMPTY = "";
    private static final String NULL = "null";

    StripeJsonUtils() {
    }

    @Nullable
    static String getString(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) throws JSONException {
        return StripeJsonUtils.nullIfNullOrEmpty(jsonObject.getString(fieldName));
    }

    @Nullable
    static Boolean optBoolean(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        if (!jsonObject.has(fieldName)) {
            return null;
        }
        return jsonObject.optBoolean(fieldName);
    }

    @Nullable
    static Integer optInteger(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        if (!jsonObject.has(fieldName)) {
            return null;
        }
        return jsonObject.optInt(fieldName);
    }

    @Nullable
    static Long optLong(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        if (!jsonObject.has(fieldName)) {
            return null;
        }
        return jsonObject.optLong(fieldName);
    }

    @Nullable
    static String optString(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        return StripeJsonUtils.nullIfNullOrEmpty(jsonObject.optString(fieldName));
    }

    @Nullable
    @Size(value=2L)
    static String optCountryCode(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        String value = StripeJsonUtils.nullIfNullOrEmpty(jsonObject.optString(fieldName));
        if (value != null && value.length() == 2) {
            return value;
        }
        return null;
    }

    @Nullable
    @Size(value=3L)
    static String optCurrency(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        String value = StripeJsonUtils.nullIfNullOrEmpty(jsonObject.optString(fieldName));
        if (value != null && value.length() == 3) {
            return value;
        }
        return null;
    }

    @Nullable
    static Map<String, Object> optMap(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        JSONObject foundObject = jsonObject.optJSONObject(fieldName);
        if (foundObject == null) {
            return null;
        }
        return StripeJsonUtils.jsonObjectToMap(foundObject);
    }

    @Nullable
    static Map<String, String> optHash(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        JSONObject foundObject = jsonObject.optJSONObject(fieldName);
        if (foundObject == null) {
            return null;
        }
        return StripeJsonUtils.jsonObjectToStringMap(foundObject);
    }

    @Nullable
    static Map<String, Object> jsonObjectToMap(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keyIterator = jsonObject.keys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object value = jsonObject.opt(key);
            if (NULL.equals(value) || value == null) continue;
            if (value instanceof JSONObject) {
                map.put(key, StripeJsonUtils.jsonObjectToMap((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                map.put(key, StripeJsonUtils.jsonArrayToList((JSONArray)value));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    @Nullable
    static Map<String, String> jsonObjectToStringMap(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keyIterator = jsonObject.keys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object value = jsonObject.opt(key);
            if (NULL.equals(value) || value == null) continue;
            map.put(key, value.toString());
        }
        return map;
    }

    @Nullable
    static List<Object> jsonArrayToList(@Nullable JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<Object> objectList = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                Object ob = jsonArray.get(i);
                if (ob instanceof JSONArray) {
                    objectList.add(StripeJsonUtils.jsonArrayToList((JSONArray)ob));
                    continue;
                }
                if (ob instanceof JSONObject) {
                    Map<String, Object> objectMap = StripeJsonUtils.jsonObjectToMap((JSONObject)ob);
                    if (objectMap == null) continue;
                    objectList.add(objectMap);
                    continue;
                }
                if (NULL.equals(ob)) continue;
                objectList.add(ob);
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return objectList;
    }

    @Nullable
    static JSONObject mapToJsonObject(@Nullable Map<String, ? extends Object> mapObject) {
        if (mapObject == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        for (String key : mapObject.keySet()) {
            Object value = mapObject.get(key);
            if (value == null) continue;
            try {
                if (value instanceof Map) {
                    try {
                        Map mapValue = (Map)value;
                        jsonObject.put(key, (Object)StripeJsonUtils.mapToJsonObject(mapValue));
                    }
                    catch (ClassCastException classCastException) {}
                    continue;
                }
                if (value instanceof List) {
                    jsonObject.put(key, (Object)StripeJsonUtils.listToJsonArray((List)value));
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    jsonObject.put(key, value);
                    continue;
                }
                jsonObject.put(key, (Object)value.toString());
            }
            catch (JSONException jSONException) {}
        }
        return jsonObject;
    }

    @Nullable
    static JSONObject stringHashToJsonObject(@Nullable Map<String, String> stringStringMap) {
        if (stringStringMap == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        for (String key : stringStringMap.keySet()) {
            try {
                jsonObject.put(key, (Object)stringStringMap.get(key));
            }
            catch (JSONException jSONException) {}
        }
        return jsonObject;
    }

    @Nullable
    static JSONArray listToJsonArray(@Nullable List values) {
        if (values == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (Object object : values) {
            if (object instanceof Map) {
                try {
                    Map mapObject = (Map)object;
                    jsonArray.put((Object)StripeJsonUtils.mapToJsonObject(mapObject));
                }
                catch (ClassCastException classCastException) {}
                continue;
            }
            if (object instanceof List) {
                jsonArray.put((Object)StripeJsonUtils.listToJsonArray((List)object));
                continue;
            }
            if (object instanceof Number || object instanceof Boolean) {
                jsonArray.put(object);
                continue;
            }
            jsonArray.put((Object)object.toString());
        }
        return jsonArray;
    }

    static void putStringIfNotNull(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName, @Nullable String value) {
        if (!StripeTextUtils.isBlank(value)) {
            try {
                jsonObject.put(fieldName, (Object)value);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    static void putIntegerIfNotNull(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName, @Nullable Integer value) {
        if (value == null) {
            return;
        }
        try {
            jsonObject.put(fieldName, value.intValue());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    static void putLongIfNotNull(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName, @Nullable Long value) {
        if (value == null) {
            return;
        }
        try {
            jsonObject.put(fieldName, value.longValue());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    static void putDoubleIfNotNull(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName, @Nullable Double value) {
        if (value == null) {
            return;
        }
        try {
            jsonObject.put(fieldName, value.doubleValue());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    static void putBooleanIfNotNull(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName, @Nullable Boolean value) {
        if (value == null) {
            return;
        }
        try {
            jsonObject.put(fieldName, value.booleanValue());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    static void putStringHashIfNotNull(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName, @Nullable Map<String, String> value) {
        if (value == null) {
            return;
        }
        JSONObject jsonHash = StripeJsonUtils.stringHashToJsonObject(value);
        if (jsonHash == null) {
            return;
        }
        try {
            jsonObject.put(fieldName, (Object)jsonHash);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    static void putMapIfNotNull(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName, @Nullable Map<String, Object> value) {
        if (value == null) {
            return;
        }
        JSONObject mapObject = StripeJsonUtils.mapToJsonObject(value);
        if (mapObject == null) {
            return;
        }
        try {
            jsonObject.put(fieldName, (Object)mapObject);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    static void putObjectIfNotNull(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName, @Nullable JSONObject value) {
        if (value == null) {
            return;
        }
        try {
            jsonObject.put(fieldName, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Nullable
    static String nullIfNullOrEmpty(@Nullable String possibleNull) {
        return NULL.equals(possibleNull) || EMPTY.equals(possibleNull) ? null : possibleNull;
    }
}

