/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputLayout;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.stripe.android.R;
import com.stripe.android.model.Address;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.view.CountryAutoCompleteTextView;
import com.stripe.android.view.CountryUtils;
import com.stripe.android.view.ErrorListener;
import com.stripe.android.view.StripeEditText;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ShippingInfoWidget
extends LinearLayout {
    public static final String ADDRESS_LINE_ONE_FIELD = "address_line_one";
    public static final String ADDRESS_LINE_TWO_FIELD = "address_line_two";
    public static final String CITY_FIELD = "city";
    public static final String POSTAL_CODE_FIELD = "postal_code";
    public static final String STATE_FIELD = "state";
    public static final String PHONE_FIELD = "phone";
    private List<String> mOptionalShippingInfoFields = new ArrayList<String>();
    private List<String> mHiddenShippingInfoFields = new ArrayList<String>();
    private CountryAutoCompleteTextView mCountryAutoCompleteTextView;
    private TextInputLayout mAddressLine1TextInputLayout;
    private TextInputLayout mAddressLine2TextInputLayout;
    private TextInputLayout mCityTextInputLayout;
    private TextInputLayout mNameTextInputLayout;
    private TextInputLayout mPostalCodeTextInputLayout;
    private TextInputLayout mStateTextInputLayout;
    private TextInputLayout mPhoneNumberTextInputLayout;
    private StripeEditText mAddressEditText;
    private StripeEditText mAddressEditText2;
    private StripeEditText mCityEditText;
    private StripeEditText mNameEditText;
    private StripeEditText mPostalCodeEditText;
    private StripeEditText mStateEditText;
    private StripeEditText mPhoneNumberEditText;

    public ShippingInfoWidget(Context context) {
        super(context);
        this.initView();
    }

    public ShippingInfoWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ShippingInfoWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setOptionalFields(@Nullable List<String> optionalAddressFields) {
        this.mOptionalShippingInfoFields = optionalAddressFields != null ? optionalAddressFields : new ArrayList<String>();
        this.renderLabels();
        this.renderCountrySpecificLabels(this.mCountryAutoCompleteTextView.getSelectedCountryCode());
    }

    public void setHiddenFields(@Nullable List<String> hiddenAddressFields) {
        this.mHiddenShippingInfoFields = hiddenAddressFields != null ? hiddenAddressFields : new ArrayList<String>();
        this.renderLabels();
        this.renderCountrySpecificLabels(this.mCountryAutoCompleteTextView.getSelectedCountryCode());
    }

    public ShippingInformation getShippingInformation() {
        if (!this.validateAllFields()) {
            return null;
        }
        Address address = new Address.Builder().setCity(this.mCityEditText.getText().toString()).setCountry(this.mCountryAutoCompleteTextView.getSelectedCountryCode()).setLine1(this.mAddressEditText.getText().toString()).setLine2(this.mAddressEditText2.getText().toString()).setPostalCode(this.mPostalCodeEditText.getText().toString()).setState(this.mStateEditText.getText().toString()).build();
        ShippingInformation shippingInformation = new ShippingInformation(address, this.mNameEditText.getText().toString(), this.mPhoneNumberEditText.getText().toString());
        return shippingInformation;
    }

    public void populateShippingInfo(@Nullable ShippingInformation shippingInformation) {
        if (shippingInformation == null) {
            return;
        }
        Address address = shippingInformation.getAddress();
        if (address != null) {
            this.mCityEditText.setText(address.getCity());
            if (address.getCountry() != null && !address.getCountry().isEmpty()) {
                this.mCountryAutoCompleteTextView.setCountrySelected(address.getCountry());
            }
            this.mAddressEditText.setText(address.getLine1());
            this.mAddressEditText2.setText(address.getLine2());
            this.mPostalCodeEditText.setText(address.getPostalCode());
            this.mStateEditText.setText(address.getState());
        }
        this.mNameEditText.setText(shippingInformation.getName());
        this.mPhoneNumberEditText.setText(shippingInformation.getPhone());
    }

    public boolean validateAllFields() {
        boolean postalCodeValid = true;
        String countrySelected = this.mCountryAutoCompleteTextView.getSelectedCountryCode();
        if (this.mPostalCodeEditText.getText().toString().isEmpty() && (this.mOptionalShippingInfoFields.contains(POSTAL_CODE_FIELD) || this.mHiddenShippingInfoFields.contains(POSTAL_CODE_FIELD))) {
            postalCodeValid = true;
        } else if (countrySelected.equals(Locale.US.getCountry())) {
            postalCodeValid = CountryUtils.isUSZipCodeValid(this.mPostalCodeEditText.getText().toString().trim());
        } else if (countrySelected.equals(Locale.UK.getCountry())) {
            postalCodeValid = CountryUtils.isUSZipCodeValid(this.mPostalCodeEditText.getText().toString().trim());
        } else if (countrySelected.equals(Locale.CANADA.getCountry())) {
            postalCodeValid = CountryUtils.isUSZipCodeValid(this.mPostalCodeEditText.getText().toString().trim());
        } else if (CountryUtils.doesCountryUsePostalCode(countrySelected)) {
            postalCodeValid = !this.mPostalCodeEditText.getText().toString().isEmpty();
        }
        this.mPostalCodeEditText.setShouldShowError(!postalCodeValid);
        boolean requiredAddressLine1Empty = this.mAddressEditText.getText().toString().isEmpty() && !this.mOptionalShippingInfoFields.contains(ADDRESS_LINE_ONE_FIELD) && !this.mHiddenShippingInfoFields.contains(ADDRESS_LINE_ONE_FIELD);
        this.mAddressEditText.setShouldShowError(requiredAddressLine1Empty);
        boolean requiredCityEmpty = this.mCityEditText.getText().toString().isEmpty() && !this.mOptionalShippingInfoFields.contains(CITY_FIELD) && !this.mHiddenShippingInfoFields.contains(CITY_FIELD);
        this.mCityEditText.setShouldShowError(requiredCityEmpty);
        boolean requiredNameEmpty = this.mNameEditText.getText().toString().isEmpty();
        this.mNameEditText.setShouldShowError(requiredNameEmpty);
        boolean requiredStateEmpty = this.mStateEditText.getText().toString().isEmpty() && !this.mOptionalShippingInfoFields.contains(STATE_FIELD) && !this.mHiddenShippingInfoFields.contains(STATE_FIELD);
        this.mStateEditText.setShouldShowError(requiredStateEmpty);
        boolean requiredPhoneNumberEmpty = this.mPhoneNumberEditText.getText().toString().isEmpty() && !this.mOptionalShippingInfoFields.contains(PHONE_FIELD) && !this.mHiddenShippingInfoFields.contains(PHONE_FIELD);
        this.mPhoneNumberEditText.setShouldShowError(requiredPhoneNumberEmpty);
        return postalCodeValid && !requiredAddressLine1Empty && !requiredCityEmpty && !requiredStateEmpty && !requiredNameEmpty && !requiredPhoneNumberEmpty;
    }

    private void initView() {
        this.setOrientation(1);
        ShippingInfoWidget.inflate((Context)this.getContext(), (int)R.layout.add_address_widget, (ViewGroup)this);
        this.mCountryAutoCompleteTextView = (CountryAutoCompleteTextView)this.findViewById(R.id.country_autocomplete_aaw);
        this.mAddressLine1TextInputLayout = (TextInputLayout)this.findViewById(R.id.tl_address_line1_aaw);
        this.mAddressLine2TextInputLayout = (TextInputLayout)this.findViewById(R.id.tl_address_line2_aaw);
        this.mCityTextInputLayout = (TextInputLayout)this.findViewById(R.id.tl_city_aaw);
        this.mNameTextInputLayout = (TextInputLayout)this.findViewById(R.id.tl_name_aaw);
        this.mPostalCodeTextInputLayout = (TextInputLayout)this.findViewById(R.id.tl_postal_code_aaw);
        this.mStateTextInputLayout = (TextInputLayout)this.findViewById(R.id.tl_state_aaw);
        this.mAddressEditText = (StripeEditText)this.findViewById(R.id.et_address_line_one_aaw);
        this.mAddressEditText2 = (StripeEditText)this.findViewById(R.id.et_address_line_two_aaw);
        this.mCityEditText = (StripeEditText)this.findViewById(R.id.et_city_aaw);
        this.mNameEditText = (StripeEditText)this.findViewById(R.id.et_name_aaw);
        this.mPostalCodeEditText = (StripeEditText)this.findViewById(R.id.et_postal_code_aaw);
        this.mStateEditText = (StripeEditText)this.findViewById(R.id.et_state_aaw);
        this.mPhoneNumberEditText = (StripeEditText)this.findViewById(R.id.et_phone_number_aaw);
        this.mPhoneNumberTextInputLayout = (TextInputLayout)this.findViewById(R.id.tl_phone_number_aaw);
        this.mCountryAutoCompleteTextView.setCountryChangeListener(new CountryAutoCompleteTextView.CountryChangeListener(){

            @Override
            public void onCountryChanged(String countryCode) {
                ShippingInfoWidget.this.renderCountrySpecificLabels(ShippingInfoWidget.this.mCountryAutoCompleteTextView.getSelectedCountryCode());
            }
        });
        this.mPhoneNumberEditText.addTextChangedListener((TextWatcher)new PhoneNumberFormattingTextWatcher());
        this.setupErrorHandling();
        this.renderLabels();
        this.renderCountrySpecificLabels(this.mCountryAutoCompleteTextView.getSelectedCountryCode());
    }

    private void setupErrorHandling() {
        this.mAddressEditText.setErrorMessageListener(new ErrorListener(this.mAddressLine1TextInputLayout));
        this.mCityEditText.setErrorMessageListener(new ErrorListener(this.mCityTextInputLayout));
        this.mNameEditText.setErrorMessageListener(new ErrorListener(this.mNameTextInputLayout));
        this.mPostalCodeEditText.setErrorMessageListener(new ErrorListener(this.mPostalCodeTextInputLayout));
        this.mStateEditText.setErrorMessageListener(new ErrorListener(this.mStateTextInputLayout));
        this.mPhoneNumberEditText.setErrorMessageListener(new ErrorListener(this.mPhoneNumberTextInputLayout));
        this.mAddressEditText.setErrorMessage(this.getResources().getString(R.string.address_required));
        this.mCityEditText.setErrorMessage(this.getResources().getString(R.string.address_city_required));
        this.mNameEditText.setErrorMessage(this.getResources().getString(R.string.address_name_required));
        this.mPhoneNumberEditText.setErrorMessage(this.getResources().getString(R.string.address_phone_number_required));
    }

    private void renderLabels() {
        this.mNameTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_name));
        if (this.mOptionalShippingInfoFields.contains(CITY_FIELD)) {
            this.mCityTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_city_optional));
        } else {
            this.mCityTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_city));
        }
        if (this.mOptionalShippingInfoFields.contains(PHONE_FIELD)) {
            this.mPhoneNumberTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_phone_number_optional));
        } else {
            this.mPhoneNumberTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_phone_number));
        }
        this.hideHiddenFields();
    }

    private void hideHiddenFields() {
        if (this.mHiddenShippingInfoFields.contains(ADDRESS_LINE_ONE_FIELD)) {
            this.mAddressLine1TextInputLayout.setVisibility(8);
        }
        if (this.mHiddenShippingInfoFields.contains(ADDRESS_LINE_TWO_FIELD)) {
            this.mAddressLine2TextInputLayout.setVisibility(8);
        }
        if (this.mHiddenShippingInfoFields.contains(STATE_FIELD)) {
            this.mStateTextInputLayout.setVisibility(8);
        }
        if (this.mHiddenShippingInfoFields.contains(CITY_FIELD)) {
            this.mCityTextInputLayout.setVisibility(8);
        }
        if (this.mHiddenShippingInfoFields.contains(POSTAL_CODE_FIELD)) {
            this.mPostalCodeTextInputLayout.setVisibility(8);
        }
        if (this.mHiddenShippingInfoFields.contains(PHONE_FIELD)) {
            this.mPhoneNumberTextInputLayout.setVisibility(8);
        }
    }

    private void renderCountrySpecificLabels(String countrySelected) {
        if (countrySelected.equals(Locale.US.getCountry())) {
            this.renderUSForm();
        } else if (countrySelected.equals(Locale.UK.getCountry())) {
            this.renderGreatBritainForm();
        } else if (countrySelected.equals(Locale.CANADA.getCountry())) {
            this.renderCanadianForm();
        } else {
            this.renderInternationalForm();
        }
        if (CountryUtils.doesCountryUsePostalCode(countrySelected) && !this.mHiddenShippingInfoFields.contains(POSTAL_CODE_FIELD)) {
            this.mPostalCodeTextInputLayout.setVisibility(0);
        } else {
            this.mPostalCodeTextInputLayout.setVisibility(8);
        }
    }

    private void renderUSForm() {
        if (this.mOptionalShippingInfoFields.contains(ADDRESS_LINE_ONE_FIELD)) {
            this.mAddressLine1TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address_optional));
        } else {
            this.mAddressLine1TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address));
        }
        this.mAddressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_apt_optional));
        if (this.mOptionalShippingInfoFields.contains(POSTAL_CODE_FIELD)) {
            this.mPostalCodeTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_zip_code_optional));
        } else {
            this.mPostalCodeTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_zip_code));
        }
        if (this.mOptionalShippingInfoFields.contains(STATE_FIELD)) {
            this.mStateTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_state_optional));
        } else {
            this.mStateTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_state));
        }
        this.mPostalCodeEditText.setErrorMessage(this.getResources().getString(R.string.address_zip_invalid));
        this.mStateEditText.setErrorMessage(this.getResources().getString(R.string.address_state_required));
    }

    private void renderGreatBritainForm() {
        if (this.mOptionalShippingInfoFields.contains(ADDRESS_LINE_ONE_FIELD)) {
            this.mAddressLine1TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address_line1_optional));
        } else {
            this.mAddressLine1TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address_line1));
        }
        this.mAddressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address_line2_optional));
        if (this.mOptionalShippingInfoFields.contains(POSTAL_CODE_FIELD)) {
            this.mPostalCodeTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_postcode_optional));
        } else {
            this.mPostalCodeTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_postcode));
        }
        if (this.mOptionalShippingInfoFields.contains(STATE_FIELD)) {
            this.mStateTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_county_optional));
        } else {
            this.mStateTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_county));
        }
        this.mPostalCodeEditText.setErrorMessage(this.getResources().getString(R.string.address_postcode_invalid));
        this.mStateEditText.setErrorMessage(this.getResources().getString(R.string.address_county_required));
    }

    private void renderCanadianForm() {
        if (this.mOptionalShippingInfoFields.contains(ADDRESS_LINE_ONE_FIELD)) {
            this.mAddressLine1TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address_optional));
        } else {
            this.mAddressLine1TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address));
        }
        this.mAddressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_apt_optional));
        if (this.mOptionalShippingInfoFields.contains(POSTAL_CODE_FIELD)) {
            this.mPostalCodeTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_postal_code_optional));
        } else {
            this.mPostalCodeTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_postal_code));
        }
        if (this.mOptionalShippingInfoFields.contains(STATE_FIELD)) {
            this.mStateTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_province_optional));
        } else {
            this.mStateTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_province));
        }
        this.mPostalCodeEditText.setErrorMessage(this.getResources().getString(R.string.address_postal_code_invalid));
        this.mStateEditText.setErrorMessage(this.getResources().getString(R.string.address_province_required));
    }

    private void renderInternationalForm() {
        if (this.mOptionalShippingInfoFields.contains(ADDRESS_LINE_ONE_FIELD)) {
            this.mAddressLine1TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address_line1_optional));
        } else {
            this.mAddressLine1TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address_line1));
        }
        this.mAddressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address_line2_optional));
        if (this.mOptionalShippingInfoFields.contains(POSTAL_CODE_FIELD)) {
            this.mPostalCodeTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_zip_postal_code_optional));
        } else {
            this.mPostalCodeTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_zip_postal_code));
        }
        if (this.mOptionalShippingInfoFields.contains(STATE_FIELD)) {
            this.mStateTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_region_generic_optional));
        } else {
            this.mStateTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_region_generic));
        }
        this.mPostalCodeEditText.setErrorMessage(this.getResources().getString(R.string.address_zip_postal_invalid));
        this.mStateEditText.setErrorMessage(this.getResources().getString(R.string.address_region_generic_required));
    }
}

