/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.net;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import com.stripe.android.util.StripeTextUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

class TelemetryClientUtil {
    TelemetryClientUtil() {
    }

    static Map<String, Object> createTelemetryMap(@NonNull Context context) {
        HashMap<String, Object> telemetryMap = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> firstMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> secondMap = new HashMap<String, Object>();
        telemetryMap.put("v2", 1);
        telemetryMap.put("tag", "4.1.1");
        telemetryMap.put("src", "android-sdk");
        firstMap.put("c", TelemetryClientUtil.createSingleValuePair(Locale.getDefault().toString()));
        firstMap.put("d", TelemetryClientUtil.createSingleValuePair(TelemetryClientUtil.getAndroidVersionString()));
        firstMap.put("f", TelemetryClientUtil.createSingleValuePair(TelemetryClientUtil.getScreen(context)));
        firstMap.put("g", TelemetryClientUtil.createSingleValuePair(TelemetryClientUtil.getTimeZoneString()));
        telemetryMap.put("a", firstMap);
        secondMap.put("d", TelemetryClientUtil.getHashedMuid(context));
        String packageName = TelemetryClientUtil.getPackageName(context);
        secondMap.put("k", packageName);
        secondMap.put("o", Build.VERSION.RELEASE);
        secondMap.put("p", Build.VERSION.SDK_INT);
        secondMap.put("q", Build.MANUFACTURER);
        secondMap.put("r", Build.BRAND);
        secondMap.put("s", Build.MODEL);
        secondMap.put("t", Build.TAGS);
        if (context.getPackageName() != null) {
            try {
                PackageInfo pInfo = context.getPackageManager().getPackageInfo(packageName, 0);
                secondMap.put("l", pInfo.versionName);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        telemetryMap.put("b", secondMap);
        return telemetryMap;
    }

    private static Map<String, Object> createSingleValuePair(Object value) {
        HashMap<String, Object> singleItemMap = new HashMap<String, Object>();
        singleItemMap.put("v", value);
        return singleItemMap;
    }

    private static String getTimeZoneString() {
        int minutes = (int)TimeUnit.MINUTES.convert(TimeZone.getDefault().getRawOffset(), TimeUnit.MILLISECONDS);
        if (minutes % 60 == 0) {
            int hours = minutes / 60;
            return String.valueOf(hours);
        }
        BigDecimal decimalValue = new BigDecimal(minutes);
        decimalValue = decimalValue.setScale(2, 6);
        BigDecimal decHours = decimalValue.divide(new BigDecimal(60), new MathContext(2)).setScale(2, 6);
        return decHours.toString();
    }

    private static String getScreen(@NonNull Context context) {
        if (context.getResources() == null) {
            return "";
        }
        int width = context.getResources().getDisplayMetrics().widthPixels;
        int height = context.getResources().getDisplayMetrics().heightPixels;
        int density = context.getResources().getDisplayMetrics().densityDpi;
        return String.format(Locale.ENGLISH, "%dw_%dh_%ddpi", width, height, density);
    }

    private static String getAndroidVersionString() {
        StringBuilder builder = new StringBuilder();
        String DELIMITER = " ";
        builder.append("Android").append(" ").append(Build.VERSION.RELEASE).append(" ").append(Build.VERSION.CODENAME).append(" ").append(Build.VERSION.SDK_INT);
        return builder.toString();
    }

    static String getHashedId(@NonNull Context context) {
        String id = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (StripeTextUtils.isBlank(id)) {
            return "";
        }
        String hashId = StripeTextUtils.shaHashInput(id);
        return hashId == null ? "" : hashId;
    }

    private static String getHashedMuid(@NonNull Context context) {
        String guid = TelemetryClientUtil.getHashedId(context);
        String packageName = TelemetryClientUtil.getPackageName(context);
        String raw = packageName + guid;
        String hashed = StripeTextUtils.shaHashInput(raw);
        return hashed == null ? "" : hashed;
    }

    private static String getPackageName(@NonNull Context context) {
        if (context.getApplicationContext() == null || context.getApplicationContext().getPackageName() == null) {
            return "";
        }
        return context.getApplicationContext().getPackageName();
    }
}

