/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.SourceAddress;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.util.StripeJsonUtils;
import com.stripe.android.util.StripeNetworkUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceOwner
extends StripeJsonModel {
    private static final String VERIFIED = "verified_";
    private static final String FIELD_ADDRESS = "address";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_PHONE = "phone";
    private static final String FIELD_VERIFIED_ADDRESS = "verified_address";
    private static final String FIELD_VERIFIED_EMAIL = "verified_email";
    private static final String FIELD_VERIFIED_NAME = "verified_name";
    private static final String FIELD_VERIFIED_PHONE = "verified_phone";
    private SourceAddress mAddress;
    private String mEmail;
    private String mName;
    private String mPhone;
    private SourceAddress mVerifiedAddress;
    private String mVerifiedEmail;
    private String mVerifiedName;
    private String mVerifiedPhone;

    SourceOwner(SourceAddress address, String email, String name, String phone, SourceAddress verifiedAddress, String verifiedEmail, String verifiedName, String verifiedPhone) {
        this.mAddress = address;
        this.mEmail = email;
        this.mName = name;
        this.mPhone = phone;
        this.mVerifiedAddress = verifiedAddress;
        this.mVerifiedEmail = verifiedEmail;
        this.mVerifiedName = verifiedName;
        this.mVerifiedPhone = verifiedPhone;
    }

    public SourceAddress getAddress() {
        return this.mAddress;
    }

    public String getEmail() {
        return this.mEmail;
    }

    public String getName() {
        return this.mName;
    }

    public String getPhone() {
        return this.mPhone;
    }

    public SourceAddress getVerifiedAddress() {
        return this.mVerifiedAddress;
    }

    public String getVerifiedEmail() {
        return this.mVerifiedEmail;
    }

    public String getVerifiedName() {
        return this.mVerifiedName;
    }

    public String getVerifiedPhone() {
        return this.mVerifiedPhone;
    }

    void setAddress(SourceAddress address) {
        this.mAddress = address;
    }

    void setEmail(String email) {
        this.mEmail = email;
    }

    void setName(String name) {
        this.mName = name;
    }

    void setPhone(String phone) {
        this.mPhone = phone;
    }

    void setVerifiedAddress(SourceAddress verifiedAddress) {
        this.mVerifiedAddress = verifiedAddress;
    }

    void setVerifiedEmail(String verifiedEmail) {
        this.mVerifiedEmail = verifiedEmail;
    }

    void setVerifiedName(String verifiedName) {
        this.mVerifiedName = verifiedName;
    }

    void setVerifiedPhone(String verifiedPhone) {
        this.mVerifiedPhone = verifiedPhone;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.mAddress != null) {
            hashMap.put(FIELD_ADDRESS, this.mAddress.toMap());
        }
        hashMap.put(FIELD_EMAIL, this.mEmail);
        hashMap.put(FIELD_NAME, this.mName);
        hashMap.put(FIELD_PHONE, this.mPhone);
        if (this.mVerifiedAddress != null) {
            hashMap.put(FIELD_VERIFIED_ADDRESS, this.mVerifiedAddress.toMap());
        }
        hashMap.put(FIELD_VERIFIED_EMAIL, this.mVerifiedEmail);
        hashMap.put(FIELD_VERIFIED_NAME, this.mVerifiedName);
        hashMap.put(FIELD_VERIFIED_PHONE, this.mVerifiedPhone);
        StripeNetworkUtils.removeNullParams(hashMap);
        return hashMap;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONObject jsonAddressObject = this.mAddress == null ? null : this.mAddress.toJson();
        JSONObject jsonVerifiedAddressObject = this.mVerifiedAddress == null ? null : this.mVerifiedAddress.toJson();
        try {
            if (jsonAddressObject != null && jsonAddressObject.length() > 0) {
                jsonObject.put(FIELD_ADDRESS, (Object)jsonAddressObject);
            }
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_EMAIL, this.mEmail);
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_NAME, this.mName);
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_PHONE, this.mPhone);
            if (jsonVerifiedAddressObject != null && jsonVerifiedAddressObject.length() > 0) {
                jsonObject.put(FIELD_VERIFIED_ADDRESS, (Object)jsonVerifiedAddressObject);
            }
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_VERIFIED_EMAIL, this.mVerifiedEmail);
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_VERIFIED_NAME, this.mVerifiedName);
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_VERIFIED_PHONE, this.mVerifiedPhone);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    @Nullable
    public static SourceOwner fromString(@Nullable String jsonString) {
        try {
            return SourceOwner.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static SourceOwner fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        SourceAddress address = null;
        SourceAddress verifiedAddress = null;
        JSONObject addressObject = jsonObject.optJSONObject(FIELD_ADDRESS);
        if (addressObject != null) {
            address = SourceAddress.fromJson(addressObject);
        }
        String email = StripeJsonUtils.optString(jsonObject, FIELD_EMAIL);
        String name = StripeJsonUtils.optString(jsonObject, FIELD_NAME);
        String phone = StripeJsonUtils.optString(jsonObject, FIELD_PHONE);
        JSONObject vAddressObject = jsonObject.optJSONObject(FIELD_VERIFIED_ADDRESS);
        if (vAddressObject != null) {
            verifiedAddress = SourceAddress.fromJson(vAddressObject);
        }
        String verifiedEmail = StripeJsonUtils.optString(jsonObject, FIELD_VERIFIED_EMAIL);
        String verifiedName = StripeJsonUtils.optString(jsonObject, FIELD_VERIFIED_NAME);
        String verifiedPhone = StripeJsonUtils.optString(jsonObject, FIELD_VERIFIED_PHONE);
        return new SourceOwner(address, email, name, phone, verifiedAddress, verifiedEmail, verifiedName, verifiedPhone);
    }
}

