/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.model.Source;
import com.stripe.android.networking.AnalyticsEvent;
import com.stripe.android.networking.AnalyticsRequestExecutor;
import com.stripe.android.networking.AnalyticsRequestFactory;
import com.stripe.android.payments.BrowserCapabilities;
import com.stripe.android.payments.BrowserCapabilitiesSupplier;
import com.stripe.android.payments.PaymentFlowResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherViewModel;", "Landroidx/lifecycle/ViewModel;", "analyticsRequestExecutor", "Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "analyticsRequestFactory", "Lcom/stripe/android/networking/AnalyticsRequestFactory;", "browserCapabilities", "Lcom/stripe/android/payments/BrowserCapabilities;", "intentChooserTitle", "", "(Lcom/stripe/android/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/AnalyticsRequestFactory;Lcom/stripe/android/payments/BrowserCapabilities;Ljava/lang/String;)V", "createLaunchIntent", "Landroid/content/Intent;", "args", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "getResultIntent", "logCapabilities", "", "shouldUseCustomTabs", "", "Factory", "stripe_release"})
public final class StripeBrowserLauncherViewModel
extends ViewModel {
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    private final AnalyticsRequestFactory analyticsRequestFactory;
    private final BrowserCapabilities browserCapabilities;
    private final String intentChooserTitle;

    @NotNull
    public final Intent createLaunchIntent(@NotNull PaymentBrowserAuthContract.Args args2) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        boolean shouldUseCustomTabs = this.browserCapabilities == BrowserCapabilities.CustomTabs;
        this.logCapabilities(shouldUseCustomTabs);
        Uri url = Uri.parse((String)args2.getUrl());
        if (shouldUseCustomTabs) {
            CustomTabColorSchemeParams customTabColorSchemeParams;
            boolean bl;
            Integer n = args2.getStatusBarColor();
            if (n != null) {
                Integer n2 = n;
                boolean bl2 = false;
                bl = false;
                int statusBarColor = ((Number)n2).intValue();
                boolean bl3 = false;
                customTabColorSchemeParams = new CustomTabColorSchemeParams.Builder().setToolbarColor(statusBarColor).build();
            } else {
                customTabColorSchemeParams = null;
            }
            CustomTabColorSchemeParams customTabColorSchemeParams2 = customTabColorSchemeParams;
            CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder().setShareState(2);
            bl = false;
            boolean bl4 = false;
            CustomTabsIntent.Builder it = builder;
            boolean bl5 = false;
            if (customTabColorSchemeParams2 != null) {
                it.setDefaultColorSchemeParams(customTabColorSchemeParams2);
            }
            CustomTabsIntent customTabsIntent = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)customTabsIntent, (String)"CustomTabsIntent.Builder\u2026\n                .build()");
            CustomTabsIntent customTabsIntent2 = customTabsIntent;
            Intent intent2 = customTabsIntent2.intent;
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"customTabsIntent.intent");
            intent2.setData(url);
            Intent intent3 = Intent.createChooser((Intent)customTabsIntent2.intent, (CharSequence)this.intentChooserTitle);
            intent = intent3;
            Intrinsics.checkNotNullExpressionValue((Object)intent3, (String)"Intent.createChooser(\n  \u2026hooserTitle\n            )");
        } else {
            Intent intent4 = Intent.createChooser((Intent)new Intent("android.intent.action.VIEW", url), (CharSequence)this.intentChooserTitle);
            intent = intent4;
            Intrinsics.checkNotNullExpressionValue((Object)intent4, (String)"Intent.createChooser(\n  \u2026hooserTitle\n            )");
        }
        return intent;
    }

    @NotNull
    public final Intent getResultIntent(@NotNull PaymentBrowserAuthContract.Args args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Uri url = Uri.parse((String)args2.getUrl());
        Intent intent = new Intent();
        String string2 = args2.getClientSecret();
        Uri uri = url;
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"url");
        String string3 = uri.getLastPathSegment();
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            string4 = "";
        }
        boolean bl2 = args2.getShouldCancelSource();
        Source source = null;
        String string5 = args2.getStripeAccountId();
        String string6 = string4;
        Intent intent2 = intent.putExtras(new PaymentFlowResult.Unvalidated(string2, 0, null, bl2, string6, source, string5, 38, null).toBundle());
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"Intent().putExtras(\n    \u2026   ).toBundle()\n        )");
        return intent2;
    }

    public final void logCapabilities(boolean shouldUseCustomTabs) {
        AnalyticsEvent analyticsEvent;
        boolean bl = shouldUseCustomTabs;
        if (bl) {
            analyticsEvent = AnalyticsEvent.AuthWithCustomTabs;
        } else if (!bl) {
            analyticsEvent = AnalyticsEvent.AuthWithDefaultBrowser;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$stripe_release$default(this.analyticsRequestFactory, analyticsEvent, null, null, null, null, 30, null));
    }

    public StripeBrowserLauncherViewModel(@NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsRequestFactory analyticsRequestFactory, @NotNull BrowserCapabilities browserCapabilities, @NotNull String intentChooserTitle) {
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)browserCapabilities), (String)"browserCapabilities");
        Intrinsics.checkNotNullParameter((Object)intentChooserTitle, (String)"intentChooserTitle");
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsRequestFactory = analyticsRequestFactory;
        this.browserCapabilities = browserCapabilities;
        this.intentChooserTitle = intentChooserTitle;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u0002H\u0006\"\n\b\u0000\u0010\u0006*\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\tH\u0016\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "stripe_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        private final Application application;

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            PaymentConfiguration config = PaymentConfiguration.Companion.getInstance((Context)this.application);
            BrowserCapabilitiesSupplier browserCapabilitiesSupplier = new BrowserCapabilitiesSupplier((Context)this.application);
            AnalyticsRequestExecutor analyticsRequestExecutor = new AnalyticsRequestExecutor.Default(null, null, 3, null);
            AnalyticsRequestFactory analyticsRequestFactory = new AnalyticsRequestFactory((Context)this.application, config.getPublishableKey());
            BrowserCapabilities browserCapabilities = browserCapabilitiesSupplier.get();
            String string2 = this.application.getString(R.string.stripe_verify_your_payment);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"application.getString(R.\u2026ripe_verify_your_payment)");
            return (T)((Object)new StripeBrowserLauncherViewModel(analyticsRequestExecutor, analyticsRequestFactory, browserCapabilities, string2));
        }

        public Factory(@NotNull Application application) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            this.application = application;
        }
    }
}

