/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.stripe.android.AnalyticsEvent;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.networking.AnalyticsRequestExecutor;
import com.stripe.android.networking.AnalyticsRequestFactory;
import com.stripe.android.payments.PaymentFlowResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherViewModel;", "Landroidx/lifecycle/ViewModel;", "analyticsRequestExecutor", "Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "analyticsRequestFactory", "Lcom/stripe/android/networking/AnalyticsRequestFactory;", "(Lcom/stripe/android/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/AnalyticsRequestFactory;)V", "getResultIntent", "Landroid/content/Intent;", "args", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "logCapabilities", "", "shouldUseCustomTabs", "", "Factory", "stripe_release"})
public final class StripeBrowserLauncherViewModel
extends ViewModel {
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    private final AnalyticsRequestFactory analyticsRequestFactory;

    @NotNull
    public final Intent getResultIntent(@NotNull PaymentBrowserAuthContract.Args args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Uri url = Uri.parse((String)args2.getUrl());
        Intent intent = new Intent();
        String string2 = args2.getClientSecret();
        Uri uri = url;
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"url");
        String string3 = uri.getLastPathSegment();
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            string4 = "";
        }
        Intent intent2 = intent.putExtras(new PaymentFlowResult.Unvalidated(string2, 0, null, false, string4, null, args2.getStripeAccountId(), 46, null).toBundle());
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"Intent().putExtras(\n    \u2026   ).toBundle()\n        )");
        return intent2;
    }

    public final void logCapabilities(boolean shouldUseCustomTabs) {
        AnalyticsEvent analyticsEvent;
        boolean bl = shouldUseCustomTabs;
        if (bl) {
            analyticsEvent = AnalyticsEvent.AuthWithCustomTabs;
        } else if (!bl) {
            analyticsEvent = AnalyticsEvent.AuthWithDefaultBrowser;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.analyticsRequestExecutor.executeAsync(this.analyticsRequestFactory.createRequest$stripe_release(analyticsEvent));
    }

    public StripeBrowserLauncherViewModel(@NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsRequestFactory analyticsRequestFactory) {
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsRequestFactory = analyticsRequestFactory;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u0002H\u0006\"\n\b\u0000\u0010\u0006*\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\tH\u0016\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "stripe_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        private final Application application;

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            PaymentConfiguration config = PaymentConfiguration.Companion.getInstance((Context)this.application);
            return (T)((Object)new StripeBrowserLauncherViewModel(new AnalyticsRequestExecutor.Default(null, null, 3, null), new AnalyticsRequestFactory((Context)this.application, config.getPublishableKey())));
        }

        public Factory(@NotNull Application application) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            this.application = application;
        }
    }
}

