/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.googlepay;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.Window;
import androidx.activity.ComponentActivity;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wallet.AutoResolveHelper;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.PaymentsClient;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.googlepay.PaymentsClientFactory;
import com.stripe.android.googlepay.StripeGooglePayContract;
import com.stripe.android.googlepay.StripeGooglePayViewModel;
import com.stripe.android.model.GooglePayResult;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.ShippingInformation;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\"\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u0010#\u001a\u00020\u00162\b\u0010$\u001a\u0004\u0018\u00010%H\u0014J\u0012\u0010&\u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u001a\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006."}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "args", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Args;", "paymentsClient", "Lcom/google/android/gms/wallet/PaymentsClient;", "getPaymentsClient", "()Lcom/google/android/gms/wallet/PaymentsClient;", "paymentsClient$delegate", "Lkotlin/Lazy;", "publishableKey", "", "getPublishableKey", "()Ljava/lang/String;", "publishableKey$delegate", "viewModel", "Lcom/stripe/android/googlepay/StripeGooglePayViewModel;", "getViewModel", "()Lcom/stripe/android/googlepay/StripeGooglePayViewModel;", "viewModel$delegate", "finish", "", "finishWithResult", "result", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "isReadyToPay", "paymentDataRequest", "Lorg/json/JSONObject;", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onGooglePayResult", "onPaymentMethodCreated", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "payWithGoogle", "Companion", "stripe_release"})
public final class StripeGooglePayActivity
extends AppCompatActivity {
    private final Lazy paymentsClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PaymentsClient>(this){
        final /* synthetic */ StripeGooglePayActivity this$0;

        @NotNull
        public final PaymentsClient invoke() {
            return new PaymentsClientFactory((Context)this.this$0).create(StripeGooglePayActivity.access$getArgs$p(this.this$0).getConfig().getEnvironment());
        }
        {
            this.this$0 = stripeGooglePayActivity;
            super(0);
        }
    }));
    private final Lazy publishableKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
        final /* synthetic */ StripeGooglePayActivity this$0;

        @NotNull
        public final String invoke() {
            return PaymentConfiguration.Companion.getInstance((Context)this.this$0).getPublishableKey();
        }
        {
            this.this$0 = stripeGooglePayActivity;
            super(0);
        }
    }));
    private final Lazy viewModel$delegate;
    private StripeGooglePayContract.Args args;
    @Deprecated
    private static final int LOAD_PAYMENT_DATA_REQUEST_CODE = 4444;
    @NotNull
    private static final Companion Companion = new Companion(null);

    private final PaymentsClient getPaymentsClient() {
        Lazy lazy = this.paymentsClient$delegate;
        StripeGooglePayActivity stripeGooglePayActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PaymentsClient)lazy.getValue();
    }

    private final String getPublishableKey() {
        Lazy lazy = this.publishableKey$delegate;
        StripeGooglePayActivity stripeGooglePayActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final StripeGooglePayViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        StripeGooglePayActivity stripeGooglePayActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (StripeGooglePayViewModel)((Object)lazy.getValue());
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT != 26) {
            this.setRequestedOrientation(1);
        }
        this.overridePendingTransition(0, 0);
        this.setResult(-1, new Intent().putExtras(StripeGooglePayContract.Result.Canceled.INSTANCE.toBundle()));
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
        StripeGooglePayContract.Args nullableArgs = StripeGooglePayContract.Args.Companion.create$stripe_release(intent);
        if (nullableArgs == null) {
            this.finishWithResult(new StripeGooglePayContract.Result.Error(new RuntimeException("StripeGooglePayActivity was started without arguments."), null, null, null, 14, null));
            return;
        }
        StripeGooglePayContract.Args args2 = this.args = nullableArgs;
        if (args2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        Integer n = args2.getStatusBarColor();
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            Window window = this.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
            window.setStatusBarColor(it);
        }
        this.getViewModel().getGooglePayResult$stripe_release().observe((LifecycleOwner)this, (Observer)new Observer<StripeGooglePayContract.Result>(this){
            final /* synthetic */ StripeGooglePayActivity this$0;

            public final void onChanged(StripeGooglePayContract.Result googlePayResult) {
                block0: {
                    StripeGooglePayContract.Result result2 = googlePayResult;
                    if (result2 == null) break block0;
                    StripeGooglePayContract.Result result3 = result2;
                    StripeGooglePayActivity stripeGooglePayActivity = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    StripeGooglePayContract.Result p1 = result3;
                    boolean bl3 = false;
                    StripeGooglePayActivity.access$finishWithResult(stripeGooglePayActivity, p1);
                }
            }
            {
                this.this$0 = stripeGooglePayActivity;
            }
        });
        if (!this.getViewModel().getHasLaunched()) {
            this.getViewModel().setHasLaunched(true);
            this.isReadyToPay(this.getViewModel().createPaymentDataRequestForPaymentIntentArgs());
        }
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    private final void isReadyToPay(JSONObject paymentDataRequest) {
        this.getPaymentsClient().isReadyToPay(this.getViewModel().createIsReadyToPayRequest()).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Boolean>(this, paymentDataRequest){
            final /* synthetic */ StripeGooglePayActivity this$0;
            final /* synthetic */ JSONObject $paymentDataRequest;

            public final void onComplete(@NotNull Task<Boolean> task) {
                Object object;
                Intrinsics.checkNotNullParameter(task, (String)"task");
                StripeGooglePayActivity stripeGooglePayActivity = this.this$0;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    StripeGooglePayActivity $this$runCatching = stripeGooglePayActivity;
                    boolean bl2 = false;
                    if (task.isSuccessful()) {
                        StripeGooglePayActivity.access$payWithGoogle($this$runCatching, this.$paymentDataRequest);
                    } else {
                        StripeGooglePayActivity.access$getViewModel$p($this$runCatching).updateGooglePayResult(StripeGooglePayContract.Result.Unavailable.INSTANCE);
                    }
                    Unit unit = Unit.INSTANCE;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                stripeGooglePayActivity = object;
                bl = false;
                boolean bl5 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)((Object)stripeGooglePayActivity));
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Throwable throwable3 = throwable2;
                    boolean bl8 = false;
                    Throwable it = throwable3;
                    boolean bl9 = false;
                    StripeGooglePayActivity.access$getViewModel$p(this.this$0).updateGooglePayResult(new StripeGooglePayContract.Result.Error(it, null, null, null, 14, null));
                }
                StripeGooglePayActivity stripeGooglePayActivity2 = stripeGooglePayActivity;
            }
            {
                this.this$0 = stripeGooglePayActivity;
                this.$paymentDataRequest = jSONObject;
            }
        });
    }

    private final void payWithGoogle(JSONObject paymentDataRequest) {
        AutoResolveHelper.resolveTask((Task)this.getPaymentsClient().loadPaymentData(PaymentDataRequest.fromJson((String)paymentDataRequest.toString())), (Activity)((Activity)this), (int)4444);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 4444) {
            switch (resultCode) {
                case -1: {
                    this.onGooglePayResult(data);
                    break;
                }
                case 0: {
                    this.getViewModel().updateGooglePayResult(StripeGooglePayContract.Result.Canceled.INSTANCE);
                    break;
                }
                case 1: {
                    Status status = AutoResolveHelper.getStatusFromIntent((Intent)data);
                    this.getViewModel().updateGooglePayResult(new StripeGooglePayContract.Result.Error(new RuntimeException("Google Pay returned an error. See googlePayStatus property for more information."), status, null, null, 12, null));
                    break;
                }
                default: {
                    this.getViewModel().updateGooglePayResult(new StripeGooglePayContract.Result.Error(new RuntimeException("Google Pay returned an expected result code."), null, null, null, 14, null));
                }
            }
        }
    }

    private final void onGooglePayResult(Intent data) {
        PaymentData paymentData;
        PaymentData paymentData2;
        Intent intent = data;
        if (intent != null) {
            Intent intent2 = intent;
            boolean bl = false;
            boolean bl2 = false;
            Intent it = intent2;
            boolean bl3 = false;
            paymentData2 = PaymentData.getFromIntent((Intent)it);
        } else {
            paymentData2 = paymentData = null;
        }
        if (paymentData == null) {
            this.getViewModel().updateGooglePayResult(new StripeGooglePayContract.Result.Error(new IllegalArgumentException("Google Pay data was not available"), null, null, null, 14, null));
            return;
        }
        JSONObject paymentDataJson = new JSONObject(paymentData.toJson());
        ShippingInformation shippingInformation = GooglePayResult.Companion.fromJson(paymentDataJson).getShippingInformation();
        PaymentMethodCreateParams params = PaymentMethodCreateParams.Companion.createFromGooglePay(paymentDataJson);
        this.getViewModel().createPaymentMethod(params).observe((LifecycleOwner)this, (Observer)new Observer<Result<? extends PaymentMethod>>(this, shippingInformation){
            final /* synthetic */ StripeGooglePayActivity this$0;
            final /* synthetic */ ShippingInformation $shippingInformation;

            public final void onChanged(Result<? extends PaymentMethod> result2) {
                block2: {
                    Result<? extends PaymentMethod> result3 = result2;
                    if (result3 == null) break block2;
                    Object object = result3.unbox-impl();
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable == null) {
                        PaymentMethod it = (PaymentMethod)object;
                        boolean bl3 = false;
                        StripeGooglePayActivity.access$onPaymentMethodCreated(this.this$0, it, this.$shippingInformation);
                    } else {
                        Throwable it = throwable;
                        boolean bl4 = false;
                        StripeGooglePayActivity.access$getViewModel$p(this.this$0).setPaymentMethod(null);
                        StripeGooglePayActivity.access$getViewModel$p(this.this$0).updateGooglePayResult(new StripeGooglePayContract.Result.Error(it, null, null, null, 14, null));
                    }
                }
            }
            {
                this.this$0 = stripeGooglePayActivity;
                this.$shippingInformation = shippingInformation;
            }
        });
    }

    private final void onPaymentMethodCreated(PaymentMethod paymentMethod, ShippingInformation shippingInformation) {
        this.getViewModel().setPaymentMethod(paymentMethod);
        this.getViewModel().updateGooglePayResult(new StripeGooglePayContract.Result.PaymentData(paymentMethod, shippingInformation));
    }

    private final void finishWithResult(StripeGooglePayContract.Result result2) {
        this.setResult(-1, new Intent().putExtras(result2.toBundle()));
        this.finish();
    }

    /*
     * WARNING - void declaration
     */
    public StripeGooglePayActivity() {
        void $this$viewModels$iv;
        StripeGooglePayActivity stripeGooglePayActivity = this;
        Function0 factoryProducer$iv = (Function0)new Function0<ViewModelProvider.Factory>(this){
            final /* synthetic */ StripeGooglePayActivity this$0;

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                Application application = this.this$0.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"application");
                return new StripeGooglePayViewModel.Factory(application, StripeGooglePayActivity.access$getPublishableKey$p(this.this$0), StripeGooglePayActivity.access$getArgs$p(this.this$0));
            }
            {
                this.this$0 = stripeGooglePayActivity;
                super(0);
            }
        };
        boolean $i$f$viewModels = false;
        Function0 factoryPromise$iv = factoryProducer$iv;
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(StripeGooglePayViewModel.class), (Function0)new Function0<ViewModelStore>((ComponentActivity)$this$viewModels$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = componentActivity;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = this.$this_viewModels.getViewModelStore();
                Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"viewModelStore");
                return viewModelStore;
            }
        }, factoryPromise$iv);
    }

    public static final /* synthetic */ void access$finishWithResult(StripeGooglePayActivity $this, StripeGooglePayContract.Result result2) {
        $this.finishWithResult(result2);
    }

    public static final /* synthetic */ void access$payWithGoogle(StripeGooglePayActivity $this, JSONObject paymentDataRequest) {
        $this.payWithGoogle(paymentDataRequest);
    }

    public static final /* synthetic */ StripeGooglePayViewModel access$getViewModel$p(StripeGooglePayActivity $this) {
        return $this.getViewModel();
    }

    public static final /* synthetic */ void access$onPaymentMethodCreated(StripeGooglePayActivity $this, PaymentMethod paymentMethod, ShippingInformation shippingInformation) {
        $this.onPaymentMethodCreated(paymentMethod, shippingInformation);
    }

    public static final /* synthetic */ StripeGooglePayContract.Args access$getArgs$p(StripeGooglePayActivity $this) {
        StripeGooglePayContract.Args args2 = $this.args;
        if (args2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        return args2;
    }

    public static final /* synthetic */ void access$setArgs$p(StripeGooglePayActivity $this, StripeGooglePayContract.Args args2) {
        $this.args = args2;
    }

    public static final /* synthetic */ String access$getPublishableKey$p(StripeGooglePayActivity $this) {
        return $this.getPublishableKey();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayActivity$Companion;", "", "()V", "LOAD_PAYMENT_DATA_REQUEST_CODE", "", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

