/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import androidx.activity.ComponentActivity;
import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.savedstate.SavedStateRegistryOwner;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.PaymentSession;
import com.stripe.android.PaymentSession$WhenMappings;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.PaymentSessionData;
import com.stripe.android.PaymentSessionViewModel;
import com.stripe.android.view.ActivityStarter;
import com.stripe.android.view.PaymentFlowActivity;
import com.stripe.android.view.PaymentFlowActivityStarter;
import com.stripe.android.view.PaymentMethodsActivity;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ab\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003*\u0001!\u0018\u0000 B2\u00020\u0001:\u0002BCB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tBq\b\u0001\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u0012\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u0017\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010-\u001a\u00020.J\u0012\u0010/\u001a\u00020.2\b\b\u0002\u00100\u001a\u000201H\u0002J \u00102\u001a\u0002012\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\b\u00106\u001a\u0004\u0018\u000107J\u000e\u00108\u001a\u00020.2\u0006\u0010#\u001a\u00020$J\u0006\u00109\u001a\u00020.J\u0010\u0010:\u001a\u00020.2\u0006\u00106\u001a\u000207H\u0002J\u0012\u0010;\u001a\u00020.2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010=J\u0006\u0010>\u001a\u00020.J\u0010\u0010?\u001a\u00020.2\b\b\u0001\u0010@\u001a\u00020AR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020*X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006D"}, d2={"Lcom/stripe/android/PaymentSession;", "", "activity", "Landroidx/activity/ComponentActivity;", "config", "Lcom/stripe/android/PaymentSessionConfig;", "(Landroidx/activity/ComponentActivity;Lcom/stripe/android/PaymentSessionConfig;)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;Lcom/stripe/android/PaymentSessionConfig;)V", "context", "Landroid/content/Context;", "application", "Landroid/app/Application;", "viewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "savedStateRegistryOwner", "Landroidx/savedstate/SavedStateRegistryOwner;", "customerSession", "Lcom/stripe/android/CustomerSession;", "paymentMethodsActivityStarter", "Lcom/stripe/android/view/ActivityStarter;", "Lcom/stripe/android/view/PaymentMethodsActivity;", "Lcom/stripe/android/view/PaymentMethodsActivityStarter$Args;", "paymentFlowActivityStarter", "Lcom/stripe/android/view/PaymentFlowActivity;", "Lcom/stripe/android/view/PaymentFlowActivityStarter$Args;", "paymentSessionData", "Lcom/stripe/android/PaymentSessionData;", "(Landroid/content/Context;Landroid/app/Application;Landroidx/lifecycle/ViewModelStoreOwner;Landroidx/lifecycle/LifecycleOwner;Landroidx/savedstate/SavedStateRegistryOwner;Lcom/stripe/android/PaymentSessionConfig;Lcom/stripe/android/CustomerSession;Lcom/stripe/android/view/ActivityStarter;Lcom/stripe/android/view/ActivityStarter;Lcom/stripe/android/PaymentSessionData;)V", "lifecycleObserver", "com/stripe/android/PaymentSession$lifecycleObserver$1", "Lcom/stripe/android/PaymentSession$lifecycleObserver$1;", "listener", "Lcom/stripe/android/PaymentSession$PaymentSessionListener;", "getListener$stripe_release", "()Lcom/stripe/android/PaymentSession$PaymentSessionListener;", "setListener$stripe_release", "(Lcom/stripe/android/PaymentSession$PaymentSessionListener;)V", "viewModel", "Lcom/stripe/android/PaymentSessionViewModel;", "getViewModel$stripe_release", "()Lcom/stripe/android/PaymentSessionViewModel;", "clearPaymentMethod", "", "fetchCustomer", "isInitialFetch", "", "handlePaymentData", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "init", "onCompleted", "onPaymentMethodResult", "presentPaymentMethodSelection", "selectedPaymentMethodId", "", "presentShippingFlow", "setCartTotal", "cartTotal", "", "Companion", "PaymentSessionListener", "stripe_release"})
public final class PaymentSession {
    @NotNull
    private final PaymentSessionViewModel viewModel;
    private /* synthetic */ PaymentSessionListener listener;
    private final lifecycleObserver.1 lifecycleObserver;
    private final Context context;
    private final LifecycleOwner lifecycleOwner;
    private final PaymentSessionConfig config;
    private final ActivityStarter<PaymentMethodsActivity, PaymentMethodsActivityStarter.Args> paymentMethodsActivityStarter;
    private final ActivityStarter<PaymentFlowActivity, PaymentFlowActivityStarter.Args> paymentFlowActivityStarter;
    @NotNull
    public static final String PRODUCT_TOKEN = "PaymentSession";
    @NotNull
    public static final String EXTRA_PAYMENT_SESSION_DATA = "extra_payment_session_data";
    private static final Set<Integer> VALID_REQUEST_CODES;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final PaymentSessionViewModel getViewModel$stripe_release() {
        return this.viewModel;
    }

    @Nullable
    public final PaymentSessionListener getListener$stripe_release() {
        return this.listener;
    }

    public final void setListener$stripe_release(@Nullable PaymentSessionListener paymentSessionListener) {
        this.listener = paymentSessionListener;
    }

    public final void onCompleted() {
        this.viewModel.onCompleted();
    }

    public final boolean handlePaymentData(int requestCode, int resultCode, @Nullable Intent data) {
        if (data == null) {
            return false;
        }
        if (!PaymentSession.Companion.isValidRequestCode(requestCode)) {
            return false;
        }
        switch (resultCode) {
            case 0: {
                if (requestCode == 6000) {
                    this.onPaymentMethodResult(data);
                } else {
                    PaymentSession.fetchCustomer$default(this, false, 1, null);
                }
                return false;
            }
            case -1: {
                boolean bl;
                switch (requestCode) {
                    case 6000: {
                        this.onPaymentMethodResult(data);
                        bl = true;
                        break;
                    }
                    case 6002: {
                        PaymentSessionData paymentSessionData = (PaymentSessionData)data.getParcelableExtra(EXTRA_PAYMENT_SESSION_DATA);
                        if (paymentSessionData != null) {
                            PaymentSessionData paymentSessionData2 = paymentSessionData;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            PaymentSessionData it = paymentSessionData2;
                            boolean bl4 = false;
                            PaymentSessionData paymentSessionData3 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)paymentSessionData3, (String)"it");
                            this.viewModel.onPaymentFlowResult(paymentSessionData3);
                        }
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }
        }
        return false;
    }

    private final void onPaymentMethodResult(Intent data) {
        this.viewModel.onPaymentMethodResult(PaymentMethodsActivityStarter.Result.Companion.fromIntent(data));
    }

    public final void init(@NotNull PaymentSessionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
        this.viewModel.onListenerAttached();
        if (this.config.getShouldPrefetchCustomer$stripe_release()) {
            this.fetchCustomer(true);
        }
    }

    public final void presentPaymentMethodSelection(@Nullable String selectedPaymentMethodId) {
        this.paymentMethodsActivityStarter.startForResult((PaymentMethodsActivityStarter.Args)((ActivityStarter.Args)new PaymentMethodsActivityStarter.Args.Builder().setInitialPaymentMethodId(this.viewModel.getSelectedPaymentMethodId(selectedPaymentMethodId)).setPaymentMethodsFooter(this.config.getPaymentMethodsFooterLayoutId()).setAddPaymentMethodFooter(this.config.getAddPaymentMethodFooterLayoutId()).setIsPaymentSessionActive(true).setPaymentConfiguration(PaymentConfiguration.Companion.getInstance(this.context)).setPaymentMethodTypes(this.config.getPaymentMethodTypes()).setShouldShowGooglePay(this.config.getShouldShowGooglePay()).setWindowFlags(this.config.getWindowFlags$stripe_release()).setBillingAddressFields(this.config.getBillingAddressFields()).setUseGooglePay$stripe_release(this.viewModel.getPaymentSessionData().getUseGooglePay()).setCanDeletePaymentMethods(this.config.getCanDeletePaymentMethods()).build()));
    }

    public static /* synthetic */ void presentPaymentMethodSelection$default(PaymentSession paymentSession, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        paymentSession.presentPaymentMethodSelection(string2);
    }

    public final void setCartTotal(@IntRange(from=0L) long cartTotal) {
        this.viewModel.updateCartTotal(cartTotal);
    }

    public final void presentShippingFlow() {
        this.paymentFlowActivityStarter.startForResult((PaymentFlowActivityStarter.Args)((ActivityStarter.Args)new PaymentFlowActivityStarter.Args(this.config, this.viewModel.getPaymentSessionData(), true, this.config.getWindowFlags$stripe_release())));
    }

    public final void clearPaymentMethod() {
        this.viewModel.clearPaymentMethod();
    }

    private final void fetchCustomer(boolean isInitialFetch) {
        this.viewModel.fetchCustomer(isInitialFetch).observe(this.lifecycleOwner, (Observer)new Observer<PaymentSessionViewModel.FetchCustomerResult>(this){
            final /* synthetic */ PaymentSession this$0;

            public final void onChanged(PaymentSessionViewModel.FetchCustomerResult result2) {
                block1: {
                    if (!(result2 instanceof PaymentSessionViewModel.FetchCustomerResult.Error)) break block1;
                    PaymentSessionListener paymentSessionListener = this.this$0.getListener$stripe_release();
                    if (paymentSessionListener != null) {
                        paymentSessionListener.onError(((PaymentSessionViewModel.FetchCustomerResult.Error)result2).getErrorCode(), ((PaymentSessionViewModel.FetchCustomerResult.Error)result2).getErrorMessage());
                    }
                }
            }
            {
                this.this$0 = paymentSession;
            }
        });
    }

    static /* synthetic */ void fetchCustomer$default(PaymentSession paymentSession, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        paymentSession.fetchCustomer(bl);
    }

    @VisibleForTesting
    public PaymentSession(@NotNull Context context, @NotNull Application application, @NotNull ViewModelStoreOwner viewModelStoreOwner, @NotNull LifecycleOwner lifecycleOwner, @NotNull SavedStateRegistryOwner savedStateRegistryOwner, @NotNull PaymentSessionConfig config, @NotNull CustomerSession customerSession2, @NotNull ActivityStarter<PaymentMethodsActivity, PaymentMethodsActivityStarter.Args> paymentMethodsActivityStarter, @NotNull ActivityStarter<PaymentFlowActivity, PaymentFlowActivityStarter.Args> paymentFlowActivityStarter, @NotNull PaymentSessionData paymentSessionData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)viewModelStoreOwner, (String)"viewModelStoreOwner");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)savedStateRegistryOwner, (String)"savedStateRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)customerSession2, (String)"customerSession");
        Intrinsics.checkNotNullParameter(paymentMethodsActivityStarter, (String)"paymentMethodsActivityStarter");
        Intrinsics.checkNotNullParameter(paymentFlowActivityStarter, (String)"paymentFlowActivityStarter");
        Intrinsics.checkNotNullParameter((Object)paymentSessionData, (String)"paymentSessionData");
        this.context = context;
        this.lifecycleOwner = lifecycleOwner;
        this.config = config;
        this.paymentMethodsActivityStarter = paymentMethodsActivityStarter;
        this.paymentFlowActivityStarter = paymentFlowActivityStarter;
        ViewModel viewModel2 = new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)new PaymentSessionViewModel.Factory(application, savedStateRegistryOwner, paymentSessionData, customerSession2)).get(PaymentSessionViewModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)viewModel2, (String)"ViewModelProvider(\n     \u2026ionViewModel::class.java]");
        this.viewModel = (PaymentSessionViewModel)viewModel2;
        this.lifecycleObserver = new LifecycleObserver(this){
            final /* synthetic */ PaymentSession this$0;

            @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
            public final void onDestroy() {
                this.this$0.setListener$stripe_release(null);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this.lifecycleObserver);
        this.viewModel.getNetworkState$stripe_release().observe(this.lifecycleOwner, (Observer)new Observer<PaymentSessionViewModel.NetworkState>(){

            public final void onChanged(PaymentSessionViewModel.NetworkState it) {
                block5: {
                    PaymentSessionViewModel.NetworkState networkState = it;
                    if (networkState == null) break block5;
                    PaymentSessionViewModel.NetworkState networkState2 = networkState;
                    boolean bl = false;
                    boolean bl2 = false;
                    PaymentSessionViewModel.NetworkState networkState3 = networkState2;
                    boolean bl3 = false;
                    PaymentSessionListener paymentSessionListener = this.getListener$stripe_release();
                    if (paymentSessionListener != null) {
                        boolean bl4;
                        switch (PaymentSession$WhenMappings.$EnumSwitchMapping$0[networkState3.ordinal()]) {
                            case 1: {
                                bl4 = true;
                                break;
                            }
                            case 2: {
                                bl4 = false;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        paymentSessionListener.onCommunicatingStateChanged(bl4);
                    }
                }
            }
        });
        this.viewModel.getPaymentSessionDataLiveData().observe(this.lifecycleOwner, (Observer)new Observer<PaymentSessionData>(){

            public final void onChanged(PaymentSessionData it) {
                block0: {
                    PaymentSessionListener paymentSessionListener = this.getListener$stripe_release();
                    if (paymentSessionListener == null) break block0;
                    PaymentSessionData paymentSessionData = it;
                    Intrinsics.checkNotNullExpressionValue((Object)paymentSessionData, (String)"it");
                    paymentSessionListener.onPaymentSessionDataChanged(paymentSessionData);
                }
            }
        });
    }

    public /* synthetic */ PaymentSession(Context context, Application application, ViewModelStoreOwner viewModelStoreOwner, LifecycleOwner lifecycleOwner, SavedStateRegistryOwner savedStateRegistryOwner, PaymentSessionConfig paymentSessionConfig2, CustomerSession customerSession2, ActivityStarter activityStarter, ActivityStarter activityStarter2, PaymentSessionData paymentSessionData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            paymentSessionData = new PaymentSessionData(paymentSessionConfig2);
        }
        this(context, application, viewModelStoreOwner, lifecycleOwner, savedStateRegistryOwner, paymentSessionConfig2, customerSession2, activityStarter, activityStarter2, paymentSessionData);
    }

    public PaymentSession(@NotNull ComponentActivity activity, @NotNull PaymentSessionConfig config) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Context context = activity.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
        Application application = activity.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"activity.application");
        this(context, application, (ViewModelStoreOwner)activity, (LifecycleOwner)activity, (SavedStateRegistryOwner)activity, config, CustomerSession.Companion.getInstance(), new PaymentMethodsActivityStarter((Activity)activity), new PaymentFlowActivityStarter((Activity)activity, config), null, 512, null);
    }

    public PaymentSession(@NotNull Fragment fragment, @NotNull PaymentSessionConfig config) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        FragmentActivity fragmentActivity = fragment.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"fragment.requireActivity()");
        Context context = fragmentActivity.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"fragment.requireActivity().applicationContext");
        FragmentActivity fragmentActivity2 = fragment.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity2, (String)"fragment.requireActivity()");
        Application application = fragmentActivity2.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"fragment.requireActivity().application");
        this(context, application, (ViewModelStoreOwner)fragment, (LifecycleOwner)fragment, (SavedStateRegistryOwner)fragment, config, CustomerSession.Companion.getInstance(), new PaymentMethodsActivityStarter(fragment), new PaymentFlowActivityStarter(fragment, config), null, 512, null);
    }

    static {
        Companion = new Companion(null);
        VALID_REQUEST_CODES = SetsKt.setOf((Object[])new Integer[]{6000, 6002});
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/PaymentSession$PaymentSessionListener;", "", "onCommunicatingStateChanged", "", "isCommunicating", "", "onError", "errorCode", "", "errorMessage", "", "onPaymentSessionDataChanged", "data", "Lcom/stripe/android/PaymentSessionData;", "stripe_release"})
    public static interface PaymentSessionListener {
        public void onCommunicatingStateChanged(boolean var1);

        public void onError(int var1, @NotNull String var2);

        public void onPaymentSessionDataChanged(@NotNull PaymentSessionData var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/PaymentSession$Companion;", "", "()V", "EXTRA_PAYMENT_SESSION_DATA", "", "PRODUCT_TOKEN", "VALID_REQUEST_CODES", "", "", "isValidRequestCode", "", "requestCode", "stripe_release"})
    public static final class Companion {
        private final boolean isValidRequestCode(int requestCode) {
            return VALID_REQUEST_CODES.contains(requestCode);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

