/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.googlepay;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.activity.ComponentActivity;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wallet.AutoResolveHelper;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.PaymentsClient;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.Stripe;
import com.stripe.android.googlepay.PaymentsClientFactory;
import com.stripe.android.googlepay.StripeGooglePayContract;
import com.stripe.android.googlepay.StripeGooglePayViewModel;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.GooglePayResult;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.ShippingInformation;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 92\u00020\u0001:\u00019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0002J\"\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0012\u0010/\u001a\u00020\u001e2\b\u00100\u001a\u0004\u0018\u000101H\u0014J\u0012\u00102\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u0010\u00103\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u00104\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u0010\u00105\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u000208H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\b\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\b\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006:"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "args", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Args;", "getArgs", "()Lcom/stripe/android/googlepay/StripeGooglePayContract$Args;", "args$delegate", "Lkotlin/Lazy;", "paymentsClient", "Lcom/google/android/gms/wallet/PaymentsClient;", "getPaymentsClient", "()Lcom/google/android/gms/wallet/PaymentsClient;", "paymentsClient$delegate", "publishableKey", "", "getPublishableKey", "()Ljava/lang/String;", "publishableKey$delegate", "stripe", "Lcom/stripe/android/Stripe;", "getStripe", "()Lcom/stripe/android/Stripe;", "stripe$delegate", "viewModel", "Lcom/stripe/android/googlepay/StripeGooglePayViewModel;", "getViewModel", "()Lcom/stripe/android/googlepay/StripeGooglePayViewModel;", "viewModel$delegate", "confirmIntent", "", "clientSecret", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "finish", "finishWithResult", "result", "Lcom/stripe/android/googlepay/StripeGooglePayContract$Result;", "isReadyToPay", "paymentDataRequest", "Lorg/json/JSONObject;", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onGooglePayResult", "onPaymentMethodCreated", "onPaymentResult", "payWithGoogle", "startGooglePay", "paymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "Companion", "stripe_release"})
public final class StripeGooglePayActivity
extends AppCompatActivity {
    private final Lazy paymentsClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PaymentsClient>(this){
        final /* synthetic */ StripeGooglePayActivity this$0;

        @NotNull
        public final PaymentsClient invoke() {
            return new PaymentsClientFactory((Context)this.this$0).create(StripeGooglePayActivity.access$getArgs$p(this.this$0).getEnvironment$stripe_release());
        }
        {
            this.this$0 = stripeGooglePayActivity;
            super(0);
        }
    }));
    private final Lazy publishableKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
        final /* synthetic */ StripeGooglePayActivity this$0;

        @NotNull
        public final String invoke() {
            return PaymentConfiguration.Companion.getInstance((Context)this.this$0).getPublishableKey();
        }
        {
            this.this$0 = stripeGooglePayActivity;
            super(0);
        }
    }));
    private final Lazy stripe$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Stripe>(this){
        final /* synthetic */ StripeGooglePayActivity this$0;

        @NotNull
        public final Stripe invoke() {
            return new Stripe((Context)this.this$0, StripeGooglePayActivity.access$getPublishableKey$p(this.this$0), null, false, 12, null);
        }
        {
            this.this$0 = stripeGooglePayActivity;
            super(0);
        }
    }));
    private final Lazy args$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StripeGooglePayContract.Args>(this){
        final /* synthetic */ StripeGooglePayActivity this$0;

        @NotNull
        public final StripeGooglePayContract.Args invoke() {
            Intent intent = this.this$0.getIntent();
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
            return StripeGooglePayContract.Args.Companion.create$stripe_release(intent);
        }
        {
            this.this$0 = stripeGooglePayActivity;
            super(0);
        }
    }));
    private final Lazy viewModel$delegate;
    private static final int LOAD_PAYMENT_DATA_REQUEST_CODE = 4444;
    @NotNull
    private static final Companion Companion = new Companion(null);

    private final PaymentsClient getPaymentsClient() {
        Lazy lazy = this.paymentsClient$delegate;
        StripeGooglePayActivity stripeGooglePayActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PaymentsClient)lazy.getValue();
    }

    private final String getPublishableKey() {
        Lazy lazy = this.publishableKey$delegate;
        StripeGooglePayActivity stripeGooglePayActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final Stripe getStripe() {
        Lazy lazy = this.stripe$delegate;
        StripeGooglePayActivity stripeGooglePayActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Stripe)lazy.getValue();
    }

    private final StripeGooglePayContract.Args getArgs() {
        Lazy lazy = this.args$delegate;
        StripeGooglePayActivity stripeGooglePayActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (StripeGooglePayContract.Args)lazy.getValue();
    }

    private final StripeGooglePayViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        StripeGooglePayActivity stripeGooglePayActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (StripeGooglePayViewModel)((Object)lazy.getValue());
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.overridePendingTransition(0, 0);
        this.setResult(-1, new Intent().putExtras(StripeGooglePayContract.Result.Canceled.INSTANCE.toBundle()));
        this.getViewModel().getGooglePayResult$stripe_release().observe((LifecycleOwner)this, (Observer)new Observer<StripeGooglePayContract.Result>(this){
            final /* synthetic */ StripeGooglePayActivity this$0;

            public final void onChanged(StripeGooglePayContract.Result googlePayResult) {
                block0: {
                    StripeGooglePayContract.Result result2 = googlePayResult;
                    if (result2 == null) break block0;
                    StripeGooglePayContract.Result result3 = result2;
                    StripeGooglePayActivity stripeGooglePayActivity = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    StripeGooglePayContract.Result p1 = result3;
                    boolean bl3 = false;
                    StripeGooglePayActivity.access$finishWithResult(stripeGooglePayActivity, p1);
                }
            }
            {
                this.this$0 = stripeGooglePayActivity;
            }
        });
        if (!this.getViewModel().getHasLaunched()) {
            this.getViewModel().setHasLaunched(true);
            this.startGooglePay(this.getArgs().getPaymentIntent$stripe_release());
        }
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    private final void startGooglePay(PaymentIntent paymentIntent) {
        if (paymentIntent.getConfirmationMethod() == PaymentIntent.ConfirmationMethod.Manual) {
            this.getViewModel().updateGooglePayResult(new StripeGooglePayContract.Result.Error(new RuntimeException("StripeGooglePayActivity requires a PaymentIntent with automatic confirmation."), null, null, null, 14, null));
        } else {
            this.isReadyToPay(this.getViewModel().createPaymentDataRequestForPaymentIntentArgs());
        }
    }

    private final void isReadyToPay(JSONObject paymentDataRequest) {
        this.getPaymentsClient().isReadyToPay(this.getViewModel().createIsReadyToPayRequest()).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Boolean>(this, paymentDataRequest){
            final /* synthetic */ StripeGooglePayActivity this$0;
            final /* synthetic */ JSONObject $paymentDataRequest;

            public final void onComplete(@NotNull Task<Boolean> task) {
                Object object;
                Intrinsics.checkNotNullParameter(task, (String)"task");
                StripeGooglePayActivity stripeGooglePayActivity = this.this$0;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    StripeGooglePayActivity $this$runCatching = stripeGooglePayActivity;
                    boolean bl2 = false;
                    if (task.isSuccessful()) {
                        StripeGooglePayActivity.access$payWithGoogle($this$runCatching, this.$paymentDataRequest);
                    } else {
                        StripeGooglePayActivity.access$getViewModel$p($this$runCatching).updateGooglePayResult(StripeGooglePayContract.Result.Unavailable.INSTANCE);
                    }
                    Unit unit = Unit.INSTANCE;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                stripeGooglePayActivity = object;
                bl = false;
                boolean bl5 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)((Object)stripeGooglePayActivity));
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Throwable throwable3 = throwable2;
                    boolean bl8 = false;
                    Throwable it = throwable3;
                    boolean bl9 = false;
                    StripeGooglePayActivity.access$getViewModel$p(this.this$0).updateGooglePayResult(new StripeGooglePayContract.Result.Error(it, null, null, null, 14, null));
                }
                StripeGooglePayActivity stripeGooglePayActivity2 = stripeGooglePayActivity;
            }
            {
                this.this$0 = stripeGooglePayActivity;
                this.$paymentDataRequest = jSONObject;
            }
        });
    }

    private final void payWithGoogle(JSONObject paymentDataRequest) {
        AutoResolveHelper.resolveTask((Task)this.getPaymentsClient().loadPaymentData(PaymentDataRequest.fromJson((String)paymentDataRequest.toString())), (Activity)((Activity)this), (int)4444);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 4444) {
            switch (resultCode) {
                case -1: {
                    this.onGooglePayResult(data);
                    break;
                }
                case 0: {
                    this.getViewModel().updateGooglePayResult(StripeGooglePayContract.Result.Canceled.INSTANCE);
                    break;
                }
                case 1: {
                    Status status = AutoResolveHelper.getStatusFromIntent((Intent)data);
                    this.getViewModel().updateGooglePayResult(new StripeGooglePayContract.Result.Error(new RuntimeException("Google Pay returned an error. See googlePayStatus property for more information."), status, null, null, 12, null));
                    break;
                }
                default: {
                    this.getViewModel().updateGooglePayResult(new StripeGooglePayContract.Result.Error(new RuntimeException("Google Pay returned an expected result code."), null, null, null, 14, null));
                    break;
                }
            }
        } else {
            this.onPaymentResult(requestCode, data);
        }
    }

    private final void onPaymentResult(int requestCode, Intent data) {
        boolean isPaymentResult2 = this.getStripe().onPaymentResult(requestCode, data, (ApiResultCallback<? super PaymentIntentResult>)new ApiResultCallback<PaymentIntentResult>(this){
            final /* synthetic */ StripeGooglePayActivity this$0;

            public void onSuccess(@NotNull PaymentIntentResult result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                StripeGooglePayActivity.access$getViewModel$p(this.this$0).updateGooglePayResult(new StripeGooglePayContract.Result.PaymentIntent(result2));
            }

            public void onError(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                StripeGooglePayActivity.access$getViewModel$p(this.this$0).updateGooglePayResult(new StripeGooglePayContract.Result.Error(e, null, StripeGooglePayActivity.access$getViewModel$p(this.this$0).getPaymentMethod(), null, 10, null));
            }
            {
                this.this$0 = this$0;
            }
        });
        if (!isPaymentResult2) {
            this.getViewModel().updateGooglePayResult(new StripeGooglePayContract.Result.Error(new RuntimeException("Unable to confirm the PaymentIntent."), null, null, null, 14, null));
        }
    }

    private final void onGooglePayResult(Intent data) {
        PaymentData paymentData;
        PaymentData paymentData2;
        Intent intent = data;
        if (intent != null) {
            Intent intent2 = intent;
            boolean bl = false;
            boolean bl2 = false;
            Intent it = intent2;
            boolean bl3 = false;
            paymentData2 = PaymentData.getFromIntent((Intent)it);
        } else {
            paymentData2 = paymentData = null;
        }
        if (paymentData == null) {
            this.getViewModel().updateGooglePayResult(new StripeGooglePayContract.Result.Error(new IllegalArgumentException("Google Pay data was not available"), null, null, null, 14, null));
            return;
        }
        JSONObject paymentDataJson = new JSONObject(paymentData.toJson());
        ShippingInformation shippingInformation = GooglePayResult.Companion.fromJson(paymentDataJson).getShippingInformation();
        PaymentMethodCreateParams params = PaymentMethodCreateParams.Companion.createFromGooglePay(paymentDataJson);
        this.getViewModel().createPaymentMethod(params).observe((LifecycleOwner)this, (Observer)new Observer<Result<? extends PaymentMethod>>(this){
            final /* synthetic */ StripeGooglePayActivity this$0;

            public final void onChanged(Result<? extends PaymentMethod> result2) {
                block2: {
                    Result<? extends PaymentMethod> result3 = result2;
                    if (result3 == null) break block2;
                    Object object = result3.unbox-impl();
                    StripeGooglePayActivity stripeGooglePayActivity = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable == null) {
                        PaymentMethod p1 = (PaymentMethod)object;
                        boolean bl3 = false;
                        StripeGooglePayActivity.access$onPaymentMethodCreated(stripeGooglePayActivity, p1);
                    } else {
                        Throwable it = throwable;
                        boolean bl4 = false;
                        StripeGooglePayActivity.access$getViewModel$p(this.this$0).setPaymentMethod(null);
                        StripeGooglePayActivity.access$getViewModel$p(this.this$0).updateGooglePayResult(new StripeGooglePayContract.Result.Error(it, null, null, null, 14, null));
                    }
                }
            }
            {
                this.this$0 = stripeGooglePayActivity;
            }
        });
    }

    private final void onPaymentMethodCreated(PaymentMethod paymentMethod) {
        this.getViewModel().setPaymentMethod(paymentMethod);
        String string2 = this.getArgs().getPaymentIntent$stripe_release().getClientSecret();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        this.confirmIntent(string3, paymentMethod);
    }

    private final void confirmIntent(String clientSecret, PaymentMethod paymentMethod) {
        Stripe stripe2 = this.getStripe();
        Activity activity = (Activity)this;
        String string2 = paymentMethod.id;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        Stripe.confirmPayment$default(stripe2, activity, ConfirmPaymentIntentParams.Companion.createWithPaymentMethodId$default(ConfirmPaymentIntentParams.Companion, string3, clientSecret, null, null, null, null, null, null, null, null, 1020, null), null, 4, null);
    }

    private final void finishWithResult(StripeGooglePayContract.Result result2) {
        this.setResult(-1, new Intent().putExtras(result2.toBundle()));
        this.finish();
    }

    /*
     * WARNING - void declaration
     */
    public StripeGooglePayActivity() {
        void $this$viewModels$iv;
        StripeGooglePayActivity stripeGooglePayActivity = this;
        Function0 factoryProducer$iv = (Function0)new Function0<ViewModelProvider.Factory>(this){
            final /* synthetic */ StripeGooglePayActivity this$0;

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                Application application = this.this$0.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"application");
                return new StripeGooglePayViewModel.Factory(application, StripeGooglePayActivity.access$getPublishableKey$p(this.this$0), StripeGooglePayActivity.access$getArgs$p(this.this$0));
            }
            {
                this.this$0 = stripeGooglePayActivity;
                super(0);
            }
        };
        boolean $i$f$viewModels = false;
        Function0 factoryPromise$iv = factoryProducer$iv;
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(StripeGooglePayViewModel.class), (Function0)new Function0<ViewModelStore>((ComponentActivity)$this$viewModels$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = componentActivity;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = this.$this_viewModels.getViewModelStore();
                Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"viewModelStore");
                return viewModelStore;
            }
        }, factoryPromise$iv);
    }

    public static final /* synthetic */ void access$finishWithResult(StripeGooglePayActivity $this, StripeGooglePayContract.Result result2) {
        $this.finishWithResult(result2);
    }

    public static final /* synthetic */ void access$payWithGoogle(StripeGooglePayActivity $this, JSONObject paymentDataRequest) {
        $this.payWithGoogle(paymentDataRequest);
    }

    public static final /* synthetic */ StripeGooglePayViewModel access$getViewModel$p(StripeGooglePayActivity $this) {
        return $this.getViewModel();
    }

    public static final /* synthetic */ void access$onPaymentMethodCreated(StripeGooglePayActivity $this, PaymentMethod paymentMethod) {
        $this.onPaymentMethodCreated(paymentMethod);
    }

    public static final /* synthetic */ StripeGooglePayContract.Args access$getArgs$p(StripeGooglePayActivity $this) {
        return $this.getArgs();
    }

    public static final /* synthetic */ String access$getPublishableKey$p(StripeGooglePayActivity $this) {
        return $this.getPublishableKey();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/googlepay/StripeGooglePayActivity$Companion;", "", "()V", "LOAD_PAYMENT_DATA_REQUEST_CODE", "", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

