/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.Size;
import com.stripe.android.model.Address;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceOrder;
import com.stripe.android.model.SourceTypeModel;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.WeChat;
import com.stripe.android.model.parsers.AddressJsonParser;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.SourceCardDataJsonParser;
import com.stripe.android.model.parsers.SourceOrderJsonParser;
import com.stripe.android.model.parsers.SourceSepaDebitDataJsonParser;
import com.stripe.android.model.parsers.WeChatJsonParser;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u0007\b\t\n\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source;", "()V", "parse", "json", "Lorg/json/JSONObject;", "CodeVerificationJsonParser", "Companion", "KlarnaJsonParser", "OwnerJsonParser", "ReceiverJsonParser", "RedirectJsonParser", "stripe_release"})
public final class SourceJsonParser
implements ModelJsonParser<Source> {
    private static final String VALUE_SOURCE = "source";
    private static final String VALUE_CARD = "card";
    private static final Set<String> MODELED_TYPES;
    private static final String FIELD_ID = "id";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_AMOUNT = "amount";
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    private static final String FIELD_CODE_VERIFICATION = "code_verification";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_FLOW = "flow";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_OWNER = "owner";
    private static final String FIELD_RECEIVER = "receiver";
    private static final String FIELD_REDIRECT = "redirect";
    private static final String FIELD_SOURCE_ORDER = "source_order";
    private static final String FIELD_STATEMENT_DESCRIPTOR = "statement_descriptor";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_USAGE = "usage";
    private static final String FIELD_WECHAT = "wechat";
    private static final String FIELD_KLARNA = "klarna";
    @NotNull
    private static final Companion Companion;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Source parse(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String string2 = json.optString(FIELD_OBJECT);
        if (string2 != null) {
            Source source;
            String string3 = string2;
            switch (string3.hashCode()) {
                case -896505829: {
                    if (!string3.equals(VALUE_SOURCE)) return null;
                    break;
                }
                case 3046160: {
                    if (!string3.equals(VALUE_CARD)) return null;
                    source = SourceJsonParser.Companion.fromCardJson(json);
                    return source;
                }
            }
            source = SourceJsonParser.Companion.fromSourceJson(json);
            return source;
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        MODELED_TYPES = SetsKt.setOf((Object[])new String[]{VALUE_CARD, "sepa_debit"});
    }

    @JvmStatic
    @NotNull
    public static final String asSourceType(@Nullable String sourceType) {
        return Companion.asSourceType(sourceType);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$RedirectJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$Redirect;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
    public static final class RedirectJsonParser
    implements ModelJsonParser<Source.Redirect> {
        private static final String FIELD_RETURN_URL = "return_url";
        private static final String FIELD_STATUS = "status";
        private static final String FIELD_URL = "url";
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public Source.Redirect parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new Source.Redirect(StripeJsonUtils.optString(json, FIELD_RETURN_URL), Source.Redirect.Status.Companion.fromCode(StripeJsonUtils.optString(json, "status")), StripeJsonUtils.optString(json, FIELD_URL));
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$RedirectJsonParser$Companion;", "", "()V", "FIELD_RETURN_URL", "", "FIELD_STATUS", "FIELD_URL", "stripe_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$CodeVerificationJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$CodeVerification;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
    public static final class CodeVerificationJsonParser
    implements ModelJsonParser<Source.CodeVerification> {
        private static final String FIELD_ATTEMPTS_REMAINING = "attempts_remaining";
        private static final String FIELD_STATUS = "status";
        private static final int INVALID_ATTEMPTS_REMAINING = -1;
        @NotNull
        private static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public Source.CodeVerification parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new Source.CodeVerification(json.optInt(FIELD_ATTEMPTS_REMAINING, -1), Source.CodeVerification.Status.Companion.fromCode(StripeJsonUtils.optString(json, "status")));
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$CodeVerificationJsonParser$Companion;", "", "()V", "FIELD_ATTEMPTS_REMAINING", "", "FIELD_STATUS", "INVALID_ATTEMPTS_REMAINING", "", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$ReceiverJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$Receiver;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
    public static final class ReceiverJsonParser
    implements ModelJsonParser<Source.Receiver> {
        private static final String FIELD_ADDRESS = "address";
        private static final String FIELD_AMOUNT_CHARGED = "amount_charged";
        private static final String FIELD_AMOUNT_RECEIVED = "amount_received";
        private static final String FIELD_AMOUNT_RETURNED = "amount_returned";
        @NotNull
        private static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public Source.Receiver parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new Source.Receiver(StripeJsonUtils.optString(json, FIELD_ADDRESS), json.optLong(FIELD_AMOUNT_CHARGED), json.optLong(FIELD_AMOUNT_RECEIVED), json.optLong(FIELD_AMOUNT_RETURNED));
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$ReceiverJsonParser$Companion;", "", "()V", "FIELD_ADDRESS", "", "FIELD_AMOUNT_CHARGED", "FIELD_AMOUNT_RECEIVED", "FIELD_AMOUNT_RETURNED", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$OwnerJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$Owner;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
    public static final class OwnerJsonParser
    implements ModelJsonParser<Source.Owner> {
        private static final String FIELD_ADDRESS = "address";
        private static final String FIELD_EMAIL = "email";
        private static final String FIELD_NAME = "name";
        private static final String FIELD_PHONE = "phone";
        private static final String FIELD_VERIFIED_ADDRESS = "verified_address";
        private static final String FIELD_VERIFIED_EMAIL = "verified_email";
        private static final String FIELD_VERIFIED_NAME = "verified_name";
        private static final String FIELD_VERIFIED_PHONE = "verified_phone";
        @NotNull
        private static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public Source.Owner parse(@NotNull JSONObject json) {
            Address address;
            Address address2;
            Address address3;
            JSONObject it;
            boolean bl;
            boolean bl2;
            JSONObject jSONObject;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            JSONObject jSONObject2 = json.optJSONObject(FIELD_ADDRESS);
            if (jSONObject2 != null) {
                jSONObject = jSONObject2;
                bl2 = false;
                bl = false;
                it = jSONObject;
                boolean bl3 = false;
                address2 = address3 = new AddressJsonParser().parse(it);
            } else {
                address2 = null;
            }
            String string2 = StripeJsonUtils.optString(json, FIELD_EMAIL);
            String string3 = StripeJsonUtils.optString(json, FIELD_NAME);
            String string4 = StripeJsonUtils.optString(json, FIELD_PHONE);
            JSONObject jSONObject3 = json.optJSONObject(FIELD_VERIFIED_ADDRESS);
            if (jSONObject3 != null) {
                jSONObject = jSONObject3;
                bl2 = false;
                bl = false;
                it = jSONObject;
                String string5 = string4;
                String string6 = string3;
                String string7 = string2;
                address3 = address2;
                boolean bl4 = false;
                Address address4 = new AddressJsonParser().parse(it);
                address2 = address3;
                string2 = string7;
                string3 = string6;
                string4 = string5;
                address = address4;
            } else {
                address = null;
            }
            String string8 = StripeJsonUtils.optString(json, FIELD_VERIFIED_PHONE);
            String string9 = StripeJsonUtils.optString(json, FIELD_VERIFIED_NAME);
            String string10 = StripeJsonUtils.optString(json, FIELD_VERIFIED_EMAIL);
            Address address5 = address;
            String string11 = string4;
            String string12 = string3;
            String string13 = string2;
            Address address6 = address2;
            return new Source.Owner(address6, string13, string12, string11, address5, string10, string9, string8);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$OwnerJsonParser$Companion;", "", "()V", "FIELD_ADDRESS", "", "FIELD_EMAIL", "FIELD_NAME", "FIELD_PHONE", "FIELD_VERIFIED_ADDRESS", "FIELD_VERIFIED_EMAIL", "FIELD_VERIFIED_NAME", "FIELD_VERIFIED_PHONE", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$KlarnaJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$Klarna;", "()V", "parse", "json", "Lorg/json/JSONObject;", "parseSet", "", "", "key", "Companion", "stripe_release"})
    public static final class KlarnaJsonParser
    implements ModelJsonParser<Source.Klarna> {
        private static final String FIELD_FIRST_NAME = "first_name";
        private static final String FIELD_LAST_NAME = "last_name";
        private static final String FIELD_PURCHASE_COUNTRY = "purchase_country";
        private static final String FIELD_CLIENT_TOKEN = "client_token";
        private static final String FIELD_PAY_LATER_ASSET_URLS_DESCRIPTIVE = "pay_later_asset_urls_descriptive";
        private static final String FIELD_PAY_LATER_ASSET_URLS_STANDARD = "pay_later_asset_urls_standard";
        private static final String FIELD_PAY_LATER_NAME = "pay_later_name";
        private static final String FIELD_PAY_LATER_REDIRECT_URL = "pay_later_redirect_url";
        private static final String FIELD_PAY_NOW_ASSET_URLS_DESCRIPTIVE = "pay_now_asset_urls_descriptive";
        private static final String FIELD_PAY_NOW_ASSET_URLS_STANDARD = "pay_now_asset_urls_standard";
        private static final String FIELD_PAY_NOW_NAME = "pay_now_name";
        private static final String FIELD_PAY_NOW_REDIRECT_URL = "pay_now_redirect_url";
        private static final String FIELD_PAY_OVER_TIME_ASSET_URLS_DESCRIPTIVE = "pay_over_time_asset_urls_descriptive";
        private static final String FIELD_PAY_OVER_TIME_ASSET_URLS_STANDARD = "pay_over_time_asset_urls_standard";
        private static final String FIELD_PAY_OVER_TIME_NAME = "pay_over_time_name";
        private static final String FIELD_PAY_OVER_TIME_REDIRECT_URL = "pay_over_time_redirect_url";
        private static final String FIELD_PAYMENT_METHOD_CATEGORIES = "payment_method_categories";
        private static final String FIELD_CUSTOM_PAYMENT_METHODS = "custom_payment_methods";
        @NotNull
        private static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public Source.Klarna parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Set<String> set = this.parseSet(json, FIELD_CUSTOM_PAYMENT_METHODS);
            Set<String> set2 = this.parseSet(json, FIELD_PAYMENT_METHOD_CATEGORIES);
            String string2 = StripeJsonUtils.optString(json, FIELD_PAY_OVER_TIME_REDIRECT_URL);
            String string3 = StripeJsonUtils.optString(json, FIELD_PAY_OVER_TIME_NAME);
            String string4 = StripeJsonUtils.optString(json, FIELD_PAY_OVER_TIME_ASSET_URLS_STANDARD);
            String string5 = StripeJsonUtils.optString(json, FIELD_PAY_OVER_TIME_ASSET_URLS_DESCRIPTIVE);
            String string6 = StripeJsonUtils.optString(json, FIELD_PAY_NOW_REDIRECT_URL);
            String string7 = StripeJsonUtils.optString(json, FIELD_PAY_NOW_NAME);
            String string8 = StripeJsonUtils.optString(json, FIELD_PAY_NOW_ASSET_URLS_STANDARD);
            String string9 = StripeJsonUtils.optString(json, FIELD_PAY_NOW_ASSET_URLS_DESCRIPTIVE);
            String string10 = StripeJsonUtils.optString(json, FIELD_PAY_LATER_REDIRECT_URL);
            String string11 = StripeJsonUtils.optString(json, FIELD_PAY_LATER_NAME);
            String string12 = StripeJsonUtils.optString(json, FIELD_PAY_LATER_ASSET_URLS_STANDARD);
            String string13 = StripeJsonUtils.optString(json, FIELD_PAY_LATER_ASSET_URLS_DESCRIPTIVE);
            return new Source.Klarna(StripeJsonUtils.optString(json, FIELD_FIRST_NAME), StripeJsonUtils.optString(json, FIELD_LAST_NAME), StripeJsonUtils.optString(json, FIELD_PURCHASE_COUNTRY), StripeJsonUtils.optString(json, FIELD_CLIENT_TOKEN), string9, string8, string7, string6, string13, string12, string11, string10, string5, string4, string3, string2, set2, set);
        }

        private final Set<String> parseSet(JSONObject json, String key) {
            Object object = StripeJsonUtils.optString(json, key);
            Set set = object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) != null ? CollectionsKt.toSet((Iterable)((Iterable)object)) : null;
            boolean bl = false;
            Set set2 = set;
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            return set2;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$KlarnaJsonParser$Companion;", "", "()V", "FIELD_CLIENT_TOKEN", "", "FIELD_CUSTOM_PAYMENT_METHODS", "FIELD_FIRST_NAME", "FIELD_LAST_NAME", "FIELD_PAYMENT_METHOD_CATEGORIES", "FIELD_PAY_LATER_ASSET_URLS_DESCRIPTIVE", "FIELD_PAY_LATER_ASSET_URLS_STANDARD", "FIELD_PAY_LATER_NAME", "FIELD_PAY_LATER_REDIRECT_URL", "FIELD_PAY_NOW_ASSET_URLS_DESCRIPTIVE", "FIELD_PAY_NOW_ASSET_URLS_STANDARD", "FIELD_PAY_NOW_NAME", "FIELD_PAY_NOW_REDIRECT_URL", "FIELD_PAY_OVER_TIME_ASSET_URLS_DESCRIPTIVE", "FIELD_PAY_OVER_TIME_ASSET_URLS_STANDARD", "FIELD_PAY_OVER_TIME_NAME", "FIELD_PAY_OVER_TIME_REDIRECT_URL", "FIELD_PURCHASE_COUNTRY", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J.\u0010\"\u001a\u0004\u0018\u0001H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020$2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010%\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$Companion;", "", "()V", "FIELD_AMOUNT", "", "FIELD_CLIENT_SECRET", "FIELD_CODE_VERIFICATION", "FIELD_CREATED", "FIELD_CURRENCY", "FIELD_FLOW", "FIELD_ID", "FIELD_KLARNA", "FIELD_LIVEMODE", "FIELD_OBJECT", "FIELD_OWNER", "FIELD_RECEIVER", "FIELD_REDIRECT", "FIELD_SOURCE_ORDER", "FIELD_STATEMENT_DESCRIPTOR", "FIELD_STATUS", "FIELD_TYPE", "FIELD_USAGE", "FIELD_WECHAT", "MODELED_TYPES", "", "VALUE_CARD", "VALUE_SOURCE", "asSourceType", "sourceType", "fromCardJson", "Lcom/stripe/android/model/Source;", "jsonObject", "Lorg/json/JSONObject;", "fromSourceJson", "optStripeJsonModel", "T", "Lcom/stripe/android/model/StripeModel;", "key", "(Lorg/json/JSONObject;Ljava/lang/String;)Lcom/stripe/android/model/StripeModel;", "stripe_release"})
    private static final class Companion {
        private final Source fromCardJson(JSONObject jsonObject) {
            return new Source(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_ID), null, null, null, null, null, null, null, null, null, null, null, null, null, new SourceCardDataJsonParser().parse(jsonObject), SourceJsonParser.VALUE_CARD, SourceJsonParser.VALUE_CARD, null, null, null, null, null, 0x3E3FFE, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Source fromSourceJson(JSONObject jsonObject) {
            Source.Klarna klarna;
            WeChat weChat;
            SourceOrder sourceOrder;
            JSONObject jSONObject;
            StripeModel stripeModel;
            StripeModel stripeModel2;
            StripeModel stripeModel3;
            StripeModel model$iv;
            StripeModel stripeModel4;
            SourceTypeModel sourceTypeModel;
            boolean bl;
            Object object;
            Companion this_$iv;
            String string2 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_TYPE);
            if (string2 == null) {
                string2 = "unknown";
            }
            String typeRaw = string2;
            String type = this.asSourceType(typeRaw);
            Map<String, Object> sourceTypeData = StripeJsonUtils.INSTANCE.jsonObjectToMap$stripe_release(jsonObject.optJSONObject(typeRaw));
            if (MODELED_TYPES.contains(typeRaw)) {
                StripeModel stripeModel5;
                this_$iv = this;
                boolean $i$f$optStripeJsonModel = false;
                if (!jsonObject.has(typeRaw)) {
                    stripeModel5 = null;
                } else {
                    StripeModel model$iv2;
                    StripeModel stripeModel6;
                    StripeModel stripeModel7;
                    switch (typeRaw) {
                        case "code_verification": {
                            Source.CodeVerification codeVerification;
                            Object it$iv;
                            boolean bl2;
                            JSONObject jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                            if (jSONObject2 != null) {
                                object = jSONObject2;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl3 = false;
                                codeVerification = new CodeVerificationJsonParser().parse((JSONObject)it$iv);
                            } else {
                                codeVerification = null;
                            }
                            stripeModel7 = codeVerification;
                            break;
                        }
                        case "owner": {
                            Source.Owner owner;
                            Object it$iv;
                            boolean bl2;
                            JSONObject jSONObject3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                            if (jSONObject3 != null) {
                                object = jSONObject3;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl4 = false;
                                owner = new OwnerJsonParser().parse((JSONObject)it$iv);
                            } else {
                                owner = null;
                            }
                            stripeModel7 = owner;
                            break;
                        }
                        case "receiver": {
                            Source.Receiver receiver;
                            Object it$iv;
                            boolean bl2;
                            JSONObject jSONObject4 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                            if (jSONObject4 != null) {
                                object = jSONObject4;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl5 = false;
                                receiver = new ReceiverJsonParser().parse((JSONObject)it$iv);
                            } else {
                                receiver = null;
                            }
                            stripeModel7 = receiver;
                            break;
                        }
                        case "redirect": {
                            Source.Redirect redirect;
                            Object it$iv;
                            boolean bl2;
                            JSONObject jSONObject5 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                            if (jSONObject5 != null) {
                                object = jSONObject5;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl6 = false;
                                redirect = new RedirectJsonParser().parse((JSONObject)it$iv);
                            } else {
                                redirect = null;
                            }
                            stripeModel7 = redirect;
                            break;
                        }
                        case "card": {
                            SourceTypeModel.Card card;
                            Object it$iv;
                            boolean bl2;
                            JSONObject jSONObject6 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                            if (jSONObject6 != null) {
                                object = jSONObject6;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl7 = false;
                                card = new SourceCardDataJsonParser().parse((JSONObject)it$iv);
                            } else {
                                card = null;
                            }
                            stripeModel7 = card;
                            break;
                        }
                        case "sepa_debit": {
                            SourceTypeModel.SepaDebit sepaDebit;
                            Object it$iv;
                            boolean bl2;
                            JSONObject jSONObject7 = jsonObject.optJSONObject("sepa_debit");
                            if (jSONObject7 != null) {
                                object = jSONObject7;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl8 = false;
                                sepaDebit = new SourceSepaDebitDataJsonParser().parse((JSONObject)it$iv);
                            } else {
                                sepaDebit = null;
                            }
                            stripeModel7 = sepaDebit;
                            break;
                        }
                        default: {
                            stripeModel7 = null;
                        }
                    }
                    if (!((stripeModel6 = (model$iv2 = stripeModel7)) instanceof SourceTypeModel)) {
                        stripeModel6 = null;
                    }
                    stripeModel5 = (SourceTypeModel)stripeModel6;
                }
                sourceTypeModel = (SourceTypeModel)stripeModel5;
            } else {
                sourceTypeModel = null;
            }
            SourceTypeModel sourceTypeModel2 = sourceTypeModel;
            String string3 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_ID);
            Long l = StripeJsonUtils.INSTANCE.optLong$stripe_release(jsonObject, SourceJsonParser.FIELD_AMOUNT);
            String string4 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_CLIENT_SECRET);
            this_$iv = this;
            String key$iv = SourceJsonParser.FIELD_CODE_VERIFICATION;
            boolean $i$f$optStripeJsonModel = false;
            if (!jsonObject.has(key$iv)) {
                stripeModel4 = null;
            } else {
                StripeModel stripeModel8;
                StripeModel stripeModel9;
                switch (key$iv) {
                    case "code_verification": {
                        Source.CodeVerification codeVerification;
                        JSONObject jSONObject8 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject8 != null) {
                            JSONObject jSONObject9 = jSONObject8;
                            bl = false;
                            boolean bl9 = false;
                            JSONObject it$iv = jSONObject9;
                            boolean bl10 = false;
                            codeVerification = new CodeVerificationJsonParser().parse(it$iv);
                        } else {
                            codeVerification = null;
                        }
                        stripeModel9 = codeVerification;
                        break;
                    }
                    case "owner": {
                        Source.Owner owner;
                        JSONObject jSONObject10 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject10 != null) {
                            JSONObject jSONObject11 = jSONObject10;
                            bl = false;
                            boolean bl11 = false;
                            JSONObject it$iv = jSONObject11;
                            boolean bl12 = false;
                            owner = new OwnerJsonParser().parse(it$iv);
                        } else {
                            owner = null;
                        }
                        stripeModel9 = owner;
                        break;
                    }
                    case "receiver": {
                        Source.Receiver receiver;
                        JSONObject jSONObject12 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject12 != null) {
                            JSONObject jSONObject13 = jSONObject12;
                            bl = false;
                            boolean bl13 = false;
                            JSONObject it$iv = jSONObject13;
                            boolean bl14 = false;
                            receiver = new ReceiverJsonParser().parse(it$iv);
                        } else {
                            receiver = null;
                        }
                        stripeModel9 = receiver;
                        break;
                    }
                    case "redirect": {
                        Source.Redirect redirect;
                        JSONObject jSONObject14 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject14 != null) {
                            JSONObject jSONObject15 = jSONObject14;
                            bl = false;
                            boolean bl15 = false;
                            JSONObject it$iv = jSONObject15;
                            boolean bl16 = false;
                            redirect = new RedirectJsonParser().parse(it$iv);
                        } else {
                            redirect = null;
                        }
                        stripeModel9 = redirect;
                        break;
                    }
                    case "card": {
                        SourceTypeModel.Card card;
                        JSONObject jSONObject16 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject16 != null) {
                            JSONObject jSONObject17 = jSONObject16;
                            bl = false;
                            boolean bl17 = false;
                            JSONObject it$iv = jSONObject17;
                            boolean bl18 = false;
                            card = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            card = null;
                        }
                        stripeModel9 = card;
                        break;
                    }
                    case "sepa_debit": {
                        SourceTypeModel.SepaDebit sepaDebit;
                        JSONObject jSONObject18 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject18 != null) {
                            JSONObject jSONObject19 = jSONObject18;
                            bl = false;
                            boolean bl19 = false;
                            JSONObject it$iv = jSONObject19;
                            boolean bl20 = false;
                            sepaDebit = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sepaDebit = null;
                        }
                        stripeModel9 = sepaDebit;
                        break;
                    }
                    default: {
                        stripeModel9 = null;
                    }
                }
                if (!((stripeModel8 = (model$iv = stripeModel9)) instanceof Source.CodeVerification)) {
                    stripeModel8 = null;
                }
                stripeModel4 = (Source.CodeVerification)stripeModel8;
            }
            Source.CodeVerification codeVerification = (Source.CodeVerification)stripeModel4;
            Long l2 = StripeJsonUtils.INSTANCE.optLong$stripe_release(jsonObject, SourceJsonParser.FIELD_CREATED);
            String string5 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_CURRENCY);
            Source.Flow flow = Source.Flow.Companion.fromCode(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_FLOW));
            Boolean bl21 = jsonObject.optBoolean(SourceJsonParser.FIELD_LIVEMODE);
            Map map = null;
            this_$iv = this;
            key$iv = SourceJsonParser.FIELD_OWNER;
            $i$f$optStripeJsonModel = false;
            if (!jsonObject.has(key$iv)) {
                stripeModel3 = null;
            } else {
                StripeModel stripeModel10;
                StripeModel stripeModel11;
                switch (key$iv) {
                    case "code_verification": {
                        Source.CodeVerification codeVerification2;
                        JSONObject jSONObject20 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject20 != null) {
                            JSONObject jSONObject21 = jSONObject20;
                            bl = false;
                            boolean bl22 = false;
                            JSONObject it$iv = jSONObject21;
                            boolean bl23 = false;
                            codeVerification2 = new CodeVerificationJsonParser().parse(it$iv);
                        } else {
                            codeVerification2 = null;
                        }
                        stripeModel11 = codeVerification2;
                        break;
                    }
                    case "owner": {
                        Source.Owner owner;
                        JSONObject jSONObject22 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject22 != null) {
                            JSONObject jSONObject23 = jSONObject22;
                            bl = false;
                            boolean bl24 = false;
                            JSONObject it$iv = jSONObject23;
                            boolean bl25 = false;
                            owner = new OwnerJsonParser().parse(it$iv);
                        } else {
                            owner = null;
                        }
                        stripeModel11 = owner;
                        break;
                    }
                    case "receiver": {
                        Source.Receiver receiver;
                        JSONObject jSONObject24 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject24 != null) {
                            JSONObject jSONObject25 = jSONObject24;
                            bl = false;
                            boolean bl26 = false;
                            JSONObject it$iv = jSONObject25;
                            boolean bl27 = false;
                            receiver = new ReceiverJsonParser().parse(it$iv);
                        } else {
                            receiver = null;
                        }
                        stripeModel11 = receiver;
                        break;
                    }
                    case "redirect": {
                        Source.Redirect redirect;
                        JSONObject jSONObject26 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject26 != null) {
                            JSONObject jSONObject27 = jSONObject26;
                            bl = false;
                            boolean bl28 = false;
                            JSONObject it$iv = jSONObject27;
                            boolean bl29 = false;
                            redirect = new RedirectJsonParser().parse(it$iv);
                        } else {
                            redirect = null;
                        }
                        stripeModel11 = redirect;
                        break;
                    }
                    case "card": {
                        SourceTypeModel.Card card;
                        JSONObject jSONObject28 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject28 != null) {
                            JSONObject jSONObject29 = jSONObject28;
                            bl = false;
                            boolean bl30 = false;
                            JSONObject it$iv = jSONObject29;
                            boolean bl31 = false;
                            card = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            card = null;
                        }
                        stripeModel11 = card;
                        break;
                    }
                    case "sepa_debit": {
                        SourceTypeModel.SepaDebit sepaDebit;
                        JSONObject jSONObject30 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject30 != null) {
                            JSONObject jSONObject31 = jSONObject30;
                            bl = false;
                            boolean bl32 = false;
                            JSONObject it$iv = jSONObject31;
                            boolean bl33 = false;
                            sepaDebit = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sepaDebit = null;
                        }
                        stripeModel11 = sepaDebit;
                        break;
                    }
                    default: {
                        stripeModel11 = null;
                    }
                }
                if (!((stripeModel10 = (model$iv = stripeModel11)) instanceof Source.Owner)) {
                    stripeModel10 = null;
                }
                stripeModel3 = (Source.Owner)stripeModel10;
            }
            Source.Owner owner = (Source.Owner)stripeModel3;
            this_$iv = this;
            key$iv = SourceJsonParser.FIELD_RECEIVER;
            $i$f$optStripeJsonModel = false;
            if (!jsonObject.has(key$iv)) {
                stripeModel2 = null;
            } else {
                StripeModel stripeModel12;
                StripeModel stripeModel13;
                switch (key$iv) {
                    case "code_verification": {
                        Source.CodeVerification codeVerification3;
                        JSONObject jSONObject32 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject32 != null) {
                            JSONObject jSONObject33 = jSONObject32;
                            bl = false;
                            boolean bl34 = false;
                            JSONObject it$iv = jSONObject33;
                            boolean bl35 = false;
                            codeVerification3 = new CodeVerificationJsonParser().parse(it$iv);
                        } else {
                            codeVerification3 = null;
                        }
                        stripeModel13 = codeVerification3;
                        break;
                    }
                    case "owner": {
                        Source.Owner owner2;
                        JSONObject jSONObject34 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject34 != null) {
                            JSONObject jSONObject35 = jSONObject34;
                            bl = false;
                            boolean bl36 = false;
                            JSONObject it$iv = jSONObject35;
                            boolean bl37 = false;
                            owner2 = new OwnerJsonParser().parse(it$iv);
                        } else {
                            owner2 = null;
                        }
                        stripeModel13 = owner2;
                        break;
                    }
                    case "receiver": {
                        Source.Receiver receiver;
                        JSONObject jSONObject36 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject36 != null) {
                            JSONObject jSONObject37 = jSONObject36;
                            bl = false;
                            boolean bl38 = false;
                            JSONObject it$iv = jSONObject37;
                            boolean bl39 = false;
                            receiver = new ReceiverJsonParser().parse(it$iv);
                        } else {
                            receiver = null;
                        }
                        stripeModel13 = receiver;
                        break;
                    }
                    case "redirect": {
                        Source.Redirect redirect;
                        JSONObject jSONObject38 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject38 != null) {
                            JSONObject jSONObject39 = jSONObject38;
                            bl = false;
                            boolean bl40 = false;
                            JSONObject it$iv = jSONObject39;
                            boolean bl41 = false;
                            redirect = new RedirectJsonParser().parse(it$iv);
                        } else {
                            redirect = null;
                        }
                        stripeModel13 = redirect;
                        break;
                    }
                    case "card": {
                        SourceTypeModel.Card card;
                        JSONObject jSONObject40 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject40 != null) {
                            JSONObject jSONObject41 = jSONObject40;
                            bl = false;
                            boolean bl42 = false;
                            JSONObject it$iv = jSONObject41;
                            boolean bl43 = false;
                            card = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            card = null;
                        }
                        stripeModel13 = card;
                        break;
                    }
                    case "sepa_debit": {
                        SourceTypeModel.SepaDebit sepaDebit;
                        JSONObject jSONObject42 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject42 != null) {
                            JSONObject jSONObject43 = jSONObject42;
                            bl = false;
                            boolean bl44 = false;
                            JSONObject it$iv = jSONObject43;
                            boolean bl45 = false;
                            sepaDebit = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sepaDebit = null;
                        }
                        stripeModel13 = sepaDebit;
                        break;
                    }
                    default: {
                        stripeModel13 = null;
                    }
                }
                if (!((stripeModel12 = (model$iv = stripeModel13)) instanceof Source.Receiver)) {
                    stripeModel12 = null;
                }
                stripeModel2 = (Source.Receiver)stripeModel12;
            }
            Source.Receiver receiver = (Source.Receiver)stripeModel2;
            this_$iv = this;
            key$iv = SourceJsonParser.FIELD_REDIRECT;
            $i$f$optStripeJsonModel = false;
            if (!jsonObject.has(key$iv)) {
                stripeModel = null;
            } else {
                StripeModel stripeModel14;
                StripeModel stripeModel15;
                switch (key$iv) {
                    case "code_verification": {
                        Source.CodeVerification codeVerification4;
                        JSONObject jSONObject44 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject44 != null) {
                            JSONObject jSONObject45 = jSONObject44;
                            bl = false;
                            boolean bl46 = false;
                            JSONObject it$iv = jSONObject45;
                            boolean bl47 = false;
                            codeVerification4 = new CodeVerificationJsonParser().parse(it$iv);
                        } else {
                            codeVerification4 = null;
                        }
                        stripeModel15 = codeVerification4;
                        break;
                    }
                    case "owner": {
                        Source.Owner owner3;
                        JSONObject jSONObject46 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject46 != null) {
                            JSONObject jSONObject47 = jSONObject46;
                            bl = false;
                            boolean bl48 = false;
                            JSONObject it$iv = jSONObject47;
                            boolean bl49 = false;
                            owner3 = new OwnerJsonParser().parse(it$iv);
                        } else {
                            owner3 = null;
                        }
                        stripeModel15 = owner3;
                        break;
                    }
                    case "receiver": {
                        Source.Receiver receiver2;
                        JSONObject jSONObject48 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject48 != null) {
                            JSONObject jSONObject49 = jSONObject48;
                            bl = false;
                            boolean bl50 = false;
                            JSONObject it$iv = jSONObject49;
                            boolean bl51 = false;
                            receiver2 = new ReceiverJsonParser().parse(it$iv);
                        } else {
                            receiver2 = null;
                        }
                        stripeModel15 = receiver2;
                        break;
                    }
                    case "redirect": {
                        Source.Redirect redirect;
                        JSONObject jSONObject50 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject50 != null) {
                            JSONObject jSONObject51 = jSONObject50;
                            bl = false;
                            boolean bl52 = false;
                            JSONObject it$iv = jSONObject51;
                            boolean bl53 = false;
                            redirect = new RedirectJsonParser().parse(it$iv);
                        } else {
                            redirect = null;
                        }
                        stripeModel15 = redirect;
                        break;
                    }
                    case "card": {
                        SourceTypeModel.Card card;
                        JSONObject jSONObject52 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject52 != null) {
                            JSONObject jSONObject53 = jSONObject52;
                            bl = false;
                            boolean bl54 = false;
                            JSONObject it$iv = jSONObject53;
                            boolean bl55 = false;
                            card = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            card = null;
                        }
                        stripeModel15 = card;
                        break;
                    }
                    case "sepa_debit": {
                        SourceTypeModel.SepaDebit sepaDebit;
                        JSONObject jSONObject54 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject54 != null) {
                            JSONObject jSONObject55 = jSONObject54;
                            bl = false;
                            boolean bl56 = false;
                            JSONObject it$iv = jSONObject55;
                            boolean bl57 = false;
                            sepaDebit = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sepaDebit = null;
                        }
                        stripeModel15 = sepaDebit;
                        break;
                    }
                    default: {
                        stripeModel15 = null;
                    }
                }
                if (!((stripeModel14 = (model$iv = stripeModel15)) instanceof Source.Redirect)) {
                    stripeModel14 = null;
                }
                stripeModel = (Source.Redirect)stripeModel14;
            }
            Source.Redirect redirect = (Source.Redirect)stripeModel;
            JSONObject jSONObject56 = jsonObject.optJSONObject(SourceJsonParser.FIELD_SOURCE_ORDER);
            if (jSONObject56 != null) {
                void it;
                jSONObject = jSONObject56;
                boolean bl58 = false;
                boolean bl59 = false;
                object = jSONObject;
                Source.Redirect redirect2 = redirect;
                Source.Receiver receiver3 = receiver;
                Source.Owner owner4 = owner;
                Map map2 = map;
                Boolean bl60 = bl21;
                Source.Flow flow2 = flow;
                String string6 = string5;
                Long l3 = l2;
                Source.CodeVerification codeVerification5 = codeVerification;
                String string7 = string4;
                Long l4 = l;
                String string8 = string3;
                boolean bl61 = false;
                SourceOrder sourceOrder2 = new SourceOrderJsonParser().parse((JSONObject)it);
                string3 = string8;
                l = l4;
                string4 = string7;
                codeVerification = codeVerification5;
                l2 = l3;
                string5 = string6;
                flow = flow2;
                bl21 = bl60;
                map = map2;
                owner = owner4;
                receiver = receiver3;
                redirect = redirect2;
                sourceOrder = sourceOrder2;
            } else {
                sourceOrder = null;
            }
            String string9 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_STATEMENT_DESCRIPTOR);
            Source.Status status = Source.Status.Companion.fromCode(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_STATUS));
            Source.Usage usage = Source.Usage.Companion.fromCode(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_USAGE));
            if (Intrinsics.areEqual((Object)SourceJsonParser.FIELD_WECHAT, (Object)type)) {
                WeChatJsonParser weChatJsonParser = new WeChatJsonParser();
                JSONObject jSONObject57 = jsonObject.optJSONObject(SourceJsonParser.FIELD_WECHAT);
                if (jSONObject57 == null) {
                    jSONObject57 = new JSONObject();
                }
                weChat = weChatJsonParser.parse(jSONObject57);
            } else {
                weChat = null;
            }
            if (Intrinsics.areEqual((Object)SourceJsonParser.FIELD_KLARNA, (Object)type)) {
                KlarnaJsonParser klarnaJsonParser = new KlarnaJsonParser();
                JSONObject jSONObject58 = jsonObject.optJSONObject(SourceJsonParser.FIELD_KLARNA);
                if (jSONObject58 == null) {
                    jSONObject58 = new JSONObject();
                }
                klarna = klarnaJsonParser.parse(jSONObject58);
            } else {
                klarna = null;
            }
            jSONObject = klarna;
            WeChat weChat2 = weChat;
            Source.Usage usage2 = usage;
            object = typeRaw;
            String string10 = type;
            SourceTypeModel sourceTypeModel3 = sourceTypeModel2;
            Map<String, Object> map3 = sourceTypeData;
            Source.Status status2 = status;
            String string11 = string9;
            SourceOrder sourceOrder3 = sourceOrder;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 256;
            String string12 = string11;
            SourceOrder sourceOrder4 = sourceOrder3;
            JSONObject jSONObject59 = jSONObject;
            WeChat weChat3 = weChat2;
            Source.Usage usage3 = usage2;
            Object object2 = object;
            String string13 = string10;
            SourceTypeModel sourceTypeModel4 = sourceTypeModel3;
            Map<String, Object> map4 = map3;
            Source.Status status3 = status2;
            Source.Redirect redirect3 = redirect;
            Source.Receiver receiver4 = receiver;
            Source.Owner owner5 = owner;
            Map map5 = map;
            Boolean bl62 = bl21;
            Source.Flow flow3 = flow;
            String string14 = string5;
            Long l5 = l2;
            Source.CodeVerification codeVerification6 = codeVerification;
            String string15 = string4;
            Long l6 = l;
            String string16 = string3;
            return new Source(string16, l6, string15, codeVerification6, l5, string14, flow3, bl62, map5, owner5, receiver4, redirect3, status3, map4, sourceTypeModel4, string13, (String)object2, usage3, weChat3, (Source.Klarna)jSONObject59, sourceOrder4, string12, n, defaultConstructorMarker);
        }

        private final /* synthetic */ <T extends StripeModel> T optStripeJsonModel(JSONObject jsonObject, @Size(min=1L) String key) {
            StripeModel stripeModel;
            int $i$f$optStripeJsonModel = 0;
            if (!jsonObject.has(key)) {
                return null;
            }
            switch (key) {
                case "code_verification": {
                    Source.CodeVerification codeVerification;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                    if (jSONObject2 != null) {
                        jSONObject = jSONObject2;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl3 = false;
                        codeVerification = new CodeVerificationJsonParser().parse(it);
                    } else {
                        codeVerification = null;
                    }
                    stripeModel = codeVerification;
                    break;
                }
                case "owner": {
                    Source.Owner owner;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                    if (jSONObject3 != null) {
                        jSONObject = jSONObject3;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl4 = false;
                        owner = new OwnerJsonParser().parse(it);
                    } else {
                        owner = null;
                    }
                    stripeModel = owner;
                    break;
                }
                case "receiver": {
                    Source.Receiver receiver;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject4 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                    if (jSONObject4 != null) {
                        jSONObject = jSONObject4;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl5 = false;
                        receiver = new ReceiverJsonParser().parse(it);
                    } else {
                        receiver = null;
                    }
                    stripeModel = receiver;
                    break;
                }
                case "redirect": {
                    Source.Redirect redirect;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject5 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                    if (jSONObject5 != null) {
                        jSONObject = jSONObject5;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl6 = false;
                        redirect = new RedirectJsonParser().parse(it);
                    } else {
                        redirect = null;
                    }
                    stripeModel = redirect;
                    break;
                }
                case "card": {
                    SourceTypeModel.Card card;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject6 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                    if (jSONObject6 != null) {
                        jSONObject = jSONObject6;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl7 = false;
                        card = new SourceCardDataJsonParser().parse(it);
                    } else {
                        card = null;
                    }
                    stripeModel = card;
                    break;
                }
                case "sepa_debit": {
                    SourceTypeModel.SepaDebit sepaDebit;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject7 = jsonObject.optJSONObject("sepa_debit");
                    if (jSONObject7 != null) {
                        jSONObject = jSONObject7;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl8 = false;
                        sepaDebit = new SourceSepaDebitDataJsonParser().parse(it);
                    } else {
                        sepaDebit = null;
                    }
                    stripeModel = sepaDebit;
                    break;
                }
                default: {
                    stripeModel = null;
                }
            }
            StripeModel model = stripeModel;
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            return (T)model;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @NotNull
        public final String asSourceType(@Nullable String sourceType) {
            String string2 = sourceType;
            if (string2 == null) return "unknown";
            switch (string2) {
                case "card": {
                    return SourceJsonParser.VALUE_CARD;
                }
                case "three_d_secure": {
                    return "three_d_secure";
                }
                case "giropay": {
                    return "giropay";
                }
                case "sepa_debit": {
                    return "sepa_debit";
                }
                case "ideal": {
                    return "ideal";
                }
                case "sofort": {
                    return "sofort";
                }
                case "bancontact": {
                    return "bancontact";
                }
                case "alipay": {
                    return "alipay";
                }
                case "eps": {
                    return "eps";
                }
                case "p24": {
                    return "p24";
                }
                case "multibanco": {
                    return "multibanco";
                }
                case "wechat": {
                    return SourceJsonParser.FIELD_WECHAT;
                }
                case "unknown": {
                    return "unknown";
                }
                case "klarna": {
                    return SourceJsonParser.FIELD_KLARNA;
                }
                default: {
                    return "unknown";
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

