/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ProgressBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.stripe.android.Logger;
import com.stripe.android.PaymentAuthWebViewStarter;
import com.stripe.android.R;
import com.stripe.android.databinding.PaymentAuthWebViewActivityBinding;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import com.stripe.android.view.PaymentAuthWebView;
import com.stripe.android.view.PaymentAuthWebViewActivityViewModel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0014J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/view/PaymentAuthWebViewActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "logger", "Lcom/stripe/android/Logger;", "viewBinding", "Lcom/stripe/android/databinding/PaymentAuthWebViewActivityBinding;", "getViewBinding", "()Lcom/stripe/android/databinding/PaymentAuthWebViewActivityBinding;", "viewBinding$delegate", "Lkotlin/Lazy;", "viewModel", "Lcom/stripe/android/view/PaymentAuthWebViewActivityViewModel;", "cancelIntentSource", "", "customizeToolbar", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "stripe_release"})
public final class PaymentAuthWebViewActivity
extends AppCompatActivity {
    private final Lazy viewBinding$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PaymentAuthWebViewActivityBinding>(this){
        final /* synthetic */ PaymentAuthWebViewActivity this$0;

        @NotNull
        public final PaymentAuthWebViewActivityBinding invoke() {
            PaymentAuthWebViewActivityBinding paymentAuthWebViewActivityBinding = PaymentAuthWebViewActivityBinding.inflate(this.this$0.getLayoutInflater());
            Intrinsics.checkNotNullExpressionValue((Object)paymentAuthWebViewActivityBinding, (String)"PaymentAuthWebViewActivi\u2026g.inflate(layoutInflater)");
            return paymentAuthWebViewActivityBinding;
        }
        {
            this.this$0 = paymentAuthWebViewActivity;
            super(0);
        }
    }));
    private Logger logger;
    private PaymentAuthWebViewActivityViewModel viewModel;

    private final PaymentAuthWebViewActivityBinding getViewBinding() {
        Lazy lazy = this.viewBinding$delegate;
        PaymentAuthWebViewActivity paymentAuthWebViewActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PaymentAuthWebViewActivityBinding)lazy.getValue();
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PaymentAuthWebViewStarter.Args args2 = (PaymentAuthWebViewStarter.Args)this.getIntent().getParcelableExtra("extra_args");
        if (args2 == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        ViewModel viewModel2 = new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new PaymentAuthWebViewActivityViewModel.Factory(args2)).get(PaymentAuthWebViewActivityViewModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)viewModel2, (String)"ViewModelProvider(\n     \u2026ityViewModel::class.java]");
        this.viewModel = (PaymentAuthWebViewActivityViewModel)viewModel2;
        Logger logger = this.logger = Logger.Companion.getInstance$stripe_release(args2.getEnableLogging());
        if (logger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger.debug("PaymentAuthWebViewActivity#onCreate()");
        LocalBroadcastManager.getInstance((Context)((Context)this)).sendBroadcast(new Intent().setAction("com.ul.sdk.HANDLE_CHALLENGE_ACTION"));
        this.setContentView((View)this.getViewBinding().getRoot());
        this.setSupportActionBar(this.getViewBinding().toolbar);
        this.customizeToolbar();
        String clientSecret = args2.getClientSecret();
        Intent intent = new Intent();
        PaymentAuthWebViewActivityViewModel paymentAuthWebViewActivityViewModel = this.viewModel;
        if (paymentAuthWebViewActivityViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        this.setResult(-1, intent.putExtras(paymentAuthWebViewActivityViewModel.getPaymentResult$stripe_release().toBundle()));
        if (StringsKt.isBlank((CharSequence)clientSecret)) {
            Logger logger2 = this.logger;
            if (logger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger2.debug("PaymentAuthWebViewActivity#onCreate() - clientSecret is blank");
            this.finish();
            return;
        }
        Logger logger3 = this.logger;
        if (logger3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger3.debug("PaymentAuthWebViewActivity#onCreate() - PaymentAuthWebView init and loadUrl");
        PaymentAuthWebView paymentAuthWebView = this.getViewBinding().webView;
        Activity activity = (Activity)this;
        Logger logger4 = this.logger;
        if (logger4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        ProgressBar progressBar2 = this.getViewBinding().progressBar;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar2, (String)"viewBinding.progressBar");
        paymentAuthWebView.init(activity, logger4, progressBar2, clientSecret, args2.getReturnUrl());
        this.getViewBinding().webView.loadUrl(args2.getUrl());
    }

    protected void onDestroy() {
        this.getViewBinding().webViewContainer.removeAllViews();
        this.getViewBinding().webView.destroy();
        super.onDestroy();
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
            Logger logger = this.logger;
            if (logger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger.debug("PaymentAuthWebViewActivity#onCreateOptionsMenu()");
            this.getMenuInflater().inflate(R.menu.payment_auth_web_view_menu, menu2);
            PaymentAuthWebViewActivityViewModel paymentAuthWebViewActivityViewModel = this.viewModel;
            if (paymentAuthWebViewActivityViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            }
            String string2 = paymentAuthWebViewActivityViewModel.getButtonText$stripe_release();
            if (string2 == null) break block3;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            Logger logger2 = this.logger;
            if (logger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger2.debug("PaymentAuthWebViewActivity#customizeToolbar() - updating close button text");
            MenuItem menuItem = menu2.findItem(R.id.action_close);
            Intrinsics.checkNotNullExpressionValue((Object)menuItem, (String)"menu.findItem(R.id.action_close)");
            menuItem.setTitle((CharSequence)it);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Logger logger = this.logger;
        if (logger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger.debug("PaymentAuthWebViewActivity#onOptionsItemSelected()");
        if (item.getItemId() == R.id.action_close) {
            this.cancelIntentSource();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        if (this.getViewBinding().webView.canGoBack()) {
            this.getViewBinding().webView.goBack();
        } else {
            this.cancelIntentSource();
        }
    }

    private final void cancelIntentSource() {
        PaymentAuthWebViewActivityViewModel paymentAuthWebViewActivityViewModel = this.viewModel;
        if (paymentAuthWebViewActivityViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        this.setResult(-1, paymentAuthWebViewActivityViewModel.getCancellationResult$stripe_release());
        this.finish();
    }

    private final void customizeToolbar() {
        block6: {
            boolean bl;
            boolean bl2;
            Object object;
            Logger logger = this.logger;
            if (logger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger.debug("PaymentAuthWebViewActivity#customizeToolbar()");
            PaymentAuthWebViewActivityViewModel paymentAuthWebViewActivityViewModel = this.viewModel;
            if (paymentAuthWebViewActivityViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            }
            PaymentAuthWebViewActivityViewModel.ToolbarTitleData toolbarTitleData = paymentAuthWebViewActivityViewModel.getToolbarTitle$stripe_release();
            if (toolbarTitleData != null) {
                object = toolbarTitleData;
                bl2 = false;
                bl = false;
                PaymentAuthWebViewActivityViewModel.ToolbarTitleData it = object;
                boolean bl3 = false;
                Logger logger2 = this.logger;
                if (logger2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                }
                logger2.debug("PaymentAuthWebViewActivity#customizeToolbar() - updating toolbar title");
                Toolbar toolbar = this.getViewBinding().toolbar;
                Intrinsics.checkNotNullExpressionValue((Object)toolbar, (String)"viewBinding.toolbar");
                toolbar.setTitle((CharSequence)CustomizeUtils.INSTANCE.buildStyledText((Context)this, it.getText$stripe_release(), (Customization)it.getToolbarCustomization$stripe_release()));
            }
            PaymentAuthWebViewActivityViewModel paymentAuthWebViewActivityViewModel2 = this.viewModel;
            if (paymentAuthWebViewActivityViewModel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            }
            String string2 = paymentAuthWebViewActivityViewModel2.getToolbarBackgroundColor$stripe_release();
            if (string2 == null) break block6;
            object = string2;
            bl2 = false;
            bl = false;
            Object backgroundColor = object;
            boolean bl4 = false;
            Logger logger3 = this.logger;
            if (logger3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger3.debug("PaymentAuthWebViewActivity#customizeToolbar() - updating toolbar background color");
            int backgroundColorInt = Color.parseColor((String)backgroundColor);
            this.getViewBinding().toolbar.setBackgroundColor(backgroundColorInt);
            CustomizeUtils.INSTANCE.setStatusBarColor((AppCompatActivity)this, backgroundColorInt);
        }
    }
}

