package com.stripe.android.model

fun evalationChange(char: Char) = when (char) {
    'D' -> -1
    'U' -> 1
    else -> throw IllegalArgumentException("Unrecognized character: $char")
}

data class HikeState(val elevation: Int, val valleysSeen: Int) {
    val isInValley = elevation < 0
}

// Complete the countingValleys function below.
fun countingValleys(n: Int, s: String): Int {
    val chars = s.toCharArray()
    val changes = chars.map(::evalationChange)
    println("changes: $changes")
    val result = changes
        .foldRight(HikeState(0, 0)) { delta: Int, prev: HikeState ->
            val updatedElevation = prev.elevation + delta
            println("prev: $prev")
            println("updated: $updatedElevation")
            if (prev.isInValley && updatedElevation >= 0) {
                HikeState(updatedElevation, prev.valleysSeen + 1)
            } else {
                prev.copy(elevation = updatedElevation)
            }
        }
    // check if final elevation is 0
    return result.valleysSeen
}

fun main() {
    println(countingValleys(8, "UDDDUDUU"))
}
