/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import com.stripe.android.R;
import com.stripe.android.databinding.ShippingMethodViewBinding;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentUtils;
import com.stripe.android.view.StripeColorUtils;
import java.util.Currency;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/view/ShippingMethodView;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "colorUtils", "Lcom/stripe/android/view/StripeColorUtils;", "selectedColorInt", "unselectedTextColorPrimaryInt", "unselectedTextColorSecondaryInt", "viewBinding", "Lcom/stripe/android/databinding/ShippingMethodViewBinding;", "setSelected", "", "selected", "", "setShippingMethod", "shippingMethod", "Lcom/stripe/android/model/ShippingMethod;", "stripe_release"})
public final class ShippingMethodView
extends RelativeLayout {
    private final StripeColorUtils colorUtils;
    @ColorInt
    private final int selectedColorInt;
    @ColorInt
    private final int unselectedTextColorSecondaryInt;
    @ColorInt
    private final int unselectedTextColorPrimaryInt;
    private final ShippingMethodViewBinding viewBinding;

    public void setSelected(boolean selected) {
        if (selected) {
            this.viewBinding.name.setTextColor(this.selectedColorInt);
            this.viewBinding.description.setTextColor(this.selectedColorInt);
            this.viewBinding.price.setTextColor(this.selectedColorInt);
            AppCompatImageView appCompatImageView = this.viewBinding.selectedIcon;
            Intrinsics.checkExpressionValueIsNotNull((Object)appCompatImageView, (String)"viewBinding.selectedIcon");
            appCompatImageView.setVisibility(0);
        } else {
            this.viewBinding.name.setTextColor(this.unselectedTextColorPrimaryInt);
            this.viewBinding.description.setTextColor(this.unselectedTextColorSecondaryInt);
            this.viewBinding.price.setTextColor(this.unselectedTextColorPrimaryInt);
            AppCompatImageView appCompatImageView = this.viewBinding.selectedIcon;
            Intrinsics.checkExpressionValueIsNotNull((Object)appCompatImageView, (String)"viewBinding.selectedIcon");
            appCompatImageView.setVisibility(4);
        }
    }

    public final void setShippingMethod(@NotNull ShippingMethod shippingMethod) {
        Intrinsics.checkParameterIsNotNull((Object)shippingMethod, (String)"shippingMethod");
        TextView textView = this.viewBinding.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"viewBinding.name");
        textView.setText((CharSequence)shippingMethod.getLabel());
        TextView textView2 = this.viewBinding.description;
        Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"viewBinding.description");
        textView2.setText((CharSequence)shippingMethod.getDetail());
        TextView textView3 = this.viewBinding.price;
        Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"viewBinding.price");
        long l = shippingMethod.getAmount();
        Currency currency = shippingMethod.getCurrency();
        String string2 = this.getContext().getString(R.string.price_free);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.string.price_free)");
        textView3.setText((CharSequence)PaymentUtils.formatPriceStringUsingFree(l, currency, string2));
    }

    @JvmOverloads
    public ShippingMethodView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.colorUtils = new StripeColorUtils(context);
        ShippingMethodViewBinding shippingMethodViewBinding = ShippingMethodViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)shippingMethodViewBinding, (String)"ShippingMethodViewBindin\u2026text),\n        this\n    )");
        this.viewBinding = shippingMethodViewBinding;
        int rawSelectedColorInt = this.colorUtils.getThemeAccentColor().data;
        int rawUnselectedTextColorPrimaryInt = this.colorUtils.getThemeTextColorPrimary().data;
        int rawUnselectedTextColorSecondaryInt = this.colorUtils.getThemeTextColorSecondary().data;
        this.selectedColorInt = StripeColorUtils.Companion.isColorTransparent(rawSelectedColorInt) ? ContextCompat.getColor((Context)context, (int)R.color.stripe_accent_color_default) : rawSelectedColorInt;
        this.unselectedTextColorPrimaryInt = StripeColorUtils.Companion.isColorTransparent(rawUnselectedTextColorPrimaryInt) ? ContextCompat.getColor((Context)context, (int)R.color.stripe_color_text_unselected_primary_default) : rawUnselectedTextColorPrimaryInt;
        this.unselectedTextColorSecondaryInt = StripeColorUtils.Companion.isColorTransparent(rawUnselectedTextColorSecondaryInt) ? ContextCompat.getColor((Context)context, (int)R.color.stripe_color_text_unselected_secondary_default) : rawUnselectedTextColorSecondaryInt;
    }

    public /* synthetic */ ShippingMethodView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ShippingMethodView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ShippingMethodView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

