/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.core.widget.ImageViewCompat;
import com.stripe.android.R;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.CardDisplayTextFactory;
import com.stripe.android.view.MaskedCardView$WhenMappings;
import com.stripe.android.view.ThemeConfig;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u001cH\u0002J\b\u0010%\u001a\u00020\u001cH\u0002J\b\u0010&\u001a\u00020\u001cH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\u00158G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/stripe/android/view/MaskedCardView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "brandImageView", "Landroid/widget/ImageView;", "<set-?>", "Lcom/stripe/android/model/CardBrand;", "cardBrand", "getCardBrand", "()Lcom/stripe/android/model/CardBrand;", "cardDisplayFactory", "Lcom/stripe/android/view/CardDisplayTextFactory;", "cardInformationTextView", "Landroid/widget/TextView;", "checkImageView", "", "last4", "getLast4", "()Ljava/lang/String;", "themeConfig", "Lcom/stripe/android/view/ThemeConfig;", "applyTint", "", "imageView", "setPaymentMethod", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "setSelected", "selected", "", "updateBrandIcon", "updateCheckMark", "updateUi", "stripe_release"})
public final class MaskedCardView
extends LinearLayout {
    @NotNull
    private CardBrand cardBrand;
    @Nullable
    private String last4;
    private final ImageView brandImageView;
    private final TextView cardInformationTextView;
    private final ImageView checkImageView;
    private final ThemeConfig themeConfig;
    private final CardDisplayTextFactory cardDisplayFactory;
    private HashMap _$_findViewCache;

    @NotNull
    public final CardBrand getCardBrand() {
        return this.cardBrand;
    }

    @VisibleForTesting
    @Nullable
    public final String getLast4() {
        return this.last4;
    }

    private final void applyTint(ImageView imageView) {
        ImageViewCompat.setImageTintList((ImageView)imageView, (ColorStateList)ColorStateList.valueOf((int)this.themeConfig.getTintColor$stripe_release(true)));
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.updateCheckMark();
        this.updateUi();
    }

    public final void setPaymentMethod(@NotNull PaymentMethod paymentMethod) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                MaskedCardView maskedCardView = this;
                object = paymentMethod.card;
                if (object == null) break block2;
                PaymentMethod.Card card = object;
                MaskedCardView maskedCardView2 = maskedCardView;
                boolean bl = false;
                boolean bl2 = false;
                PaymentMethod.Card it = card;
                boolean bl3 = false;
                CardBrand cardBrand = CardBrand.Companion.fromCode(it.brand);
                maskedCardView = maskedCardView2;
                object = cardBrand;
                if (object != null) break block3;
            }
            object = CardBrand.Unknown;
        }
        maskedCardView.cardBrand = object;
        PaymentMethod.Card card = paymentMethod.card;
        this.last4 = card != null ? card.last4 : null;
        this.updateUi();
    }

    private final void updateUi() {
        this.updateBrandIcon();
        this.cardInformationTextView.setText((CharSequence)this.cardDisplayFactory.createStyled$stripe_release(this.cardBrand, this.last4, this.isSelected()));
    }

    private final void updateBrandIcon() {
        int n;
        Context context = this.getContext();
        switch (MaskedCardView$WhenMappings.$EnumSwitchMapping$0[this.cardBrand.ordinal()]) {
            case 1: {
                n = R.drawable.stripe_ic_amex_template_32;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_discover_template_32;
                break;
            }
            case 3: {
                n = R.drawable.stripe_ic_jcb_template_32;
                break;
            }
            case 4: {
                n = R.drawable.stripe_ic_diners_template_32;
                break;
            }
            case 5: {
                n = R.drawable.stripe_ic_visa_template_32;
                break;
            }
            case 6: {
                n = R.drawable.stripe_ic_mastercard_template_32;
                break;
            }
            case 7: {
                n = R.drawable.stripe_ic_unionpay_template_32;
                break;
            }
            case 8: {
                n = R.drawable.stripe_ic_unknown;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.brandImageView.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)n));
    }

    private final void updateCheckMark() {
        this.checkImageView.setVisibility(this.isSelected() ? 0 : 4);
    }

    @JvmOverloads
    public MaskedCardView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.cardBrand = CardBrand.Unknown;
        this.themeConfig = new ThemeConfig(context);
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        this.cardDisplayFactory = new CardDisplayTextFactory(resources, this.themeConfig);
        View.inflate((Context)this.getContext(), (int)R.layout.masked_card_view, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.masked_icon_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.masked_icon_view)");
        this.brandImageView = (ImageView)view;
        View view2 = this.findViewById(R.id.masked_card_info_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.masked_card_info_view)");
        this.cardInformationTextView = (TextView)view2;
        View view3 = this.findViewById(R.id.check_icon);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.check_icon)");
        this.checkImageView = (ImageView)view3;
        this.applyTint(this.brandImageView);
        this.applyTint(this.checkImageView);
    }

    public /* synthetic */ MaskedCardView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public MaskedCardView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public MaskedCardView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

