/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.Size;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import androidx.fragment.app.Fragment;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.Logger;
import com.stripe.android.PaymentController;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.SetupIntentResult;
import com.stripe.android.StripeApiRepository;
import com.stripe.android.StripePaymentController;
import com.stripe.android.StripeRepository;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.AccountParams;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.BankAccountTokenParams;
import com.stripe.android.model.Card;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.CvcTokenParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.PersonTokenParams;
import com.stripe.android.model.PiiTokenParams;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.StripeFile;
import com.stripe.android.model.StripeFileParams;
import com.stripe.android.model.Token;
import com.stripe.android.model.TokenParams;
import com.stripe.android.view.AuthActivityStarter;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 f2\u00020\u0001:\u0006fghijkB-\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB1\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fB)\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fB5\b\u0000\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0016\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0007J\u001e\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0007J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0007J\u001e\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J*\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0007J\u001e\u0010/\u001a\u0004\u0018\u00010.2\u0006\u0010*\u001a\u00020+2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J*\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u0002022\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0007J*\u00100\u001a\u00020\u00142\u0006\u00103\u001a\u0002042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0007J\u001e\u00105\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u0002022\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J\u001e\u00105\u001a\u0004\u0018\u00010.2\u0006\u00103\u001a\u0002042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J*\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u0002082\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0007J\u001e\u00109\u001a\u0004\u0018\u00010.2\u0006\u00107\u001a\u0002082\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J,\u0010:\u001a\u00020\u00142\b\b\u0001\u0010;\u001a\u00020\u00052\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0007J\u001e\u0010<\u001a\u0004\u0018\u00010.2\u0006\u0010;\u001a\u00020\u00052\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J*\u0010=\u001a\u00020\u00142\u0006\u0010>\u001a\u00020?2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020@0-H\u0007J\u001c\u0010A\u001a\u00020@2\u0006\u0010>\u001a\u00020?2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J*\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020D2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020E0-H\u0007J\u001e\u0010F\u001a\u0004\u0018\u00010E2\u0006\u0010C\u001a\u00020D2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J*\u0010G\u001a\u00020\u00142\u0006\u0010H\u001a\u00020I2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0007J\u001e\u0010J\u001a\u0004\u0018\u00010.2\u0006\u0010H\u001a\u00020I2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J*\u0010K\u001a\u00020\u00142\u0006\u0010L\u001a\u00020\u00052\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0007J\u001e\u0010M\u001a\u0004\u0018\u00010.2\u0006\u0010L\u001a\u00020\u00052\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J*\u0010N\u001a\u00020\u00142\u0006\u0010O\u001a\u00020P2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0-H\u0007J\u001e\u0010Q\u001a\u0004\u0018\u00010\u001d2\u0006\u0010H\u001a\u00020P2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J*\u0010R\u001a\u00020\u00142\u0006\u00107\u001a\u0002082\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0007J*\u0010R\u001a\u00020\u00142\u0006\u0010S\u001a\u00020T2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002J\u0018\u0010U\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0018\u0010U\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0018\u0010V\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0018\u0010V\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0018\u0010W\u001a\u00020\b2\u0006\u0010X\u001a\u00020Y2\b\u0010Z\u001a\u0004\u0018\u00010[J\u001c\u0010\\\u001a\u00020\u00142\u0006\u0010Z\u001a\u00020[2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0-J(\u0010]\u001a\u00020\b2\u0006\u0010X\u001a\u00020Y2\b\u0010Z\u001a\u0004\u0018\u00010[2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020^0-H\u0007J(\u0010_\u001a\u00020\b2\u0006\u0010X\u001a\u00020Y2\b\u0010Z\u001a\u0004\u0018\u00010[2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020`0-H\u0007J\u0012\u0010a\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0012\u0010b\u001a\u0004\u0018\u00010(2\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J*\u0010c\u001a\u00020\u00142\b\b\u0001\u0010d\u001a\u00020\u00052\b\b\u0001\u0010\u0017\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0-H\u0007J\u001e\u0010e\u001a\u0004\u0018\u00010\u001d2\b\b\u0001\u0010d\u001a\u00020\u00052\b\b\u0001\u0010\u0017\u001a\u00020\u0005H\u0007R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006l"}, d2={"Lcom/stripe/android/Stripe;", "", "context", "Landroid/content/Context;", "publishableKey", "", "stripeAccountId", "enableLogging", "", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Z)V", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "(Landroid/content/Context;Lcom/stripe/android/StripeRepository;Ljava/lang/String;Ljava/lang/String;Z)V", "paymentController", "Lcom/stripe/android/PaymentController;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/PaymentController;Ljava/lang/String;Ljava/lang/String;)V", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/PaymentController;Ljava/lang/String;Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;)V", "authenticatePayment", "", "activity", "Landroid/app/Activity;", "clientSecret", "fragment", "Landroidx/fragment/app/Fragment;", "authenticateSetup", "authenticateSource", "source", "Lcom/stripe/android/model/Source;", "confirmPayment", "confirmPaymentIntentParams", "Lcom/stripe/android/model/ConfirmPaymentIntentParams;", "confirmPaymentIntentSynchronous", "Lcom/stripe/android/model/PaymentIntent;", "idempotencyKey", "confirmSetupIntent", "confirmSetupIntentParams", "Lcom/stripe/android/model/ConfirmSetupIntentParams;", "confirmSetupIntentSynchronous", "Lcom/stripe/android/model/SetupIntent;", "createAccountToken", "accountParams", "Lcom/stripe/android/model/AccountParams;", "callback", "Lcom/stripe/android/ApiResultCallback;", "Lcom/stripe/android/model/Token;", "createAccountTokenSynchronous", "createBankAccountToken", "bankAccount", "Lcom/stripe/android/model/BankAccount;", "bankAccountTokenParams", "Lcom/stripe/android/model/BankAccountTokenParams;", "createBankAccountTokenSynchronous", "createCardToken", "card", "Lcom/stripe/android/model/Card;", "createCardTokenSynchronous", "createCvcUpdateToken", "cvc", "createCvcUpdateTokenSynchronous", "createFile", "fileParams", "Lcom/stripe/android/model/StripeFileParams;", "Lcom/stripe/android/model/StripeFile;", "createFileSynchronous", "createPaymentMethod", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "Lcom/stripe/android/model/PaymentMethod;", "createPaymentMethodSynchronous", "createPersonToken", "params", "Lcom/stripe/android/model/PersonTokenParams;", "createPersonTokenSynchronous", "createPiiToken", "personalId", "createPiiTokenSynchronous", "createSource", "sourceParams", "Lcom/stripe/android/model/SourceParams;", "createSourceSynchronous", "createToken", "tokenParams", "Lcom/stripe/android/model/TokenParams;", "handleNextActionForPayment", "handleNextActionForSetupIntent", "isAuthenticateSourceResult", "requestCode", "", "data", "Landroid/content/Intent;", "onAuthenticateSourceResult", "onPaymentResult", "Lcom/stripe/android/PaymentIntentResult;", "onSetupResult", "Lcom/stripe/android/SetupIntentResult;", "retrievePaymentIntentSynchronous", "retrieveSetupIntentSynchronous", "retrieveSource", "sourceId", "retrieveSourceSynchronous", "Companion", "CreateFileTask", "CreatePaymentMethodTask", "CreateSourceTask", "CreateTokenTask", "RetrieveSourceTask", "stripe_release"})
public final class Stripe {
    private final String publishableKey;
    private final StripeRepository stripeRepository;
    private final PaymentController paymentController;
    private final String stripeAccountId;
    private final CoroutineScope workScope;
    @JvmField
    @NotNull
    public static final String API_VERSION;
    @NotNull
    public static final String VERSION = "AndroidBindings/14.0.0";
    @Nullable
    private static AppInfo appInfo;
    public static final Companion Companion;

    @UiThread
    public final void confirmPayment(@NotNull Activity activity, @NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        this.paymentController.startConfirmAndAuth(AuthActivityStarter.Host.Companion.create$stripe_release(activity), confirmPaymentIntentParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void confirmPayment(@NotNull Fragment fragment, @NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        this.paymentController.startConfirmAndAuth(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), confirmPaymentIntentParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @Deprecated(message="Rename to better reflect behavior and match iOS naming.", replaceWith=@ReplaceWith(imports={}, expression="handleNextActionForPayment(activity, clientSecret)"))
    @UiThread
    public final void authenticatePayment(@NotNull Activity activity, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(activity), new PaymentIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void handleNextActionForPayment(@NotNull Activity activity, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(activity), new PaymentIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @Deprecated(message="Rename to better reflect behavior and match iOS naming.", replaceWith=@ReplaceWith(imports={}, expression="handleNextActionForPayment(fragment, clientSecret)"))
    @UiThread
    public final void authenticatePayment(@NotNull Fragment fragment, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), new PaymentIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void handleNextActionForPayment(@NotNull Fragment fragment, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), new PaymentIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final boolean onPaymentResult(int requestCode, @Nullable Intent data, @NotNull ApiResultCallback<PaymentIntentResult> callback) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (data != null && this.paymentController.shouldHandlePaymentResult(requestCode, data)) {
            this.paymentController.handlePaymentResult(data, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null), callback);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @WorkerThread
    @Nullable
    public final PaymentIntent retrievePaymentIntentSynchronous(@NotNull String clientSecret) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        return this.stripeRepository.retrievePaymentIntent(new PaymentIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @Deprecated(message="use {@link #confirmPayment(Activity, ConfirmPaymentIntentParams)}")
    @WorkerThread
    @JvmOverloads
    @Nullable
    public final PaymentIntent confirmPaymentIntentSynchronous(@NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        return this.stripeRepository.confirmPaymentIntent(confirmPaymentIntentParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey));
    }

    public static /* synthetic */ PaymentIntent confirmPaymentIntentSynchronous$default(Stripe stripe2, ConfirmPaymentIntentParams confirmPaymentIntentParams, String string, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.confirmPaymentIntentSynchronous(confirmPaymentIntentParams, string);
    }

    @Deprecated(message="use {@link #confirmPayment(Activity, ConfirmPaymentIntentParams)}")
    @WorkerThread
    @JvmOverloads
    @Nullable
    public final PaymentIntent confirmPaymentIntentSynchronous(@NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Stripe.confirmPaymentIntentSynchronous$default(this, confirmPaymentIntentParams, null, 2, null);
    }

    @UiThread
    public final void confirmSetupIntent(@NotNull Activity activity, @NotNull ConfirmSetupIntentParams confirmSetupIntentParams) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)confirmSetupIntentParams, (String)"confirmSetupIntentParams");
        this.paymentController.startConfirmAndAuth(AuthActivityStarter.Host.Companion.create$stripe_release(activity), confirmSetupIntentParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void confirmSetupIntent(@NotNull Fragment fragment, @NotNull ConfirmSetupIntentParams confirmSetupIntentParams) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)confirmSetupIntentParams, (String)"confirmSetupIntentParams");
        this.paymentController.startConfirmAndAuth(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), confirmSetupIntentParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @Deprecated(message="Rename to better reflect behavior and match iOS naming.", replaceWith=@ReplaceWith(imports={}, expression="handleNextActionForSetupIntent(activity, clientSecret)"))
    @UiThread
    public final void authenticateSetup(@NotNull Activity activity, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(activity), new SetupIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void handleNextActionForSetupIntent(@NotNull Activity activity, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(activity), new SetupIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @Deprecated(message="Rename to better reflect behavior and match iOS naming.", replaceWith=@ReplaceWith(imports={}, expression="handleNextActionForSetupIntent(fragment, clientSecret)"))
    @UiThread
    public final void authenticateSetup(@NotNull Fragment fragment, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), new SetupIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void handleNextActionForSetupIntent(@NotNull Fragment fragment, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), new SetupIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final boolean onSetupResult(int requestCode, @Nullable Intent data, @NotNull ApiResultCallback<SetupIntentResult> callback) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (data != null && this.paymentController.shouldHandleSetupResult(requestCode, data)) {
            this.paymentController.handleSetupResult(data, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null), callback);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @WorkerThread
    @Nullable
    public final SetupIntent retrieveSetupIntentSynchronous(@NotNull String clientSecret) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        return this.stripeRepository.retrieveSetupIntent(new SetupIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @Deprecated(message="use {@link #confirmSetupIntent(Activity, ConfirmSetupIntentParams)}")
    @WorkerThread
    @JvmOverloads
    @Nullable
    public final SetupIntent confirmSetupIntentSynchronous(@NotNull ConfirmSetupIntentParams confirmSetupIntentParams, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)confirmSetupIntentParams, (String)"confirmSetupIntentParams");
        return this.stripeRepository.confirmSetupIntent(confirmSetupIntentParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey));
    }

    public static /* synthetic */ SetupIntent confirmSetupIntentSynchronous$default(Stripe stripe2, ConfirmSetupIntentParams confirmSetupIntentParams, String string, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.confirmSetupIntentSynchronous(confirmSetupIntentParams, string);
    }

    @Deprecated(message="use {@link #confirmSetupIntent(Activity, ConfirmSetupIntentParams)}")
    @WorkerThread
    @JvmOverloads
    @Nullable
    public final SetupIntent confirmSetupIntentSynchronous(@NotNull ConfirmSetupIntentParams confirmSetupIntentParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Stripe.confirmSetupIntentSynchronous$default(this, confirmSetupIntentParams, null, 2, null);
    }

    @UiThread
    @JvmOverloads
    public final void createPaymentMethod(@NotNull PaymentMethodCreateParams paymentMethodCreateParams, @Nullable String idempotencyKey, @NotNull ApiResultCallback<PaymentMethod> callback) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodCreateParams, (String)"paymentMethodCreateParams");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new CreatePaymentMethodTask(this.stripeRepository, paymentMethodCreateParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey), this.workScope, callback).execute$stripe_release();
    }

    public static /* synthetic */ void createPaymentMethod$default(Stripe stripe2, PaymentMethodCreateParams paymentMethodCreateParams, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createPaymentMethod(paymentMethodCreateParams, string, apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createPaymentMethod(@NotNull PaymentMethodCreateParams paymentMethodCreateParams, @NotNull ApiResultCallback<PaymentMethod> callback) {
        Stripe.createPaymentMethod$default(this, paymentMethodCreateParams, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final PaymentMethod createPaymentMethodSynchronous(@NotNull PaymentMethodCreateParams paymentMethodCreateParams, @Nullable String idempotencyKey) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodCreateParams, (String)"paymentMethodCreateParams");
        return this.stripeRepository.createPaymentMethod(paymentMethodCreateParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey));
    }

    public static /* synthetic */ PaymentMethod createPaymentMethodSynchronous$default(Stripe stripe2, PaymentMethodCreateParams paymentMethodCreateParams, String string, int n, Object object) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.createPaymentMethodSynchronous(paymentMethodCreateParams, string);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final PaymentMethod createPaymentMethodSynchronous(@NotNull PaymentMethodCreateParams paymentMethodCreateParams) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        return Stripe.createPaymentMethodSynchronous$default(this, paymentMethodCreateParams, null, 2, null);
    }

    public final void authenticateSource(@NotNull Activity activity, @NotNull Source source) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.paymentController.startAuthenticateSource(AuthActivityStarter.Host.Companion.create$stripe_release(activity), source, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    public final void authenticateSource(@NotNull Fragment fragment, @NotNull Source source) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.paymentController.startAuthenticateSource(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), source, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    public final boolean isAuthenticateSourceResult(int requestCode, @Nullable Intent data) {
        return data != null && this.paymentController.shouldHandleSourceResult(requestCode, data);
    }

    public final void onAuthenticateSourceResult(@NotNull Intent data, @NotNull ApiResultCallback<Source> callback) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.paymentController.handleSourceResult(data, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null), callback);
    }

    @UiThread
    @JvmOverloads
    public final void createSource(@NotNull SourceParams sourceParams, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Source> callback) {
        Intrinsics.checkParameterIsNotNull((Object)sourceParams, (String)"sourceParams");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new CreateSourceTask(this.stripeRepository, sourceParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey), this.workScope, callback).execute$stripe_release();
    }

    public static /* synthetic */ void createSource$default(Stripe stripe2, SourceParams sourceParams, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createSource(sourceParams, string, apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createSource(@NotNull SourceParams sourceParams, @NotNull ApiResultCallback<Source> callback) {
        Stripe.createSource$default(this, sourceParams, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Source createSourceSynchronous(@NotNull SourceParams params, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        return this.stripeRepository.createSource(params, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey));
    }

    public static /* synthetic */ Source createSourceSynchronous$default(Stripe stripe2, SourceParams sourceParams, String string, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.createSourceSynchronous(sourceParams, string);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Source createSourceSynchronous(@NotNull SourceParams params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Stripe.createSourceSynchronous$default(this, params, null, 2, null);
    }

    @UiThread
    public final void retrieveSource(@Size(min=1L) @NotNull String sourceId, @Size(min=1L) @NotNull String clientSecret, @NotNull ApiResultCallback<Source> callback) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new RetrieveSourceTask(this.stripeRepository, sourceId, clientSecret, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null), this.workScope, callback).execute$stripe_release();
    }

    @WorkerThread
    @Nullable
    public final Source retrieveSourceSynchronous(@Size(min=1L) @NotNull String sourceId, @Size(min=1L) @NotNull String clientSecret) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        return this.stripeRepository.retrieveSource(sourceId, clientSecret, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    @JvmOverloads
    public final void createAccountToken(@NotNull AccountParams accountParams, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)accountParams, (String)"accountParams");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createToken(accountParams, idempotencyKey, callback);
    }

    public static /* synthetic */ void createAccountToken$default(Stripe stripe2, AccountParams accountParams, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createAccountToken(accountParams, string, apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createAccountToken(@NotNull AccountParams accountParams, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createAccountToken$default(this, accountParams, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createAccountTokenSynchronous(@NotNull AccountParams accountParams, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Token token;
        Intrinsics.checkParameterIsNotNull((Object)accountParams, (String)"accountParams");
        try {
            token = this.stripeRepository.createToken(accountParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey));
        }
        catch (CardException exception) {
            token = null;
        }
        return token;
    }

    public static /* synthetic */ Token createAccountTokenSynchronous$default(Stripe stripe2, AccountParams accountParams, String string, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.createAccountTokenSynchronous(accountParams, string);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createAccountTokenSynchronous(@NotNull AccountParams accountParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Stripe.createAccountTokenSynchronous$default(this, accountParams, null, 2, null);
    }

    @UiThread
    @JvmOverloads
    public final void createBankAccountToken(@NotNull BankAccountTokenParams bankAccountTokenParams, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)bankAccountTokenParams, (String)"bankAccountTokenParams");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createToken(bankAccountTokenParams, idempotencyKey, callback);
    }

    public static /* synthetic */ void createBankAccountToken$default(Stripe stripe2, BankAccountTokenParams bankAccountTokenParams, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createBankAccountToken(bankAccountTokenParams, string, (ApiResultCallback<Token>)apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createBankAccountToken(@NotNull BankAccountTokenParams bankAccountTokenParams, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createBankAccountToken$default(this, bankAccountTokenParams, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createBankAccountTokenSynchronous(@NotNull BankAccountTokenParams bankAccountTokenParams, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)bankAccountTokenParams, (String)"bankAccountTokenParams");
        return this.stripeRepository.createToken(bankAccountTokenParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey));
    }

    public static /* synthetic */ Token createBankAccountTokenSynchronous$default(Stripe stripe2, BankAccountTokenParams bankAccountTokenParams, String string, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.createBankAccountTokenSynchronous(bankAccountTokenParams, string);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createBankAccountTokenSynchronous(@NotNull BankAccountTokenParams bankAccountTokenParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Stripe.createBankAccountTokenSynchronous$default(this, bankAccountTokenParams, null, 2, null);
    }

    @Deprecated(message="Use BankAccountTokenParams")
    @UiThread
    @JvmOverloads
    public final void createBankAccountToken(@NotNull BankAccount bankAccount, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)bankAccount, (String)"bankAccount");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createToken(bankAccount, idempotencyKey, callback);
    }

    public static /* synthetic */ void createBankAccountToken$default(Stripe stripe2, BankAccount bankAccount, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createBankAccountToken(bankAccount, string, (ApiResultCallback<Token>)apiResultCallback);
    }

    @Deprecated(message="Use BankAccountTokenParams")
    @UiThread
    @JvmOverloads
    public final void createBankAccountToken(@NotNull BankAccount bankAccount, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createBankAccountToken$default(this, bankAccount, null, callback, 2, null);
    }

    @Deprecated(message="Use BankAccountTokenParams")
    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createBankAccountTokenSynchronous(@NotNull BankAccount bankAccount, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)bankAccount, (String)"bankAccount");
        return this.stripeRepository.createToken(bankAccount, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey));
    }

    public static /* synthetic */ Token createBankAccountTokenSynchronous$default(Stripe stripe2, BankAccount bankAccount, String string, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.createBankAccountTokenSynchronous(bankAccount, string);
    }

    @Deprecated(message="Use BankAccountTokenParams")
    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createBankAccountTokenSynchronous(@NotNull BankAccount bankAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Stripe.createBankAccountTokenSynchronous$default(this, bankAccount, null, 2, null);
    }

    @UiThread
    @JvmOverloads
    public final void createPiiToken(@NotNull String personalId, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)personalId, (String)"personalId");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createToken(new PiiTokenParams(personalId), idempotencyKey, callback);
    }

    public static /* synthetic */ void createPiiToken$default(Stripe stripe2, String string, String string2, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        stripe2.createPiiToken(string, string2, apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createPiiToken(@NotNull String personalId, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createPiiToken$default(this, personalId, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createPiiTokenSynchronous(@NotNull String personalId, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)personalId, (String)"personalId");
        return this.stripeRepository.createToken(new PiiTokenParams(personalId), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey));
    }

    public static /* synthetic */ Token createPiiTokenSynchronous$default(Stripe stripe2, String string, String string2, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return stripe2.createPiiTokenSynchronous(string, string2);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createPiiTokenSynchronous(@NotNull String personalId) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Stripe.createPiiTokenSynchronous$default(this, personalId, null, 2, null);
    }

    @Deprecated(message="Deprecated, replace with Stripe#createCardToken()", replaceWith=@ReplaceWith(imports={}, expression="createCardToken(card, idempotencyKey, callback)"))
    @UiThread
    @JvmOverloads
    public final void createToken(@NotNull Card card, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createCardToken(card, idempotencyKey, callback);
    }

    public static /* synthetic */ void createToken$default(Stripe stripe2, Card card, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createToken(card, string, (ApiResultCallback<Token>)apiResultCallback);
    }

    @Deprecated(message="Deprecated, replace with Stripe#createCardToken()", replaceWith=@ReplaceWith(imports={}, expression="createCardToken(card, idempotencyKey, callback)"))
    @UiThread
    @JvmOverloads
    public final void createToken(@NotNull Card card, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createToken$default(this, card, null, callback, 2, null);
    }

    @UiThread
    @JvmOverloads
    public final void createCardToken(@NotNull Card card, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createToken((TokenParams)card, idempotencyKey, callback);
    }

    public static /* synthetic */ void createCardToken$default(Stripe stripe2, Card card, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createCardToken(card, string, apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createCardToken(@NotNull Card card, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createCardToken$default(this, card, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createCardTokenSynchronous(@NotNull Card card, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        return this.stripeRepository.createToken(card, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey));
    }

    public static /* synthetic */ Token createCardTokenSynchronous$default(Stripe stripe2, Card card, String string, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.createCardTokenSynchronous(card, string);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createCardTokenSynchronous(@NotNull Card card) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Stripe.createCardTokenSynchronous$default(this, card, null, 2, null);
    }

    @UiThread
    @JvmOverloads
    public final void createCvcUpdateToken(@Size(min=3L, max=4L) @NotNull String cvc, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)cvc, (String)"cvc");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createToken(new CvcTokenParams(cvc), idempotencyKey, callback);
    }

    public static /* synthetic */ void createCvcUpdateToken$default(Stripe stripe2, String string, String string2, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        stripe2.createCvcUpdateToken(string, string2, apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createCvcUpdateToken(@Size(min=3L, max=4L) @NotNull String cvc, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createCvcUpdateToken$default(this, cvc, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createCvcUpdateTokenSynchronous(@NotNull String cvc, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)cvc, (String)"cvc");
        return this.stripeRepository.createToken(new CvcTokenParams(cvc), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey));
    }

    public static /* synthetic */ Token createCvcUpdateTokenSynchronous$default(Stripe stripe2, String string, String string2, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return stripe2.createCvcUpdateTokenSynchronous(string, string2);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createCvcUpdateTokenSynchronous(@NotNull String cvc) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Stripe.createCvcUpdateTokenSynchronous$default(this, cvc, null, 2, null);
    }

    @UiThread
    @JvmOverloads
    public final void createPersonToken(@NotNull PersonTokenParams params, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createToken(params, idempotencyKey, callback);
    }

    public static /* synthetic */ void createPersonToken$default(Stripe stripe2, PersonTokenParams personTokenParams, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createPersonToken(personTokenParams, string, apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createPersonToken(@NotNull PersonTokenParams params, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createPersonToken$default(this, params, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createPersonTokenSynchronous(@NotNull PersonTokenParams params, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        return this.stripeRepository.createToken(params, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey));
    }

    public static /* synthetic */ Token createPersonTokenSynchronous$default(Stripe stripe2, PersonTokenParams personTokenParams, String string, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.createPersonTokenSynchronous(personTokenParams, string);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createPersonTokenSynchronous(@NotNull PersonTokenParams params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Stripe.createPersonTokenSynchronous$default(this, params, null, 2, null);
    }

    private final void createToken(TokenParams tokenParams, String idempotencyKey, ApiResultCallback<Token> callback) {
        new CreateTokenTask(this.stripeRepository, tokenParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey), this.workScope, callback).execute$stripe_release();
    }

    static /* synthetic */ void createToken$default(Stripe stripe2, TokenParams tokenParams, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createToken(tokenParams, string, (ApiResultCallback<Token>)apiResultCallback);
    }

    @JvmOverloads
    public final void createFile(@NotNull StripeFileParams fileParams, @Nullable String idempotencyKey, @NotNull ApiResultCallback<StripeFile> callback) {
        Intrinsics.checkParameterIsNotNull((Object)fileParams, (String)"fileParams");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new CreateFileTask(this.stripeRepository, fileParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey), this.workScope, callback).execute$stripe_release();
    }

    public static /* synthetic */ void createFile$default(Stripe stripe2, StripeFileParams stripeFileParams, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createFile(stripeFileParams, string, apiResultCallback);
    }

    @JvmOverloads
    public final void createFile(@NotNull StripeFileParams fileParams, @NotNull ApiResultCallback<StripeFile> callback) {
        Stripe.createFile$default(this, fileParams, null, callback, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final StripeFile createFileSynchronous(@NotNull StripeFileParams fileParams, @Nullable String idempotencyKey) {
        Intrinsics.checkParameterIsNotNull((Object)fileParams, (String)"fileParams");
        return this.stripeRepository.createFile(fileParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey));
    }

    public static /* synthetic */ StripeFile createFileSynchronous$default(Stripe stripe2, StripeFileParams stripeFileParams, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.createFileSynchronous(stripeFileParams, string);
    }

    @JvmOverloads
    @NotNull
    public final StripeFile createFileSynchronous(@NotNull StripeFileParams fileParams) {
        return Stripe.createFileSynchronous$default(this, fileParams, null, 2, null);
    }

    public Stripe(@NotNull StripeRepository stripeRepository, @NotNull PaymentController paymentController, @NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull CoroutineScope workScope) {
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)paymentController, (String)"paymentController");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
        this.stripeRepository = stripeRepository;
        this.paymentController = paymentController;
        this.stripeAccountId = stripeAccountId;
        this.workScope = workScope;
        this.publishableKey = new ApiKeyValidator().requireValid(publishableKey);
    }

    public /* synthetic */ Stripe(StripeRepository stripeRepository, PaymentController paymentController, String string, String string2, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        }
        this(stripeRepository, paymentController, string, string2, coroutineScope);
    }

    @JvmOverloads
    public Stripe(@NotNull Context context, @NotNull String publishableKey, @Nullable String stripeAccountId, boolean enableLogging) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        Context context3 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context.applicationContext");
        this(context2, new StripeApiRepository(context3, appInfo, Logger.Companion.getInstance$stripe_release(enableLogging), null, null, null, null, null, null, null, null, 2040, null), ApiKeyValidator.Companion.get$stripe_release().requireValid(publishableKey), stripeAccountId, enableLogging);
    }

    public /* synthetic */ Stripe(Context context, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(context, string, string2, bl);
    }

    @JvmOverloads
    public Stripe(@NotNull Context context, @NotNull String publishableKey, @Nullable String stripeAccountId) {
        this(context, publishableKey, stripeAccountId, false, 8, null);
    }

    @JvmOverloads
    public Stripe(@NotNull Context context, @NotNull String publishableKey) {
        this(context, publishableKey, null, false, 12, null);
    }

    private Stripe(Context context, StripeRepository stripeRepository, String publishableKey, String stripeAccountId, boolean enableLogging) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        this(stripeRepository, StripePaymentController.Companion.create(context2, stripeRepository, enableLogging), publishableKey, stripeAccountId);
    }

    public Stripe(@NotNull StripeRepository stripeRepository, @NotNull PaymentController paymentController, @NotNull String publishableKey, @Nullable String stripeAccountId) {
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)paymentController, (String)"paymentController");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        this(stripeRepository, paymentController, publishableKey, stripeAccountId, CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())));
    }

    static {
        Companion = new Companion(null);
        API_VERSION = ApiVersion.Companion.get$stripe_release().getCode$stripe_release();
    }

    @Nullable
    public static final AppInfo getAppInfo() {
        Companion companion = Companion;
        return appInfo;
    }

    public static final void setAppInfo(@Nullable AppInfo appInfo) {
        Companion companion = Companion;
        Stripe.appInfo = appInfo;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/Stripe$CreateSourceTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Source;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "sourceParams", "Lcom/stripe/android/model/SourceParams;", "options", "Lcom/stripe/android/ApiRequest$Options;", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/SourceParams;Lcom/stripe/android/ApiRequest$Options;Lkotlinx/coroutines/CoroutineScope;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class CreateSourceTask
    extends ApiOperation<Source> {
        private final StripeRepository stripeRepository;
        private final SourceParams sourceParams;
        private final ApiRequest.Options options;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super Source> $completion) throws StripeException {
            return this.stripeRepository.createSource(this.sourceParams, this.options);
        }

        public CreateSourceTask(@NotNull StripeRepository stripeRepository, @NotNull SourceParams sourceParams, @NotNull ApiRequest.Options options, @NotNull CoroutineScope workScope, @NotNull ApiResultCallback<Source> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)sourceParams, (String)"sourceParams");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(workScope, callback);
            this.stripeRepository = stripeRepository;
            this.sourceParams = sourceParams;
            this.options = options;
        }

        public /* synthetic */ CreateSourceTask(StripeRepository stripeRepository, SourceParams sourceParams, ApiRequest.Options options, CoroutineScope coroutineScope, ApiResultCallback apiResultCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
            }
            this(stripeRepository, sourceParams, options, coroutineScope, apiResultCallback);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B?\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/Stripe$RetrieveSourceTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Source;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "sourceId", "", "clientSecret", "options", "Lcom/stripe/android/ApiRequest$Options;", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lkotlinx/coroutines/CoroutineScope;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class RetrieveSourceTask
    extends ApiOperation<Source> {
        private final StripeRepository stripeRepository;
        private final String sourceId;
        private final String clientSecret;
        private final ApiRequest.Options options;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super Source> $completion) throws StripeException {
            return this.stripeRepository.retrieveSource(this.sourceId, this.clientSecret, this.options);
        }

        public RetrieveSourceTask(@NotNull StripeRepository stripeRepository, @NotNull String sourceId, @NotNull String clientSecret, @NotNull ApiRequest.Options options, @NotNull CoroutineScope workScope, @NotNull ApiResultCallback<Source> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(workScope, callback);
            this.stripeRepository = stripeRepository;
            this.sourceId = sourceId;
            this.clientSecret = clientSecret;
            this.options = options;
        }

        public /* synthetic */ RetrieveSourceTask(StripeRepository stripeRepository, String string, String string2, ApiRequest.Options options, CoroutineScope coroutineScope, ApiResultCallback apiResultCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
            }
            this(stripeRepository, string, string2, options, coroutineScope, apiResultCallback);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/Stripe$CreatePaymentMethodTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/PaymentMethod;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "options", "Lcom/stripe/android/ApiRequest$Options;", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/PaymentMethodCreateParams;Lcom/stripe/android/ApiRequest$Options;Lkotlinx/coroutines/CoroutineScope;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class CreatePaymentMethodTask
    extends ApiOperation<PaymentMethod> {
        private final StripeRepository stripeRepository;
        private final PaymentMethodCreateParams paymentMethodCreateParams;
        private final ApiRequest.Options options;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super PaymentMethod> $completion) throws StripeException {
            return this.stripeRepository.createPaymentMethod(this.paymentMethodCreateParams, this.options);
        }

        public CreatePaymentMethodTask(@NotNull StripeRepository stripeRepository, @NotNull PaymentMethodCreateParams paymentMethodCreateParams, @NotNull ApiRequest.Options options, @NotNull CoroutineScope workScope, @NotNull ApiResultCallback<PaymentMethod> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)paymentMethodCreateParams, (String)"paymentMethodCreateParams");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(workScope, callback);
            this.stripeRepository = stripeRepository;
            this.paymentMethodCreateParams = paymentMethodCreateParams;
            this.options = options;
        }

        public /* synthetic */ CreatePaymentMethodTask(StripeRepository stripeRepository, PaymentMethodCreateParams paymentMethodCreateParams, ApiRequest.Options options, CoroutineScope coroutineScope, ApiResultCallback apiResultCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
            }
            this(stripeRepository, paymentMethodCreateParams, options, coroutineScope, apiResultCallback);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/Stripe$CreateTokenTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Token;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "tokenParams", "Lcom/stripe/android/model/TokenParams;", "options", "Lcom/stripe/android/ApiRequest$Options;", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/TokenParams;Lcom/stripe/android/ApiRequest$Options;Lkotlinx/coroutines/CoroutineScope;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class CreateTokenTask
    extends ApiOperation<Token> {
        private final StripeRepository stripeRepository;
        private final TokenParams tokenParams;
        private final ApiRequest.Options options;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super Token> $completion) throws StripeException {
            return this.stripeRepository.createToken(this.tokenParams, this.options);
        }

        public CreateTokenTask(@NotNull StripeRepository stripeRepository, @NotNull TokenParams tokenParams, @NotNull ApiRequest.Options options, @NotNull CoroutineScope workScope, @NotNull ApiResultCallback<Token> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)tokenParams, (String)"tokenParams");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(workScope, callback);
            this.stripeRepository = stripeRepository;
            this.tokenParams = tokenParams;
            this.options = options;
        }

        public /* synthetic */ CreateTokenTask(StripeRepository stripeRepository, TokenParams tokenParams, ApiRequest.Options options, CoroutineScope coroutineScope, ApiResultCallback apiResultCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
            }
            this(stripeRepository, tokenParams, options, coroutineScope, apiResultCallback);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/Stripe$CreateFileTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/StripeFile;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "fileParams", "Lcom/stripe/android/model/StripeFileParams;", "options", "Lcom/stripe/android/ApiRequest$Options;", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/StripeFileParams;Lcom/stripe/android/ApiRequest$Options;Lkotlinx/coroutines/CoroutineScope;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class CreateFileTask
    extends ApiOperation<StripeFile> {
        private final StripeRepository stripeRepository;
        private final StripeFileParams fileParams;
        private final ApiRequest.Options options;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super StripeFile> $completion) throws StripeException {
            return this.stripeRepository.createFile(this.fileParams, this.options);
        }

        public CreateFileTask(@NotNull StripeRepository stripeRepository, @NotNull StripeFileParams fileParams, @NotNull ApiRequest.Options options, @NotNull CoroutineScope workScope, @NotNull ApiResultCallback<StripeFile> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)fileParams, (String)"fileParams");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(workScope, callback);
            this.stripeRepository = stripeRepository;
            this.fileParams = fileParams;
            this.options = options;
        }

        public /* synthetic */ CreateFileTask(StripeRepository stripeRepository, StripeFileParams stripeFileParams, ApiRequest.Options options, CoroutineScope coroutineScope, ApiResultCallback apiResultCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
            }
            this(stripeRepository, stripeFileParams, options, coroutineScope, apiResultCallback);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcom/stripe/android/Stripe$Companion;", "", "()V", "API_VERSION", "", "VERSION", "appInfo", "Lcom/stripe/android/AppInfo;", "appInfo$annotations", "getAppInfo", "()Lcom/stripe/android/AppInfo;", "setAppInfo", "(Lcom/stripe/android/AppInfo;)V", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void appInfo$annotations() {
        }

        @Nullable
        public final AppInfo getAppInfo() {
            return appInfo;
        }

        public final void setAppInfo(@Nullable AppInfo appInfo) {
            Stripe.appInfo = appInfo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

