/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.PaymentSessionData;
import com.stripe.android.R;
import com.stripe.android.StripeError;
import com.stripe.android.model.Customer;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentFlowActivityStarter;
import com.stripe.android.view.PaymentFlowPagerAdapter;
import com.stripe.android.view.PaymentFlowPagerEnum;
import com.stripe.android.view.SelectShippingMethodWidget;
import com.stripe.android.view.ShippingInfoWidget;
import com.stripe.android.view.StripeActivity;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 22\u00020\u0001:\u000223B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\u0012\u0010\u001b\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u0012H\u0014J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010 \u001a\u00020\u0012H\u0014J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001dH\u0014J\u0012\u0010#\u001a\u00020\u00122\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J3\u0010&\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\u000e\b\u0002\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b*J\b\u0010+\u001a\u00020\u0012H\u0002J(\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0(2\b\u0010)\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010/\u001a\u00020\u0012H\u0002J \u00100\u001a\u00020\u00122\f\u00101\u001a\b\u0012\u0004\u0012\u00020\b0(2\b\u0010)\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/stripe/android/view/PaymentFlowActivity;", "Lcom/stripe/android/view/StripeActivity;", "()V", "paymentFlowPagerAdapter", "Lcom/stripe/android/view/PaymentFlowPagerAdapter;", "paymentSessionData", "Lcom/stripe/android/PaymentSessionData;", "selectedShippingMethod", "Lcom/stripe/android/model/ShippingMethod;", "getSelectedShippingMethod", "()Lcom/stripe/android/model/ShippingMethod;", "shippingInfo", "Lcom/stripe/android/model/ShippingInformation;", "getShippingInfo", "()Lcom/stripe/android/model/ShippingInformation;", "shippingInfoSubmittedBroadcastReceiver", "Landroid/content/BroadcastReceiver;", "broadcastShippingInfoSubmitted", "", "shippingInformation", "finishWithData", "hasNextPage", "", "hasPreviousPage", "hideKeyboard", "onActionSave", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onPause", "onRestoreInstanceState", "onResume", "onSaveInstanceState", "outState", "onShippingInfoError", "errorMessage", "", "onShippingInfoSaved", "shippingMethods", "", "defaultShippingMethod", "onShippingInfoSaved$stripe_release", "onShippingInfoSubmitted", "onShippingInfoValidated", "customerSession", "Lcom/stripe/android/CustomerSession;", "onShippingMethodSave", "onShippingMethodsReady", "validShippingMethods", "Companion", "CustomerShippingInfoSavedListener", "stripe_release"})
public final class PaymentFlowActivity
extends StripeActivity {
    private BroadcastReceiver shippingInfoSubmittedBroadcastReceiver;
    private PaymentFlowPagerAdapter paymentFlowPagerAdapter;
    private PaymentSessionData paymentSessionData;
    @NotNull
    public static final String TOKEN_PAYMENT_FLOW_ACTIVITY = "PaymentFlowActivity";
    @NotNull
    public static final String TOKEN_SHIPPING_INFO_SCREEN = "ShippingInfoScreen";
    @NotNull
    public static final String TOKEN_SHIPPING_METHOD_SCREEN = "ShippingMethodScreen";
    private static final String STATE_PAYMENT_SESSION_DATA = "state_payment_session_data";
    private static final String STATE_SHIPPING_INFO = "state_shipping_info";
    private static final String STATE_SHIPPING_METHOD = "state_shipping_method";
    private static final String STATE_CURRENT_ITEM = "state_current_item";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        PaymentFlowActivityStarter.Args args = PaymentFlowActivityStarter.Args.Companion.create(intent);
        CustomerSession customerSession = CustomerSession.Companion.getInstance();
        customerSession.addProductUsageTokenIfValid$stripe_release("PaymentSession");
        customerSession.addProductUsageTokenIfValid$stripe_release(TOKEN_PAYMENT_FLOW_ACTIVITY);
        this.getViewStub().setLayoutResource(R.layout.activity_shipping_flow);
        this.getViewStub().inflate();
        PaymentFlowActivity paymentFlowActivity = this;
        Object object = savedInstanceState;
        if (object == null || (object = (PaymentSessionData)object.getParcelable(STATE_PAYMENT_SESSION_DATA)) == null) {
            PaymentSessionData paymentSessionData = args.getPaymentSessionData$stripe_release();
            PaymentFlowActivity paymentFlowActivity2 = paymentFlowActivity;
            boolean bl = false;
            boolean bl2 = false;
            if (paymentSessionData == null) {
                boolean bl3 = false;
                String string2 = "PaymentFlowActivity launched without PaymentSessionData";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            PaymentSessionData paymentSessionData2 = paymentSessionData;
            paymentFlowActivity = paymentFlowActivity2;
            object = paymentSessionData2;
        }
        paymentFlowActivity.paymentSessionData = object;
        PaymentSessionConfig paymentSessionConfig = args.getPaymentSessionConfig$stripe_release();
        Object object2 = savedInstanceState;
        if (object2 == null || (object2 = (ShippingInformation)object2.getParcelable(STATE_SHIPPING_INFO)) == null) {
            object2 = paymentSessionConfig.getPrepopulatedShippingInfo();
        }
        Object shippingInformation = object2;
        Bundle bundle = savedInstanceState;
        this.paymentFlowPagerAdapter = new PaymentFlowPagerAdapter((Context)this, paymentSessionConfig, customerSession, (ShippingInformation)shippingInformation, bundle != null ? (ShippingMethod)bundle.getParcelable(STATE_SHIPPING_METHOD) : null, paymentSessionConfig.getAllowedShippingCountryCodes());
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        PaymentFlowPagerAdapter paymentFlowPagerAdapter = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        viewPager.setAdapter((PagerAdapter)paymentFlowPagerAdapter);
        ((ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager)).addOnPageChangeListener(new ViewPager.OnPageChangeListener(this){
            final /* synthetic */ PaymentFlowActivity this$0;

            public void onPageScrolled(int i, float v, int i1) {
            }

            public void onPageSelected(int i) {
                this.this$0.setTitle(PaymentFlowActivity.access$getPaymentFlowPagerAdapter$p(this.this$0).getPageTitle(i));
                if (PaymentFlowActivity.access$getPaymentFlowPagerAdapter$p(this.this$0).getPageAt$stripe_release(i) == PaymentFlowPagerEnum.SHIPPING_INFO) {
                    PaymentFlowActivity.access$getPaymentFlowPagerAdapter$p(this.this$0).hideShippingPage();
                }
            }

            public void onPageScrollStateChanged(int i) {
            }
            {
                this.this$0 = $outer;
            }
        });
        this.shippingInfoSubmittedBroadcastReceiver = new BroadcastReceiver(this, customerSession){
            final /* synthetic */ PaymentFlowActivity this$0;
            final /* synthetic */ CustomerSession $customerSession;

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                boolean isShippingInfoValid = intent.getBooleanExtra("shipping_is_shipping_info_valid", false);
                if (isShippingInfoValid) {
                    List shippingMethods = intent.getParcelableArrayListExtra("valid_shipping_methods");
                    ShippingMethod defaultShippingMethod = (ShippingMethod)intent.getParcelableExtra("default_shipping_method");
                    List list = shippingMethods;
                    CustomerSession customerSession = this.$customerSession;
                    PaymentFlowActivity paymentFlowActivity = this.this$0;
                    boolean bl = false;
                    List list2 = list;
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    List list3 = list2;
                    PaymentFlowActivity.access$onShippingInfoValidated(paymentFlowActivity, customerSession, list3, defaultShippingMethod);
                } else {
                    String errorMessage = intent.getStringExtra("shipping_info_error");
                    PaymentFlowActivity.access$onShippingInfoError(this.this$0, errorMessage);
                }
            }
            {
                this.this$0 = $outer;
                this.$customerSession = $captured_local_variable$1;
            }
        };
        PaymentFlowPagerAdapter paymentFlowPagerAdapter2 = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        ViewPager viewPager2 = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager2, (String)"shipping_flow_viewpager");
        this.setTitle(paymentFlowPagerAdapter2.getPageTitle(viewPager2.getCurrentItem()));
    }

    protected void onRestoreInstanceState(@NotNull Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)savedInstanceState, (String)"savedInstanceState");
        super.onRestoreInstanceState(savedInstanceState);
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        viewPager.setCurrentItem(savedInstanceState.getInt(STATE_CURRENT_ITEM, 0));
    }

    @Override
    public void onActionSave() {
        PaymentFlowPagerAdapter paymentFlowPagerAdapter = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        if (PaymentFlowPagerEnum.SHIPPING_INFO == paymentFlowPagerAdapter.getPageAt$stripe_release(viewPager.getCurrentItem())) {
            this.onShippingInfoSubmitted();
        } else {
            this.onShippingMethodSave();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)((Context)this));
        BroadcastReceiver broadcastReceiver = this.shippingInfoSubmittedBroadcastReceiver;
        if (broadcastReceiver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shippingInfoSubmittedBroadcastReceiver");
        }
        localBroadcastManager.unregisterReceiver(broadcastReceiver);
    }

    @Override
    protected void onResume() {
        super.onResume();
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)((Context)this));
        BroadcastReceiver broadcastReceiver = this.shippingInfoSubmittedBroadcastReceiver;
        if (broadcastReceiver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shippingInfoSubmittedBroadcastReceiver");
        }
        localBroadcastManager.registerReceiver(broadcastReceiver, new IntentFilter("shipping_info_processed"));
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        PaymentSessionData paymentSessionData = this.paymentSessionData;
        if (paymentSessionData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentSessionData");
        }
        outState.putParcelable(STATE_PAYMENT_SESSION_DATA, (Parcelable)paymentSessionData);
        outState.putParcelable(STATE_SHIPPING_INFO, (Parcelable)this.getShippingInfo());
        outState.putParcelable(STATE_SHIPPING_METHOD, (Parcelable)this.getSelectedShippingMethod());
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        outState.putInt(STATE_CURRENT_ITEM, viewPager.getCurrentItem());
    }

    public final /* synthetic */ void onShippingInfoSaved$stripe_release(@Nullable ShippingInformation shippingInformation, @NotNull List<ShippingMethod> shippingMethods, @Nullable ShippingMethod defaultShippingMethod) {
        Intrinsics.checkParameterIsNotNull(shippingMethods, (String)"shippingMethods");
        this.onShippingMethodsReady(shippingMethods, defaultShippingMethod);
        PaymentSessionData paymentSessionData = this.paymentSessionData;
        if (paymentSessionData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentSessionData");
        }
        this.paymentSessionData = PaymentSessionData.copy$default(paymentSessionData, null, 0L, 0L, shippingInformation, null, null, 55, null);
    }

    public static /* synthetic */ void onShippingInfoSaved$stripe_release$default(PaymentFlowActivity paymentFlowActivity, ShippingInformation shippingInformation, List list, ShippingMethod shippingMethod, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            shippingMethod = null;
        }
        paymentFlowActivity.onShippingInfoSaved$stripe_release(shippingInformation, list, shippingMethod);
    }

    private final void onShippingInfoValidated(CustomerSession customerSession, List<ShippingMethod> shippingMethods, ShippingMethod defaultShippingMethod) {
        block1: {
            PaymentSessionData paymentSessionData = this.paymentSessionData;
            if (paymentSessionData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paymentSessionData");
            }
            ShippingInformation shippingInformation = paymentSessionData.getShippingInformation();
            if (shippingInformation == null) break block1;
            ShippingInformation shippingInformation2 = shippingInformation;
            boolean bl = false;
            boolean bl2 = false;
            ShippingInformation it = shippingInformation2;
            boolean bl3 = false;
            customerSession.setCustomerShippingInformation(it, new CustomerShippingInfoSavedListener(this, shippingMethods, defaultShippingMethod));
        }
    }

    private final void onShippingMethodsReady(List<ShippingMethod> validShippingMethods, ShippingMethod defaultShippingMethod) {
        this.setCommunicatingProgress(false);
        PaymentFlowPagerAdapter paymentFlowPagerAdapter = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        paymentFlowPagerAdapter.setShippingMethods(validShippingMethods, defaultShippingMethod);
        PaymentFlowPagerAdapter paymentFlowPagerAdapter2 = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        paymentFlowPagerAdapter2.setShippingInfoSaved(true);
        if (this.hasNextPage()) {
            ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
            Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
            ViewPager viewPager2 = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
            Intrinsics.checkExpressionValueIsNotNull((Object)viewPager2, (String)"shipping_flow_viewpager");
            viewPager.setCurrentItem(viewPager2.getCurrentItem() + 1);
        } else {
            PaymentSessionData paymentSessionData = this.paymentSessionData;
            if (paymentSessionData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paymentSessionData");
            }
            this.finishWithData(paymentSessionData);
        }
    }

    private final void onShippingInfoSubmitted() {
        block1: {
            this.hideKeyboard();
            ShippingInformation shippingInformation = this.getShippingInfo();
            if (shippingInformation == null) break block1;
            ShippingInformation shippingInformation2 = shippingInformation;
            boolean bl = false;
            boolean bl2 = false;
            ShippingInformation shippingInfo = shippingInformation2;
            boolean bl3 = false;
            PaymentSessionData paymentSessionData = this.paymentSessionData;
            if (paymentSessionData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paymentSessionData");
            }
            this.paymentSessionData = PaymentSessionData.copy$default(paymentSessionData, null, 0L, 0L, shippingInfo, null, null, 55, null);
            this.setCommunicatingProgress(true);
            this.broadcastShippingInfoSubmitted(shippingInfo);
        }
    }

    private final ShippingInformation getShippingInfo() {
        return ((ShippingInfoWidget)this._$_findCachedViewById(R.id.shipping_info_widget)).getShippingInformation();
    }

    private final ShippingMethod getSelectedShippingMethod() {
        ShippingMethod shippingMethod;
        PaymentFlowPagerAdapter paymentFlowPagerAdapter = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        if (PaymentFlowPagerEnum.SHIPPING_METHOD == paymentFlowPagerAdapter.getPageAt$stripe_release(viewPager.getCurrentItem())) {
            View view = this.findViewById(R.id.select_shipping_method_widget);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.select_shipping_method_widget)");
            SelectShippingMethodWidget selectShippingMethodWidget = (SelectShippingMethodWidget)view;
            shippingMethod = selectShippingMethodWidget.getSelectedShippingMethod();
        } else {
            shippingMethod = null;
        }
        return shippingMethod;
    }

    private final void hideKeyboard() {
        Object object = this.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        if (inputMethodManager.isAcceptingText()) {
            View view = this.getCurrentFocus();
            inputMethodManager.hideSoftInputFromWindow((IBinder)(view != null ? view.getWindowToken() : null), 0);
        }
    }

    private final void broadcastShippingInfoSubmitted(ShippingInformation shippingInformation) {
        LocalBroadcastManager.getInstance((Context)((Context)this)).sendBroadcast(new Intent("shipping_info_submitted").putExtra("shipping_info_data", (Parcelable)shippingInformation));
    }

    private final boolean hasNextPage() {
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        int n = viewPager.getCurrentItem() + 1;
        PaymentFlowPagerAdapter paymentFlowPagerAdapter = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        return n < paymentFlowPagerAdapter.getCount();
    }

    private final boolean hasPreviousPage() {
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        int currentPageIndex = viewPager.getCurrentItem();
        return currentPageIndex != 0;
    }

    private final void onShippingMethodSave() {
        View view = this.findViewById(R.id.select_shipping_method_widget);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.select_shipping_method_widget)");
        SelectShippingMethodWidget selectShippingMethodWidget = (SelectShippingMethodWidget)view;
        PaymentSessionData paymentSessionData = this.paymentSessionData;
        if (paymentSessionData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentSessionData");
        }
        this.finishWithData(PaymentSessionData.copy$default(paymentSessionData, null, 0L, 0L, null, selectShippingMethodWidget.getSelectedShippingMethod(), null, 47, null));
        this.finish();
    }

    private final void onShippingInfoError(String errorMessage) {
        this.setCommunicatingProgress(false);
        CharSequence charSequence = errorMessage;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.showError(errorMessage);
        } else {
            String string2 = this.getString(R.string.invalid_shipping_information);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(R.string.invalid_shipping_information)");
            this.showError(string2);
        }
        PaymentSessionData paymentSessionData = this.paymentSessionData;
        if (paymentSessionData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentSessionData");
        }
        this.paymentSessionData = PaymentSessionData.copy$default(paymentSessionData, null, 0L, 0L, null, null, null, 55, null);
    }

    private final void finishWithData(PaymentSessionData paymentSessionData) {
        this.setResult(-1, new Intent().putExtra("extra_payment_session_data", (Parcelable)paymentSessionData));
        this.finish();
    }

    public void onBackPressed() {
        if (this.hasPreviousPage()) {
            ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
            Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
            ViewPager viewPager2 = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
            Intrinsics.checkExpressionValueIsNotNull((Object)viewPager2, (String)"shipping_flow_viewpager");
            viewPager.setCurrentItem(viewPager2.getCurrentItem() - 1);
        } else {
            super.onBackPressed();
        }
    }

    public static final /* synthetic */ PaymentFlowPagerAdapter access$getPaymentFlowPagerAdapter$p(PaymentFlowActivity $this) {
        PaymentFlowPagerAdapter paymentFlowPagerAdapter = $this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        return paymentFlowPagerAdapter;
    }

    public static final /* synthetic */ void access$setPaymentFlowPagerAdapter$p(PaymentFlowActivity $this, PaymentFlowPagerAdapter paymentFlowPagerAdapter) {
        $this.paymentFlowPagerAdapter = paymentFlowPagerAdapter;
    }

    public static final /* synthetic */ void access$onShippingInfoValidated(PaymentFlowActivity $this, CustomerSession customerSession, List shippingMethods, ShippingMethod defaultShippingMethod) {
        $this.onShippingInfoValidated(customerSession, shippingMethods, defaultShippingMethod);
    }

    public static final /* synthetic */ void access$onShippingInfoError(PaymentFlowActivity $this, String errorMessage) {
        $this.onShippingInfoError(errorMessage);
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/view/PaymentFlowActivity$CustomerShippingInfoSavedListener;", "Lcom/stripe/android/CustomerSession$CustomerRetrievalListener;", "activity", "Lcom/stripe/android/view/PaymentFlowActivity;", "shippingMethods", "", "Lcom/stripe/android/model/ShippingMethod;", "defaultShippingMethod", "(Lcom/stripe/android/view/PaymentFlowActivity;Ljava/util/List;Lcom/stripe/android/model/ShippingMethod;)V", "activityRef", "Ljava/lang/ref/WeakReference;", "onCustomerRetrieved", "", "customer", "Lcom/stripe/android/model/Customer;", "onError", "errorCode", "", "errorMessage", "", "stripeError", "Lcom/stripe/android/StripeError;", "stripe_release"})
    private static final class CustomerShippingInfoSavedListener
    implements CustomerSession.CustomerRetrievalListener {
        private final WeakReference<PaymentFlowActivity> activityRef;
        private final List<ShippingMethod> shippingMethods;
        private final ShippingMethod defaultShippingMethod;

        @Override
        public void onCustomerRetrieved(@NotNull Customer customer) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)customer, (String)"customer");
                PaymentFlowActivity paymentFlowActivity = (PaymentFlowActivity)((Object)this.activityRef.get());
                if (paymentFlowActivity == null) break block0;
                paymentFlowActivity.onShippingInfoSaved$stripe_release(customer.getShippingInformation(), this.shippingMethods, this.defaultShippingMethod);
            }
        }

        @Override
        public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PaymentFlowActivity paymentFlowActivity = (PaymentFlowActivity)((Object)this.activityRef.get());
                if (paymentFlowActivity == null) break block0;
                paymentFlowActivity.showError(errorMessage);
            }
        }

        public CustomerShippingInfoSavedListener(@NotNull PaymentFlowActivity activity, @NotNull List<ShippingMethod> shippingMethods, @Nullable ShippingMethod defaultShippingMethod) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)activity), (String)"activity");
            Intrinsics.checkParameterIsNotNull(shippingMethods, (String)"shippingMethods");
            this.shippingMethods = shippingMethods;
            this.defaultShippingMethod = defaultShippingMethod;
            this.activityRef = new WeakReference<PaymentFlowActivity>(activity);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/view/PaymentFlowActivity$Companion;", "", "()V", "STATE_CURRENT_ITEM", "", "STATE_PAYMENT_SESSION_DATA", "STATE_SHIPPING_INFO", "STATE_SHIPPING_METHOD", "TOKEN_PAYMENT_FLOW_ACTIVITY", "TOKEN_SHIPPING_INFO_SCREEN", "TOKEN_SHIPPING_METHOD_SCREEN", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

