/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.Size;
import com.stripe.android.CardUtils;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.R;
import com.stripe.android.model.Address;
import com.stripe.android.model.ModelUtils;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripeParamsModel;
import com.stripe.android.model.StripePaymentSource;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b=\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0087\b\u0018\u0000 \u007f2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0005}~\u007f\u0080\u0001B\u0095\u0002\b\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0006\u0012\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e\u0012\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006\u0012\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010!\u00a2\u0006\u0002\u0010\"J\u000b\u0010A\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010B\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010C\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010D\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010F\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010G\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010I\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010J\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010K\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010L\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010M\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010N\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010O\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0014\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u00c0\u0003\u00a2\u0006\u0002\bQJ\u0010\u0010R\u001a\u0004\u0018\u00010\u0006H\u00c0\u0003\u00a2\u0006\u0002\bSJ\u0017\u0010T\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010!H\u00c6\u0003J\u0010\u0010U\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u00103J\u0010\u0010V\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u00103J\u000b\u0010W\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010X\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010Y\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010Z\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010[\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u00ca\u0002\u0010\\\u001a\u00020\u00002\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00062\n\b\u0003\u0010\u0014\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0016\b\u0002\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010!H\u00c6\u0001\u00a2\u0006\u0002\u0010]J\u0016\u0010^\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010_0!H\u0002J\t\u0010`\u001a\u00020\tH\u00d6\u0001J\u0013\u0010a\u001a\u00020b2\b\u0010c\u001a\u0004\u0018\u00010_H\u00d6\u0003J\t\u0010d\u001a\u00020\tH\u00d6\u0001J\u0006\u0010e\u001a\u00020fJ\u0014\u0010g\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020_0!H\u0016J\u0006\u0010h\u001a\u00020iJ\u0006\u0010j\u001a\u00020kJ\t\u0010l\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010m\u001a\u00020bJ\u0006\u0010n\u001a\u00020bJ\u0015\u0010n\u001a\u00020b2\u0006\u0010o\u001a\u00020pH\u0000\u00a2\u0006\u0002\bqJ\u0006\u0010r\u001a\u00020bJ\u0015\u0010s\u001a\u00020b2\u0006\u0010o\u001a\u00020pH\u0000\u00a2\u0006\u0002\btJ\u0006\u0010u\u001a\u00020bJ\u0015\u0010u\u001a\u00020b2\u0006\u0010o\u001a\u00020pH\u0000\u00a2\u0006\u0002\bvJ\u0006\u0010w\u001a\u00020bJ\u0019\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010$R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010$R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010$R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010$R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010$R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010$R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010$R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010$R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010$R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010$R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010$R\u0017\u0010\b\u001a\u0004\u0018\u00010\t8\u0007\u00a2\u0006\n\n\u0002\u00104\u001a\u0004\b2\u00103R\u0015\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u00104\u001a\u0004\b5\u00103R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010$R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010$R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010$R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010$R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u001f\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010!\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010$R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010$R\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010$\u00a8\u0006\u0081\u0001"}, d2={"Lcom/stripe/android/model/Card;", "Lcom/stripe/android/model/StripeModel;", "Lcom/stripe/android/model/StripePaymentSource;", "Lcom/stripe/android/model/StripeParamsModel;", "Landroid/os/Parcelable;", "number", "", "cvc", "expMonth", "", "expYear", "name", "addressLine1", "addressLine1Check", "addressLine2", "addressCity", "addressState", "addressZip", "addressZipCheck", "addressCountry", "last4", "brand", "funding", "fingerprint", "country", "currency", "customerId", "cvcCheck", "id", "loggingTokens", "", "tokenizationMethod", "metadata", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/util/Map;)V", "getAddressCity", "()Ljava/lang/String;", "getAddressCountry", "getAddressLine1", "getAddressLine1Check", "getAddressLine2", "getAddressState", "getAddressZip", "getAddressZipCheck", "getBrand", "getCountry", "getCurrency", "getCustomerId", "getCvc", "getCvcCheck", "getExpMonth", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getExpYear", "getFingerprint", "getFunding", "getId", "getLast4", "getLoggingTokens$stripe_release", "()Ljava/util/List;", "getMetadata", "()Ljava/util/Map;", "getName", "getNumber", "getTokenizationMethod$stripe_release", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component23$stripe_release", "component24", "component24$stripe_release", "component25", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/util/Map;)Lcom/stripe/android/model/Card;", "createCardParams", "", "describeContents", "equals", "", "other", "hashCode", "toBuilder", "Lcom/stripe/android/model/Card$Builder;", "toParamMap", "toPaymentMethodParamsCard", "Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "toPaymentMethodsParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "toString", "validateCVC", "validateCard", "now", "Ljava/util/Calendar;", "validateCard$stripe_release", "validateExpMonth", "validateExpYear", "validateExpYear$stripe_release", "validateExpiryDate", "validateExpiryDate$stripe_release", "validateNumber", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Builder", "CardBrand", "Companion", "FundingType", "stripe_release"})
@Parcelize
public final class Card
extends StripeModel
implements StripePaymentSource,
StripeParamsModel,
Parcelable {
    @Nullable
    private final String number;
    @Nullable
    private final String cvc;
    @Nullable
    private final Integer expMonth;
    @Nullable
    private final Integer expYear;
    @Nullable
    private final String name;
    @Nullable
    private final String addressLine1;
    @Nullable
    private final String addressLine1Check;
    @Nullable
    private final String addressLine2;
    @Nullable
    private final String addressCity;
    @Nullable
    private final String addressState;
    @Nullable
    private final String addressZip;
    @Nullable
    private final String addressZipCheck;
    @Nullable
    private final String addressCountry;
    @Nullable
    private final String last4;
    @Nullable
    private final String brand;
    @Nullable
    private final String funding;
    @Nullable
    private final String fingerprint;
    @Nullable
    private final String country;
    @Nullable
    private final String currency;
    @Nullable
    private final String customerId;
    @Nullable
    private final String cvcCheck;
    @Nullable
    private final String id;
    @NotNull
    private final List<String> loggingTokens;
    @Nullable
    private final String tokenizationMethod;
    @Nullable
    private final Map<String, String> metadata;
    public static final int CVC_LENGTH_AMERICAN_EXPRESS = 4;
    public static final int CVC_LENGTH_COMMON = 3;
    @NotNull
    private static final String[] PREFIXES_AMERICAN_EXPRESS;
    @NotNull
    private static final String[] PREFIXES_DISCOVER;
    @NotNull
    private static final String[] PREFIXES_JCB;
    @NotNull
    private static final String[] PREFIXES_DINERS_CLUB;
    @NotNull
    private static final String[] PREFIXES_VISA;
    @NotNull
    private static final String[] PREFIXES_MASTERCARD;
    @NotNull
    private static final String[] PREFIXES_UNIONPAY;
    public static final int MAX_LENGTH_STANDARD = 16;
    public static final int MAX_LENGTH_AMERICAN_EXPRESS = 15;
    public static final int MAX_LENGTH_DINERS_CLUB = 14;
    @NotNull
    public static final String VALUE_CARD = "card";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_ADDRESS_CITY = "address_city";
    private static final String FIELD_ADDRESS_COUNTRY = "address_country";
    private static final String FIELD_ADDRESS_LINE1 = "address_line1";
    private static final String FIELD_ADDRESS_LINE1_CHECK = "address_line1_check";
    private static final String FIELD_ADDRESS_LINE2 = "address_line2";
    private static final String FIELD_ADDRESS_STATE = "address_state";
    private static final String FIELD_ADDRESS_ZIP = "address_zip";
    private static final String FIELD_ADDRESS_ZIP_CHECK = "address_zip_check";
    private static final String FIELD_BRAND = "brand";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_CUSTOMER = "customer";
    private static final String FIELD_CVC_CHECK = "cvc_check";
    private static final String FIELD_EXP_MONTH = "exp_month";
    private static final String FIELD_EXP_YEAR = "exp_year";
    private static final String FIELD_FINGERPRINT = "fingerprint";
    private static final String FIELD_FUNDING = "funding";
    private static final String FIELD_METADATA = "metadata";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_LAST4 = "last4";
    private static final String FIELD_ID = "id";
    private static final String FIELD_TOKENIZATION_METHOD = "tokenization_method";
    private static final Map<String, Integer> BRAND_RESOURCE_MAP;
    public static final Companion Companion;
    public static final Parcelable.Creator CREATOR;

    @NotNull
    public final PaymentMethodCreateParams toPaymentMethodsParams() {
        return PaymentMethodCreateParams.Companion.create$default(PaymentMethodCreateParams.Companion, this.toPaymentMethodParamsCard(), new PaymentMethod.BillingDetails.Builder().setName(this.name).setAddress(new Address.Builder().setLine1(this.addressLine1).setLine2(this.addressLine2).setCity(this.addressCity).setState(this.addressState).setCountry(this.addressCountry).setPostalCode(this.addressZip).build()).build(), null, 4, null);
    }

    @NotNull
    public final PaymentMethodCreateParams.Card toPaymentMethodParamsCard() {
        return new PaymentMethodCreateParams.Card.Builder().setNumber(this.number).setCvc(this.cvc).setExpiryMonth(this.expMonth).setExpiryYear(this.expYear).build();
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder(this.number, this.expMonth, this.expYear, this.cvc).name(this.name).addressLine1(this.addressLine1).addressLine1Check(this.addressLine1Check).addressLine2(this.addressLine2).addressCity(this.addressCity).addressState(this.addressState).addressZip(this.addressZip).addressZipCheck(this.addressZipCheck).addressCountry(this.addressCountry).brand(this.brand).fingerprint(this.fingerprint).funding(this.funding).country(this.country).currency(this.currency).customer(this.customerId).cvcCheck(this.cvcCheck).last4(this.last4).id(this.getId()).tokenizationMethod(this.tokenizationMethod).metadata(this.metadata).loggingTokens(this.loggingTokens);
    }

    public final boolean validateCard() {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        return this.validateCard$stripe_release(calendar);
    }

    public final boolean validateNumber() {
        return CardUtils.isValidCardNumber(this.number);
    }

    public final boolean validateExpiryDate() {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        return this.validateExpiryDate$stripe_release(calendar);
    }

    public final boolean validateCVC() {
        CharSequence charSequence = this.cvc;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        String string = this.cvc;
        bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String cvcValue = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        String updatedType = this.brand;
        boolean validLength = updatedType == null && cvcValue.length() >= 3 && cvcValue.length() <= 4 || Intrinsics.areEqual((Object)"American Express", (Object)updatedType) && cvcValue.length() == 4 || cvcValue.length() == 3;
        return ModelUtils.INSTANCE.isWholePositiveNumber$stripe_release(cvcValue) && validLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean validateExpMonth() {
        Integer n = this.expMonth;
        if (n == null) return false;
        Integer n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        int expMonth = ((Number)n2).intValue();
        boolean bl3 = false;
        int n3 = expMonth;
        if (1 > n3) return false;
        if (12 < n3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean validateExpYear$stripe_release(@NotNull Calendar now) {
        Intrinsics.checkParameterIsNotNull((Object)now, (String)"now");
        Integer n = this.expYear;
        if (n == null) return false;
        Integer n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n2).intValue();
        boolean bl3 = false;
        if (ModelUtils.INSTANCE.hasYearPassed$stripe_release(it, now)) return false;
        return true;
    }

    public final boolean validateCard$stripe_release(@NotNull Calendar now) {
        Intrinsics.checkParameterIsNotNull((Object)now, (String)"now");
        return this.cvc == null ? this.validateNumber() && this.validateExpiryDate$stripe_release(now) : this.validateNumber() && this.validateExpiryDate$stripe_release(now) && this.validateCVC();
    }

    public final boolean validateExpiryDate$stripe_release(@NotNull Calendar now) {
        Intrinsics.checkParameterIsNotNull((Object)now, (String)"now");
        Integer expMonth = this.expMonth;
        if (expMonth == null || !this.validateExpMonth()) {
            return false;
        }
        return this.expYear == null || !this.validateExpYear$stripe_release(now) ? false : !ModelUtils.INSTANCE.hasMonthPassed$stripe_release(this.expYear, expMonth, now);
    }

    @Override
    @NotNull
    public Map<String, Object> toParamMap() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)VALUE_CARD, this.createCardParams()));
    }

    private final Map<String, Object> createCardParams() {
        Pair[] pairArray;
        String string = this.number;
        String string2 = "number";
        int n = 0;
        Pair[] pairArray2 = pairArray = new Pair[12];
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        boolean bl5 = false;
        String string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.cvc;
        string2 = "cvc";
        n = 1;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl6 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        Pair[] pairArray3 = pairArray2;
        pairArray2[2] = TuplesKt.to((Object)FIELD_EXP_MONTH, (Object)this.expMonth);
        pairArray3[3] = TuplesKt.to((Object)FIELD_EXP_YEAR, (Object)this.expYear);
        string = this.name;
        string2 = FIELD_NAME;
        n = 4;
        pairArray = pairArray3;
        pairArray2 = pairArray3;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl7 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.currency;
        string2 = FIELD_CURRENCY;
        n = 5;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl8 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.addressLine1;
        string2 = FIELD_ADDRESS_LINE1;
        n = 6;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl9 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.addressLine2;
        string2 = FIELD_ADDRESS_LINE2;
        n = 7;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl10 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.addressCity;
        string2 = FIELD_ADDRESS_CITY;
        n = 8;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl11 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.addressZip;
        string2 = FIELD_ADDRESS_ZIP;
        n = 9;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl12 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.addressState;
        string2 = FIELD_ADDRESS_STATE;
        n = 10;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl13 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.addressCountry;
        string2 = FIELD_ADDRESS_COUNTRY;
        n = 11;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl14 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        return MapsKt.mapOf((Pair[])pairArray2);
    }

    @Nullable
    public final String getNumber() {
        return this.number;
    }

    @Nullable
    public final String getCvc() {
        return this.cvc;
    }

    @IntRange(from=1L, to=12L)
    @Nullable
    public final Integer getExpMonth() {
        return this.expMonth;
    }

    @Nullable
    public final Integer getExpYear() {
        return this.expYear;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getAddressLine1() {
        return this.addressLine1;
    }

    @Nullable
    public final String getAddressLine1Check() {
        return this.addressLine1Check;
    }

    @Nullable
    public final String getAddressLine2() {
        return this.addressLine2;
    }

    @Nullable
    public final String getAddressCity() {
        return this.addressCity;
    }

    @Nullable
    public final String getAddressState() {
        return this.addressState;
    }

    @Nullable
    public final String getAddressZip() {
        return this.addressZip;
    }

    @Nullable
    public final String getAddressZipCheck() {
        return this.addressZipCheck;
    }

    @Nullable
    public final String getAddressCountry() {
        return this.addressCountry;
    }

    @Nullable
    public final String getLast4() {
        return this.last4;
    }

    @Nullable
    public final String getBrand() {
        return this.brand;
    }

    @Nullable
    public final String getFunding() {
        return this.funding;
    }

    @Nullable
    public final String getFingerprint() {
        return this.fingerprint;
    }

    @Nullable
    public final String getCountry() {
        return this.country;
    }

    @Nullable
    public final String getCurrency() {
        return this.currency;
    }

    @Nullable
    public final String getCustomerId() {
        return this.customerId;
    }

    @Nullable
    public final String getCvcCheck() {
        return this.cvcCheck;
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @NotNull
    public final List<String> getLoggingTokens$stripe_release() {
        return this.loggingTokens;
    }

    @Nullable
    public final String getTokenizationMethod$stripe_release() {
        return this.tokenizationMethod;
    }

    @Nullable
    public final Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Card(@Nullable String number, @Nullable String cvc, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String name, @Nullable String addressLine1, @Nullable String addressLine1Check, @Nullable String addressLine2, @Nullable String addressCity, @Nullable String addressState, @Nullable String addressZip, @Nullable String addressZipCheck, @Nullable String addressCountry, @Size(value=4L) @Nullable String last4, @Nullable String brand, @Nullable String funding, @Nullable String fingerprint, @Nullable String country, @Nullable String currency, @Nullable String customerId, @Nullable String cvcCheck, @Nullable String id, @NotNull List<String> loggingTokens, @Nullable String tokenizationMethod, @Nullable Map<String, String> metadata) {
        Intrinsics.checkParameterIsNotNull(loggingTokens, (String)"loggingTokens");
        this.number = number;
        this.cvc = cvc;
        this.expMonth = expMonth;
        this.expYear = expYear;
        this.name = name;
        this.addressLine1 = addressLine1;
        this.addressLine1Check = addressLine1Check;
        this.addressLine2 = addressLine2;
        this.addressCity = addressCity;
        this.addressState = addressState;
        this.addressZip = addressZip;
        this.addressZipCheck = addressZipCheck;
        this.addressCountry = addressCountry;
        this.last4 = last4;
        this.brand = brand;
        this.funding = funding;
        this.fingerprint = fingerprint;
        this.country = country;
        this.currency = currency;
        this.customerId = customerId;
        this.cvcCheck = cvcCheck;
        this.id = id;
        this.loggingTokens = loggingTokens;
        this.tokenizationMethod = tokenizationMethod;
        this.metadata = metadata;
    }

    public /* synthetic */ Card(String string, String string2, Integer n, Integer n2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20, List list, String string21, Map map, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x400000) != 0) {
            boolean bl = false;
            list = new ArrayList();
        }
        this(string, string2, n, n2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20, list, string21, map);
    }

    static {
        Companion = new Companion(null);
        PREFIXES_AMERICAN_EXPRESS = new String[]{"34", "37"};
        PREFIXES_DISCOVER = new String[]{"60", "64", "65"};
        PREFIXES_JCB = new String[]{"35"};
        PREFIXES_DINERS_CLUB = new String[]{"300", "301", "302", "303", "304", "305", "309", "36", "38", "39"};
        PREFIXES_VISA = new String[]{"4"};
        PREFIXES_MASTERCARD = new String[]{"2221", "2222", "2223", "2224", "2225", "2226", "2227", "2228", "2229", "223", "224", "225", "226", "227", "228", "229", "23", "24", "25", "26", "270", "271", "2720", "50", "51", "52", "53", "54", "55", "67"};
        PREFIXES_UNIONPAY = new String[]{"62"};
        BRAND_RESOURCE_MAP = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"American Express", (Object)R.drawable.ic_amex), TuplesKt.to((Object)"Diners Club", (Object)R.drawable.ic_diners), TuplesKt.to((Object)"Discover", (Object)R.drawable.ic_discover), TuplesKt.to((Object)"JCB", (Object)R.drawable.ic_jcb), TuplesKt.to((Object)"MasterCard", (Object)R.drawable.ic_mastercard), TuplesKt.to((Object)"Visa", (Object)R.drawable.ic_visa), TuplesKt.to((Object)"UnionPay", (Object)R.drawable.ic_unionpay), TuplesKt.to((Object)"Unknown", (Object)R.drawable.ic_unknown)});
        CREATOR = new Creator();
    }

    @Nullable
    public final String component1() {
        return this.number;
    }

    @Nullable
    public final String component2() {
        return this.cvc;
    }

    @Nullable
    public final Integer component3() {
        return this.expMonth;
    }

    @Nullable
    public final Integer component4() {
        return this.expYear;
    }

    @Nullable
    public final String component5() {
        return this.name;
    }

    @Nullable
    public final String component6() {
        return this.addressLine1;
    }

    @Nullable
    public final String component7() {
        return this.addressLine1Check;
    }

    @Nullable
    public final String component8() {
        return this.addressLine2;
    }

    @Nullable
    public final String component9() {
        return this.addressCity;
    }

    @Nullable
    public final String component10() {
        return this.addressState;
    }

    @Nullable
    public final String component11() {
        return this.addressZip;
    }

    @Nullable
    public final String component12() {
        return this.addressZipCheck;
    }

    @Nullable
    public final String component13() {
        return this.addressCountry;
    }

    @Nullable
    public final String component14() {
        return this.last4;
    }

    @Nullable
    public final String component15() {
        return this.brand;
    }

    @Nullable
    public final String component16() {
        return this.funding;
    }

    @Nullable
    public final String component17() {
        return this.fingerprint;
    }

    @Nullable
    public final String component18() {
        return this.country;
    }

    @Nullable
    public final String component19() {
        return this.currency;
    }

    @Nullable
    public final String component20() {
        return this.customerId;
    }

    @Nullable
    public final String component21() {
        return this.cvcCheck;
    }

    @Nullable
    public final String component22() {
        return this.getId();
    }

    @NotNull
    public final List<String> component23$stripe_release() {
        return this.loggingTokens;
    }

    @Nullable
    public final String component24$stripe_release() {
        return this.tokenizationMethod;
    }

    @Nullable
    public final Map<String, String> component25() {
        return this.metadata;
    }

    @NotNull
    public final Card copy(@Nullable String number, @Nullable String cvc, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String name, @Nullable String addressLine1, @Nullable String addressLine1Check, @Nullable String addressLine2, @Nullable String addressCity, @Nullable String addressState, @Nullable String addressZip, @Nullable String addressZipCheck, @Nullable String addressCountry, @Size(value=4L) @Nullable String last4, @Nullable String brand, @Nullable String funding, @Nullable String fingerprint, @Nullable String country, @Nullable String currency, @Nullable String customerId, @Nullable String cvcCheck, @Nullable String id, @NotNull List<String> loggingTokens, @Nullable String tokenizationMethod, @Nullable Map<String, String> metadata) {
        Intrinsics.checkParameterIsNotNull(loggingTokens, (String)"loggingTokens");
        return new Card(number, cvc, expMonth, expYear, name, addressLine1, addressLine1Check, addressLine2, addressCity, addressState, addressZip, addressZipCheck, addressCountry, last4, brand, funding, fingerprint, country, currency, customerId, cvcCheck, id, loggingTokens, tokenizationMethod, metadata);
    }

    public static /* synthetic */ Card copy$default(Card card, String string, String string2, Integer n, Integer n2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20, List list, String string21, Map map, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = card.number;
        }
        if ((n3 & 2) != 0) {
            string2 = card.cvc;
        }
        if ((n3 & 4) != 0) {
            n = card.expMonth;
        }
        if ((n3 & 8) != 0) {
            n2 = card.expYear;
        }
        if ((n3 & 0x10) != 0) {
            string3 = card.name;
        }
        if ((n3 & 0x20) != 0) {
            string4 = card.addressLine1;
        }
        if ((n3 & 0x40) != 0) {
            string5 = card.addressLine1Check;
        }
        if ((n3 & 0x80) != 0) {
            string6 = card.addressLine2;
        }
        if ((n3 & 0x100) != 0) {
            string7 = card.addressCity;
        }
        if ((n3 & 0x200) != 0) {
            string8 = card.addressState;
        }
        if ((n3 & 0x400) != 0) {
            string9 = card.addressZip;
        }
        if ((n3 & 0x800) != 0) {
            string10 = card.addressZipCheck;
        }
        if ((n3 & 0x1000) != 0) {
            string11 = card.addressCountry;
        }
        if ((n3 & 0x2000) != 0) {
            string12 = card.last4;
        }
        if ((n3 & 0x4000) != 0) {
            string13 = card.brand;
        }
        if ((n3 & 0x8000) != 0) {
            string14 = card.funding;
        }
        if ((n3 & 0x10000) != 0) {
            string15 = card.fingerprint;
        }
        if ((n3 & 0x20000) != 0) {
            string16 = card.country;
        }
        if ((n3 & 0x40000) != 0) {
            string17 = card.currency;
        }
        if ((n3 & 0x80000) != 0) {
            string18 = card.customerId;
        }
        if ((n3 & 0x100000) != 0) {
            string19 = card.cvcCheck;
        }
        if ((n3 & 0x200000) != 0) {
            string20 = card.getId();
        }
        if ((n3 & 0x400000) != 0) {
            list = card.loggingTokens;
        }
        if ((n3 & 0x800000) != 0) {
            string21 = card.tokenizationMethod;
        }
        if ((n3 & 0x1000000) != 0) {
            map = card.metadata;
        }
        return card.copy(string, string2, n, n2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20, list, string21, map);
    }

    @NotNull
    public String toString() {
        return "Card(number=" + this.number + ", cvc=" + this.cvc + ", expMonth=" + this.expMonth + ", expYear=" + this.expYear + ", name=" + this.name + ", addressLine1=" + this.addressLine1 + ", addressLine1Check=" + this.addressLine1Check + ", addressLine2=" + this.addressLine2 + ", addressCity=" + this.addressCity + ", addressState=" + this.addressState + ", addressZip=" + this.addressZip + ", addressZipCheck=" + this.addressZipCheck + ", addressCountry=" + this.addressCountry + ", last4=" + this.last4 + ", brand=" + this.brand + ", funding=" + this.funding + ", fingerprint=" + this.fingerprint + ", country=" + this.country + ", currency=" + this.currency + ", customerId=" + this.customerId + ", cvcCheck=" + this.cvcCheck + ", id=" + this.getId() + ", loggingTokens=" + this.loggingTokens + ", tokenizationMethod=" + this.tokenizationMethod + ", metadata=" + this.metadata + ")";
    }

    @Override
    public int hashCode() {
        String string = this.number;
        String string2 = this.cvc;
        Integer n = this.expMonth;
        Integer n2 = this.expYear;
        String string3 = this.name;
        String string4 = this.addressLine1;
        String string5 = this.addressLine1Check;
        String string6 = this.addressLine2;
        String string7 = this.addressCity;
        String string8 = this.addressState;
        String string9 = this.addressZip;
        String string10 = this.addressZipCheck;
        String string11 = this.addressCountry;
        String string12 = this.last4;
        String string13 = this.brand;
        String string14 = this.funding;
        String string15 = this.fingerprint;
        String string16 = this.country;
        String string17 = this.currency;
        String string18 = this.customerId;
        String string19 = this.cvcCheck;
        String string20 = this.getId();
        List<String> list = this.loggingTokens;
        String string21 = this.tokenizationMethod;
        Map<String, String> map = this.metadata;
        return ((((((((((((((((((((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (n != null ? ((Object)n).hashCode() : 0)) * 31 + (n2 != null ? ((Object)n2).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31 + (string7 != null ? string7.hashCode() : 0)) * 31 + (string8 != null ? string8.hashCode() : 0)) * 31 + (string9 != null ? string9.hashCode() : 0)) * 31 + (string10 != null ? string10.hashCode() : 0)) * 31 + (string11 != null ? string11.hashCode() : 0)) * 31 + (string12 != null ? string12.hashCode() : 0)) * 31 + (string13 != null ? string13.hashCode() : 0)) * 31 + (string14 != null ? string14.hashCode() : 0)) * 31 + (string15 != null ? string15.hashCode() : 0)) * 31 + (string16 != null ? string16.hashCode() : 0)) * 31 + (string17 != null ? string17.hashCode() : 0)) * 31 + (string18 != null ? string18.hashCode() : 0)) * 31 + (string19 != null ? string19.hashCode() : 0)) * 31 + (string20 != null ? string20.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (string21 != null ? string21.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Card)) break block3;
                Card card = (Card)object;
                if (!Intrinsics.areEqual((Object)this.number, (Object)card.number) || !Intrinsics.areEqual((Object)this.cvc, (Object)card.cvc) || !Intrinsics.areEqual((Object)this.expMonth, (Object)card.expMonth) || !Intrinsics.areEqual((Object)this.expYear, (Object)card.expYear) || !Intrinsics.areEqual((Object)this.name, (Object)card.name) || !Intrinsics.areEqual((Object)this.addressLine1, (Object)card.addressLine1) || !Intrinsics.areEqual((Object)this.addressLine1Check, (Object)card.addressLine1Check) || !Intrinsics.areEqual((Object)this.addressLine2, (Object)card.addressLine2) || !Intrinsics.areEqual((Object)this.addressCity, (Object)card.addressCity) || !Intrinsics.areEqual((Object)this.addressState, (Object)card.addressState) || !Intrinsics.areEqual((Object)this.addressZip, (Object)card.addressZip) || !Intrinsics.areEqual((Object)this.addressZipCheck, (Object)card.addressZipCheck) || !Intrinsics.areEqual((Object)this.addressCountry, (Object)card.addressCountry) || !Intrinsics.areEqual((Object)this.last4, (Object)card.last4) || !Intrinsics.areEqual((Object)this.brand, (Object)card.brand) || !Intrinsics.areEqual((Object)this.funding, (Object)card.funding) || !Intrinsics.areEqual((Object)this.fingerprint, (Object)card.fingerprint) || !Intrinsics.areEqual((Object)this.country, (Object)card.country) || !Intrinsics.areEqual((Object)this.currency, (Object)card.currency) || !Intrinsics.areEqual((Object)this.customerId, (Object)card.customerId) || !Intrinsics.areEqual((Object)this.cvcCheck, (Object)card.cvcCheck) || !Intrinsics.areEqual((Object)this.getId(), (Object)card.getId()) || !Intrinsics.areEqual(this.loggingTokens, card.loggingTokens) || !Intrinsics.areEqual((Object)this.tokenizationMethod, (Object)card.tokenizationMethod) || !Intrinsics.areEqual(this.metadata, card.metadata)) break block3;
            }
            return true;
        }
        return false;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
        parcel.writeString(this.number);
        parcel.writeString(this.cvc);
        Parcel parcel2 = parcel;
        Integer n = this.expMonth;
        if (n != null) {
            parcel.writeInt(1);
            parcel2.writeInt(n.intValue());
        } else {
            parcel2.writeInt(0);
        }
        Parcel parcel3 = parcel;
        Integer n2 = this.expYear;
        if (n2 != null) {
            parcel.writeInt(1);
            parcel3.writeInt(n2.intValue());
        } else {
            parcel3.writeInt(0);
        }
        parcel.writeString(this.name);
        parcel.writeString(this.addressLine1);
        parcel.writeString(this.addressLine1Check);
        parcel.writeString(this.addressLine2);
        parcel.writeString(this.addressCity);
        parcel.writeString(this.addressState);
        parcel.writeString(this.addressZip);
        parcel.writeString(this.addressZipCheck);
        parcel.writeString(this.addressCountry);
        parcel.writeString(this.last4);
        parcel.writeString(this.brand);
        parcel.writeString(this.funding);
        parcel.writeString(this.fingerprint);
        parcel.writeString(this.country);
        parcel.writeString(this.currency);
        parcel.writeString(this.customerId);
        parcel.writeString(this.cvcCheck);
        parcel.writeString(this.id);
        parcel.writeStringList(this.loggingTokens);
        parcel.writeString(this.tokenizationMethod);
        Parcel parcel4 = parcel;
        Map<String, String> map = this.metadata;
        if (map != null) {
            parcel.writeInt(1);
            parcel4.writeInt(map.size());
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                iterator = iterator;
                Parcel parcel5 = parcel;
                Map.Entry<String, String> entry = iterator.next();
                parcel5.writeString(entry.getKey());
                parcel5.writeString(entry.getValue());
            }
        } else {
            parcel4.writeInt(0);
        }
    }

    @JvmStatic
    @Nullable
    public static final String asCardBrand(@Nullable String possibleCardType) {
        return Companion.asCardBrand(possibleCardType);
    }

    @JvmStatic
    @Nullable
    public static final String asFundingType(@Nullable String possibleFundingType) {
        return Companion.asFundingType(possibleFundingType);
    }

    @JvmStatic
    @DrawableRes
    public static final int getBrandIcon(@Nullable String brand) {
        return Companion.getBrandIcon(brand);
    }

    @JvmStatic
    @Nullable
    public static final Card fromString(@NotNull String jsonString) {
        return Companion.fromString(jsonString);
    }

    @JvmStatic
    @Nullable
    public static final Card fromJson(@Nullable JSONObject jsonObject) {
        return Companion.fromJson(jsonObject);
    }

    @JvmStatic
    @NotNull
    public static final Card create(@Nullable String number, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String cvc) {
        return Companion.create(number, expMonth, expYear, cvc);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class Creator
    implements Parcelable.Creator {
        @NotNull
        public final Object[] newArray(int size) {
            return new Card[size];
        }

        @NotNull
        public final Object createFromParcel(@NotNull Parcel in) {
            LinkedHashMap<String, String> linkedHashMap;
            Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
            String string = in.readString();
            String string2 = in.readString();
            Integer n = in.readInt() != 0 ? Integer.valueOf(in.readInt()) : null;
            Integer n2 = in.readInt() != 0 ? Integer.valueOf(in.readInt()) : null;
            String string3 = in.readString();
            String string4 = in.readString();
            String string5 = in.readString();
            String string6 = in.readString();
            String string7 = in.readString();
            String string8 = in.readString();
            String string9 = in.readString();
            String string10 = in.readString();
            String string11 = in.readString();
            String string12 = in.readString();
            String string13 = in.readString();
            String string14 = in.readString();
            String string15 = in.readString();
            String string16 = in.readString();
            String string17 = in.readString();
            String string18 = in.readString();
            String string19 = in.readString();
            String string20 = in.readString();
            List list = in.createStringArrayList();
            String string21 = in.readString();
            if (in.readInt() != 0) {
                int n3 = in.readInt();
                LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>(n3);
                int n4 = n3;
                while (n4 != 0) {
                    Parcel parcel = in;
                    linkedHashMap2.put(parcel.readString(), parcel.readString());
                    linkedHashMap2 = linkedHashMap2;
                    n4 = n4 + -1;
                }
                linkedHashMap = linkedHashMap2;
            } else {
                linkedHashMap = null;
            }
            return new Card(string, string2, n, n2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20, list, string21, linkedHashMap);
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/model/Card$CardBrand;", "", "Companion", "stripe_release"})
    public static @interface CardBrand {
        public static final Companion Companion = Companion.$$INSTANCE;
        @NotNull
        public static final String AMERICAN_EXPRESS = "American Express";
        @NotNull
        public static final String DISCOVER = "Discover";
        @NotNull
        public static final String JCB = "JCB";
        @NotNull
        public static final String DINERS_CLUB = "Diners Club";
        @NotNull
        public static final String VISA = "Visa";
        @NotNull
        public static final String MASTERCARD = "MasterCard";
        @NotNull
        public static final String UNIONPAY = "UnionPay";
        @NotNull
        public static final String UNKNOWN = "Unknown";

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/Card$CardBrand$Companion;", "", "()V", "AMERICAN_EXPRESS", "", "DINERS_CLUB", "DISCOVER", "JCB", "MASTERCARD", "UNIONPAY", "UNKNOWN", "VISA", "stripe_release"})
        public static final class Companion {
            @NotNull
            public static final String AMERICAN_EXPRESS = "American Express";
            @NotNull
            public static final String DISCOVER = "Discover";
            @NotNull
            public static final String JCB = "JCB";
            @NotNull
            public static final String DINERS_CLUB = "Diners Club";
            @NotNull
            public static final String VISA = "Visa";
            @NotNull
            public static final String MASTERCARD = "MasterCard";
            @NotNull
            public static final String UNIONPAY = "UnionPay";
            @NotNull
            public static final String UNKNOWN = "Unknown";
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/model/Card$FundingType;", "", "Companion", "stripe_release"})
    public static @interface FundingType {
        public static final Companion Companion = Companion.$$INSTANCE;
        @NotNull
        public static final String CREDIT = "credit";
        @NotNull
        public static final String DEBIT = "debit";
        @NotNull
        public static final String PREPAID = "prepaid";
        @NotNull
        public static final String UNKNOWN = "unknown";

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/Card$FundingType$Companion;", "", "()V", "CREDIT", "", "DEBIT", "PREPAID", "UNKNOWN", "stripe_release"})
        public static final class Companion {
            @NotNull
            public static final String CREDIT = "credit";
            @NotNull
            public static final String DEBIT = "debit";
            @NotNull
            public static final String PREPAID = "prepaid";
            @NotNull
            public static final String UNKNOWN = "unknown";
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u001e\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u000e\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00002\b\u0010+\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\f\u001a\u00020\u00002\b\u0010,\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\r\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010,\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010-\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010.\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010/\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004J\b\u00100\u001a\u00020\u0002H\u0016J\u0014\u00101\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0002J\u0014\u00102\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0016\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004J\u0010\u00103\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001a\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001f\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004J\u0010\u0010 \u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u0004J\u0010\u0010\"\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010\u0004J\u0010\u0010#\u001a\u00020\u00002\b\u0010#\u001a\u0004\u0018\u00010\u0004J\u0014\u0010$\u001a\u00020\u00002\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%J\u001c\u0010&\u001a\u00020\u00002\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010'J\u0010\u0010(\u001a\u00020\u00002\b\u0010(\u001a\u0004\u0018\u00010\u0004J\u0014\u00104\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010*\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001e\u0010\u001cR\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b!\u0010\u0014R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0019R\u0010\u0010*\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/stripe/android/model/Card$Builder;", "Lcom/stripe/android/ObjectBuilder;", "Lcom/stripe/android/model/Card;", "number", "", "expMonth", "", "expYear", "cvc", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)V", "addressCity", "addressCountry", "addressLine1", "addressLine1Check", "addressLine2", "addressState", "addressZip", "addressZipCheck", "brand", "brand$annotations", "()V", "country", "currency", "customerId", "getCvc$stripe_release", "()Ljava/lang/String;", "cvcCheck", "getExpMonth$stripe_release", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getExpYear$stripe_release", "fingerprint", "funding", "funding$annotations", "id", "last4", "loggingTokens", "", "metadata", "", "name", "getNumber$stripe_release", "tokenizationMethod", "city", "address", "state", "zip", "zipCheck", "build", "calculateBrand", "calculateLast4", "customer", "normalizeCardNumber", "stripe_release"})
    public static final class Builder
    implements ObjectBuilder<Card> {
        private String name;
        private String addressLine1;
        private String addressLine1Check;
        private String addressLine2;
        private String addressCity;
        private String addressState;
        private String addressZip;
        private String addressZipCheck;
        private String addressCountry;
        private String brand;
        private String funding;
        @Size(value=4L)
        private String last4;
        private String fingerprint;
        private String country;
        private String currency;
        private String customerId;
        private String cvcCheck;
        private String id;
        private String tokenizationMethod;
        private Map<String, String> metadata;
        private List<String> loggingTokens;
        @Nullable
        private final String number;
        @Nullable
        private final Integer expMonth;
        @Nullable
        private final Integer expYear;
        @Nullable
        private final String cvc;

        private static /* synthetic */ void brand$annotations() {
        }

        private static /* synthetic */ void funding$annotations() {
        }

        @NotNull
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @NotNull
        public final Builder addressLine1(@Nullable String address) {
            this.addressLine1 = address;
            return this;
        }

        @NotNull
        public final Builder addressLine1Check(@Nullable String addressLine1Check) {
            this.addressLine1Check = addressLine1Check;
            return this;
        }

        @NotNull
        public final Builder addressLine2(@Nullable String address) {
            this.addressLine2 = address;
            return this;
        }

        @NotNull
        public final Builder addressCity(@Nullable String city) {
            this.addressCity = city;
            return this;
        }

        @NotNull
        public final Builder addressState(@Nullable String state) {
            this.addressState = state;
            return this;
        }

        @NotNull
        public final Builder addressZip(@Nullable String zip) {
            this.addressZip = zip;
            return this;
        }

        @NotNull
        public final Builder addressZipCheck(@Nullable String zipCheck) {
            this.addressZipCheck = zipCheck;
            return this;
        }

        @NotNull
        public final Builder addressCountry(@Nullable String country) {
            this.addressCountry = country;
            return this;
        }

        @NotNull
        public final Builder brand(@Nullable String brand) {
            this.brand = brand;
            return this;
        }

        @NotNull
        public final Builder fingerprint(@Nullable String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        @NotNull
        public final Builder funding(@Nullable String funding) {
            this.funding = funding;
            return this;
        }

        @NotNull
        public final Builder country(@Nullable String country) {
            this.country = country;
            return this;
        }

        @NotNull
        public final Builder currency(@Nullable String currency) {
            this.currency = currency;
            return this;
        }

        @NotNull
        public final Builder customer(@Nullable String customerId) {
            this.customerId = customerId;
            return this;
        }

        @NotNull
        public final Builder cvcCheck(@Nullable String cvcCheck) {
            this.cvcCheck = cvcCheck;
            return this;
        }

        @NotNull
        public final Builder last4(@Nullable String last4) {
            this.last4 = last4;
            return this;
        }

        @NotNull
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @NotNull
        public final Builder tokenizationMethod(@Nullable String tokenizationMethod) {
            this.tokenizationMethod = tokenizationMethod;
            return this;
        }

        @NotNull
        public final Builder metadata(@Nullable Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @NotNull
        public final Builder loggingTokens(@NotNull List<String> loggingTokens) {
            Intrinsics.checkParameterIsNotNull(loggingTokens, (String)"loggingTokens");
            this.loggingTokens = loggingTokens;
            return this;
        }

        @Override
        @NotNull
        public Card build() {
            String string = this.normalizeCardNumber(this.number);
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            boolean bl5 = false;
            String number = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
            Object object = this.last4;
            bl2 = false;
            boolean bl6 = false;
            String it2 = object;
            boolean bl7 = false;
            CharSequence charSequence2 = it2;
            bl5 = false;
            boolean bl8 = false;
            Object object2 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            if (object2 == null) {
                object2 = this.calculateLast4(number);
            }
            String last4 = object2;
            object = this.cvc;
            Integer n = this.expYear;
            Integer n2 = this.expMonth;
            String string2 = number;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl9 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string3 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.name;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl10 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string4 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.addressLine1;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl11 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string5 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.addressLine1Check;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl12 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string6 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.addressLine2;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl13 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string7 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.addressCity;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl14 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string8 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.addressState;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl15 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string9 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.addressZip;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl16 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string10 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.addressZipCheck;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl17 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string11 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.addressCountry;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl18 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string12 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.fingerprint;
            String string13 = Companion.asCardBrand(this.brand) == null ? this.calculateBrand(this.brand) : this.brand;
            String string14 = last4;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl19 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string15 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = Companion.asFundingType(this.funding);
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl20 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string16 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.country;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl21 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string17 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.currency;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl22 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string18 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.customerId;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl23 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string19 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.cvcCheck;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl24 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string20 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.id;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl25 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string21 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.tokenizationMethod;
            bl2 = false;
            bl6 = false;
            it2 = object;
            boolean bl26 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string22 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object : null;
            object = this.loggingTokens;
            Map<String, String> map = this.metadata;
            bl2 = false;
            Object object3 = object;
            if (object3 == null) {
                object3 = CollectionsKt.emptyList();
            }
            Object object4 = object3;
            object = CollectionsKt.toMutableList((Collection)((Collection)object4));
            Map<String, String> map2 = map;
            String string23 = string22;
            String string24 = string21;
            String string25 = string20;
            charSequence2 = string19;
            String string26 = string18;
            String string27 = string17;
            String string28 = string16;
            String string29 = string15;
            String string30 = string13;
            String string31 = string14;
            String string32 = string12;
            String string33 = string11;
            String string34 = string10;
            String string35 = string9;
            String string36 = string8;
            String string37 = string7;
            String string38 = string6;
            String string39 = string5;
            String string40 = string4;
            String string41 = string3;
            Integer n3 = n;
            Integer n4 = n2;
            Map<String, String> map3 = map2;
            String string42 = string23;
            Object object5 = object;
            String string43 = string24;
            String string44 = string25;
            CharSequence charSequence3 = charSequence2;
            String string45 = string26;
            String string46 = string27;
            String string47 = string29;
            String string48 = string28;
            String string49 = string30;
            String string50 = string31;
            String string51 = string32;
            String string52 = string33;
            String string53 = string34;
            String string54 = string35;
            String string55 = string36;
            String string56 = string37;
            String string57 = string38;
            String string58 = string39;
            String string59 = string40;
            Integer n5 = n3;
            Integer n6 = n4;
            String string60 = string41;
            String string61 = string2;
            return new Card(string61, string60, n6, n5, string59, string58, string57, string56, string55, string54, string53, string52, string51, string50, string49, string48, string47, string46, string45, (String)charSequence3, string44, string43, (List<String>)object5, string42, map3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String normalizeCardNumber(String number) {
            String string = number;
            String string2 = string;
            if (string == null) return null;
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            string2 = string5;
            if (string5 == null) return null;
            CharSequence charSequence = string2;
            String string6 = "\\s+|-";
            boolean bl2 = false;
            string6 = new Regex(string6);
            String string7 = "";
            boolean bl3 = false;
            String string8 = string6.replace(charSequence, string7);
            return string8;
        }

        private final String calculateLast4(String number) {
            String string;
            if (number != null && number.length() > 4) {
                String string2 = number;
                int n = number.length() - 4;
                boolean bl = false;
                String string3 = string2.substring(n);
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = null;
            }
            return string;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final String calculateBrand(String brand) {
            String string;
            CharSequence charSequence = brand;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                charSequence = this.number;
                bl = false;
                bl2 = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    string = CardUtils.getPossibleCardType(this.number);
                    return string;
                }
            }
            string = brand;
            return string;
        }

        @Nullable
        public final String getNumber$stripe_release() {
            return this.number;
        }

        @Nullable
        public final Integer getExpMonth$stripe_release() {
            return this.expMonth;
        }

        @Nullable
        public final Integer getExpYear$stripe_release() {
            return this.expYear;
        }

        @Nullable
        public final String getCvc$stripe_release() {
            return this.cvc;
        }

        public Builder(@Nullable String number, @IntRange(from=1L, to=12L) @Nullable Integer expMonth, @IntRange(from=0L) @Nullable Integer expYear, @Nullable String cvc) {
            this.number = number;
            this.expMonth = expMonth;
            this.expYear = expYear;
            this.cvc = cvc;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u001d\n\u0002\u0010\u0011\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u00105\u001a\u0004\u0018\u00010\u00052\b\u00106\u001a\u0004\u0018\u00010\u0005H\u0007J\u0014\u00107\u001a\u0004\u0018\u00010\u00052\b\u00108\u001a\u0004\u0018\u00010\u0005H\u0007J5\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010\u00052\b\u0010<\u001a\u0004\u0018\u00010\u00062\b\u0010=\u001a\u0004\u0018\u00010\u00062\b\u0010>\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010?J\u0014\u0010@\u001a\u0004\u0018\u00010:2\b\u0010A\u001a\u0004\u0018\u00010BH\u0007J\u0012\u0010C\u001a\u0004\u0018\u00010:2\u0006\u0010D\u001a\u00020\u0005H\u0007J\u0012\u0010E\u001a\u00020\u00062\b\u0010F\u001a\u0004\u0018\u00010\u0005H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b%\u0010&R\u0019\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050$\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b)\u0010&R\u0019\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050$\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b+\u0010&R\u0019\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050$\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b-\u0010&R\u0019\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050$\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b/\u0010&R\u0019\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050$\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b1\u0010&R\u0019\u00102\u001a\b\u0012\u0004\u0012\u00020\u00050$\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b3\u0010&R\u000e\u00104\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/stripe/android/model/Card$Companion;", "", "()V", "BRAND_RESOURCE_MAP", "", "", "", "CVC_LENGTH_AMERICAN_EXPRESS", "CVC_LENGTH_COMMON", "FIELD_ADDRESS_CITY", "FIELD_ADDRESS_COUNTRY", "FIELD_ADDRESS_LINE1", "FIELD_ADDRESS_LINE1_CHECK", "FIELD_ADDRESS_LINE2", "FIELD_ADDRESS_STATE", "FIELD_ADDRESS_ZIP", "FIELD_ADDRESS_ZIP_CHECK", "FIELD_BRAND", "FIELD_COUNTRY", "FIELD_CURRENCY", "FIELD_CUSTOMER", "FIELD_CVC_CHECK", "FIELD_EXP_MONTH", "FIELD_EXP_YEAR", "FIELD_FINGERPRINT", "FIELD_FUNDING", "FIELD_ID", "FIELD_LAST4", "FIELD_METADATA", "FIELD_NAME", "FIELD_OBJECT", "FIELD_TOKENIZATION_METHOD", "MAX_LENGTH_AMERICAN_EXPRESS", "MAX_LENGTH_DINERS_CLUB", "MAX_LENGTH_STANDARD", "PREFIXES_AMERICAN_EXPRESS", "", "getPREFIXES_AMERICAN_EXPRESS", "()[Ljava/lang/String;", "[Ljava/lang/String;", "PREFIXES_DINERS_CLUB", "getPREFIXES_DINERS_CLUB", "PREFIXES_DISCOVER", "getPREFIXES_DISCOVER", "PREFIXES_JCB", "getPREFIXES_JCB", "PREFIXES_MASTERCARD", "getPREFIXES_MASTERCARD", "PREFIXES_UNIONPAY", "getPREFIXES_UNIONPAY", "PREFIXES_VISA", "getPREFIXES_VISA", "VALUE_CARD", "asCardBrand", "possibleCardType", "asFundingType", "possibleFundingType", "create", "Lcom/stripe/android/model/Card;", "number", "expMonth", "expYear", "cvc", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)Lcom/stripe/android/model/Card;", "fromJson", "jsonObject", "Lorg/json/JSONObject;", "fromString", "jsonString", "getBrandIcon", "brand", "stripe_release"})
    public static final class Companion {
        @NotNull
        public final String[] getPREFIXES_AMERICAN_EXPRESS() {
            return PREFIXES_AMERICAN_EXPRESS;
        }

        @NotNull
        public final String[] getPREFIXES_DISCOVER() {
            return PREFIXES_DISCOVER;
        }

        @NotNull
        public final String[] getPREFIXES_JCB() {
            return PREFIXES_JCB;
        }

        @NotNull
        public final String[] getPREFIXES_DINERS_CLUB() {
            return PREFIXES_DINERS_CLUB;
        }

        @NotNull
        public final String[] getPREFIXES_VISA() {
            return PREFIXES_VISA;
        }

        @NotNull
        public final String[] getPREFIXES_MASTERCARD() {
            return PREFIXES_MASTERCARD;
        }

        @NotNull
        public final String[] getPREFIXES_UNIONPAY() {
            return PREFIXES_UNIONPAY;
        }

        @JvmStatic
        @Nullable
        public final String asCardBrand(@Nullable String possibleCardType) {
            CharSequence charSequence = possibleCardType;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            return StringsKt.equals((String)"American Express", (String)possibleCardType, (boolean)true) ? "American Express" : (StringsKt.equals((String)"MasterCard", (String)possibleCardType, (boolean)true) ? "MasterCard" : (StringsKt.equals((String)"Diners Club", (String)possibleCardType, (boolean)true) ? "Diners Club" : (StringsKt.equals((String)"Discover", (String)possibleCardType, (boolean)true) ? "Discover" : (StringsKt.equals((String)"JCB", (String)possibleCardType, (boolean)true) ? "JCB" : (StringsKt.equals((String)"Visa", (String)possibleCardType, (boolean)true) ? "Visa" : (StringsKt.equals((String)"UnionPay", (String)possibleCardType, (boolean)true) ? "UnionPay" : "Unknown"))))));
        }

        @JvmStatic
        @Nullable
        public final String asFundingType(@Nullable String possibleFundingType) {
            CharSequence charSequence = possibleFundingType;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            return StringsKt.equals((String)"credit", (String)possibleFundingType, (boolean)true) ? "credit" : (StringsKt.equals((String)"debit", (String)possibleFundingType, (boolean)true) ? "debit" : (StringsKt.equals((String)"prepaid", (String)possibleFundingType, (boolean)true) ? "prepaid" : "unknown"));
        }

        @JvmStatic
        @DrawableRes
        public final int getBrandIcon(@Nullable String brand) {
            Integer brandIcon;
            Map map = BRAND_RESOURCE_MAP;
            boolean bl = false;
            Integer n = brandIcon = (Integer)map.get(brand);
            return n != null ? n : R.drawable.ic_unknown;
        }

        @JvmStatic
        @Nullable
        public final Card fromString(@NotNull String jsonString) {
            Card card;
            Intrinsics.checkParameterIsNotNull((Object)jsonString, (String)"jsonString");
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                card = this.fromJson(jsonObject);
            }
            catch (JSONException ignored) {
                card = null;
            }
            return card;
        }

        @JvmStatic
        @Nullable
        public final Card fromJson(@Nullable JSONObject jsonObject) {
            if (jsonObject == null || Intrinsics.areEqual((Object)Card.VALUE_CARD, (Object)jsonObject.optString(Card.FIELD_OBJECT)) ^ true) {
                return null;
            }
            Integer n = StripeJsonUtils.INSTANCE.optInteger$stripe_release(jsonObject, Card.FIELD_EXP_MONTH);
            Integer n2 = n != null ? n : -1;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            Integer expMonth = !(it < 1 || it > 12) ? n2 : null;
            Integer n3 = StripeJsonUtils.INSTANCE.optInteger$stripe_release(jsonObject, Card.FIELD_EXP_YEAR);
            Integer n4 = n3 != null ? n3 : -1;
            bl2 = false;
            boolean bl4 = false;
            int it2 = ((Number)n4).intValue();
            boolean bl5 = false;
            Integer expYear = !(it2 < 0) ? n4 : null;
            return new Builder(null, expMonth, expYear, null).addressCity(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_CITY)).addressLine1(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_LINE1)).addressLine1Check(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_LINE1_CHECK)).addressLine2(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_LINE2)).addressCountry(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_COUNTRY)).addressState(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_STATE)).addressZip(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_ZIP)).addressZipCheck(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_ZIP_CHECK)).brand(this.asCardBrand(StripeJsonUtils.optString(jsonObject, Card.FIELD_BRAND))).country(StripeJsonUtils.INSTANCE.optCountryCode$stripe_release(jsonObject, Card.FIELD_COUNTRY)).customer(StripeJsonUtils.optString(jsonObject, Card.FIELD_CUSTOMER)).currency(StripeJsonUtils.optCurrency$stripe_release(jsonObject, Card.FIELD_CURRENCY)).cvcCheck(StripeJsonUtils.optString(jsonObject, Card.FIELD_CVC_CHECK)).funding(this.asFundingType(StripeJsonUtils.optString(jsonObject, Card.FIELD_FUNDING))).fingerprint(StripeJsonUtils.optString(jsonObject, Card.FIELD_FINGERPRINT)).id(StripeJsonUtils.optString(jsonObject, Card.FIELD_ID)).last4(StripeJsonUtils.optString(jsonObject, Card.FIELD_LAST4)).name(StripeJsonUtils.optString(jsonObject, Card.FIELD_NAME)).tokenizationMethod(StripeJsonUtils.optString(jsonObject, Card.FIELD_TOKENIZATION_METHOD)).metadata(StripeJsonUtils.INSTANCE.optHash$stripe_release(jsonObject, Card.FIELD_METADATA)).build();
        }

        @JvmStatic
        @NotNull
        public final Card create(@Nullable String number, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String cvc) {
            return new Builder(number, expMonth, expYear, cvc).build();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

