/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import com.stripe.android.ApiVersion;
import com.stripe.android.EphemeralKey;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.EphemeralKeyUpdateListener;
import com.stripe.android.OperationIdFactory;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000  2\u00020\u0001:\u0003\u001f !B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0018J:\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0018H\u0002J \u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/stripe/android/EphemeralKeyManager;", "", "ephemeralKeyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "listener", "Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;", "timeBufferInSeconds", "", "overrideCalendar", "Ljava/util/Calendar;", "operationIdFactory", "Lcom/stripe/android/OperationIdFactory;", "shouldPrefetchEphemeralKey", "", "(Lcom/stripe/android/EphemeralKeyProvider;Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;JLjava/util/Calendar;Lcom/stripe/android/OperationIdFactory;Z)V", "apiVersion", "", "ephemeralKey", "Lcom/stripe/android/EphemeralKey;", "retrieveEphemeralKey", "", "operationId", "actionString", "arguments", "", "updateKey", "key", "updateKeyError", "errorCode", "", "errorMessage", "ClientKeyUpdateListener", "Companion", "KeyManagerListener", "stripe_release"})
public final class EphemeralKeyManager {
    private final String apiVersion;
    private EphemeralKey ephemeralKey;
    private final EphemeralKeyProvider ephemeralKeyProvider;
    private final KeyManagerListener listener;
    private final long timeBufferInSeconds;
    private final Calendar overrideCalendar;
    public static final Companion Companion = new Companion(null);

    public final void retrieveEphemeralKey(@NotNull String operationId, @Nullable String actionString, @Nullable Map<String, ? extends Object> arguments) {
        Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
        EphemeralKey ephemeralKey = this.ephemeralKey;
        if (ephemeralKey == null || Companion.shouldRefreshKey(ephemeralKey, this.timeBufferInSeconds, this.overrideCalendar)) {
            this.ephemeralKeyProvider.createEphemeralKey(this.apiVersion, new ClientKeyUpdateListener(this, operationId, actionString, arguments));
        } else {
            this.listener.onKeyUpdate(ephemeralKey, operationId, actionString, arguments);
        }
    }

    private final void updateKey(String operationId, String key, String actionString, Map<String, ? extends Object> arguments) {
        if (key == null) {
            this.listener.onKeyError(operationId, 500, "EphemeralKeyUpdateListener.onKeyUpdate was called with a null value");
            return;
        }
        try {
            EphemeralKey ephemeralKey;
            this.ephemeralKey = ephemeralKey = EphemeralKey.Companion.fromJson$stripe_release(new JSONObject(key));
            this.listener.onKeyUpdate(ephemeralKey, operationId, actionString, arguments);
        }
        catch (JSONException e) {
            this.listener.onKeyError(operationId, 500, "EphemeralKeyUpdateListener.onKeyUpdate was passed " + "a value that could not be JSON parsed: [" + e.getLocalizedMessage() + "]. " + "The raw body from Stripe's response should be passed.");
        }
        catch (Exception e) {
            this.listener.onKeyError(operationId, 500, "EphemeralKeyUpdateListener.onKeyUpdate was passed " + "a JSON String that was invalid: [" + e.getLocalizedMessage() + "]. " + "The raw body from Stripe's response should be passed.");
        }
    }

    private final void updateKeyError(String operationId, int errorCode, String errorMessage) {
        this.ephemeralKey = null;
        this.listener.onKeyError(operationId, errorCode, errorMessage);
    }

    public EphemeralKeyManager(@NotNull EphemeralKeyProvider ephemeralKeyProvider, @NotNull KeyManagerListener listener, long timeBufferInSeconds, @Nullable Calendar overrideCalendar, @NotNull OperationIdFactory operationIdFactory, boolean shouldPrefetchEphemeralKey) {
        Intrinsics.checkParameterIsNotNull((Object)ephemeralKeyProvider, (String)"ephemeralKeyProvider");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)operationIdFactory, (String)"operationIdFactory");
        this.ephemeralKeyProvider = ephemeralKeyProvider;
        this.listener = listener;
        this.timeBufferInSeconds = timeBufferInSeconds;
        this.overrideCalendar = overrideCalendar;
        this.apiVersion = ApiVersion.Companion.get$stripe_release().getCode$stripe_release();
        if (shouldPrefetchEphemeralKey) {
            this.retrieveEphemeralKey(operationIdFactory.create(), null, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b`\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H&J8\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000eH&\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;", "", "onKeyError", "", "operationId", "", "errorCode", "", "errorMessage", "onKeyUpdate", "ephemeralKey", "Lcom/stripe/android/EphemeralKey;", "action", "arguments", "", "stripe_release"})
    public static interface KeyManagerListener {
        public void onKeyUpdate(@NotNull EphemeralKey var1, @NotNull String var2, @Nullable String var3, @Nullable Map<String, ? extends Object> var4);

        public void onKeyError(@NotNull String var1, int var2, @NotNull String var3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/EphemeralKeyManager$ClientKeyUpdateListener;", "Lcom/stripe/android/EphemeralKeyUpdateListener;", "ephemeralKeyManager", "Lcom/stripe/android/EphemeralKeyManager;", "operationId", "", "actionString", "arguments", "", "", "(Lcom/stripe/android/EphemeralKeyManager;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "onKeyUpdate", "", "stripeResponseJson", "onKeyUpdateFailure", "responseCode", "", "message", "stripe_release"})
    private static final class ClientKeyUpdateListener
    implements EphemeralKeyUpdateListener {
        private final EphemeralKeyManager ephemeralKeyManager;
        private final String operationId;
        private final String actionString;
        private final Map<String, Object> arguments;

        @Override
        public void onKeyUpdate(@NotNull String stripeResponseJson) {
            Intrinsics.checkParameterIsNotNull((Object)stripeResponseJson, (String)"stripeResponseJson");
            this.ephemeralKeyManager.updateKey(this.operationId, stripeResponseJson, this.actionString, this.arguments);
        }

        @Override
        public void onKeyUpdateFailure(int responseCode, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.ephemeralKeyManager.updateKeyError(this.operationId, responseCode, message);
        }

        public ClientKeyUpdateListener(@NotNull EphemeralKeyManager ephemeralKeyManager, @NotNull String operationId, @Nullable String actionString, @Nullable Map<String, ? extends Object> arguments) {
            Intrinsics.checkParameterIsNotNull((Object)ephemeralKeyManager, (String)"ephemeralKeyManager");
            Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
            this.ephemeralKeyManager = ephemeralKeyManager;
            this.operationId = operationId;
            this.actionString = actionString;
            this.arguments = arguments;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/EphemeralKeyManager$Companion;", "", "()V", "shouldRefreshKey", "", "key", "Lcom/stripe/android/EphemeralKey;", "bufferInSeconds", "", "proxyCalendar", "Ljava/util/Calendar;", "stripe_release"})
    public static final class Companion {
        public final boolean shouldRefreshKey(@Nullable EphemeralKey key, long bufferInSeconds, @Nullable Calendar proxyCalendar) {
            Calendar now;
            if (key == null) {
                return true;
            }
            Calendar calendar = proxyCalendar;
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            Calendar calendar2 = now = calendar;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"now");
            long nowInSeconds = TimeUnit.MILLISECONDS.toSeconds(calendar2.getTimeInMillis());
            long nowPlusBuffer = nowInSeconds + bufferInSeconds;
            return key.getExpires$stripe_release() < nowPlusBuffer;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

