/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.wallets;

import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.wallets.AmexExpressCheckoutWallet;
import com.stripe.android.model.wallets.ApplePayWallet;
import com.stripe.android.model.wallets.GooglePayWallet;
import com.stripe.android.model.wallets.MasterpassWallet;
import com.stripe.android.model.wallets.SamsungPayWallet;
import com.stripe.android.model.wallets.VisaCheckoutWallet;
import com.stripe.android.model.wallets.Wallet;
import com.stripe.android.model.wallets.WalletFactory$WhenMappings;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/wallets/WalletFactory;", "", "()V", "create", "Lcom/stripe/android/model/wallets/Wallet;", "walletType", "Lcom/stripe/android/model/wallets/Wallet$Type;", "walletJson", "Lorg/json/JSONObject;", "stripe_release"})
public final class WalletFactory {
    @Nullable
    public final Wallet create(@Nullable JSONObject walletJson) {
        if (walletJson == null) {
            return null;
        }
        Wallet.Type type = Wallet.Type.Companion.fromCode$stripe_release(StripeJsonUtils.optString(walletJson, "type"));
        if (type == null) {
            return null;
        }
        Wallet.Type walletType = type;
        return this.create(walletType, walletJson);
    }

    private final Wallet create(Wallet.Type walletType, JSONObject walletJson) {
        JSONObject jSONObject = walletJson.optJSONObject(walletType.getCode());
        if (jSONObject == null) {
            return null;
        }
        JSONObject walletTypeJson = jSONObject;
        Wallet.Builder walletBuilder = null;
        switch (WalletFactory$WhenMappings.$EnumSwitchMapping$0[walletType.ordinal()]) {
            case 1: {
                walletBuilder = AmexExpressCheckoutWallet.Companion.fromJson$stripe_release();
                break;
            }
            case 2: {
                walletBuilder = ApplePayWallet.Companion.fromJson$stripe_release();
                break;
            }
            case 3: {
                walletBuilder = GooglePayWallet.Companion.fromJson$stripe_release();
                break;
            }
            case 4: {
                walletBuilder = MasterpassWallet.Companion.fromJson$stripe_release(walletTypeJson);
                break;
            }
            case 5: {
                walletBuilder = SamsungPayWallet.Companion.fromJson$stripe_release();
                break;
            }
            case 6: {
                walletBuilder = VisaCheckoutWallet.Companion.fromJson$stripe_release(walletTypeJson);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return walletBuilder.setDynamicLast4(StripeJsonUtils.optString(walletJson, "dynamic_last4")).build$stripe_release();
    }
}

