/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.R;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentFlowPagerEnum;
import com.stripe.android.view.SelectShippingMethodWidget;
import com.stripe.android.view.ShippingInfoWidget;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u001e\u001a\u00020\u0013J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0019H\u0016J\u000e\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u000fJ \u0010%\u001a\u00020\u00132\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00112\b\u0010\t\u001a\u0004\u0018\u00010\nJ\b\u0010&\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/stripe/android/view/PaymentFlowPagerAdapter;", "Landroidx/viewpager/widget/PagerAdapter;", "context", "Landroid/content/Context;", "paymentSessionConfig", "Lcom/stripe/android/PaymentSessionConfig;", "customerSession", "Lcom/stripe/android/CustomerSession;", "(Landroid/content/Context;Lcom/stripe/android/PaymentSessionConfig;Lcom/stripe/android/CustomerSession;)V", "defaultShippingMethod", "Lcom/stripe/android/model/ShippingMethod;", "pages", "", "Lcom/stripe/android/view/PaymentFlowPagerEnum;", "shippingInfoSaved", "", "validShippingMethods", "", "destroyItem", "", "collection", "Landroid/view/ViewGroup;", "position", "", "view", "", "getCount", "getPageAt", "getPageTitle", "", "hideShippingPage", "instantiateItem", "isViewFromObject", "Landroid/view/View;", "o", "setShippingInfoSaved", "addressSaved", "setShippingMethods", "shouldAddShippingScreen", "stripe_release"})
public final class PaymentFlowPagerAdapter
extends PagerAdapter {
    private final List<PaymentFlowPagerEnum> pages;
    private boolean shippingInfoSaved;
    private List<ShippingMethod> validShippingMethods;
    private ShippingMethod defaultShippingMethod;
    private final Context context;
    private final PaymentSessionConfig paymentSessionConfig;
    private final CustomerSession customerSession;

    private final boolean shouldAddShippingScreen() {
        return this.paymentSessionConfig.isShippingMethodRequired() && (!this.paymentSessionConfig.isShippingInfoRequired() || this.shippingInfoSaved) && !this.pages.contains((Object)PaymentFlowPagerEnum.SHIPPING_METHOD);
    }

    public final void setShippingInfoSaved(boolean addressSaved) {
        this.shippingInfoSaved = addressSaved;
        if (this.shouldAddShippingScreen()) {
            this.pages.add(PaymentFlowPagerEnum.SHIPPING_METHOD);
        }
        this.notifyDataSetChanged();
    }

    public final void setShippingMethods(@Nullable List<ShippingMethod> validShippingMethods, @Nullable ShippingMethod defaultShippingMethod) {
        this.validShippingMethods = validShippingMethods;
        this.defaultShippingMethod = defaultShippingMethod;
    }

    public final void hideShippingPage() {
        this.pages.remove((Object)PaymentFlowPagerEnum.SHIPPING_METHOD);
        this.notifyDataSetChanged();
    }

    @NotNull
    public Object instantiateItem(@NotNull ViewGroup collection, int position) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        PaymentFlowPagerEnum paymentFlowPagerEnum = this.pages.get(position);
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        View view = inflater.inflate(paymentFlowPagerEnum.getLayoutResId(), collection, false);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup layout2 = (ViewGroup)view;
        if (paymentFlowPagerEnum == PaymentFlowPagerEnum.SHIPPING_METHOD) {
            this.customerSession.addProductUsageTokenIfValid("ShippingMethodScreen");
            SelectShippingMethodWidget selectShippingMethodWidget = (SelectShippingMethodWidget)layout2.findViewById(R.id.select_shipping_method_widget);
            selectShippingMethodWidget.setShippingMethods(this.validShippingMethods, this.defaultShippingMethod);
        }
        if (paymentFlowPagerEnum == PaymentFlowPagerEnum.SHIPPING_INFO) {
            this.customerSession.addProductUsageTokenIfValid("ShippingInfoScreen");
            ShippingInfoWidget shippingInfoWidget = (ShippingInfoWidget)layout2.findViewById(R.id.shipping_info_widget);
            shippingInfoWidget.setHiddenFields(this.paymentSessionConfig.getHiddenShippingInfoFields());
            shippingInfoWidget.setOptionalFields(this.paymentSessionConfig.getOptionalShippingInfoFields());
            shippingInfoWidget.populateShippingInfo(this.paymentSessionConfig.getPrepopulatedShippingInfo());
        }
        collection.addView((View)layout2);
        return layout2;
    }

    public void destroyItem(@NotNull ViewGroup collection, int position, @NotNull Object view) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        collection.removeView((View)view);
    }

    public int getCount() {
        return this.pages.size();
    }

    @Nullable
    public final PaymentFlowPagerEnum getPageAt(int position) {
        return position < this.pages.size() ? this.pages.get(position) : null;
    }

    public boolean isViewFromObject(@NotNull View view, @NotNull Object o) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        return view == o;
    }

    @Nullable
    public CharSequence getPageTitle(int position) {
        return this.context.getString(this.pages.get(position).getTitleResId());
    }

    public PaymentFlowPagerAdapter(@NotNull Context context, @NotNull PaymentSessionConfig paymentSessionConfig, @NotNull CustomerSession customerSession) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)paymentSessionConfig, (String)"paymentSessionConfig");
        Intrinsics.checkParameterIsNotNull((Object)customerSession, (String)"customerSession");
        this.context = context;
        this.paymentSessionConfig = paymentSessionConfig;
        this.customerSession = customerSession;
        this.validShippingMethods = new ArrayList();
        this.pages = new ArrayList();
        if (this.paymentSessionConfig.isShippingInfoRequired()) {
            this.pages.add(PaymentFlowPagerEnum.SHIPPING_INFO);
        }
        if (this.shouldAddShippingScreen()) {
            this.pages.add(PaymentFlowPagerEnum.SHIPPING_METHOD);
        }
    }
}

