/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.Logger;
import com.stripe.android.PaymentController;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.SetupIntentResult;
import com.stripe.android.StripeApiRepository;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.StripeRepository;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.AccountParams;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.CvcTokenParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.PiiTokenParams;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Token;
import com.stripe.android.view.AuthActivityStarter;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 X2\u00020\u0001:\u0005XYZ[\\B-\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB9\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eB1\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0011B9\b\u0000\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0005J\u0016\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005J\u0016\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0005J\u0016\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0016\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$J\u0016\u0010\"\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010#\u001a\u00020$H\u0007J\u001c\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+J\u0010\u0010-\u001a\u0004\u0018\u00010,2\u0006\u0010(\u001a\u00020)J\u001c\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u0002002\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+J\u0010\u00101\u001a\u0004\u0018\u00010,2\u0006\u0010/\u001a\u000200J\u0010\u00102\u001a\u0004\u0018\u00010,2\u0006\u00103\u001a\u000204J\u001e\u00105\u001a\u00020\u00162\b\b\u0001\u00106\u001a\u00020\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+J\u0010\u00107\u001a\u0004\u0018\u00010,2\u0006\u00106\u001a\u00020\u0005J\u001c\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020:2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020;0+J\u0010\u0010<\u001a\u0004\u0018\u00010;2\u0006\u00109\u001a\u00020:J\u001c\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u00020\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+J\u0010\u0010?\u001a\u0004\u0018\u00010,2\u0006\u0010>\u001a\u00020\u0005J\u001c\u0010@\u001a\u00020\u00162\u0006\u0010A\u001a\u00020B2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020C0+J\u0010\u0010D\u001a\u0004\u0018\u00010C2\u0006\u0010E\u001a\u00020BJ\u001c\u0010F\u001a\u00020\u00162\u0006\u00103\u001a\u0002042\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+J2\u0010G\u001a\u00020\u00162\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010I2\u0006\u0010J\u001a\u00020\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002J\u0012\u0010K\u001a\u0004\u0018\u00010,2\u0006\u00103\u001a\u000204H\u0007J&\u0010L\u001a\u00020\b2\u0006\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u00010P2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020Q0+J&\u0010R\u001a\u00020\b2\u0006\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u00010P2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020S0+J\u0010\u0010T\u001a\u0004\u0018\u00010!2\u0006\u0010\u0019\u001a\u00020\u0005J\u0010\u0010U\u001a\u0004\u0018\u00010&2\u0006\u0010\u0019\u001a\u00020\u0005J\u001c\u0010V\u001a\u0004\u0018\u00010C2\b\b\u0001\u0010W\u001a\u00020\u00052\b\b\u0001\u0010\u0019\u001a\u00020\u0005R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/stripe/android/Stripe;", "", "context", "Landroid/content/Context;", "publishableKey", "", "stripeAccountId", "enableLogging", "", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Z)V", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "stripeNetworkUtils", "Lcom/stripe/android/StripeNetworkUtils;", "(Landroid/content/Context;Lcom/stripe/android/StripeRepository;Lcom/stripe/android/StripeNetworkUtils;Ljava/lang/String;Ljava/lang/String;Z)V", "paymentController", "Lcom/stripe/android/PaymentController;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/StripeNetworkUtils;Lcom/stripe/android/PaymentController;Ljava/lang/String;Ljava/lang/String;)V", "tokenCreator", "Lcom/stripe/android/Stripe$TokenCreator;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/StripeNetworkUtils;Lcom/stripe/android/PaymentController;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/Stripe$TokenCreator;)V", "authenticatePayment", "", "activity", "Landroid/app/Activity;", "clientSecret", "fragment", "Landroidx/fragment/app/Fragment;", "authenticateSetup", "confirmPayment", "confirmPaymentIntentParams", "Lcom/stripe/android/model/ConfirmPaymentIntentParams;", "confirmPaymentIntentSynchronous", "Lcom/stripe/android/model/PaymentIntent;", "confirmSetupIntent", "confirmSetupIntentParams", "Lcom/stripe/android/model/ConfirmSetupIntentParams;", "confirmSetupIntentSynchronous", "Lcom/stripe/android/model/SetupIntent;", "createAccountToken", "accountParams", "Lcom/stripe/android/model/AccountParams;", "callback", "Lcom/stripe/android/ApiResultCallback;", "Lcom/stripe/android/model/Token;", "createAccountTokenSynchronous", "createBankAccountToken", "bankAccount", "Lcom/stripe/android/model/BankAccount;", "createBankAccountTokenSynchronous", "createCardTokenSynchronous", "card", "Lcom/stripe/android/model/Card;", "createCvcUpdateToken", "cvc", "createCvcUpdateTokenSynchronous", "createPaymentMethod", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "Lcom/stripe/android/model/PaymentMethod;", "createPaymentMethodSynchronous", "createPiiToken", "personalId", "createPiiTokenSynchronous", "createSource", "sourceParams", "Lcom/stripe/android/model/SourceParams;", "Lcom/stripe/android/model/Source;", "createSourceSynchronous", "params", "createToken", "createTokenFromParams", "tokenParams", "", "tokenType", "createTokenSynchronous", "onPaymentResult", "requestCode", "", "data", "Landroid/content/Intent;", "Lcom/stripe/android/PaymentIntentResult;", "onSetupResult", "Lcom/stripe/android/SetupIntentResult;", "retrievePaymentIntentSynchronous", "retrieveSetupIntentSynchronous", "retrieveSourceSynchronous", "sourceId", "Companion", "CreatePaymentMethodTask", "CreateSourceTask", "CreateTokenTask", "TokenCreator", "stripe_release"})
public final class Stripe {
    private final String publishableKey;
    private final StripeRepository stripeRepository;
    private final StripeNetworkUtils stripeNetworkUtils;
    private final PaymentController paymentController;
    private final String stripeAccountId;
    private final TokenCreator tokenCreator;
    @JvmField
    @NotNull
    public static final String API_VERSION;
    @NotNull
    public static final String VERSION = "AndroidBindings/11.3.0";
    private static AppInfo appInfo;
    private static boolean advancedFraudSignalsEnabled;
    public static final Companion Companion;

    public final void confirmPayment(@NotNull Activity activity, @NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        this.paymentController.startConfirmAndAuth(AuthActivityStarter.Host.Companion.create(activity), confirmPaymentIntentParams, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    public final void confirmPayment(@NotNull Fragment fragment, @NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        this.paymentController.startConfirmAndAuth(AuthActivityStarter.Host.Companion.create(fragment), confirmPaymentIntentParams, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    public final void authenticatePayment(@NotNull Activity activity, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create(activity), clientSecret, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    public final void authenticatePayment(@NotNull Fragment fragment, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create(fragment), clientSecret, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    public final boolean onPaymentResult(int requestCode, @Nullable Intent data, @NotNull ApiResultCallback<PaymentIntentResult> callback) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (data != null && this.paymentController.shouldHandlePaymentResult(requestCode, data)) {
            this.paymentController.handlePaymentResult(data, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId), callback);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final PaymentIntent retrievePaymentIntentSynchronous(@NotNull String clientSecret) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        return this.stripeRepository.retrievePaymentIntent(clientSecret, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    @Deprecated(message="use {@link #confirmPayment(Activity, ConfirmPaymentIntentParams)}")
    @Nullable
    public final PaymentIntent confirmPaymentIntentSynchronous(@NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        return this.stripeRepository.confirmPaymentIntent(confirmPaymentIntentParams, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    public final void confirmSetupIntent(@NotNull Activity activity, @NotNull ConfirmSetupIntentParams confirmSetupIntentParams) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)confirmSetupIntentParams, (String)"confirmSetupIntentParams");
        this.paymentController.startConfirmAndAuth(AuthActivityStarter.Host.Companion.create(activity), confirmSetupIntentParams, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    public final void confirmSetupIntent(@NotNull Fragment fragment, @NotNull ConfirmSetupIntentParams confirmSetupIntentParams) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)confirmSetupIntentParams, (String)"confirmSetupIntentParams");
        this.paymentController.startConfirmAndAuth(AuthActivityStarter.Host.Companion.create(fragment), confirmSetupIntentParams, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    public final void authenticateSetup(@NotNull Activity activity, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create(activity), clientSecret, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    public final void authenticateSetup(@NotNull Fragment fragment, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create(fragment), clientSecret, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    public final boolean onSetupResult(int requestCode, @Nullable Intent data, @NotNull ApiResultCallback<SetupIntentResult> callback) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (data != null && this.paymentController.shouldHandleSetupResult(requestCode, data)) {
            this.paymentController.handleSetupResult(data, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId), callback);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final SetupIntent retrieveSetupIntentSynchronous(@NotNull String clientSecret) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        return this.stripeRepository.retrieveSetupIntent(clientSecret, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    @Deprecated(message="use {@link #confirmSetupIntent(Activity, ConfirmSetupIntentParams)}")
    @Nullable
    public final SetupIntent confirmSetupIntentSynchronous(@NotNull ConfirmSetupIntentParams confirmSetupIntentParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)confirmSetupIntentParams, (String)"confirmSetupIntentParams");
        return this.stripeRepository.confirmSetupIntent(confirmSetupIntentParams, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    public final void createPaymentMethod(@NotNull PaymentMethodCreateParams paymentMethodCreateParams, @NotNull ApiResultCallback<PaymentMethod> callback) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodCreateParams, (String)"paymentMethodCreateParams");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new CreatePaymentMethodTask(this.stripeRepository, paymentMethodCreateParams, this.publishableKey, this.stripeAccountId, callback).execute(new Void[0]);
    }

    @Nullable
    public final PaymentMethod createPaymentMethodSynchronous(@NotNull PaymentMethodCreateParams paymentMethodCreateParams) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodCreateParams, (String)"paymentMethodCreateParams");
        return this.stripeRepository.createPaymentMethod(paymentMethodCreateParams, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    public final void createSource(@NotNull SourceParams sourceParams, @NotNull ApiResultCallback<Source> callback) {
        Intrinsics.checkParameterIsNotNull((Object)sourceParams, (String)"sourceParams");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new CreateSourceTask(this.stripeRepository, sourceParams, this.publishableKey, this.stripeAccountId, callback).execute(new Void[0]);
    }

    @Nullable
    public final Source createSourceSynchronous(@NotNull SourceParams params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        return this.stripeRepository.createSource(params, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    @Nullable
    public final Source retrieveSourceSynchronous(@Size(min=1L) @NotNull String sourceId, @Size(min=1L) @NotNull String clientSecret) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        return this.stripeRepository.retrieveSource(sourceId, clientSecret, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId));
    }

    public final void createAccountToken(@NotNull AccountParams accountParams, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)accountParams, (String)"accountParams");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Map params = MapsKt.plus(accountParams.toParamMap(), this.stripeNetworkUtils.createUidParams());
        this.createTokenFromParams(params, "account", callback);
    }

    @Nullable
    public final Token createAccountTokenSynchronous(@NotNull AccountParams accountParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Token token;
        Intrinsics.checkParameterIsNotNull((Object)accountParams, (String)"accountParams");
        try {
            token = this.stripeRepository.createToken(accountParams.toParamMap(), ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId), "account");
        }
        catch (CardException exception) {
            token = null;
        }
        return token;
    }

    public final void createBankAccountToken(@NotNull BankAccount bankAccount, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)bankAccount, (String)"bankAccount");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Map params = MapsKt.plus(bankAccount.toParamMap(), this.stripeNetworkUtils.createUidParams());
        this.createTokenFromParams(params, "bank_account", callback);
    }

    @Nullable
    public final Token createBankAccountTokenSynchronous(@NotNull BankAccount bankAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)bankAccount, (String)"bankAccount");
        Map params = MapsKt.plus(bankAccount.toParamMap(), this.stripeNetworkUtils.createUidParams());
        return this.stripeRepository.createToken(params, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId), "bank_account");
    }

    public final void createPiiToken(@NotNull String personalId, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)personalId, (String)"personalId");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createTokenFromParams(new PiiTokenParams(personalId).toParamMap(), "pii", callback);
    }

    @Nullable
    public final Token createPiiTokenSynchronous(@NotNull String personalId) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)personalId, (String)"personalId");
        return this.stripeRepository.createToken(new PiiTokenParams(personalId).toParamMap(), ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId), "pii");
    }

    public final void createToken(@NotNull Card card, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createTokenFromParams(this.stripeNetworkUtils.createCardTokenParams(card), "card", callback);
    }

    @Nullable
    public final Token createCardTokenSynchronous(@NotNull Card card) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        return this.stripeRepository.createToken(this.stripeNetworkUtils.createCardTokenParams(card), ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId), "card");
    }

    @Deprecated(message="Use createCardTokenSynchronous()")
    @Nullable
    public final Token createTokenSynchronous(@NotNull Card card) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        return this.stripeRepository.createToken(this.stripeNetworkUtils.createCardTokenParams(card), ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId), "card");
    }

    public final void createCvcUpdateToken(@Size(min=3L, max=4L) @NotNull String cvc, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)cvc, (String)"cvc");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createTokenFromParams(new CvcTokenParams(cvc).toParamMap(), "cvc_update", callback);
    }

    @Nullable
    public final Token createCvcUpdateTokenSynchronous(@NotNull String cvc) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)cvc, (String)"cvc");
        return this.stripeRepository.createToken(new CvcTokenParams(cvc).toParamMap(), ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId), "cvc_update");
    }

    private final void createTokenFromParams(Map<String, ? extends Object> tokenParams, String tokenType, ApiResultCallback<Token> callback) {
        this.tokenCreator.create(tokenParams, ApiRequest.Options.Companion.create(this.publishableKey, this.stripeAccountId), tokenType, null, callback);
    }

    public Stripe(@NotNull StripeRepository stripeRepository, @NotNull StripeNetworkUtils stripeNetworkUtils, @NotNull PaymentController paymentController, @NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull TokenCreator tokenCreator) {
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)stripeNetworkUtils, (String)"stripeNetworkUtils");
        Intrinsics.checkParameterIsNotNull((Object)paymentController, (String)"paymentController");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull((Object)tokenCreator, (String)"tokenCreator");
        this.stripeRepository = stripeRepository;
        this.stripeNetworkUtils = stripeNetworkUtils;
        this.paymentController = paymentController;
        this.stripeAccountId = stripeAccountId;
        this.tokenCreator = tokenCreator;
        this.publishableKey = new ApiKeyValidator().requireValid(publishableKey);
    }

    @JvmOverloads
    public Stripe(@NotNull Context context, @NotNull String publishableKey, @Nullable String stripeAccountId, boolean enableLogging) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        Context context3 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context.applicationContext");
        StripeRepository stripeRepository = new StripeApiRepository(context3, appInfo, Logger.Companion.getInstance$stripe_release(enableLogging), null, null, null, null, null, null, 504, null);
        Context context4 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context4, (String)"context.applicationContext");
        this(context2, stripeRepository, new StripeNetworkUtils(context4), ApiKeyValidator.Companion.get().requireValid(publishableKey), stripeAccountId, enableLogging);
    }

    public /* synthetic */ Stripe(Context context, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(context, string, string2, bl);
    }

    @JvmOverloads
    public Stripe(@NotNull Context context, @NotNull String publishableKey, @Nullable String stripeAccountId) {
        this(context, publishableKey, stripeAccountId, false, 8, null);
    }

    @JvmOverloads
    public Stripe(@NotNull Context context, @NotNull String publishableKey) {
        this(context, publishableKey, null, false, 12, null);
    }

    private Stripe(Context context, StripeRepository stripeRepository, StripeNetworkUtils stripeNetworkUtils, String publishableKey, String stripeAccountId, boolean enableLogging) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        this(stripeRepository, stripeNetworkUtils, PaymentController.Companion.create(context2, stripeRepository, enableLogging), publishableKey, stripeAccountId);
    }

    public Stripe(final @NotNull StripeRepository stripeRepository, @NotNull StripeNetworkUtils stripeNetworkUtils, @NotNull PaymentController paymentController, @NotNull String publishableKey, @Nullable String stripeAccountId) {
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)stripeNetworkUtils, (String)"stripeNetworkUtils");
        Intrinsics.checkParameterIsNotNull((Object)paymentController, (String)"paymentController");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        this(stripeRepository, stripeNetworkUtils, paymentController, publishableKey, stripeAccountId, new TokenCreator(){

            @Override
            public void create(@NotNull Map<String, ? extends Object> params, @NotNull ApiRequest.Options options, @NotNull String tokenType, @Nullable Executor executor, @NotNull ApiResultCallback<Token> callback) {
                Intrinsics.checkParameterIsNotNull(params, (String)"params");
                Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                Intrinsics.checkParameterIsNotNull((Object)tokenType, (String)"tokenType");
                Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
                Companion.executeTask(executor, new CreateTokenTask(stripeRepository, params, options, tokenType, callback));
            }
        });
    }

    static {
        Companion = new Companion(null);
        API_VERSION = ApiVersion.Companion.get().getCode();
        advancedFraudSignalsEnabled = true;
    }

    @JvmStatic
    public static final void setAppInfo(@NotNull AppInfo appInfo) {
        Companion.setAppInfo(appInfo);
    }

    @JvmStatic
    @Nullable
    public static final AppInfo getAppInfo() {
        return Companion.getAppInfo();
    }

    public static final boolean getAdvancedFraudSignalsEnabled() {
        Companion companion = Companion;
        return advancedFraudSignalsEnabled;
    }

    public static final void setAdvancedFraudSignalsEnabled(boolean bl) {
        Companion companion = Companion;
        advancedFraudSignalsEnabled = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\ba\u0018\u00002\u00020\u0001JD\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH&\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/Stripe$TokenCreator;", "", "create", "", "params", "", "", "options", "Lcom/stripe/android/ApiRequest$Options;", "tokenType", "executor", "Ljava/util/concurrent/Executor;", "callback", "Lcom/stripe/android/ApiResultCallback;", "Lcom/stripe/android/model/Token;", "stripe_release"})
    @VisibleForTesting
    public static interface TokenCreator {
        public void create(@NotNull Map<String, ? extends Object> var1, @NotNull ApiRequest.Options var2, @NotNull String var3, @Nullable Executor var4, @NotNull ApiResultCallback<Token> var5);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0010\u00a2\u0006\u0002\b\u0010R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/Stripe$CreateSourceTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Source;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "sourceParams", "Lcom/stripe/android/model/SourceParams;", "publishableKey", "", "stripeAccount", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/SourceParams;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/ApiResultCallback;)V", "options", "Lcom/stripe/android/ApiRequest$Options;", "getResult", "getResult$stripe_release", "stripe_release"})
    private static final class CreateSourceTask
    extends ApiOperation<Source> {
        private final ApiRequest.Options options;
        private final StripeRepository stripeRepository;
        private final SourceParams sourceParams;

        @Override
        @Nullable
        public Source getResult$stripe_release() throws StripeException {
            return this.stripeRepository.createSource(this.sourceParams, this.options);
        }

        public CreateSourceTask(@NotNull StripeRepository stripeRepository, @NotNull SourceParams sourceParams, @NotNull String publishableKey, @Nullable String stripeAccount, @NotNull ApiResultCallback<Source> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)sourceParams, (String)"sourceParams");
            Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(callback);
            this.stripeRepository = stripeRepository;
            this.sourceParams = sourceParams;
            this.options = ApiRequest.Options.Companion.create(publishableKey, stripeAccount);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0010\u00a2\u0006\u0002\b\u0010R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/Stripe$CreatePaymentMethodTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/PaymentMethod;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "publishableKey", "", "stripeAccount", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/PaymentMethodCreateParams;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/ApiResultCallback;)V", "options", "Lcom/stripe/android/ApiRequest$Options;", "getResult", "getResult$stripe_release", "stripe_release"})
    private static final class CreatePaymentMethodTask
    extends ApiOperation<PaymentMethod> {
        private final ApiRequest.Options options;
        private final StripeRepository stripeRepository;
        private final PaymentMethodCreateParams paymentMethodCreateParams;

        @Override
        @Nullable
        public PaymentMethod getResult$stripe_release() throws StripeException {
            return this.stripeRepository.createPaymentMethod(this.paymentMethodCreateParams, this.options);
        }

        public CreatePaymentMethodTask(@NotNull StripeRepository stripeRepository, @NotNull PaymentMethodCreateParams paymentMethodCreateParams, @NotNull String publishableKey, @Nullable String stripeAccount, @NotNull ApiResultCallback<PaymentMethod> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)paymentMethodCreateParams, (String)"paymentMethodCreateParams");
            Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(callback);
            this.stripeRepository = stripeRepository;
            this.paymentMethodCreateParams = paymentMethodCreateParams;
            this.options = ApiRequest.Options.Companion.create(publishableKey, stripeAccount);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BA\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0010\u00a2\u0006\u0002\b\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/Stripe$CreateTokenTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Token;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "tokenParams", "", "", "", "options", "Lcom/stripe/android/ApiRequest$Options;", "tokenType", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Ljava/util/Map;Lcom/stripe/android/ApiRequest$Options;Ljava/lang/String;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "stripe_release"})
    private static final class CreateTokenTask
    extends ApiOperation<Token> {
        private final StripeRepository stripeRepository;
        private final Map<String, Object> tokenParams;
        private final ApiRequest.Options options;
        private final String tokenType;

        @Override
        @Nullable
        public Token getResult$stripe_release() throws StripeException {
            return this.stripeRepository.createToken(this.tokenParams, this.options, this.tokenType);
        }

        public CreateTokenTask(@NotNull StripeRepository stripeRepository, @NotNull Map<String, ? extends Object> tokenParams, @NotNull ApiRequest.Options options, @NotNull String tokenType, @NotNull ApiResultCallback<Token> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull(tokenParams, (String)"tokenParams");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            Intrinsics.checkParameterIsNotNull((Object)tokenType, (String)"tokenType");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(callback);
            this.stripeRepository = stripeRepository;
            this.tokenParams = tokenParams;
            this.options = options;
            this.tokenType = tokenType;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0012\u0002\b\u00030\u0014H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0007J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/Stripe$Companion;", "", "()V", "API_VERSION", "", "VERSION", "advancedFraudSignalsEnabled", "", "advancedFraudSignalsEnabled$annotations", "getAdvancedFraudSignalsEnabled", "()Z", "setAdvancedFraudSignalsEnabled", "(Z)V", "appInfo", "Lcom/stripe/android/AppInfo;", "executeTask", "", "executor", "Ljava/util/concurrent/Executor;", "task", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "getAppInfo", "setAppInfo", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        public final void setAppInfo(@NotNull AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)appInfo, (String)"appInfo");
            Stripe.appInfo = appInfo;
        }

        @JvmStatic
        @Nullable
        public final AppInfo getAppInfo() {
            return appInfo;
        }

        private final void executeTask(Executor executor, AsyncTask<Void, Void, ?> task) {
            if (executor != null) {
                task.executeOnExecutor(executor, (Object[])new Void[0]);
            } else {
                task.execute((Object[])new Void[0]);
            }
        }

        @JvmStatic
        public static /* synthetic */ void advancedFraudSignalsEnabled$annotations() {
        }

        public final boolean getAdvancedFraudSignalsEnabled() {
            return advancedFraudSignalsEnabled;
        }

        public final void setAdvancedFraudSignalsEnabled(boolean bl) {
            advancedFraudSignalsEnabled = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

