/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.AnalyticsDataFactory;
import com.stripe.android.AnalyticsRequest;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.Factory;
import com.stripe.android.FireAndForgetRequestExecutor;
import com.stripe.android.PaymentAuthConfig;
import com.stripe.android.PaymentAuthWebViewStarter;
import com.stripe.android.PaymentController;
import com.stripe.android.PaymentController$WhenMappings;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.PaymentRelayStarter;
import com.stripe.android.SetupIntentResult;
import com.stripe.android.Stripe3ds2AuthParams;
import com.stripe.android.Stripe3ds2CompletionStarter;
import com.stripe.android.StripeFireAndForgetRequestExecutor;
import com.stripe.android.StripeRepository;
import com.stripe.android.StripeSSLSocketFactory;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.ConfirmStripeIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.Stripe3ds2AuthResult;
import com.stripe.android.model.Stripe3ds2Fingerprint;
import com.stripe.android.model.Stripe3dsRedirect;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.stripe3ds2.init.ConfigParameters;
import com.stripe.android.stripe3ds2.init.StripeConfigParameters;
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2ServiceImpl;
import com.stripe.android.stripe3ds2.transaction.AuthenticationRequestParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.CompletionEvent;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.ProtocolErrorEvent;
import com.stripe.android.stripe3ds2.transaction.RuntimeErrorEvent;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.views.ChallengeProgressDialogActivity;
import com.stripe.android.view.AuthActivityStarter;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0010\u0018\u0000 62\u00020\u0001:\b456789:;B]\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0007J \u0010$\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J&\u0010%\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J&\u0010)\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020*0'H\u0016J\u001a\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u001a\u0010.\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J \u0010/\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00100\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u00101\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00102\u001a\u0002032\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/stripe/android/PaymentController;", "", "context", "Landroid/content/Context;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "enableLogging", "", "messageVersionRegistry", "Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;", "config", "Lcom/stripe/android/PaymentAuthConfig;", "threeDs2Service", "Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2Service;", "analyticsRequestExecutor", "Lcom/stripe/android/FireAndForgetRequestExecutor;", "analyticsDataFactory", "Lcom/stripe/android/AnalyticsDataFactory;", "challengeFlowStarter", "Lcom/stripe/android/PaymentController$ChallengeFlowStarter;", "(Landroid/content/Context;Lcom/stripe/android/StripeRepository;ZLcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;Lcom/stripe/android/PaymentAuthConfig;Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2Service;Lcom/stripe/android/FireAndForgetRequestExecutor;Lcom/stripe/android/AnalyticsDataFactory;Lcom/stripe/android/PaymentController$ChallengeFlowStarter;)V", "begin3ds2Auth", "", "host", "Lcom/stripe/android/view/AuthActivityStarter$Host;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "stripe3ds2Fingerprint", "Lcom/stripe/android/model/Stripe3ds2Fingerprint;", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "bypassAuth", "getClientSecret", "", "data", "Landroid/content/Intent;", "handleNextAction", "handlePaymentResult", "callback", "Lcom/stripe/android/ApiResultCallback;", "Lcom/stripe/android/PaymentIntentResult;", "handleSetupResult", "Lcom/stripe/android/SetupIntentResult;", "shouldHandlePaymentResult", "requestCode", "", "shouldHandleSetupResult", "startAuth", "clientSecret", "startConfirmAndAuth", "confirmStripeIntentParams", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "ChallengeFlowStarter", "ChallengeFlowStarterImpl", "Companion", "ConfirmStripeIntentCallback", "ConfirmStripeIntentTask", "PaymentAuth3ds2ChallengeStatusReceiver", "RetrieveIntentTask", "Stripe3ds2AuthCallback", "stripe_release"})
public class PaymentController {
    private final StripeRepository stripeRepository;
    private final boolean enableLogging;
    private final MessageVersionRegistry messageVersionRegistry;
    private final PaymentAuthConfig config;
    private final StripeThreeDs2Service threeDs2Service;
    private final FireAndForgetRequestExecutor analyticsRequestExecutor;
    private final AnalyticsDataFactory analyticsDataFactory;
    private final ChallengeFlowStarter challengeFlowStarter;
    public static final int PAYMENT_REQUEST_CODE = 50000;
    public static final int SETUP_REQUEST_CODE = 50001;
    public static final Companion Companion = new Companion(null);

    public void startConfirmAndAuth(@NotNull AuthActivityStarter.Host host, @NotNull ConfirmStripeIntentParams confirmStripeIntentParams, @NotNull ApiRequest.Options requestOptions) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)confirmStripeIntentParams, (String)"confirmStripeIntentParams");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        new ConfirmStripeIntentTask(this.stripeRepository, confirmStripeIntentParams, requestOptions, new ConfirmStripeIntentCallback(host, requestOptions, this, Companion.getRequestCode(confirmStripeIntentParams))).execute(new Void[0]);
    }

    public void startAuth(@NotNull AuthActivityStarter.Host host, @NotNull String clientSecret, @NotNull ApiRequest.Options requestOptions) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        new RetrieveIntentTask(this.stripeRepository, clientSecret, requestOptions, new ApiResultCallback<StripeIntent>(this, host, requestOptions){
            final /* synthetic */ PaymentController this$0;
            final /* synthetic */ AuthActivityStarter.Host $host;
            final /* synthetic */ ApiRequest.Options $requestOptions;

            public void onSuccess(@NotNull StripeIntent stripeIntent) {
                Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
                this.this$0.handleNextAction(this.$host, stripeIntent, this.$requestOptions);
            }

            public void onError(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                com.stripe.android.PaymentController$Companion.access$handleError(PaymentController.Companion, this.$host, 50000, e);
            }
            {
                this.this$0 = $outer;
                this.$host = $captured_local_variable$1;
                this.$requestOptions = $captured_local_variable$2;
            }
        }).execute(new Void[0]);
    }

    public boolean shouldHandlePaymentResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50000 && data != null;
    }

    public boolean shouldHandleSetupResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50001 && data != null;
    }

    public void handlePaymentResult(@NotNull Intent data, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<PaymentIntentResult> callback) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Serializable authException = data.getSerializableExtra("exception");
        if (authException instanceof Exception) {
            callback.onError((Exception)authException);
            return;
        }
        int flowOutcome = data.getIntExtra("flow_outcome", 0);
        new RetrieveIntentTask(this.stripeRepository, this.getClientSecret(data), requestOptions, new ApiResultCallback<StripeIntent>(callback, flowOutcome){
            final /* synthetic */ ApiResultCallback $callback;
            final /* synthetic */ int $flowOutcome;

            public void onSuccess(@NotNull StripeIntent stripeIntent) {
                Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
                if (stripeIntent instanceof PaymentIntent) {
                    this.$callback.onSuccess(new PaymentIntentResult((PaymentIntent)stripeIntent, this.$flowOutcome));
                }
            }

            public void onError(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$callback.onError(e);
            }
            {
                this.$callback = $captured_local_variable$0;
                this.$flowOutcome = $captured_local_variable$1;
            }
        }).execute(new Void[0]);
    }

    public void handleSetupResult(@NotNull Intent data, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<SetupIntentResult> callback) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Serializable authException = data.getSerializableExtra("exception");
        if (authException instanceof Exception) {
            callback.onError((Exception)authException);
            return;
        }
        int flowOutcome = data.getIntExtra("flow_outcome", 0);
        new RetrieveIntentTask(this.stripeRepository, this.getClientSecret(data), requestOptions, new ApiResultCallback<StripeIntent>(callback, flowOutcome){
            final /* synthetic */ ApiResultCallback $callback;
            final /* synthetic */ int $flowOutcome;

            public void onSuccess(@NotNull StripeIntent stripeIntent) {
                Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
                if (stripeIntent instanceof SetupIntent) {
                    this.$callback.onSuccess(new SetupIntentResult((SetupIntent)stripeIntent, this.$flowOutcome));
                }
            }

            public void onError(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$callback.onError(e);
            }
            {
                this.$callback = $captured_local_variable$0;
                this.$flowOutcome = $captured_local_variable$1;
            }
        }).execute(new Void[0]);
    }

    @VisibleForTesting
    @NotNull
    public final String getClientSecret(@NotNull Intent data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string2 = data.getStringExtra("client_secret");
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (string2 == null) {
            boolean bl4 = false;
            String string3 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public final void handleNextAction(@NotNull AuthActivityStarter.Host host, @NotNull StripeIntent stripeIntent, @NotNull ApiRequest.Options requestOptions) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        if (!stripeIntent.requiresAction()) {
            this.bypassAuth(host, stripeIntent);
            return;
        }
        StripeIntent.NextActionType nextActionType = stripeIntent.getNextActionType();
        if (nextActionType != null) {
            switch (PaymentController$WhenMappings.$EnumSwitchMapping$0[nextActionType.ordinal()]) {
                case 1: {
                    StripeIntent.SdkData sdkData = stripeIntent.getStripeSdkData();
                    StripeIntent.SdkData sdkData2 = sdkData;
                    if (sdkData2 != null && sdkData2.is3ds2()) {
                        String string2 = stripeIntent.getId();
                        String string3 = "3ds2_fingerprint";
                        AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
                        FireAndForgetRequestExecutor fireAndForgetRequestExecutor = this.analyticsRequestExecutor;
                        boolean bl = false;
                        String string4 = string2;
                        if (string4 == null) {
                            string4 = "";
                        }
                        String string5 = string4;
                        fireAndForgetRequestExecutor.executeAsync(AnalyticsRequest.create$default(analyticsDataFactory.createAuthParams(string3, string5, requestOptions.getApiKey()), requestOptions, null, 4, null));
                        try {
                            this.begin3ds2Auth(host, stripeIntent, Stripe3ds2Fingerprint.Companion.create(sdkData), requestOptions);
                            return;
                        }
                        catch (CertificateException e) {
                            PaymentController.Companion.handleError(host, PaymentController.Companion.getRequestCode(stripeIntent), e);
                            return;
                        }
                    }
                    StripeIntent.SdkData sdkData3 = sdkData;
                    if (sdkData3 != null && sdkData3.is3ds1()) {
                        String string6 = stripeIntent.getId();
                        String string7 = "3ds1_sdk";
                        AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
                        FireAndForgetRequestExecutor fireAndForgetRequestExecutor = this.analyticsRequestExecutor;
                        boolean bl = false;
                        String string8 = string6;
                        if (string8 == null) {
                            string8 = "";
                        }
                        String string9 = string8;
                        fireAndForgetRequestExecutor.executeAsync(AnalyticsRequest.create$default(analyticsDataFactory.createAuthParams(string7, string9, requestOptions.getApiKey()), requestOptions, null, 4, null));
                        int n = Companion.getRequestCode(stripeIntent);
                        String string10 = stripeIntent.getClientSecret();
                        if (string10 == null) {
                            string10 = "";
                        }
                        com.stripe.android.PaymentController$Companion.beginWebAuth$default(Companion, host, n, string10, Stripe3dsRedirect.Companion.create(sdkData).getUrl(), null, this.enableLogging, 16, null);
                        return;
                    }
                    this.bypassAuth(host, stripeIntent);
                    return;
                }
                case 2: {
                    String sdkData = stripeIntent.getId();
                    String string11 = "url_redirect_next_action";
                    AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
                    FireAndForgetRequestExecutor fireAndForgetRequestExecutor = this.analyticsRequestExecutor;
                    boolean bl = false;
                    String string12 = sdkData;
                    if (string12 == null) {
                        string12 = "";
                    }
                    String string13 = string12;
                    fireAndForgetRequestExecutor.executeAsync(AnalyticsRequest.create$default(analyticsDataFactory.createAuthParams(string11, string13, requestOptions.getApiKey()), requestOptions, null, 4, null));
                    StripeIntent.RedirectData redirectData = stripeIntent.getRedirectData();
                    int n = Companion.getRequestCode(stripeIntent);
                    String string14 = stripeIntent.getClientSecret();
                    if (string14 == null) {
                        string14 = "";
                    }
                    StripeIntent.RedirectData redirectData2 = redirectData;
                    StripeIntent.RedirectData redirectData3 = redirectData;
                    PaymentController.Companion.beginWebAuth(host, n, string14, String.valueOf(redirectData2 != null ? redirectData2.url : null), redirectData3 != null ? redirectData3.returnUrl : null, this.enableLogging);
                    return;
                }
            }
        }
        this.bypassAuth(host, stripeIntent);
    }

    private final void bypassAuth(AuthActivityStarter.Host host, StripeIntent stripeIntent) {
        new PaymentRelayStarter(host, Companion.getRequestCode(stripeIntent)).start(PaymentRelayStarter.Data.Companion.create(stripeIntent));
    }

    private final void begin3ds2Auth(AuthActivityStarter.Host host, StripeIntent stripeIntent, Stripe3ds2Fingerprint stripe3ds2Fingerprint, ApiRequest.Options requestOptions) {
        StripeIntent.RedirectData redirectData;
        Activity activity = host.getActivity();
        if (activity == null) {
            return;
        }
        Activity activity2 = activity;
        Transaction transaction = this.threeDs2Service.createTransaction(stripe3ds2Fingerprint.getDirectoryServer().getId(), this.messageVersionRegistry.getCurrent(), stripeIntent.isLiveMode(), stripe3ds2Fingerprint.getDirectoryServer().getNetworkName(), stripe3ds2Fingerprint.getDirectoryServerEncryption().getRootCerts(), stripe3ds2Fingerprint.getDirectoryServerEncryption().getDirectoryServerPublicKey(), stripe3ds2Fingerprint.getDirectoryServerEncryption().getKeyId());
        Context context = (Context)activity2;
        String string2 = stripe3ds2Fingerprint.getDirectoryServer().getNetworkName();
        PaymentAuthConfig.Stripe3ds2UiCustomization stripe3ds2UiCustomization = this.config.stripe3ds2Config.uiCustomization;
        Intrinsics.checkExpressionValueIsNotNull((Object)stripe3ds2UiCustomization, (String)"config.stripe3ds2Config.uiCustomization");
        StripeUiCustomization stripeUiCustomization = stripe3ds2UiCustomization.getUiCustomization();
        Intrinsics.checkExpressionValueIsNotNull((Object)stripeUiCustomization, (String)"config.stripe3ds2Config.\u2026omization.uiCustomization");
        ChallengeProgressDialogActivity.Companion.show(context, string2, false, stripeUiCustomization);
        StripeIntent.RedirectData redirectData2 = redirectData = stripeIntent.getRedirectData();
        String returnUrl = redirectData2 != null ? redirectData2.returnUrl : null;
        AuthenticationRequestParameters areqParams = transaction.getAuthenticationRequestParameters();
        int timeout = this.config.stripe3ds2Config.timeout;
        Stripe3ds2AuthParams authParams = new Stripe3ds2AuthParams(stripe3ds2Fingerprint.getSource(), areqParams.getSdkAppId(), areqParams.getSdkReferenceNumber(), areqParams.getSdkTransactionId(), areqParams.getDeviceData(), areqParams.getSdkEphemeralPublicKey(), areqParams.getMessageVersion(), timeout, returnUrl);
        String string3 = stripeIntent.getId();
        Stripe3ds2AuthParams stripe3ds2AuthParams = authParams;
        StripeRepository stripeRepository = this.stripeRepository;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            string4 = "";
        }
        String string5 = string4;
        stripeRepository.start3ds2Auth(stripe3ds2AuthParams, string5, requestOptions, new Stripe3ds2AuthCallback(host, this.stripeRepository, transaction, timeout, stripeIntent, stripe3ds2Fingerprint.getSource(), requestOptions, this.analyticsRequestExecutor, this.analyticsDataFactory, this.challengeFlowStarter, this.enableLogging));
    }

    @VisibleForTesting
    public PaymentController(@NotNull Context context, @NotNull StripeRepository stripeRepository, boolean enableLogging, @NotNull MessageVersionRegistry messageVersionRegistry, @NotNull PaymentAuthConfig config, @NotNull StripeThreeDs2Service threeDs2Service, @NotNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull ChallengeFlowStarter challengeFlowStarter) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)messageVersionRegistry, (String)"messageVersionRegistry");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)threeDs2Service, (String)"threeDs2Service");
        Intrinsics.checkParameterIsNotNull((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)analyticsDataFactory, (String)"analyticsDataFactory");
        Intrinsics.checkParameterIsNotNull((Object)challengeFlowStarter, (String)"challengeFlowStarter");
        this.stripeRepository = stripeRepository;
        this.enableLogging = enableLogging;
        this.messageVersionRegistry = messageVersionRegistry;
        this.config = config;
        this.threeDs2Service = threeDs2Service;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsDataFactory = analyticsDataFactory;
        this.challengeFlowStarter = challengeFlowStarter;
        ConfigParameters configParameters = (ConfigParameters)new StripeConfigParameters();
        PaymentAuthConfig.Stripe3ds2UiCustomization stripe3ds2UiCustomization = this.config.stripe3ds2Config.uiCustomization;
        Intrinsics.checkExpressionValueIsNotNull((Object)stripe3ds2UiCustomization, (String)"config.stripe3ds2Config.uiCustomization");
        this.threeDs2Service.initialize(context, configParameters, null, (UiCustomization)stripe3ds2UiCustomization.getUiCustomization());
    }

    public /* synthetic */ PaymentController(Context context, StripeRepository stripeRepository, boolean bl, MessageVersionRegistry messageVersionRegistry, PaymentAuthConfig paymentAuthConfig, StripeThreeDs2Service stripeThreeDs2Service, FireAndForgetRequestExecutor fireAndForgetRequestExecutor, AnalyticsDataFactory analyticsDataFactory, ChallengeFlowStarter challengeFlowStarter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            messageVersionRegistry = new MessageVersionRegistry();
        }
        if ((n & 0x10) != 0) {
            PaymentAuthConfig paymentAuthConfig2 = PaymentAuthConfig.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)paymentAuthConfig2, (String)"PaymentAuthConfig.get()");
            paymentAuthConfig = paymentAuthConfig2;
        }
        if ((n & 0x20) != 0) {
            stripeThreeDs2Service = (StripeThreeDs2Service)new StripeThreeDs2ServiceImpl(context, (SSLSocketFactory)new StripeSSLSocketFactory(), bl);
        }
        if ((n & 0x40) != 0) {
            fireAndForgetRequestExecutor = new StripeFireAndForgetRequestExecutor();
        }
        if ((n & 0x80) != 0) {
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            analyticsDataFactory = AnalyticsDataFactory.Companion.create(context2);
        }
        if ((n & 0x100) != 0) {
            challengeFlowStarter = new ChallengeFlowStarterImpl();
        }
        this(context, stripeRepository, bl, messageVersionRegistry, paymentAuthConfig, stripeThreeDs2Service, fireAndForgetRequestExecutor, analyticsDataFactory, challengeFlowStarter);
    }

    @JvmStatic
    public static final int getRequestCode(@NotNull StripeIntent intent) {
        return Companion.getRequestCode(intent);
    }

    @JvmStatic
    public static final int getRequestCode(@NotNull ConfirmStripeIntentParams params) {
        return Companion.getRequestCode(params);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PaymentController create(@NotNull Context context, @NotNull StripeRepository stripeRepository, boolean enableLogging) {
        return Companion.create(context, stripeRepository, enableLogging);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PaymentController create(@NotNull Context context, @NotNull StripeRepository stripeRepository) {
        return com.stripe.android.PaymentController$Companion.create$default(Companion, context, stripeRepository, false, 4, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0010\u00a2\u0006\u0002\b\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/PaymentController$RetrieveIntentTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/StripeIntent;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "clientSecret", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "stripe_release"})
    private static final class RetrieveIntentTask
    extends ApiOperation<StripeIntent> {
        private final StripeRepository stripeRepository;
        private final String clientSecret;
        private final ApiRequest.Options requestOptions;

        @Override
        @Nullable
        public StripeIntent getResult$stripe_release() throws StripeException {
            return StringsKt.startsWith$default((String)this.clientSecret, (String)"pi_", (boolean)false, (int)2, null) ? (StripeIntent)this.stripeRepository.retrievePaymentIntent(this.clientSecret, this.requestOptions) : (StringsKt.startsWith$default((String)this.clientSecret, (String)"seti_", (boolean)false, (int)2, null) ? (StripeIntent)this.stripeRepository.retrieveSetupIntent(this.clientSecret, this.requestOptions) : null);
        }

        public RetrieveIntentTask(@NotNull StripeRepository stripeRepository, @NotNull String clientSecret, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<StripeIntent> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(callback);
            this.stripeRepository = stripeRepository;
            this.clientSecret = clientSecret;
            this.requestOptions = requestOptions;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0010\u00a2\u0006\u0002\b\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/PaymentController$ConfirmStripeIntentTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/StripeIntent;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "params", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/ConfirmStripeIntentParams;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "stripe_release"})
    private static final class ConfirmStripeIntentTask
    extends ApiOperation<StripeIntent> {
        private final ConfirmStripeIntentParams params;
        private final StripeRepository stripeRepository;
        private final ApiRequest.Options requestOptions;

        @Override
        @Nullable
        public StripeIntent getResult$stripe_release() throws StripeException {
            ConfirmStripeIntentParams confirmStripeIntentParams = this.params;
            return confirmStripeIntentParams instanceof ConfirmPaymentIntentParams ? (StripeIntent)this.stripeRepository.confirmPaymentIntent((ConfirmPaymentIntentParams)this.params, this.requestOptions) : (confirmStripeIntentParams instanceof ConfirmSetupIntentParams ? (StripeIntent)this.stripeRepository.confirmSetupIntent((ConfirmSetupIntentParams)this.params, this.requestOptions) : null);
        }

        public ConfirmStripeIntentTask(@NotNull StripeRepository stripeRepository, @NotNull ConfirmStripeIntentParams params, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<StripeIntent> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(callback);
            this.stripeRepository = stripeRepository;
            this.requestOptions = requestOptions;
            this.params = params.withShouldUseStripeSdk(true);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/PaymentController$ConfirmStripeIntentCallback;", "Lcom/stripe/android/ApiResultCallback;", "Lcom/stripe/android/model/StripeIntent;", "host", "Lcom/stripe/android/view/AuthActivityStarter$Host;", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "paymentController", "Lcom/stripe/android/PaymentController;", "requestCode", "", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/PaymentController;I)V", "onError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "stripeIntent", "stripe_release"})
    private static final class ConfirmStripeIntentCallback
    implements ApiResultCallback<StripeIntent> {
        private final AuthActivityStarter.Host host;
        private final ApiRequest.Options requestOptions;
        private final PaymentController paymentController;
        private final int requestCode;

        @Override
        public void onSuccess(@NotNull StripeIntent stripeIntent) {
            Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
            this.paymentController.handleNextAction(this.host, stripeIntent, this.requestOptions);
        }

        @Override
        public void onError(@NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Companion.handleError(this.host, this.requestCode, e);
        }

        public ConfirmStripeIntentCallback(@NotNull AuthActivityStarter.Host host, @NotNull ApiRequest.Options requestOptions, @NotNull PaymentController paymentController, int requestCode) {
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull((Object)paymentController, (String)"paymentController");
            this.host = host;
            this.requestOptions = requestOptions;
            this.paymentController = paymentController;
            this.requestCode = requestCode;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B_\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019Bi\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u001a\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u00060!j\u0002`\"H\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0002H\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u001fH\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/stripe/android/PaymentController$Stripe3ds2AuthCallback;", "Lcom/stripe/android/ApiResultCallback;", "Lcom/stripe/android/model/Stripe3ds2AuthResult;", "host", "Lcom/stripe/android/view/AuthActivityStarter$Host;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "transaction", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "maxTimeout", "", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "sourceId", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "analyticsRequestExecutor", "Lcom/stripe/android/FireAndForgetRequestExecutor;", "analyticsDataFactory", "Lcom/stripe/android/AnalyticsDataFactory;", "challengeFlowStarter", "Lcom/stripe/android/PaymentController$ChallengeFlowStarter;", "enableLogging", "", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/StripeRepository;Lcom/stripe/android/stripe3ds2/transaction/Transaction;ILcom/stripe/android/model/StripeIntent;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/FireAndForgetRequestExecutor;Lcom/stripe/android/AnalyticsDataFactory;Lcom/stripe/android/PaymentController$ChallengeFlowStarter;Z)V", "stripeRepository1", "paymentRelayStarter", "Lcom/stripe/android/PaymentRelayStarter;", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/StripeRepository;Lcom/stripe/android/stripe3ds2/transaction/Transaction;ILcom/stripe/android/model/StripeIntent;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/PaymentRelayStarter;Lcom/stripe/android/FireAndForgetRequestExecutor;Lcom/stripe/android/AnalyticsDataFactory;Lcom/stripe/android/PaymentController$ChallengeFlowStarter;Z)V", "onError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "result", "startChallengeFlow", "ares", "Lcom/stripe/android/model/Stripe3ds2AuthResult$Ares;", "startFrictionlessFlow", "stripe_release"})
    public static final class Stripe3ds2AuthCallback
    implements ApiResultCallback<Stripe3ds2AuthResult> {
        private final AuthActivityStarter.Host host;
        private final StripeRepository stripeRepository1;
        private final Transaction transaction;
        private final int maxTimeout;
        private final StripeIntent stripeIntent;
        private final String sourceId;
        private final ApiRequest.Options requestOptions;
        private final PaymentRelayStarter paymentRelayStarter;
        private final FireAndForgetRequestExecutor analyticsRequestExecutor;
        private final AnalyticsDataFactory analyticsDataFactory;
        private final ChallengeFlowStarter challengeFlowStarter;
        private final boolean enableLogging;

        @Override
        public void onSuccess(@NotNull Stripe3ds2AuthResult result) {
            Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
            Stripe3ds2AuthResult.Ares ares = result.getAres();
            if (ares != null) {
                if (ares.isChallenge()) {
                    this.startChallengeFlow(ares);
                } else {
                    this.startFrictionlessFlow();
                }
            } else if (result.getFallbackRedirectUrl() != null) {
                String string2 = this.stripeIntent.getId();
                String string3 = "3ds2_fallback";
                AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
                FireAndForgetRequestExecutor fireAndForgetRequestExecutor = this.analyticsRequestExecutor;
                boolean bl = false;
                String string4 = string2;
                if (string4 == null) {
                    string4 = "";
                }
                String string5 = string4;
                fireAndForgetRequestExecutor.executeAsync(AnalyticsRequest.create$default(analyticsDataFactory.createAuthParams(string3, string5, this.requestOptions.getApiKey()), this.requestOptions, null, 4, null));
                int n = Companion.getRequestCode(this.stripeIntent);
                String string6 = this.stripeIntent.getClientSecret();
                if (string6 == null) {
                    string6 = "";
                }
                com.stripe.android.PaymentController$Companion.beginWebAuth$default(Companion, this.host, n, string6, result.getFallbackRedirectUrl(), null, this.enableLogging, 16, null);
            } else {
                Stripe3ds2AuthResult.ThreeDS2Error error = result.getError();
                String errorMessage = null;
                errorMessage = error != null ? "Code: " + error.getErrorCode() + ", " + "Detail: " + error.getErrorDetail() + ", " + "Description: " + error.getErrorDescription() + ", " + "Component: " + error.getErrorComponent() : "Invalid 3DS2 authentication response";
                this.onError(new RuntimeException("Error encountered during 3DS2 authentication request. " + errorMessage));
            }
        }

        @Override
        public void onError(@NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            this.paymentRelayStarter.start(PaymentRelayStarter.Data.Companion.create(e));
        }

        private final void startFrictionlessFlow() {
            String string2 = this.stripeIntent.getId();
            String string3 = "3ds2_frictionless_flow";
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            FireAndForgetRequestExecutor fireAndForgetRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string4 = string2;
            if (string4 == null) {
                string4 = "";
            }
            String string5 = string4;
            fireAndForgetRequestExecutor.executeAsync(AnalyticsRequest.create$default(analyticsDataFactory.createAuthParams(string3, string5, this.requestOptions.getApiKey()), this.requestOptions, null, 4, null));
            this.paymentRelayStarter.start(PaymentRelayStarter.Data.Companion.create(this.stripeIntent));
        }

        private final void startChallengeFlow(Stripe3ds2AuthResult.Ares ares) {
            StripeChallengeParameters challengeParameters = new StripeChallengeParameters();
            challengeParameters.setAcsSignedContent(ares.getAcsSignedContent());
            challengeParameters.setThreeDsServerTransactionId(ares.getThreeDSServerTransId());
            challengeParameters.setAcsTransactionId(ares.getAcsTransId());
            this.challengeFlowStarter.start(new Runnable(this, challengeParameters){
                final /* synthetic */ Stripe3ds2AuthCallback this$0;
                final /* synthetic */ StripeChallengeParameters $challengeParameters;

                public final void run() {
                    Activity activity = Stripe3ds2AuthCallback.access$getHost$p(this.this$0).getActivity();
                    if (activity == null) {
                        return;
                    }
                    Activity activity2 = activity;
                    Stripe3ds2AuthCallback.access$getTransaction$p(this.this$0).doChallenge(activity2, (ChallengeParameters)this.$challengeParameters, (ChallengeStatusReceiver)PaymentAuth3ds2ChallengeStatusReceiver.Companion.create(Stripe3ds2AuthCallback.access$getHost$p(this.this$0), Stripe3ds2AuthCallback.access$getStripeRepository1$p(this.this$0), Stripe3ds2AuthCallback.access$getStripeIntent$p(this.this$0), Stripe3ds2AuthCallback.access$getSourceId$p(this.this$0), Stripe3ds2AuthCallback.access$getRequestOptions$p(this.this$0), Stripe3ds2AuthCallback.access$getAnalyticsRequestExecutor$p(this.this$0), Stripe3ds2AuthCallback.access$getAnalyticsDataFactory$p(this.this$0), Stripe3ds2AuthCallback.access$getTransaction$p(this.this$0)), Stripe3ds2AuthCallback.access$getMaxTimeout$p(this.this$0));
                }
                {
                    this.this$0 = stripe3ds2AuthCallback;
                    this.$challengeParameters = stripeChallengeParameters;
                }
            });
        }

        @VisibleForTesting
        public Stripe3ds2AuthCallback(@NotNull AuthActivityStarter.Host host, @NotNull StripeRepository stripeRepository1, @NotNull Transaction transaction, int maxTimeout, @NotNull StripeIntent stripeIntent, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull PaymentRelayStarter paymentRelayStarter, @NotNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull ChallengeFlowStarter challengeFlowStarter, boolean enableLogging) {
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository1, (String)"stripeRepository1");
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull((Object)paymentRelayStarter, (String)"paymentRelayStarter");
            Intrinsics.checkParameterIsNotNull((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
            Intrinsics.checkParameterIsNotNull((Object)analyticsDataFactory, (String)"analyticsDataFactory");
            Intrinsics.checkParameterIsNotNull((Object)challengeFlowStarter, (String)"challengeFlowStarter");
            this.host = host;
            this.stripeRepository1 = stripeRepository1;
            this.transaction = transaction;
            this.maxTimeout = maxTimeout;
            this.stripeIntent = stripeIntent;
            this.sourceId = sourceId;
            this.requestOptions = requestOptions;
            this.paymentRelayStarter = paymentRelayStarter;
            this.analyticsRequestExecutor = analyticsRequestExecutor;
            this.analyticsDataFactory = analyticsDataFactory;
            this.challengeFlowStarter = challengeFlowStarter;
            this.enableLogging = enableLogging;
        }

        public /* synthetic */ Stripe3ds2AuthCallback(AuthActivityStarter.Host host, StripeRepository stripeRepository, Transaction transaction, int n, StripeIntent stripeIntent, String string2, ApiRequest.Options options, PaymentRelayStarter paymentRelayStarter, FireAndForgetRequestExecutor fireAndForgetRequestExecutor, AnalyticsDataFactory analyticsDataFactory, ChallengeFlowStarter challengeFlowStarter, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x800) != 0) {
                bl = false;
            }
            this(host, stripeRepository, transaction, n, stripeIntent, string2, options, paymentRelayStarter, fireAndForgetRequestExecutor, analyticsDataFactory, challengeFlowStarter, bl);
        }

        public Stripe3ds2AuthCallback(@NotNull AuthActivityStarter.Host host, @NotNull StripeRepository stripeRepository, @NotNull Transaction transaction, int maxTimeout, @NotNull StripeIntent stripeIntent, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull ChallengeFlowStarter challengeFlowStarter, boolean enableLogging) {
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
            Intrinsics.checkParameterIsNotNull((Object)analyticsDataFactory, (String)"analyticsDataFactory");
            Intrinsics.checkParameterIsNotNull((Object)challengeFlowStarter, (String)"challengeFlowStarter");
            this(host, stripeRepository, transaction, maxTimeout, stripeIntent, sourceId, requestOptions, new PaymentRelayStarter(host, Companion.getRequestCode(stripeIntent)), analyticsRequestExecutor, analyticsDataFactory, challengeFlowStarter, enableLogging);
        }

        public static final /* synthetic */ AuthActivityStarter.Host access$getHost$p(Stripe3ds2AuthCallback $this) {
            return $this.host;
        }

        public static final /* synthetic */ Transaction access$getTransaction$p(Stripe3ds2AuthCallback $this) {
            return $this.transaction;
        }

        public static final /* synthetic */ StripeRepository access$getStripeRepository1$p(Stripe3ds2AuthCallback $this) {
            return $this.stripeRepository1;
        }

        public static final /* synthetic */ StripeIntent access$getStripeIntent$p(Stripe3ds2AuthCallback $this) {
            return $this.stripeIntent;
        }

        public static final /* synthetic */ String access$getSourceId$p(Stripe3ds2AuthCallback $this) {
            return $this.sourceId;
        }

        public static final /* synthetic */ ApiRequest.Options access$getRequestOptions$p(Stripe3ds2AuthCallback $this) {
            return $this.requestOptions;
        }

        public static final /* synthetic */ FireAndForgetRequestExecutor access$getAnalyticsRequestExecutor$p(Stripe3ds2AuthCallback $this) {
            return $this.analyticsRequestExecutor;
        }

        public static final /* synthetic */ AnalyticsDataFactory access$getAnalyticsDataFactory$p(Stripe3ds2AuthCallback $this) {
            return $this.analyticsDataFactory;
        }

        public static final /* synthetic */ int access$getMaxTimeout$p(Stripe3ds2AuthCallback $this) {
            return $this.maxTimeout;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 #2\u00020\u0001:\u0002#$BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/stripe/android/PaymentController$PaymentAuth3ds2ChallengeStatusReceiver;", "Lcom/stripe/android/stripe3ds2/transaction/StripeChallengeStatusReceiver;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "sourceId", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "analyticsRequestExecutor", "Lcom/stripe/android/FireAndForgetRequestExecutor;", "analyticsDataFactory", "Lcom/stripe/android/AnalyticsDataFactory;", "transaction", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "complete3ds2AuthCallbackFactory", "Lcom/stripe/android/PaymentController$PaymentAuth3ds2ChallengeStatusReceiver$Complete3ds2AuthCallbackFactory;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/StripeIntent;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/FireAndForgetRequestExecutor;Lcom/stripe/android/AnalyticsDataFactory;Lcom/stripe/android/stripe3ds2/transaction/Transaction;Lcom/stripe/android/PaymentController$PaymentAuth3ds2ChallengeStatusReceiver$Complete3ds2AuthCallbackFactory;)V", "cancelled", "", "uiTypeCode", "completed", "completionEvent", "Lcom/stripe/android/stripe3ds2/transaction/CompletionEvent;", "notifyCompletion", "startData", "Lcom/stripe/android/Stripe3ds2CompletionStarter$StartData;", "protocolError", "protocolErrorEvent", "Lcom/stripe/android/stripe3ds2/transaction/ProtocolErrorEvent;", "runtimeError", "runtimeErrorEvent", "Lcom/stripe/android/stripe3ds2/transaction/RuntimeErrorEvent;", "timedout", "Companion", "Complete3ds2AuthCallbackFactory", "stripe_release"})
    public static final class PaymentAuth3ds2ChallengeStatusReceiver
    extends StripeChallengeStatusReceiver {
        private final StripeRepository stripeRepository;
        private final StripeIntent stripeIntent;
        private final String sourceId;
        private final ApiRequest.Options requestOptions;
        private final FireAndForgetRequestExecutor analyticsRequestExecutor;
        private final AnalyticsDataFactory analyticsDataFactory;
        private final Transaction transaction;
        private final Complete3ds2AuthCallbackFactory complete3ds2AuthCallbackFactory;
        private static final String VALUE_YES = "Y";
        public static final Companion Companion = new Companion(null);

        public void completed(@NotNull CompletionEvent completionEvent, @NotNull String uiTypeCode) {
            Intrinsics.checkParameterIsNotNull((Object)completionEvent, (String)"completionEvent");
            Intrinsics.checkParameterIsNotNull((Object)uiTypeCode, (String)"uiTypeCode");
            super.completed(completionEvent, uiTypeCode);
            String string2 = this.stripeIntent.getId();
            String string3 = "3ds2_challenge_flow_completed";
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            FireAndForgetRequestExecutor fireAndForgetRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string4 = string2;
            if (string4 == null) {
                string4 = "";
            }
            String string5 = string4;
            fireAndForgetRequestExecutor.executeAsync(AnalyticsRequest.create$default(analyticsDataFactory.create3ds2ChallengeParams(string3, string5, uiTypeCode, this.requestOptions.getApiKey()), this.requestOptions, null, 4, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.stripeIntent, Intrinsics.areEqual((Object)VALUE_YES, (Object)completionEvent.getTransactionStatus()) ? 0 : 1));
        }

        public void cancelled(@NotNull String uiTypeCode) {
            Intrinsics.checkParameterIsNotNull((Object)uiTypeCode, (String)"uiTypeCode");
            super.cancelled(uiTypeCode);
            String string2 = this.stripeIntent.getId();
            String string3 = "3ds2_challenge_flow_canceled";
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            FireAndForgetRequestExecutor fireAndForgetRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string4 = string2;
            if (string4 == null) {
                string4 = "";
            }
            String string5 = string4;
            fireAndForgetRequestExecutor.executeAsync(AnalyticsRequest.create$default(analyticsDataFactory.create3ds2ChallengeParams(string3, string5, uiTypeCode, this.requestOptions.getApiKey()), this.requestOptions, null, 4, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.stripeIntent, 2));
        }

        public void timedout(@NotNull String uiTypeCode) {
            Intrinsics.checkParameterIsNotNull((Object)uiTypeCode, (String)"uiTypeCode");
            super.timedout(uiTypeCode);
            String string2 = this.stripeIntent.getId();
            String string3 = "3ds2_challenge_flow_timed_out";
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            FireAndForgetRequestExecutor fireAndForgetRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string4 = string2;
            if (string4 == null) {
                string4 = "";
            }
            String string5 = string4;
            fireAndForgetRequestExecutor.executeAsync(AnalyticsRequest.create$default(analyticsDataFactory.create3ds2ChallengeParams(string3, string5, uiTypeCode, this.requestOptions.getApiKey()), this.requestOptions, null, 4, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.stripeIntent, 3));
        }

        public void protocolError(@NotNull ProtocolErrorEvent protocolErrorEvent) {
            Intrinsics.checkParameterIsNotNull((Object)protocolErrorEvent, (String)"protocolErrorEvent");
            super.protocolError(protocolErrorEvent);
            String string2 = this.stripeIntent.getId();
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            FireAndForgetRequestExecutor fireAndForgetRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            fireAndForgetRequestExecutor.executeAsync(AnalyticsRequest.create$default(analyticsDataFactory.create3ds2ChallengeErrorParams(string4, protocolErrorEvent, this.requestOptions.getApiKey()), this.requestOptions, null, 4, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.stripeIntent, 4));
        }

        public void runtimeError(@NotNull RuntimeErrorEvent runtimeErrorEvent) {
            Intrinsics.checkParameterIsNotNull((Object)runtimeErrorEvent, (String)"runtimeErrorEvent");
            super.runtimeError(runtimeErrorEvent);
            String string2 = this.stripeIntent.getId();
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            FireAndForgetRequestExecutor fireAndForgetRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            fireAndForgetRequestExecutor.executeAsync(AnalyticsRequest.create$default(analyticsDataFactory.create3ds2ChallengeErrorParams(string4, runtimeErrorEvent, this.requestOptions.getApiKey()), this.requestOptions, null, 4, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.stripeIntent, 5));
        }

        private final void notifyCompletion(Stripe3ds2CompletionStarter.StartData startData) {
            String string2 = this.stripeIntent.getId();
            String string3 = "3ds2_challenge_flow_presented";
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            FireAndForgetRequestExecutor fireAndForgetRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string4 = string2;
            if (string4 == null) {
                string4 = "";
            }
            String string5 = string4;
            string2 = this.transaction.getInitialChallengeUiType();
            bl = false;
            String string6 = string2;
            if (string6 == null) {
                string6 = "";
            }
            String string7 = string6;
            fireAndForgetRequestExecutor.executeAsync(AnalyticsRequest.create$default(analyticsDataFactory.create3ds2ChallengeParams(string3, string5, string7, this.requestOptions.getApiKey()), this.requestOptions, null, 4, null));
            this.stripeRepository.complete3ds2Auth(this.sourceId, this.requestOptions, (ApiResultCallback)this.complete3ds2AuthCallbackFactory.create(startData));
        }

        public PaymentAuth3ds2ChallengeStatusReceiver(@NotNull StripeRepository stripeRepository, @NotNull StripeIntent stripeIntent, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull Transaction transaction, @NotNull Complete3ds2AuthCallbackFactory complete3ds2AuthCallbackFactory) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
            Intrinsics.checkParameterIsNotNull((Object)analyticsDataFactory, (String)"analyticsDataFactory");
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)complete3ds2AuthCallbackFactory, (String)"complete3ds2AuthCallbackFactory");
            this.stripeRepository = stripeRepository;
            this.stripeIntent = stripeIntent;
            this.sourceId = sourceId;
            this.requestOptions = requestOptions;
            this.analyticsRequestExecutor = analyticsRequestExecutor;
            this.analyticsDataFactory = analyticsDataFactory;
            this.transaction = transaction;
            this.complete3ds2AuthCallbackFactory = complete3ds2AuthCallbackFactory;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b`\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/PaymentController$PaymentAuth3ds2ChallengeStatusReceiver$Complete3ds2AuthCallbackFactory;", "Lcom/stripe/android/Factory;", "Lcom/stripe/android/Stripe3ds2CompletionStarter$StartData;", "Lcom/stripe/android/ApiResultCallback;", "", "stripe_release"})
        public static interface Complete3ds2AuthCallbackFactory
        extends Factory<Stripe3ds2CompletionStarter.StartData, ApiResultCallback<Boolean>> {
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/PaymentController$PaymentAuth3ds2ChallengeStatusReceiver$Companion;", "", "()V", "VALUE_YES", "", "create", "Lcom/stripe/android/PaymentController$PaymentAuth3ds2ChallengeStatusReceiver;", "host", "Lcom/stripe/android/view/AuthActivityStarter$Host;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "sourceId", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "analyticsRequestExecutor", "Lcom/stripe/android/FireAndForgetRequestExecutor;", "analyticsDataFactory", "Lcom/stripe/android/AnalyticsDataFactory;", "transaction", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "createComplete3ds2AuthCallbackFactory", "Lcom/stripe/android/PaymentController$PaymentAuth3ds2ChallengeStatusReceiver$Complete3ds2AuthCallbackFactory;", "starter", "Lcom/stripe/android/Stripe3ds2CompletionStarter;", "stripe_release"})
        public static final class Companion {
            @NotNull
            public final PaymentAuth3ds2ChallengeStatusReceiver create(@NotNull AuthActivityStarter.Host host, @NotNull StripeRepository stripeRepository, @NotNull StripeIntent stripeIntent, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull Transaction transaction) {
                Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
                Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
                Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
                Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
                Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
                Intrinsics.checkParameterIsNotNull((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
                Intrinsics.checkParameterIsNotNull((Object)analyticsDataFactory, (String)"analyticsDataFactory");
                Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
                return new PaymentAuth3ds2ChallengeStatusReceiver(stripeRepository, stripeIntent, sourceId, requestOptions, analyticsRequestExecutor, analyticsDataFactory, transaction, this.createComplete3ds2AuthCallbackFactory(new Stripe3ds2CompletionStarter(host, PaymentController.Companion.getRequestCode(stripeIntent)), host, stripeIntent));
            }

            private final Complete3ds2AuthCallbackFactory createComplete3ds2AuthCallbackFactory(Stripe3ds2CompletionStarter starter, AuthActivityStarter.Host host, StripeIntent stripeIntent) {
                return new Complete3ds2AuthCallbackFactory(starter, host, stripeIntent){
                    final /* synthetic */ Stripe3ds2CompletionStarter $starter;
                    final /* synthetic */ AuthActivityStarter.Host $host;
                    final /* synthetic */ StripeIntent $stripeIntent;

                    @NotNull
                    public ApiResultCallback<Boolean> create(@NotNull Stripe3ds2CompletionStarter.StartData arg) {
                        Intrinsics.checkParameterIsNotNull((Object)arg, (String)"arg");
                        return new ApiResultCallback<Boolean>(this, arg){
                            final /* synthetic */ createComplete3ds2AuthCallbackFactory.1 this$0;
                            final /* synthetic */ Stripe3ds2CompletionStarter.StartData $arg;

                            public void onSuccess(boolean result) {
                                this.this$0.$starter.start(this.$arg);
                            }

                            public void onError(@NotNull Exception e) {
                                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                                com.stripe.android.PaymentController$Companion.access$handleError(PaymentController.Companion, this.this$0.$host, PaymentController.Companion.getRequestCode(this.this$0.$stripeIntent), e);
                            }
                            {
                                this.this$0 = $outer;
                                this.$arg = $captured_local_variable$1;
                            }
                        };
                    }
                    {
                        this.$starter = $captured_local_variable$0;
                        this.$host = $captured_local_variable$1;
                        this.$stripeIntent = $captured_local_variable$2;
                    }
                };
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/PaymentController$ChallengeFlowStarterImpl;", "Lcom/stripe/android/PaymentController$ChallengeFlowStarter;", "()V", "start", "", "runnable", "Ljava/lang/Runnable;", "Companion", "stripe_release"})
    private static final class ChallengeFlowStarterImpl
    implements ChallengeFlowStarter {
        private static final long DELAY_SECONDS = 2L;
        public static final Companion Companion = new Companion(null);

        @Override
        public void start(@NotNull Runnable runnable) {
            Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
            HandlerThread handlerThread = new HandlerThread(Stripe3ds2AuthCallback.class.getSimpleName());
            Handler handler = Companion.createHandler(handlerThread);
            handler.postDelayed(new Runnable(runnable, handlerThread){
                final /* synthetic */ Runnable $runnable;
                final /* synthetic */ HandlerThread $handlerThread;

                public final void run() {
                    this.$runnable.run();
                    this.$handlerThread.quitSafely();
                }
                {
                    this.$runnable = runnable;
                    this.$handlerThread = handlerThread;
                }
            }, TimeUnit.SECONDS.toMillis(2L));
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/PaymentController$ChallengeFlowStarterImpl$Companion;", "", "()V", "DELAY_SECONDS", "", "createHandler", "Landroid/os/Handler;", "handlerThread", "Landroid/os/HandlerThread;", "stripe_release"})
        public static final class Companion {
            @NotNull
            public final Handler createHandler(@NotNull HandlerThread handlerThread) {
                Intrinsics.checkParameterIsNotNull((Object)handlerThread, (String)"handlerThread");
                handlerThread.start();
                return new Handler(handlerThread.getLooper());
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/PaymentController$ChallengeFlowStarter;", "", "start", "", "runnable", "Ljava/lang/Runnable;", "stripe_release"})
    public static interface ChallengeFlowStarter {
        public void start(@NotNull Runnable var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J$\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/stripe/android/PaymentController$Companion;", "", "()V", "PAYMENT_REQUEST_CODE", "", "SETUP_REQUEST_CODE", "beginWebAuth", "", "host", "Lcom/stripe/android/view/AuthActivityStarter$Host;", "requestCode", "clientSecret", "", "authUrl", "returnUrl", "enableLogging", "", "create", "Lcom/stripe/android/PaymentController;", "context", "Landroid/content/Context;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "getRequestCode", "params", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "intent", "Lcom/stripe/android/model/StripeIntent;", "handleError", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        public final int getRequestCode(@NotNull StripeIntent intent) {
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            return intent instanceof PaymentIntent ? 50000 : 50001;
        }

        @JvmStatic
        public final int getRequestCode(@NotNull ConfirmStripeIntentParams params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            return params instanceof ConfirmPaymentIntentParams ? 50000 : 50001;
        }

        private final void beginWebAuth(AuthActivityStarter.Host host, int requestCode, String clientSecret, String authUrl, String returnUrl, boolean enableLogging) {
            new PaymentAuthWebViewStarter(host, requestCode, null, enableLogging, 4, null).start(new PaymentAuthWebViewStarter.Data(clientSecret, authUrl, returnUrl));
        }

        static /* synthetic */ void beginWebAuth$default(Companion companion, AuthActivityStarter.Host host, int n, String string2, String string3, String string4, boolean bl, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                string4 = null;
            }
            if ((n2 & 0x20) != 0) {
                bl = false;
            }
            companion.beginWebAuth(host, n, string2, string3, string4, bl);
        }

        private final void handleError(AuthActivityStarter.Host host, int requestCode, Exception exception) {
            new PaymentRelayStarter(host, requestCode).start(PaymentRelayStarter.Data.Companion.create(exception));
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PaymentController create(@NotNull Context context, @NotNull StripeRepository stripeRepository, boolean enableLogging) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            return new PaymentController(context2, stripeRepository, enableLogging, null, null, null, null, null, null, 504, null);
        }

        public static /* synthetic */ PaymentController create$default(Companion companion, Context context, StripeRepository stripeRepository, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.create(context, stripeRepository, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PaymentController create(@NotNull Context context, @NotNull StripeRepository stripeRepository) {
            return com.stripe.android.PaymentController$Companion.create$default(this, context, stripeRepository, false, 4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

