/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import java.util.Objects;

public abstract class ActivityStarter<TargetActivityType extends Activity, ArgsType extends Args> {
    @NonNull
    private final Activity mActivity;
    @Nullable
    private final Fragment mFragment;
    @NonNull
    private final Class<TargetActivityType> mTargetClass;
    @NonNull
    private final ArgsType mDefaultArgs;
    private final int mRequestCode;

    ActivityStarter(@NonNull Activity activity, @NonNull Class<TargetActivityType> targetClass, @NonNull ArgsType args, int requestCode) {
        this.mActivity = activity;
        this.mFragment = null;
        this.mTargetClass = targetClass;
        this.mDefaultArgs = args;
        this.mRequestCode = requestCode;
    }

    ActivityStarter(@NonNull Fragment fragment, @NonNull Class<TargetActivityType> targetClass, @NonNull ArgsType args, int requestCode) {
        this.mActivity = fragment.requireActivity();
        this.mFragment = fragment;
        this.mTargetClass = targetClass;
        this.mDefaultArgs = args;
        this.mRequestCode = requestCode;
    }

    public final void startForResult() {
        this.startForResult(this.mDefaultArgs);
    }

    public final void startForResult(@NonNull ArgsType args) {
        Intent intent = this.newIntent().putExtra("extra_activity_args", args);
        if (this.mFragment != null) {
            Objects.requireNonNull(this.mFragment).startActivityForResult(intent, this.mRequestCode);
        } else {
            this.mActivity.startActivityForResult(intent, this.mRequestCode);
        }
    }

    @NonNull
    final Intent newIntent() {
        return new Intent((Context)this.mActivity, this.mTargetClass);
    }

    public static interface Result
    extends Parcelable {
        public static final String EXTRA = "extra_activity_result";

        @NonNull
        public Bundle toBundle();
    }

    public static interface Args
    extends Parcelable {
        public static final String EXTRA = "extra_activity_args";
    }
}

