/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.annotation.NonNull;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Currency;

public class PayWithGoogleUtils {
    @NonNull
    public static String getPriceString(long price, @NonNull Currency currency) {
        int i;
        int fractionDigits = currency.getDefaultFractionDigits();
        int totalLength = String.valueOf(price).length();
        StringBuilder builder = new StringBuilder();
        if (fractionDigits == 0) {
            for (int i2 = 0; i2 < totalLength; ++i2) {
                builder.append('#');
            }
            DecimalFormat noDecimalCurrencyFormat = new DecimalFormat(builder.toString());
            noDecimalCurrencyFormat.setCurrency(currency);
            noDecimalCurrencyFormat.setGroupingUsed(false);
            return noDecimalCurrencyFormat.format(price);
        }
        int beforeDecimal = totalLength - fractionDigits;
        for (i = 0; i < beforeDecimal; ++i) {
            builder.append('#');
        }
        if (totalLength <= fractionDigits) {
            builder.append('0');
        }
        builder.append('.');
        for (i = 0; i < fractionDigits; ++i) {
            builder.append('0');
        }
        double modBreak = Math.pow(10.0, fractionDigits);
        double decimalPrice = (double)price / modBreak;
        DecimalFormatSymbols symbolOverride = new DecimalFormatSymbols();
        symbolOverride.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat(builder.toString(), symbolOverride);
        decimalFormat.setCurrency(currency);
        decimalFormat.setGroupingUsed(false);
        return decimalFormat.format(decimalPrice);
    }
}

