/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.ShippingMethod;
import java.util.Objects;

public class PaymentSessionData
implements Parcelable {
    private long mCartTotal = 0L;
    private boolean mIsPaymentReadyToCharge;
    private long mShippingTotal = 0L;
    @Nullable
    private ShippingInformation mShippingInformation;
    @Nullable
    private ShippingMethod mShippingMethod;
    @Nullable
    private PaymentMethod mPaymentMethod;
    public static final Parcelable.Creator<PaymentSessionData> CREATOR = new Parcelable.Creator<PaymentSessionData>(){

        public PaymentSessionData createFromParcel(Parcel in) {
            return new PaymentSessionData(in);
        }

        public PaymentSessionData[] newArray(int size) {
            return new PaymentSessionData[size];
        }
    };

    public PaymentSessionData() {
    }

    @Nullable
    public PaymentMethod getPaymentMethod() {
        return this.mPaymentMethod;
    }

    public long getCartTotal() {
        return this.mCartTotal;
    }

    public boolean isPaymentReadyToCharge() {
        return this.mIsPaymentReadyToCharge;
    }

    public void setPaymentReadyToCharge(boolean paymentReadyToCharge) {
        this.mIsPaymentReadyToCharge = paymentReadyToCharge;
    }

    public long getShippingTotal() {
        return this.mShippingTotal;
    }

    @Nullable
    public ShippingInformation getShippingInformation() {
        return this.mShippingInformation;
    }

    public void setShippingInformation(@Nullable ShippingInformation shippingInformation) {
        this.mShippingInformation = shippingInformation;
    }

    @Nullable
    public ShippingMethod getShippingMethod() {
        return this.mShippingMethod;
    }

    public void setShippingMethod(@Nullable ShippingMethod shippingMethod) {
        this.mShippingMethod = shippingMethod;
    }

    void setCartTotal(long cartTotal) {
        this.mCartTotal = cartTotal;
    }

    void setPaymentMethod(@Nullable PaymentMethod paymentMethod) {
        this.mPaymentMethod = paymentMethod;
    }

    void setShippingTotal(long shippingTotal) {
        this.mShippingTotal = shippingTotal;
    }

    public boolean updateIsPaymentReadyToCharge(@NonNull PaymentSessionConfig config) {
        if (this.getPaymentMethod() == null || config.isShippingInfoRequired() && this.getShippingInformation() == null || config.isShippingMethodRequired() && this.getShippingMethod() == null) {
            this.setPaymentReadyToCharge(false);
            return false;
        }
        this.setPaymentReadyToCharge(true);
        return true;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof PaymentSessionData && this.typedEquals((PaymentSessionData)obj);
    }

    private boolean typedEquals(@NonNull PaymentSessionData data) {
        return Objects.equals(this.mCartTotal, data.mCartTotal) && Objects.equals(this.mIsPaymentReadyToCharge, data.mIsPaymentReadyToCharge) && Objects.equals(this.mShippingTotal, data.mShippingTotal) && Objects.equals(this.mShippingInformation, data.mShippingInformation) && Objects.equals(this.mShippingMethod, data.mShippingMethod) && Objects.equals(this.mPaymentMethod, data.mPaymentMethod);
    }

    public int hashCode() {
        return Objects.hash(this.mCartTotal, this.mIsPaymentReadyToCharge, this.mPaymentMethod, this.mShippingTotal, this.mShippingInformation, this.mShippingMethod);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeLong(this.mCartTotal);
        parcel.writeInt(this.mIsPaymentReadyToCharge ? 1 : 0);
        parcel.writeParcelable((Parcelable)this.mPaymentMethod, i);
        parcel.writeParcelable((Parcelable)this.mShippingInformation, i);
        parcel.writeParcelable((Parcelable)this.mShippingMethod, i);
        parcel.writeLong(this.mShippingTotal);
    }

    private PaymentSessionData(@NonNull Parcel in) {
        this.mCartTotal = in.readLong();
        this.mIsPaymentReadyToCharge = in.readInt() == 1;
        this.mPaymentMethod = (PaymentMethod)in.readParcelable(PaymentMethod.class.getClassLoader());
        this.mShippingInformation = (ShippingInformation)in.readParcelable(ShippingInformation.class.getClassLoader());
        this.mShippingMethod = (ShippingMethod)in.readParcelable(ShippingMethod.class.getClassLoader());
        this.mShippingTotal = in.readLong();
    }
}

