/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Transformation;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.stripe.android.R;
import com.stripe.android.model.Card;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.BackUpFieldDeleteListener;
import com.stripe.android.view.CardInputListener;
import com.stripe.android.view.CardNumberEditText;
import com.stripe.android.view.CardWidget;
import com.stripe.android.view.DateUtils;
import com.stripe.android.view.ExpiryDateEditText;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.ViewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;

public class CardInputWidget
extends LinearLayout
implements CardWidget {
    static final String LOGGING_TOKEN = "CardInputView";
    private static final String PEEK_TEXT_COMMON = "4242";
    private static final String PEEK_TEXT_DINERS = "88";
    private static final String PEEK_TEXT_AMEX = "34343";
    private static final String CVC_PLACEHOLDER_COMMON = "CVC";
    private static final String CVC_PLACEHOLDER_AMEX = "2345";
    private static final String HIDDEN_TEXT_AMEX = "3434 343434 ";
    private static final String HIDDEN_TEXT_COMMON = "4242 4242 4242 ";
    private static final String FULL_SIZING_CARD_TEXT = "4242 4242 4242 4242";
    private static final String FULL_SIZING_DATE_TEXT = "MM/MM";
    private static final String EXTRA_CARD_VIEWED = "extra_card_viewed";
    private static final String EXTRA_SUPER_STATE = "extra_super_state";
    @IdRes
    private static final int DEFAULT_READER_ID = R.id.default_reader_id;
    private static final long ANIMATION_LENGTH = 150L;
    @NonNull
    private final ImageView mCardIconImageView;
    @NonNull
    private final FrameLayout mFrameLayout;
    @NonNull
    private final CardNumberEditText mCardNumberEditText;
    @NonNull
    private final StripeEditText mCvcNumberEditText;
    @NonNull
    private final ExpiryDateEditText mExpiryDateEditText;
    @Nullable
    private CardInputListener mCardInputListener;
    private boolean mCardNumberIsViewed = true;
    @ColorInt
    private int mTintColorInt;
    private boolean mIsAmEx;
    private boolean mInitFlag;
    private int mTotalLengthInPixels;
    @Nullable
    private DimensionOverrideSettings mDimensionOverrides;
    @NonNull
    private final PlacementParameters mPlacementParameters;

    public CardInputWidget(@NonNull Context context) {
        this(context, null);
    }

    public CardInputWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardInputWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        CardInputWidget.inflate((Context)this.getContext(), (int)R.layout.card_input_widget, (ViewGroup)this);
        if (this.getId() == -1) {
            this.setId(DEFAULT_READER_ID);
        }
        this.setOrientation(0);
        this.setMinimumWidth(this.getResources().getDimensionPixelSize(R.dimen.card_widget_min_width));
        this.mPlacementParameters = new PlacementParameters();
        this.mCardIconImageView = (ImageView)this.findViewById(R.id.iv_card_icon);
        this.mCardNumberEditText = (CardNumberEditText)this.findViewById(R.id.et_card_number);
        this.mExpiryDateEditText = (ExpiryDateEditText)this.findViewById(R.id.et_expiry_date);
        this.mCvcNumberEditText = (StripeEditText)this.findViewById(R.id.et_cvc_number);
        this.mFrameLayout = (FrameLayout)this.findViewById(R.id.frame_container);
        this.initView(attrs);
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams.Card getPaymentMethodCard() {
        String cardNumber = this.mCardNumberEditText.getCardNumber();
        int[] cardDate = this.mExpiryDateEditText.getValidDateFields();
        String cvcValue = Objects.requireNonNull(this.mCvcNumberEditText.getText()).toString().trim();
        if (cardNumber == null || cardDate == null || cardDate.length != 2 || !this.isCvcLengthValid(cvcValue)) {
            return null;
        }
        return new PaymentMethodCreateParams.Card.Builder().setNumber(cardNumber).setCvc(cvcValue).setExpiryMonth(cardDate[0]).setExpiryYear(cardDate[1]).build();
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams getPaymentMethodCreateParams() {
        PaymentMethodCreateParams.Card card = this.getPaymentMethodCard();
        if (card == null) {
            return null;
        }
        return PaymentMethodCreateParams.create(card);
    }

    @Override
    @Nullable
    public Card getCard() {
        Card.Builder builder = this.getCardBuilder();
        return builder != null ? builder.build() : null;
    }

    @Override
    @Nullable
    public Card.Builder getCardBuilder() {
        String cardNumber = this.mCardNumberEditText.getCardNumber();
        int[] cardDate = this.mExpiryDateEditText.getValidDateFields();
        if (cardNumber == null || cardDate == null || cardDate.length != 2) {
            return null;
        }
        String cvcValue = Objects.requireNonNull(this.mCvcNumberEditText.getText()).toString().trim();
        if (!this.isCvcLengthValid(cvcValue)) {
            return null;
        }
        return new Card.Builder(cardNumber, cardDate[0], cardDate[1], cvcValue).loggingTokens(new ArrayList<String>(Collections.singletonList(LOGGING_TOKEN)));
    }

    @Override
    public void setCardInputListener(@Nullable CardInputListener listener) {
        this.mCardInputListener = listener;
    }

    @Override
    public void setCardNumber(@Nullable String cardNumber) {
        this.mCardNumberEditText.setText(cardNumber);
        this.setCardNumberIsViewed(!this.mCardNumberEditText.isCardNumberValid());
    }

    @Override
    public void setCardHint(@NonNull String cardHint) {
        this.mCardNumberEditText.setHint(cardHint);
    }

    @Override
    public void setExpiryDate(@IntRange(from=1L, to=12L) int month, @IntRange(from=0L, to=9999L) int year) {
        this.mExpiryDateEditText.setText(DateUtils.createDateStringFromIntegerInput(month, year));
    }

    @Override
    public void setCvcCode(@Nullable String cvcCode) {
        this.mCvcNumberEditText.setText(cvcCode);
    }

    @Override
    public void clear() {
        if (this.mCardNumberEditText.hasFocus() || this.mExpiryDateEditText.hasFocus() || this.mCvcNumberEditText.hasFocus() || this.hasFocus()) {
            this.mCardNumberEditText.requestFocus();
        }
        this.mCvcNumberEditText.setText("");
        this.mExpiryDateEditText.setText("");
        this.mCardNumberEditText.setText("");
    }

    public void setEnabled(boolean isEnabled) {
        this.mCardNumberEditText.setEnabled(isEnabled);
        this.mExpiryDateEditText.setEnabled(isEnabled);
        this.mCvcNumberEditText.setEnabled(isEnabled);
    }

    public void setCardNumberTextWatcher(TextWatcher cardNumberTextWatcher) {
        this.mCardNumberEditText.addTextChangedListener(cardNumberTextWatcher);
    }

    public void setExpiryDateTextWatcher(TextWatcher expiryDateTextWatcher) {
        this.mExpiryDateEditText.addTextChangedListener(expiryDateTextWatcher);
    }

    public void setCvcNumberTextWatcher(TextWatcher cvcNumberTextWatcher) {
        this.mCvcNumberEditText.addTextChangedListener(cvcNumberTextWatcher);
    }

    public boolean isEnabled() {
        return this.mCardNumberEditText.isEnabled() && this.mExpiryDateEditText.isEnabled() && this.mCvcNumberEditText.isEnabled();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getAction() != 0) {
            return super.onInterceptTouchEvent(ev);
        }
        StripeEditText focusEditText = this.getFocusRequestOnTouch((int)ev.getX());
        if (focusEditText != null) {
            focusEditText.requestFocus();
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(EXTRA_SUPER_STATE, super.onSaveInstanceState());
        bundle.putBoolean(EXTRA_CARD_VIEWED, this.mCardNumberIsViewed);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            int cvcMargin;
            int dateMargin;
            int cardMargin;
            Bundle bundleState = (Bundle)state;
            this.mCardNumberIsViewed = bundleState.getBoolean(EXTRA_CARD_VIEWED, true);
            this.updateSpaceSizes(this.mCardNumberIsViewed);
            this.mTotalLengthInPixels = this.getFrameWidth();
            if (this.mCardNumberIsViewed) {
                cardMargin = 0;
                dateMargin = this.mPlacementParameters.cardWidth + this.mPlacementParameters.cardDateSeparation;
                cvcMargin = this.mTotalLengthInPixels;
            } else {
                cardMargin = -1 * this.mPlacementParameters.hiddenCardWidth;
                dateMargin = this.mPlacementParameters.peekCardWidth + this.mPlacementParameters.cardDateSeparation;
                cvcMargin = dateMargin + this.mPlacementParameters.dateWidth + this.mPlacementParameters.dateCvcSeparation;
            }
            this.setLayoutValues(this.mPlacementParameters.cardWidth, cardMargin, this.mCardNumberEditText);
            this.setLayoutValues(this.mPlacementParameters.dateWidth, dateMargin, this.mExpiryDateEditText);
            this.setLayoutValues(this.mPlacementParameters.cvcWidth, cvcMargin, this.mCvcNumberEditText);
            super.onRestoreInstanceState(bundleState.getParcelable(EXTRA_SUPER_STATE));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    @VisibleForTesting
    @Nullable
    StripeEditText getFocusRequestOnTouch(int touchX) {
        int frameStart = this.mFrameLayout.getLeft();
        if (this.mCardNumberIsViewed) {
            if (touchX < frameStart + this.mPlacementParameters.cardWidth) {
                return null;
            }
            if (touchX < this.mPlacementParameters.cardTouchBufferLimit) {
                return this.mCardNumberEditText;
            }
            if (touchX < this.mPlacementParameters.dateStartPosition) {
                return this.mExpiryDateEditText;
            }
            return null;
        }
        if (touchX < frameStart + this.mPlacementParameters.peekCardWidth) {
            return null;
        }
        if (touchX < this.mPlacementParameters.cardTouchBufferLimit) {
            return this.mCardNumberEditText;
        }
        if (touchX < this.mPlacementParameters.dateStartPosition) {
            return this.mExpiryDateEditText;
        }
        if (touchX < this.mPlacementParameters.dateStartPosition + this.mPlacementParameters.dateWidth) {
            return null;
        }
        if (touchX < this.mPlacementParameters.dateRightTouchBufferLimit) {
            return this.mExpiryDateEditText;
        }
        if (touchX < this.mPlacementParameters.cvcStartPosition) {
            return this.mCvcNumberEditText;
        }
        return null;
    }

    @VisibleForTesting
    void setDimensionOverrideSettings(@Nullable DimensionOverrideSettings dimensonOverrides) {
        this.mDimensionOverrides = dimensonOverrides;
    }

    @VisibleForTesting
    void setCardNumberIsViewed(boolean cardNumberIsViewed) {
        this.mCardNumberIsViewed = cardNumberIsViewed;
    }

    @NonNull
    @VisibleForTesting
    PlacementParameters getPlacementParameters() {
        return this.mPlacementParameters;
    }

    @VisibleForTesting
    void updateSpaceSizes(boolean isCardViewed) {
        int frameWidth = this.getFrameWidth();
        int frameStart = this.mFrameLayout.getLeft();
        if (frameWidth == 0) {
            return;
        }
        this.mPlacementParameters.cardWidth = this.getDesiredWidthInPixels(FULL_SIZING_CARD_TEXT, this.mCardNumberEditText);
        this.mPlacementParameters.dateWidth = this.getDesiredWidthInPixels(FULL_SIZING_DATE_TEXT, this.mExpiryDateEditText);
        String brand = this.mCardNumberEditText.getCardBrand();
        this.mPlacementParameters.hiddenCardWidth = this.getDesiredWidthInPixels(this.getHiddenTextForBrand(brand), this.mCardNumberEditText);
        this.mPlacementParameters.cvcWidth = this.getDesiredWidthInPixels(this.getCvcPlaceHolderForBrand(brand), this.mCvcNumberEditText);
        this.mPlacementParameters.peekCardWidth = this.getDesiredWidthInPixels(this.getPeekCardTextForBrand(brand), this.mCardNumberEditText);
        if (isCardViewed) {
            this.mPlacementParameters.cardDateSeparation = frameWidth - this.mPlacementParameters.cardWidth - this.mPlacementParameters.dateWidth;
            this.mPlacementParameters.cardTouchBufferLimit = frameStart + this.mPlacementParameters.cardWidth + this.mPlacementParameters.cardDateSeparation / 2;
            this.mPlacementParameters.dateStartPosition = frameStart + this.mPlacementParameters.cardWidth + this.mPlacementParameters.cardDateSeparation;
        } else {
            this.mPlacementParameters.cardDateSeparation = frameWidth / 2 - this.mPlacementParameters.peekCardWidth - this.mPlacementParameters.dateWidth / 2;
            this.mPlacementParameters.dateCvcSeparation = frameWidth - this.mPlacementParameters.peekCardWidth - this.mPlacementParameters.cardDateSeparation - this.mPlacementParameters.dateWidth - this.mPlacementParameters.cvcWidth;
            this.mPlacementParameters.cardTouchBufferLimit = frameStart + this.mPlacementParameters.peekCardWidth + this.mPlacementParameters.cardDateSeparation / 2;
            this.mPlacementParameters.dateStartPosition = frameStart + this.mPlacementParameters.peekCardWidth + this.mPlacementParameters.cardDateSeparation;
            this.mPlacementParameters.dateRightTouchBufferLimit = this.mPlacementParameters.dateStartPosition + this.mPlacementParameters.dateWidth + this.mPlacementParameters.dateCvcSeparation / 2;
            this.mPlacementParameters.cvcStartPosition = this.mPlacementParameters.dateStartPosition + this.mPlacementParameters.dateWidth + this.mPlacementParameters.dateCvcSeparation;
        }
    }

    private boolean isCvcLengthValid(@NonNull String cvcValue) {
        int cvcLength = cvcValue.length();
        if (this.mIsAmEx && cvcLength == 4) {
            return true;
        }
        return cvcLength == 3;
    }

    private void setLayoutValues(int width, int margin, @NonNull StripeEditText editText) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)editText.getLayoutParams();
        layoutParams.width = width;
        layoutParams.leftMargin = margin;
        editText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private int getDesiredWidthInPixels(@NonNull String text, @NonNull StripeEditText editText) {
        return this.mDimensionOverrides == null ? (int)Layout.getDesiredWidth((CharSequence)text, (TextPaint)editText.getPaint()) : this.mDimensionOverrides.getPixelWidth(text, (EditText)editText);
    }

    private int getFrameWidth() {
        return this.mDimensionOverrides == null ? this.mFrameLayout.getWidth() : this.mDimensionOverrides.getFrameWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initView(@Nullable AttributeSet attrs) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.mCardNumberEditText.setAutofillHints(new String[]{"creditCardNumber"});
            this.mExpiryDateEditText.setAutofillHints(new String[]{"creditCardExpirationDate"});
            this.mCvcNumberEditText.setAutofillHints(new String[]{"creditCardSecurityCode"});
        }
        ViewCompat.setAccessibilityDelegate((View)this.mCvcNumberEditText, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(@NonNull View host, @NonNull AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                String accLabel = CardInputWidget.this.getResources().getString(R.string.acc_label_cvc_node, new Object[]{CardInputWidget.this.mCvcNumberEditText.getText()});
                info.setText((CharSequence)accLabel);
            }
        });
        this.mCardNumberIsViewed = true;
        int errorColorInt = this.mCardNumberEditText.getDefaultErrorColorInt();
        this.mTintColorInt = this.mCardNumberEditText.getHintTextColors().getDefaultColor();
        String cardHintText = null;
        if (attrs != null) {
            TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.CardInputView, 0, 0);
            try {
                this.mTintColorInt = a.getColor(R.styleable.CardInputView_cardTint, this.mTintColorInt);
                errorColorInt = a.getColor(R.styleable.CardInputView_cardTextErrorColor, errorColorInt);
                cardHintText = a.getString(R.styleable.CardInputView_cardHintText);
            }
            finally {
                a.recycle();
            }
        }
        if (cardHintText != null) {
            this.mCardNumberEditText.setHint(cardHintText);
        }
        this.mCardNumberEditText.setErrorColor(errorColorInt);
        this.mExpiryDateEditText.setErrorColor(errorColorInt);
        this.mCvcNumberEditText.setErrorColor(errorColorInt);
        this.mCardNumberEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    CardInputWidget.this.scrollLeft();
                    if (CardInputWidget.this.mCardInputListener != null) {
                        CardInputWidget.this.mCardInputListener.onFocusChange("focus_card");
                    }
                }
            }
        });
        this.mExpiryDateEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    CardInputWidget.this.scrollRight();
                    if (CardInputWidget.this.mCardInputListener != null) {
                        CardInputWidget.this.mCardInputListener.onFocusChange("focus_expiry");
                    }
                }
            }
        });
        this.mExpiryDateEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.mCardNumberEditText));
        this.mCvcNumberEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.mExpiryDateEditText));
        this.mCvcNumberEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    CardInputWidget.this.scrollRight();
                    if (CardInputWidget.this.mCardInputListener != null) {
                        CardInputWidget.this.mCardInputListener.onFocusChange("focus_cvc");
                    }
                }
                CardInputWidget.this.updateIconCvc(CardInputWidget.this.mCardNumberEditText.getCardBrand(), hasFocus, Objects.requireNonNull(CardInputWidget.this.mCvcNumberEditText.getText()).toString());
            }
        });
        this.mCvcNumberEditText.setAfterTextChangedListener(new StripeEditText.AfterTextChangedListener(){

            @Override
            public void onTextChanged(String text) {
                if (CardInputWidget.this.mCardInputListener != null && ViewUtils.isCvcMaximalLength(CardInputWidget.this.mCardNumberEditText.getCardBrand(), text)) {
                    CardInputWidget.this.mCardInputListener.onCvcComplete();
                }
                CardInputWidget.this.updateIconCvc(CardInputWidget.this.mCardNumberEditText.getCardBrand(), CardInputWidget.this.mCvcNumberEditText.hasFocus(), text);
            }
        });
        this.mCardNumberEditText.setCardNumberCompleteListener(new CardNumberEditText.CardNumberCompleteListener(){

            @Override
            public void onCardNumberComplete() {
                CardInputWidget.this.scrollRight();
                if (CardInputWidget.this.mCardInputListener != null) {
                    CardInputWidget.this.mCardInputListener.onCardComplete();
                }
            }
        });
        this.mCardNumberEditText.setCardBrandChangeListener(new CardNumberEditText.CardBrandChangeListener(){

            @Override
            public void onCardBrandChanged(@NonNull String brand) {
                CardInputWidget.this.mIsAmEx = "American Express".equals(brand);
                CardInputWidget.this.updateIcon(brand);
                CardInputWidget.this.updateCvc(brand);
            }
        });
        this.mExpiryDateEditText.setExpiryDateEditListener(new ExpiryDateEditText.ExpiryDateEditListener(){

            @Override
            public void onExpiryDateComplete() {
                CardInputWidget.this.mCvcNumberEditText.requestFocus();
                if (CardInputWidget.this.mCardInputListener != null) {
                    CardInputWidget.this.mCardInputListener.onExpirationComplete();
                }
            }
        });
        this.mCardNumberEditText.requestFocus();
    }

    private void scrollLeft() {
        if (this.mCardNumberIsViewed || !this.mInitFlag) {
            return;
        }
        final int dateStartPosition = this.mPlacementParameters.peekCardWidth + this.mPlacementParameters.cardDateSeparation;
        final int cvcStartPosition = dateStartPosition + this.mPlacementParameters.dateWidth + this.mPlacementParameters.dateCvcSeparation;
        this.updateSpaceSizes(true);
        final int startPoint = ((FrameLayout.LayoutParams)this.mCardNumberEditText.getLayoutParams()).leftMargin;
        Animation slideCardLeftAnimation = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                super.applyTransformation(interpolatedTime, t);
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)CardInputWidget.this.mCardNumberEditText.getLayoutParams();
                params.leftMargin = (int)((float)startPoint * (1.0f - interpolatedTime));
                CardInputWidget.this.mCardNumberEditText.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        };
        final int dateDestination = this.mPlacementParameters.cardWidth + this.mPlacementParameters.cardDateSeparation;
        Animation slideDateLeftAnimation = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                super.applyTransformation(interpolatedTime, t);
                int tempValue = (int)(interpolatedTime * (float)dateDestination + (1.0f - interpolatedTime) * (float)dateStartPosition);
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)CardInputWidget.this.mExpiryDateEditText.getLayoutParams();
                params.leftMargin = tempValue;
                CardInputWidget.this.mExpiryDateEditText.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        };
        final int cvcDestination = cvcStartPosition + (dateDestination - dateStartPosition);
        Animation slideCvcLeftAnimation = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                super.applyTransformation(interpolatedTime, t);
                int tempValue = (int)(interpolatedTime * (float)cvcDestination + (1.0f - interpolatedTime) * (float)cvcStartPosition);
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)CardInputWidget.this.mCvcNumberEditText.getLayoutParams();
                params.leftMargin = tempValue;
                params.rightMargin = 0;
                params.width = ((CardInputWidget)CardInputWidget.this).mPlacementParameters.cvcWidth;
                CardInputWidget.this.mCvcNumberEditText.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        };
        slideCardLeftAnimation.setAnimationListener((Animation.AnimationListener)new AnimationEndListener(){

            public void onAnimationEnd(Animation animation) {
                CardInputWidget.this.mCardNumberEditText.requestFocus();
            }
        });
        slideCardLeftAnimation.setDuration(150L);
        slideDateLeftAnimation.setDuration(150L);
        slideCvcLeftAnimation.setDuration(150L);
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.addAnimation(slideCardLeftAnimation);
        animationSet.addAnimation(slideDateLeftAnimation);
        animationSet.addAnimation(slideCvcLeftAnimation);
        this.mFrameLayout.startAnimation((Animation)animationSet);
        this.mCardNumberIsViewed = true;
    }

    private void scrollRight() {
        if (!this.mCardNumberIsViewed || !this.mInitFlag) {
            return;
        }
        final int dateStartMargin = this.mPlacementParameters.cardWidth + this.mPlacementParameters.cardDateSeparation;
        this.updateSpaceSizes(false);
        Animation slideCardRightAnimation = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                super.applyTransformation(interpolatedTime, t);
                FrameLayout.LayoutParams cardParams = (FrameLayout.LayoutParams)CardInputWidget.this.mCardNumberEditText.getLayoutParams();
                cardParams.leftMargin = (int)((float)(-1 * ((CardInputWidget)CardInputWidget.this).mPlacementParameters.hiddenCardWidth) * interpolatedTime);
                CardInputWidget.this.mCardNumberEditText.setLayoutParams((ViewGroup.LayoutParams)cardParams);
            }
        };
        final int dateDestination = this.mPlacementParameters.peekCardWidth + this.mPlacementParameters.cardDateSeparation;
        Animation slideDateRightAnimation = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                super.applyTransformation(interpolatedTime, t);
                int tempValue = (int)(interpolatedTime * (float)dateDestination + (1.0f - interpolatedTime) * (float)dateStartMargin);
                FrameLayout.LayoutParams dateParams = (FrameLayout.LayoutParams)CardInputWidget.this.mExpiryDateEditText.getLayoutParams();
                dateParams.leftMargin = tempValue;
                CardInputWidget.this.mExpiryDateEditText.setLayoutParams((ViewGroup.LayoutParams)dateParams);
            }
        };
        final int cvcDestination = this.mPlacementParameters.peekCardWidth + this.mPlacementParameters.cardDateSeparation + this.mPlacementParameters.dateWidth + this.mPlacementParameters.dateCvcSeparation;
        final int cvcStartMargin = cvcDestination + (dateStartMargin - dateDestination);
        Animation slideCvcRightAnimation = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                super.applyTransformation(interpolatedTime, t);
                int tempValue = (int)(interpolatedTime * (float)cvcDestination + (1.0f - interpolatedTime) * (float)cvcStartMargin);
                FrameLayout.LayoutParams cardParams = (FrameLayout.LayoutParams)CardInputWidget.this.mCvcNumberEditText.getLayoutParams();
                cardParams.leftMargin = tempValue;
                cardParams.rightMargin = 0;
                cardParams.width = ((CardInputWidget)CardInputWidget.this).mPlacementParameters.cvcWidth;
                CardInputWidget.this.mCvcNumberEditText.setLayoutParams((ViewGroup.LayoutParams)cardParams);
            }
        };
        slideCardRightAnimation.setDuration(150L);
        slideDateRightAnimation.setDuration(150L);
        slideCvcRightAnimation.setDuration(150L);
        slideCardRightAnimation.setAnimationListener((Animation.AnimationListener)new AnimationEndListener(){

            public void onAnimationEnd(Animation animation) {
                CardInputWidget.this.mExpiryDateEditText.requestFocus();
            }
        });
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.addAnimation(slideCardRightAnimation);
        animationSet.addAnimation(slideDateRightAnimation);
        animationSet.addAnimation(slideCvcRightAnimation);
        this.mFrameLayout.startAnimation((Animation)animationSet);
        this.mCardNumberIsViewed = false;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.applyTint(false);
        }
    }

    @VisibleForTesting
    static boolean shouldIconShowBrand(@NonNull String brand, boolean cvcHasFocus, @Nullable String cvcText) {
        if (!cvcHasFocus) {
            return true;
        }
        return ViewUtils.isCvcMaximalLength(brand, cvcText);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (!this.mInitFlag && this.getWidth() != 0) {
            this.mInitFlag = true;
            this.mTotalLengthInPixels = this.getFrameWidth();
            this.updateSpaceSizes(this.mCardNumberIsViewed);
            int cardLeftMargin = this.mCardNumberIsViewed ? 0 : -1 * this.mPlacementParameters.hiddenCardWidth;
            this.setLayoutValues(this.mPlacementParameters.cardWidth, cardLeftMargin, this.mCardNumberEditText);
            int dateMargin = this.mCardNumberIsViewed ? this.mPlacementParameters.cardWidth + this.mPlacementParameters.cardDateSeparation : this.mPlacementParameters.peekCardWidth + this.mPlacementParameters.cardDateSeparation;
            this.setLayoutValues(this.mPlacementParameters.dateWidth, dateMargin, this.mExpiryDateEditText);
            int cvcMargin = this.mCardNumberIsViewed ? this.mTotalLengthInPixels : this.mPlacementParameters.peekCardWidth + this.mPlacementParameters.cardDateSeparation + this.mPlacementParameters.dateWidth + this.mPlacementParameters.dateCvcSeparation;
            this.setLayoutValues(this.mPlacementParameters.cvcWidth, cvcMargin, this.mCvcNumberEditText);
        }
    }

    @NonNull
    private String getHiddenTextForBrand(@NonNull String brand) {
        if ("American Express".equals(brand)) {
            return HIDDEN_TEXT_AMEX;
        }
        return HIDDEN_TEXT_COMMON;
    }

    @NonNull
    private String getCvcPlaceHolderForBrand(@NonNull String brand) {
        if ("American Express".equals(brand)) {
            return CVC_PLACEHOLDER_AMEX;
        }
        return CVC_PLACEHOLDER_COMMON;
    }

    @NonNull
    private String getPeekCardTextForBrand(@NonNull String brand) {
        switch (brand) {
            case "American Express": {
                return PEEK_TEXT_AMEX;
            }
            case "Diners Club": {
                return PEEK_TEXT_DINERS;
            }
        }
        return PEEK_TEXT_COMMON;
    }

    private void applyTint(boolean isCvc) {
        if (isCvc || "Unknown".equals(this.mCardNumberEditText.getCardBrand())) {
            Drawable icon = this.mCardIconImageView.getDrawable();
            Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
            DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)this.mTintColorInt);
            this.mCardIconImageView.setImageDrawable(DrawableCompat.unwrap((Drawable)compatIcon));
        }
    }

    private void updateCvc(@NonNull String brand) {
        if ("American Express".equals(brand)) {
            this.mCvcNumberEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(4)});
            this.mCvcNumberEditText.setHint(R.string.cvc_amex_hint);
        } else {
            this.mCvcNumberEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(3)});
            this.mCvcNumberEditText.setHint(R.string.cvc_number_hint);
        }
    }

    private void updateIcon(@NonNull String brand) {
        if ("Unknown".equals(brand)) {
            Drawable icon = this.getResources().getDrawable(R.drawable.ic_unknown);
            this.mCardIconImageView.setImageDrawable(icon);
            this.applyTint(false);
        } else {
            this.mCardIconImageView.setImageResource(Card.getBrandIcon(brand));
        }
    }

    private void updateIconCvc(@NonNull String brand, boolean hasFocus, @Nullable String cvcText) {
        if (CardInputWidget.shouldIconShowBrand(brand, hasFocus, cvcText)) {
            this.updateIcon(brand);
        } else {
            this.updateIconForCvcEntry("American Express".equals(brand));
        }
    }

    private void updateIconForCvcEntry(boolean isAmEx) {
        if (isAmEx) {
            this.mCardIconImageView.setImageResource(R.drawable.ic_cvc_amex);
        } else {
            this.mCardIconImageView.setImageResource(R.drawable.ic_cvc);
        }
        this.applyTint(true);
    }

    private abstract class AnimationEndListener
    implements Animation.AnimationListener {
        private AnimationEndListener() {
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    static class PlacementParameters {
        int cardWidth;
        int hiddenCardWidth;
        int peekCardWidth;
        int cardDateSeparation;
        int dateWidth;
        int dateCvcSeparation;
        int cvcWidth;
        int cardTouchBufferLimit;
        int dateStartPosition;
        int dateRightTouchBufferLimit;
        int cvcStartPosition;

        PlacementParameters() {
        }

        @NonNull
        public String toString() {
            String touchBufferData = String.format(Locale.ENGLISH, "Touch Buffer Data:\nCardTouchBufferLimit = %d\nDateStartPosition = %d\nDateRightTouchBufferLimit = %d\nCvcStartPosition = %d", this.cardTouchBufferLimit, this.dateStartPosition, this.dateRightTouchBufferLimit, this.cvcStartPosition);
            String elementSizeData = String.format(Locale.ENGLISH, "CardWidth = %d\nHiddenCardWidth = %d\nPeekCardWidth = %d\nCardDateSeparation = %d\nDateWidth = %d\nDateCvcSeparation = %d\nCvcWidth = %d\n", this.cardWidth, this.hiddenCardWidth, this.peekCardWidth, this.cardDateSeparation, this.dateWidth, this.dateCvcSeparation, this.cvcWidth);
            return elementSizeData + touchBufferData;
        }
    }

    @VisibleForTesting
    static interface DimensionOverrideSettings {
        public int getPixelWidth(@NonNull String var1, @NonNull EditText var2);

        public int getFrameWidth();
    }
}

