/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.support.annotation.VisibleForTesting;
import android.support.v4.os.ConfigurationCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import com.stripe.android.R;
import com.stripe.android.view.CountryAdapter;
import com.stripe.android.view.CountryUtils;
import java.util.HashMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001cB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u0019\u001a\u00020\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u001a\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/view/CountryAutoCompleteTextView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "countryAutocomplete", "Landroid/widget/AutoCompleteTextView;", "countryChangeListener", "Lcom/stripe/android/view/CountryAutoCompleteTextView$CountryChangeListener;", "selectedCountryCode", "", "selectedCountryCode$annotations", "()V", "getSelectedCountryCode", "()Ljava/lang/String;", "setSelectedCountryCode", "(Ljava/lang/String;)V", "getDisplayCountry", "countryCode", "setCountryChangeListener", "", "setCountrySelected", "updateUiForCountryEntered", "displayCountryEntered", "CountryChangeListener", "stripe_release"})
public final class CountryAutoCompleteTextView
extends FrameLayout {
    private final AutoCompleteTextView countryAutocomplete;
    @Nullable
    private String selectedCountryCode;
    private CountryChangeListener countryChangeListener;
    private HashMap _$_findViewCache;

    @VisibleForTesting
    public static /* synthetic */ void selectedCountryCode$annotations() {
    }

    @Nullable
    public final String getSelectedCountryCode() {
        return this.selectedCountryCode;
    }

    public final void setSelectedCountryCode(@Nullable String string2) {
        this.selectedCountryCode = string2;
    }

    public final void setCountrySelected(@Nullable String countryCode) {
        if (countryCode == null) {
            return;
        }
        this.updateUiForCountryEntered(this.getDisplayCountry(countryCode));
    }

    public final void setCountryChangeListener(@Nullable CountryChangeListener countryChangeListener) {
        this.countryChangeListener = countryChangeListener;
    }

    @VisibleForTesting
    public final void updateUiForCountryEntered(@Nullable String displayCountryEntered) {
        String string2;
        block8: {
            String it;
            boolean bl;
            boolean bl2;
            String string3;
            block7: {
                string2 = CountryUtils.getCountryCode(displayCountryEntered);
                if (string2 == null) break block7;
                string3 = string2;
                bl2 = false;
                bl = false;
                it = string3;
                boolean bl3 = false;
                if (this.selectedCountryCode == null || Intrinsics.areEqual((Object)this.selectedCountryCode, (Object)it) ^ true) {
                    this.selectedCountryCode = it;
                    CountryChangeListener countryChangeListener = this.countryChangeListener;
                    if (countryChangeListener != null) {
                        countryChangeListener.onCountryChanged(it);
                    }
                }
                if ((string2 = displayCountryEntered) != null) break block8;
            }
            String string4 = this.selectedCountryCode;
            if (string4 != null) {
                string3 = string4;
                bl2 = false;
                bl = false;
                it = string3;
                boolean bl4 = false;
                string2 = this.getDisplayCountry(it);
            } else {
                string2 = null;
            }
        }
        String displayCountry = string2;
        this.countryAutocomplete.setText((CharSequence)displayCountry);
    }

    private final String getDisplayCountry(String countryCode) {
        String string2 = new Locale("", countryCode).getDisplayCountry();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Locale(\"\", countryCode).displayCountry");
        return string2;
    }

    @JvmOverloads
    public CountryAutoCompleteTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        View.inflate((Context)this.getContext(), (int)R.layout.country_autocomplete_textview, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.autocomplete_country_cat);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.autocomplete_country_cat)");
        this.countryAutocomplete = (AutoCompleteTextView)view;
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"getContext()");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        Locale locale = ConfigurationCompat.getLocales((Configuration)resources.getConfiguration()).get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"ConfigurationCompat.getL\u2026sources.configuration)[0]");
        CountryAdapter countryAdapter = new CountryAdapter(context2, CountryUtils.getOrderedCountries(locale));
        this.countryAutocomplete.setThreshold(0);
        this.countryAutocomplete.setAdapter((ListAdapter)countryAdapter);
        this.countryAutocomplete.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public final void onItemClick(AdapterView<?> $noName_0, View $noName_1, int $noName_2, long $noName_3) {
                String countryEntered = countryAutocomplete.getText().toString();
                this.updateUiForCountryEntered(countryEntered);
            }
        });
        String defaultCountryEntered = countryAdapter.getItem(0);
        this.updateUiForCountryEntered(defaultCountryEntered);
        this.countryAutocomplete.setText((CharSequence)defaultCountryEntered);
        this.countryAutocomplete.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public final void onFocusChange(View $noName_0, boolean focused) {
                String countryEntered = countryAutocomplete.getText().toString();
                if (focused) {
                    countryAutocomplete.showDropDown();
                } else {
                    this.updateUiForCountryEntered(countryEntered);
                }
            }
        });
    }

    public /* synthetic */ CountryAutoCompleteTextView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CountryAutoCompleteTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CountryAutoCompleteTextView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/CountryAutoCompleteTextView$CountryChangeListener;", "", "onCountryChanged", "", "countryCode", "", "stripe_release"})
    public static interface CountryChangeListener {
        public void onCountryChanged(@NotNull String var1);
    }
}

