/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/view/CountryUtils;", "", "()V", "NO_POSTAL_CODE_COUNTRIES", "", "", "[Ljava/lang/String;", "NO_POSTAL_CODE_COUNTRIES_SET", "", "countryNameToCodeMap", "", "countryNameToCodeMap$annotations", "getCountryNameToCodeMap", "()Ljava/util/Map;", "doesCountryUsePostalCode", "", "countryCode", "stripe_release"})
public final class CountryUtils {
    private static final String[] NO_POSTAL_CODE_COUNTRIES;
    private static final Set<String> NO_POSTAL_CODE_COUNTRIES_SET;
    public static final CountryUtils INSTANCE;

    @JvmStatic
    public static /* synthetic */ void countryNameToCodeMap$annotations() {
    }

    @NotNull
    public static final Map<String, String> getCountryNameToCodeMap() {
        HashMap displayNameToCountryCode = new HashMap();
        for (String countryCode : Locale.getISOCountries()) {
            Locale locale = new Locale("", countryCode);
            Map map = displayNameToCountryCode;
            String string2 = locale.getDisplayCountry();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"locale.displayCountry");
            String string3 = countryCode;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"countryCode");
            map.put(string2, string3);
        }
        return displayNameToCountryCode;
    }

    @JvmStatic
    public static final boolean doesCountryUsePostalCode(@NotNull String countryCode) {
        Intrinsics.checkParameterIsNotNull((Object)countryCode, (String)"countryCode");
        return !NO_POSTAL_CODE_COUNTRIES_SET.contains(countryCode);
    }

    private CountryUtils() {
    }

    static {
        CountryUtils countryUtils;
        INSTANCE = countryUtils = new CountryUtils();
        NO_POSTAL_CODE_COUNTRIES = new String[]{"AE", "AG", "AN", "AO", "AW", "BF", "BI", "BJ", "BO", "BS", "BW", "BZ", "CD", "CF", "CG", "CI", "CK", "CM", "DJ", "DM", "ER", "FJ", "GD", "GH", "GM", "GN", "GQ", "GY", "HK", "IE", "JM", "KE", "KI", "KM", "KN", "KP", "LC", "ML", "MO", "MR", "MS", "MU", "MW", "NR", "NU", "PA", "QA", "RW", "SB", "SC", "SL", "SO", "SR", "ST", "SY", "TF", "TK", "TL", "TO", "TT", "TV", "TZ", "UG", "VU", "YE", "ZA", "ZW"};
        NO_POSTAL_CODE_COUNTRIES_SET = SetsKt.setOf((Object[])Arrays.copyOf(NO_POSTAL_CODE_COUNTRIES, NO_POSTAL_CODE_COUNTRIES.length));
    }
}

