/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.PaymentSessionData;
import com.stripe.android.utils.ObjectUtils;
import com.stripe.android.view.ActivityStarter;
import com.stripe.android.view.PaymentFlowActivity;
import java.util.Objects;

public final class PaymentFlowActivityStarter
extends ActivityStarter<PaymentFlowActivity, Args> {
    public static final int REQUEST_CODE = 6002;

    public PaymentFlowActivityStarter(@NonNull Activity activity) {
        super(activity, PaymentFlowActivity.class, Args.DEFAULT, 6002);
    }

    public PaymentFlowActivityStarter(@NonNull Fragment fragment) {
        super(fragment, PaymentFlowActivity.class, Args.DEFAULT, 6002);
    }

    public static final class Args
    implements ActivityStarter.Args {
        private static final Args DEFAULT = new Builder().build();
        @NonNull
        final PaymentSessionConfig paymentSessionConfig;
        @Nullable
        final PaymentSessionData paymentSessionData;
        final boolean isPaymentSessionActive;
        public static final Parcelable.Creator<Args> CREATOR = new Parcelable.Creator<Args>(){

            public Args createFromParcel(@NonNull Parcel in) {
                return new Args(in);
            }

            public Args[] newArray(int size) {
                return new Args[size];
            }
        };

        @NonNull
        public static Args create(@NonNull Intent intent) {
            Args args = (Args)intent.getParcelableExtra("EXTRA_ARGS");
            return Objects.requireNonNull(args);
        }

        private Args(@NonNull Builder builder) {
            this.paymentSessionConfig = ObjectUtils.getOrDefault(builder.mPaymentSessionConfig, new PaymentSessionConfig.Builder().build());
            this.paymentSessionData = builder.mPaymentSessionData;
            this.isPaymentSessionActive = builder.mIsPaymentSessionActive;
        }

        private Args(@NonNull Parcel in) {
            PaymentSessionConfig paymentSessionConfig = (PaymentSessionConfig)in.readParcelable(PaymentSessionConfig.class.getClassLoader());
            this.paymentSessionConfig = Objects.requireNonNull(paymentSessionConfig);
            this.paymentSessionData = (PaymentSessionData)in.readParcelable(PaymentSessionData.class.getClassLoader());
            this.isPaymentSessionActive = in.readInt() == 1;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.paymentSessionConfig, 0);
            dest.writeParcelable((Parcelable)this.paymentSessionData, 0);
            dest.writeInt(this.isPaymentSessionActive ? 1 : 0);
        }

        public static final class Builder
        implements ObjectBuilder<Args> {
            @Nullable
            PaymentSessionConfig mPaymentSessionConfig;
            @Nullable
            PaymentSessionData mPaymentSessionData;
            private boolean mIsPaymentSessionActive = false;

            @NonNull
            public Builder setPaymentSessionConfig(@Nullable PaymentSessionConfig paymentSessionConfig) {
                this.mPaymentSessionConfig = paymentSessionConfig;
                return this;
            }

            @NonNull
            public Builder setPaymentSessionData(@Nullable PaymentSessionData paymentSessionData) {
                this.mPaymentSessionData = paymentSessionData;
                return this;
            }

            @NonNull
            public Builder setIsPaymentSessionActive(boolean isPaymentSessionActive) {
                this.mIsPaymentSessionActive = isPaymentSessionActive;
                return this;
            }

            @Override
            @NonNull
            public Args build() {
                return new Args(this);
            }
        }
    }
}

