/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import java.lang.ref.WeakReference;

public interface AuthActivityStarter<StartDataType> {
    public void start(@NonNull StartDataType var1);

    public static final class Host {
        @NonNull
        private final WeakReference<Activity> mActivityRef;
        @Nullable
        private final WeakReference<Fragment> mFragmentRef;

        @NonNull
        public static Host create(@NonNull Fragment fragment) {
            return new Host((Activity)fragment.requireActivity(), fragment);
        }

        public static Host create(@NonNull Activity activity) {
            return new Host(activity, null);
        }

        private Host(@NonNull Activity activity, @Nullable Fragment fragment) {
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.mFragmentRef = fragment != null ? new WeakReference<Fragment>(fragment) : null;
        }

        @Nullable
        public Activity getActivity() {
            return (Activity)this.mActivityRef.get();
        }

        public void startActivityForResult(@NonNull Class target, @NonNull Bundle extras, int requestCode) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity == null) {
                return;
            }
            Intent intent = new Intent((Context)activity, target).putExtras(extras);
            if (this.mFragmentRef != null) {
                Fragment fragment = (Fragment)this.mFragmentRef.get();
                if (fragment != null) {
                    fragment.startActivityForResult(intent, requestCode);
                }
            } else {
                activity.startActivityForResult(intent, requestCode);
            }
        }
    }
}

