/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.stripe.android.R;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.AddPaymentMethodView;
import com.stripe.android.view.ThemeConfig;

class AddPaymentMethodFpxView
extends AddPaymentMethodView {
    @NonNull
    private final Adapter mAdapter;

    @NonNull
    static AddPaymentMethodFpxView create(@NonNull Context context) {
        return new AddPaymentMethodFpxView(context);
    }

    private AddPaymentMethodFpxView(@NonNull Context context) {
        super(context);
        AddPaymentMethodFpxView.inflate((Context)this.getContext(), (int)R.layout.add_payment_method_fpx_layout, (ViewGroup)this);
        this.setId(R.id.payment_methods_add_fpx);
        this.mAdapter = new Adapter(new ThemeConfig(context));
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.fpx_list);
        recyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        recyclerView.setHasFixedSize(true);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        recyclerView.setItemAnimator(null);
    }

    @Override
    @Nullable
    PaymentMethodCreateParams getCreateParams() {
        FpxBank fpxBank = this.mAdapter.getSelectedBank();
        if (fpxBank == null) {
            return null;
        }
        return PaymentMethodCreateParams.create(new PaymentMethodCreateParams.Fpx.Builder().setBank(fpxBank.code).build());
    }

    protected Parcelable onSaveInstanceState() {
        return new SavedState(super.onSaveInstanceState(), this.mAdapter.mSelectedPosition);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState savedState = (SavedState)state;
            super.onRestoreInstanceState(savedState.getSuperState());
            this.mAdapter.updateSelected(savedState.selectedPosition);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        final int selectedPosition;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(@Nullable Parcelable superState, int selectedPosition) {
            super(superState);
            this.selectedPosition = selectedPosition;
        }

        private SavedState(@NonNull Parcel in) {
            super(in);
            this.selectedPosition = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.selectedPosition);
        }
    }

    private static enum FpxBank {
        AffinBank("affin_bank", "Affin Bank"),
        AllianceBankBusiness("alliance_bank", "Alliance Bank (Business)"),
        AmBank("ambank", "AmBank"),
        BankMuamalat("bank_muamalat", "Bank Muamalat"),
        DeutscheBank("deutsche_bank", "Deutsche Bank"),
        Maybank2e("maybank2e", "Maybank2E"),
        PublicBankEnterprise("pb_enterprise", "PB Enterprise"),
        StandardChartered("standard_chartered", "Standard Chartered"),
        UobBank("uob", "UOB Bank"),
        UobRegional("uob_regional", "UOB Regional");

        @NonNull
        private final String code;
        @NonNull
        private final String displayName;

        private FpxBank(String code, String displayName) {
            this.code = code;
            this.displayName = displayName;
        }
    }

    private static final class Adapter
    extends RecyclerView.Adapter<ViewHolder> {
        private int mSelectedPosition = -1;
        @NonNull
        private final ThemeConfig mThemeConfig;

        private Adapter(@NonNull ThemeConfig themeConfig) {
            this.setHasStableIds(true);
            this.mThemeConfig = themeConfig;
        }

        @NonNull
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int i) {
            View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.fpx_bank, parent, false);
            return new ViewHolder(itemView, this.mThemeConfig);
        }

        public void onBindViewHolder(final @NonNull ViewHolder viewHolder, int i) {
            viewHolder.setSelected(i == this.mSelectedPosition);
            viewHolder.update(FpxBank.values()[i].displayName);
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int currentPosition = viewHolder.getAdapterPosition();
                    if (currentPosition != Adapter.this.mSelectedPosition) {
                        int prevSelectedPosition = Adapter.this.mSelectedPosition;
                        Adapter.this.mSelectedPosition = currentPosition;
                        viewHolder.setSelected(true);
                        Adapter.this.notifyItemChanged(prevSelectedPosition);
                        Adapter.this.notifyItemChanged(currentPosition);
                    }
                }
            });
        }

        public long getItemId(int position) {
            return FpxBank.values()[position].hashCode();
        }

        public int getItemCount() {
            return FpxBank.values().length;
        }

        @Nullable
        FpxBank getSelectedBank() {
            if (this.mSelectedPosition == -1) {
                return null;
            }
            return FpxBank.values()[this.mSelectedPosition];
        }

        private void updateSelected(int position) {
            this.mSelectedPosition = position;
            this.notifyItemChanged(position);
        }

        private static final class ViewHolder
        extends RecyclerView.ViewHolder {
            @NonNull
            private final TextView mName;
            @NonNull
            private final ThemeConfig mThemeConfig;

            private ViewHolder(@NonNull View itemView, @NonNull ThemeConfig themeConfig) {
                super(itemView);
                this.mName = (TextView)itemView.findViewById(R.id.name);
                this.mThemeConfig = themeConfig;
            }

            void update(@NonNull String bankName) {
                this.mName.setText((CharSequence)bankName);
            }

            void setSelected(boolean isSelected) {
                this.mName.setTextColor(this.mThemeConfig.getTextColor(isSelected));
            }
        }
    }
}

