/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.utils.ObjectUtils;
import com.stripe.android.view.AuthActivityStarter;
import com.stripe.android.view.PaymentRelayActivity;
import java.io.Serializable;

class PaymentRelayStarter
implements AuthActivityStarter<Data> {
    @NonNull
    private final AuthActivityStarter.Host mHost;
    private final int mRequestCode;

    PaymentRelayStarter(@NonNull AuthActivityStarter.Host host, int requestCode) {
        this.mHost = host;
        this.mRequestCode = requestCode;
    }

    @Override
    public void start(@NonNull Data data) {
        Bundle extras = new Bundle();
        extras.putString("client_secret", data.stripeIntent != null ? data.stripeIntent.getClientSecret() : null);
        extras.putSerializable("exception", (Serializable)data.exception);
        this.mHost.startActivityForResult(PaymentRelayActivity.class, extras, this.mRequestCode);
    }

    public static final class Data {
        @Nullable
        final StripeIntent stripeIntent;
        @Nullable
        final Exception exception;

        Data(@NonNull StripeIntent stripeIntent) {
            this.stripeIntent = stripeIntent;
            this.exception = null;
        }

        Data(@NonNull Exception exception) {
            this.stripeIntent = null;
            this.exception = exception;
        }

        public int hashCode() {
            return ObjectUtils.hash(this.stripeIntent, this.exception);
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof Data && this.typedEquals((Data)obj);
        }

        private boolean typedEquals(@NonNull Data data) {
            return ObjectUtils.equals(this.stripeIntent, data.stripeIntent) && ObjectUtils.equals(this.exception, data.exception);
        }
    }
}

