/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.wallets;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONObject;

public abstract class Wallet
extends StripeModel
implements Parcelable {
    static final String FIELD_DYNAMIC_LAST4 = "dynamic_last4";
    static final String FIELD_TYPE = "type";
    @Nullable
    private final String dynamicLast4;
    @NonNull
    private final Type walletType;

    Wallet(@NonNull Type walletType, @NonNull Builder builder) {
        this.walletType = walletType;
        this.dynamicLast4 = builder.mDynamicLast4;
    }

    Wallet(@NonNull Parcel in) {
        this.dynamicLast4 = in.readString();
        this.walletType = Objects.requireNonNull(Type.fromCode(in.readString()));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.dynamicLast4);
        dest.writeString(this.walletType.code);
    }

    @Override
    @NonNull
    public final Map<String, Object> toMap() {
        HashMap<String, Object> wallet = new HashMap<String, Object>();
        ((AbstractMap)wallet).put(FIELD_TYPE, this.walletType.code);
        ((AbstractMap)wallet).put(FIELD_DYNAMIC_LAST4, this.dynamicLast4);
        ((AbstractMap)wallet).put(this.walletType.code, this.getWalletTypeMap());
        return wallet;
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash(new Object[]{this.dynamicLast4, this.walletType});
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Wallet && this.typedEquals((Wallet)obj);
    }

    private boolean typedEquals(@NonNull Wallet wallet) {
        return ObjectUtils.equals(this.dynamicLast4, wallet.dynamicLast4) && ObjectUtils.equals((Object)this.walletType, (Object)wallet.walletType);
    }

    @NonNull
    abstract Map<String, Object> getWalletTypeMap();

    public static class Address
    extends StripeModel
    implements Parcelable {
        static final String FIELD_CITY = "city";
        static final String FIELD_COUNTRY = "country";
        static final String FIELD_LINE1 = "line1";
        static final String FIELD_LINE2 = "line2";
        static final String FIELD_POSTAL_CODE = "postal_code";
        static final String FIELD_STATE = "state";
        @Nullable
        public final String city;
        @Nullable
        public final String country;
        @Nullable
        public final String line1;
        @Nullable
        public final String line2;
        @Nullable
        public final String postalCode;
        @Nullable
        public final String state;
        public static final Parcelable.Creator<Address> CREATOR = new Parcelable.Creator<Address>(){

            public Address createFromParcel(@NonNull Parcel in) {
                return new Address(in);
            }

            public Address[] newArray(int size) {
                return new Address[size];
            }
        };

        private Address(@NonNull Builder builder) {
            this.city = builder.mCity;
            this.country = builder.mCountry;
            this.line1 = builder.mLine1;
            this.line2 = builder.mLine2;
            this.postalCode = builder.mPostalCode;
            this.state = builder.mState;
        }

        private Address(@NonNull Parcel in) {
            this.city = in.readString();
            this.country = in.readString();
            this.line1 = in.readString();
            this.line2 = in.readString();
            this.postalCode = in.readString();
            this.state = in.readString();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.city);
            dest.writeString(this.country);
            dest.writeString(this.line1);
            dest.writeString(this.line2);
            dest.writeString(this.postalCode);
            dest.writeString(this.state);
        }

        @Override
        @NonNull
        public Map<String, Object> toMap() {
            HashMap<String, Object> address = new HashMap<String, Object>();
            ((AbstractMap)address).put(FIELD_CITY, this.city);
            ((AbstractMap)address).put(FIELD_COUNTRY, this.country);
            ((AbstractMap)address).put(FIELD_LINE1, this.line1);
            ((AbstractMap)address).put(FIELD_LINE2, this.line2);
            ((AbstractMap)address).put(FIELD_POSTAL_CODE, this.postalCode);
            ((AbstractMap)address).put(FIELD_STATE, this.state);
            return address;
        }

        @Nullable
        static Address fromJson(@Nullable JSONObject addressJson) {
            if (addressJson == null) {
                return null;
            }
            return new Builder().setCity(StripeJsonUtils.optString(addressJson, FIELD_CITY)).setCountry(StripeJsonUtils.optString(addressJson, FIELD_COUNTRY)).setLine1(StripeJsonUtils.optString(addressJson, FIELD_LINE1)).setLine2(StripeJsonUtils.optString(addressJson, FIELD_LINE2)).setPostalCode(StripeJsonUtils.optString(addressJson, FIELD_POSTAL_CODE)).setState(StripeJsonUtils.optString(addressJson, FIELD_STATE)).build();
        }

        @Override
        public int hashCode() {
            return ObjectUtils.hash(this.city, this.country, this.line1, this.line2, this.postalCode, this.state);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Address && this.typedEquals((Address)obj);
        }

        private boolean typedEquals(@NonNull Address address) {
            return ObjectUtils.equals(this.city, address.city) && ObjectUtils.equals(this.country, address.country) && ObjectUtils.equals(this.line1, address.line1) && ObjectUtils.equals(this.line2, address.line2) && ObjectUtils.equals(this.postalCode, address.postalCode) && ObjectUtils.equals(this.state, address.state);
        }

        static final class Builder
        implements ObjectBuilder<Address> {
            @Nullable
            private String mCity;
            @Nullable
            private String mCountry;
            @Nullable
            private String mLine1;
            @Nullable
            private String mLine2;
            @Nullable
            private String mPostalCode;
            @Nullable
            private String mState;

            Builder() {
            }

            @NonNull
            public Builder setCity(@Nullable String city) {
                this.mCity = city;
                return this;
            }

            @NonNull
            public Builder setCountry(@Nullable String country) {
                this.mCountry = country;
                return this;
            }

            @NonNull
            public Builder setLine1(@Nullable String line1) {
                this.mLine1 = line1;
                return this;
            }

            @NonNull
            public Builder setLine2(@Nullable String line2) {
                this.mLine2 = line2;
                return this;
            }

            @NonNull
            public Builder setPostalCode(@Nullable String postalCode) {
                this.mPostalCode = postalCode;
                return this;
            }

            @NonNull
            public Builder setState(@Nullable String state) {
                this.mState = state;
                return this;
            }

            @Override
            @NonNull
            public Address build() {
                return new Address(this);
            }
        }
    }

    static enum Type {
        AmexExpressCheckout("amex_express_checkout"),
        ApplePay("apple_pay"),
        GooglePay("google_pay"),
        Masterpass("master_pass"),
        SamsungPay("samsung_pay"),
        VisaCheckout("visa_checkout");

        @NonNull
        public final String code;

        private Type(String code) {
            this.code = code;
        }

        @Nullable
        static Type fromCode(@Nullable String code) {
            for (Type type : Type.values()) {
                if (!type.code.equals(code)) continue;
                return type;
            }
            return null;
        }
    }

    static abstract class Builder<W extends Wallet> {
        @Nullable
        private String mDynamicLast4;

        Builder() {
        }

        @NonNull
        public Builder setDynamicLast4(@Nullable String dynamicLast4) {
            this.mDynamicLast4 = dynamicLast4;
            return this;
        }

        @NonNull
        abstract W build();
    }
}

