/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ApiVersion;
import com.stripe.android.EphemeralKey;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.EphemeralKeyUpdateListener;
import com.stripe.android.OperationIdFactory;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class EphemeralKeyManager<TEphemeralKey extends EphemeralKey> {
    @NonNull
    private final EphemeralKeyProvider mEphemeralKeyProvider;
    @Nullable
    private final Calendar mOverrideCalendar;
    @NonNull
    private final KeyManagerListener<TEphemeralKey> mListener;
    private final long mTimeBufferInSeconds;
    @NonNull
    private final EphemeralKey.Factory<TEphemeralKey> mFactory;
    @NonNull
    private final String mApiVersion;
    @Nullable
    private TEphemeralKey mEphemeralKey;

    EphemeralKeyManager(@NonNull EphemeralKeyProvider ephemeralKeyProvider, @NonNull KeyManagerListener<TEphemeralKey> keyManagerListener, long timeBufferInSeconds, @Nullable Calendar overrideCalendar, @NonNull OperationIdFactory operationIdFactory, @NonNull EphemeralKey.Factory<TEphemeralKey> factory) {
        this.mFactory = factory;
        this.mEphemeralKeyProvider = ephemeralKeyProvider;
        this.mListener = keyManagerListener;
        this.mTimeBufferInSeconds = timeBufferInSeconds;
        this.mOverrideCalendar = overrideCalendar;
        this.mApiVersion = ApiVersion.get().code;
        this.retrieveEphemeralKey(operationIdFactory.create(), null, null);
    }

    void retrieveEphemeralKey(@NonNull String operationId, @Nullable String actionString, @Nullable Map<String, Object> arguments) {
        if (EphemeralKeyManager.shouldRefreshKey(this.mEphemeralKey, this.mTimeBufferInSeconds, this.mOverrideCalendar)) {
            this.mEphemeralKeyProvider.createEphemeralKey(this.mApiVersion, new ClientKeyUpdateListener(this, operationId, actionString, arguments));
        } else {
            this.mListener.onKeyUpdate(this.mEphemeralKey, operationId, actionString, arguments);
        }
    }

    private void updateKey(@NonNull String operationId, @NonNull String key, @Nullable String actionString, @Nullable Map<String, Object> arguments) {
        if (key == null) {
            this.mListener.onKeyError(operationId, 500, "EphemeralKeyUpdateListener.onKeyUpdate was called with a null value");
            return;
        }
        try {
            this.mEphemeralKey = EphemeralKey.fromJson(new JSONObject(key), this.mFactory);
            this.mListener.onKeyUpdate(this.mEphemeralKey, operationId, actionString, arguments);
        }
        catch (JSONException e) {
            this.mListener.onKeyError(operationId, 500, "EphemeralKeyUpdateListener.onKeyUpdate was passed a value that could not be JSON parsed: [" + e.getLocalizedMessage() + "]. The raw body from Stripe's response should be passed.");
        }
        catch (Exception e) {
            this.mListener.onKeyError(operationId, 500, "EphemeralKeyUpdateListener.onKeyUpdate was passed a JSON String that was invalid: [" + e.getLocalizedMessage() + "]. The raw body from Stripe's response should be passed.");
        }
    }

    private void updateKeyError(@NonNull String operationId, int errorCode, @NonNull String errorMessage) {
        this.mEphemeralKey = null;
        this.mListener.onKeyError(operationId, errorCode, errorMessage);
    }

    static boolean shouldRefreshKey(@Nullable EphemeralKey key, long bufferInSeconds, @Nullable Calendar proxyCalendar) {
        if (key == null) {
            return true;
        }
        Calendar now = proxyCalendar == null ? Calendar.getInstance() : proxyCalendar;
        long nowInSeconds = TimeUnit.MILLISECONDS.toSeconds(now.getTimeInMillis());
        long nowPlusBuffer = nowInSeconds + bufferInSeconds;
        return key.getExpires() < nowPlusBuffer;
    }

    private static class ClientKeyUpdateListener
    implements EphemeralKeyUpdateListener {
        @NonNull
        private final EphemeralKeyManager mEphemeralKeyManager;
        @NonNull
        private final String mOperationId;
        @Nullable
        private final String mActionString;
        @Nullable
        private final Map<String, Object> mArguments;

        ClientKeyUpdateListener(@NonNull EphemeralKeyManager ephemeralKeyManager, @NonNull String operationId, @Nullable String actionString, @Nullable Map<String, Object> arguments) {
            this.mEphemeralKeyManager = ephemeralKeyManager;
            this.mOperationId = operationId;
            this.mActionString = actionString;
            this.mArguments = arguments;
        }

        @Override
        public void onKeyUpdate(@NonNull String rawKey) {
            this.mEphemeralKeyManager.updateKey(this.mOperationId, rawKey, this.mActionString, this.mArguments);
        }

        @Override
        public void onKeyUpdateFailure(int responseCode, @NonNull String message) {
            this.mEphemeralKeyManager.updateKeyError(this.mOperationId, responseCode, message);
        }
    }

    static interface KeyManagerListener<TEphemeralKey extends EphemeralKey> {
        public void onKeyUpdate(@NonNull TEphemeralKey var1, @NonNull String var2, @Nullable String var3, @Nullable Map<String, Object> var4);

        public void onKeyError(@NonNull String var1, int var2, @NonNull String var3);
    }
}

