/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.utils.ObjectUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public abstract class StripeIntentResult<T extends StripeIntent> {
    @NonNull
    private final T mStripeIntent;
    private final int mStatus;

    public StripeIntentResult(@NonNull T stripeIntent, int status) {
        this.mStripeIntent = stripeIntent;
        this.mStatus = StripeIntentResult.calculateStatus(Objects.requireNonNull(stripeIntent.getStatus()), status);
    }

    private static int calculateStatus(@NonNull StripeIntent.Status stripeIntentStatus, int authStatus) {
        if (authStatus != 0) {
            return authStatus;
        }
        switch (stripeIntentStatus) {
            case RequiresAction: 
            case Canceled: {
                return 3;
            }
            case RequiresPaymentMethod: {
                return 2;
            }
            case Succeeded: 
            case RequiresCapture: 
            case RequiresConfirmation: {
                return 1;
            }
        }
        return 0;
    }

    @NonNull
    public final T getIntent() {
        return this.mStripeIntent;
    }

    public final int getStatus() {
        return this.mStatus;
    }

    public final boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof StripeIntentResult && this.typedEquals((StripeIntentResult)obj);
    }

    private boolean typedEquals(@NonNull StripeIntentResult setupIntentResult) {
        return ObjectUtils.equals(this.mStripeIntent, setupIntentResult.mStripeIntent) && ObjectUtils.equals(this.mStatus, setupIntentResult.mStatus);
    }

    public final int hashCode() {
        return ObjectUtils.hash(this.mStripeIntent, this.mStatus);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
        public static final int UNKNOWN = 0;
        public static final int SUCCEEDED = 1;
        public static final int FAILED = 2;
        public static final int CANCELED = 3;
        public static final int TIMEDOUT = 4;
    }
}

