/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class PaymentAuthWebView
extends WebView {
    public PaymentAuthWebView(@NonNull Context context) {
        this(context, null);
    }

    public PaymentAuthWebView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.configureSettings();
    }

    public PaymentAuthWebView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.configureSettings();
    }

    void init(@NonNull PaymentAuthWebViewClient.Listener listener, @NonNull ProgressBar progressBar, @NonNull String clientSecret, @NonNull String returnUrl) {
        this.setWebViewClient(new PaymentAuthWebViewClient(listener, progressBar, clientSecret, returnUrl));
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void configureSettings() {
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setAllowContentAccess(false);
    }

    static class PaymentAuthWebViewClient
    extends WebViewClient {
        static final String PARAM_PAYMENT_CLIENT_SECRET = "payment_intent_client_secret";
        static final String PARAM_SETUP_CLIENT_SECRET = "setup_intent_client_secret";
        private static final Set<String> COMPLETION_URLS = new HashSet<String>(Arrays.asList("https://hooks.stripe.com/redirect/complete/src_", "https://hooks.stripe.com/3d_secure/complete/tdsrc_"));
        @NonNull
        private final String mClientSecret;
        @Nullable
        private final Uri mReturnUrl;
        @NonNull
        private final ProgressBar mProgressBar;
        @NonNull
        private final Listener mListener;

        PaymentAuthWebViewClient(@NonNull Listener listener, @NonNull ProgressBar progressBar, @NonNull String clientSecret, @Nullable String returnUrl) {
            this.mListener = listener;
            this.mClientSecret = clientSecret;
            this.mReturnUrl = returnUrl != null ? Uri.parse((String)returnUrl) : null;
            this.mProgressBar = progressBar;
        }

        public void onPageCommitVisible(@NonNull WebView view, @NonNull String url) {
            super.onPageCommitVisible(view, url);
            this.mProgressBar.setVisibility(8);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (url != null && this.isCompletionUrl(url)) {
                this.onAuthCompleted();
            }
        }

        private boolean isCompletionUrl(@NonNull String url) {
            for (String completionUrl : COMPLETION_URLS) {
                if (!url.startsWith(completionUrl)) continue;
                return true;
            }
            return false;
        }

        public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull String urlString) {
            Uri uri = Uri.parse((String)urlString);
            if (this.isReturnUrl(uri)) {
                this.onAuthCompleted();
                return true;
            }
            return super.shouldOverrideUrlLoading(view, urlString);
        }

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull WebResourceRequest request) {
            return this.shouldOverrideUrlLoading(view, request.getUrl().toString());
        }

        private boolean isReturnUrl(@NonNull Uri uri) {
            if (this.isPredefinedReturnUrl(uri)) {
                return true;
            }
            if (this.mReturnUrl != null) {
                return this.mReturnUrl.getScheme() != null && this.mReturnUrl.getScheme().equals(uri.getScheme()) && this.mReturnUrl.getHost() != null && this.mReturnUrl.getHost().equals(uri.getHost());
            }
            Set paramNames = uri.getQueryParameterNames();
            String clientSecret = paramNames.contains(PARAM_PAYMENT_CLIENT_SECRET) ? uri.getQueryParameter(PARAM_PAYMENT_CLIENT_SECRET) : (paramNames.contains(PARAM_SETUP_CLIENT_SECRET) ? uri.getQueryParameter(PARAM_SETUP_CLIENT_SECRET) : null);
            return this.mClientSecret.equals(clientSecret);
        }

        private boolean isPredefinedReturnUrl(@NonNull Uri uri) {
            return "stripejs://use_stripe_sdk/return_url".equals(uri.toString());
        }

        private void onAuthCompleted() {
            this.mListener.onAuthCompleted(1);
        }

        static interface Listener {
            public void onAuthCompleted(int var1);
        }
    }
}

