/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiRequestExecutor;
import com.stripe.android.ConnectionFactory;
import com.stripe.android.StripeResponse;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.InvalidRequestException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

final class StripeApiRequestExecutor
implements ApiRequestExecutor {
    private static final String CHARSET = StandardCharsets.UTF_8.name();
    @NonNull
    private final ConnectionFactory mConnectionFactory = new ConnectionFactory();

    StripeApiRequestExecutor() {
    }

    @Override
    @NonNull
    public StripeResponse execute(@NonNull ApiRequest request) throws APIConnectionException, InvalidRequestException {
        HttpURLConnection conn = null;
        try {
            conn = this.mConnectionFactory.create(request);
            int responseCode = conn.getResponseCode();
            String responseBody = responseCode >= 200 && responseCode < 300 ? this.getResponseBody(conn.getInputStream()) : this.getResponseBody(conn.getErrorStream());
            StripeResponse stripeResponse = new StripeResponse(responseCode, responseBody, conn.getHeaderFields());
            return stripeResponse;
        }
        catch (IOException e) {
            throw APIConnectionException.create(request.getBaseUrl(), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Nullable
    private String getResponseBody(@Nullable InputStream responseStream) throws IOException {
        if (responseStream == null) {
            return null;
        }
        Scanner scanner = new Scanner(responseStream, CHARSET).useDelimiter("\\A");
        String rBody = scanner.hasNext() ? scanner.next() : null;
        responseStream.close();
        return rBody;
    }
}

